/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.controller.vehicle;

import com.bizunited.empower.business.sales.dto.VehicleTaskDto;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskVoService;
import com.bizunited.empower.business.sales.vo.DistributionRouteCustomerVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleTaskPanelVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleTaskVehicleVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleTaskVo;
import com.bizunited.empower.business.vehicle.vo.VehicleProductStockVo;
import com.bizunited.empower.business.vehicle.vo.VehicleTransformProductTypeVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/vehicleTaskVo"})
public class VehicleTaskVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(VehicleTaskVoController.class);
    @Autowired
    private VehicleTaskVoService vehicleTaskVoService;

    @ApiOperation(value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody @ApiParam(name="VehicleTaskVo", value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b") VehicleTaskVo vehicleTaskVo) {
        try {
            VehicleTaskVo current = this.vehicleTaskVoService.create(vehicleTaskVo);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody @ApiParam(name="VehicleVo", value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b") VehicleTaskVo vehicleTaskVo) {
        try {
            VehicleTaskVo current = this.vehicleTaskVoService.update(vehicleTaskVo);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ResponseModel findById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            VehicleTaskVo current = this.vehicleTaskVoService.findDetailsById(id);
            return this.buildHttpResultW((Object)current, new String[]{"saleManVos", "vehicleTaskDeliverGoods", "vehicleDistributionProductVos", "vehicleSalesProductVos"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByConditions"})
    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u53c2\u6570\u4e3apage\u548csize\uff0cpage\u4ece0\u5f00\u59cb\uff0csize\u9ed8\u8ba450")
    public ResponseModel findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u62dc\u8bbf\u8ba1\u5212dto\u7ed3\u6784\u4f53") VehicleTaskDto dto) {
        try {
            Page<VehicleTaskVo> vehicleTasks = this.vehicleTaskVoService.findByConditions(pageable, dto);
            return this.buildHttpResult(vehicleTasks);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByPanel"})
    @ApiOperation(value="\u770b\u677f\u67e5\u770b")
    public ResponseModel findByPanel(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u51fa\u8f66\u4efb\u52a1dto\u7ed3\u6784\u4f53") VehicleTaskDto dto) {
        try {
            List<VehicleTaskPanelVo> visitTaskVoPage = this.vehicleTaskVoService.findByPanel(pageable, dto);
            return this.buildHttpResult(visitTaskVoPage);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findVehicleStatus"})
    @ApiOperation(value="\u51fa\u8f66\u4efb\u52a1\u67e5\u8be2\u8f66\u8f86\u72b6\u6001")
    public ResponseModel findVehicleStatus() {
        try {
            List<VehicleTaskVehicleVo> vehicleTaskVehicleVos = this.vehicleTaskVoService.findVehicleStatus();
            return this.buildHttpResultW(vehicleTaskVehicleVos, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findCustomersByVehicleCode"})
    @ApiOperation(value="\u6839\u636e\u8f66\u8f86\u7f16\u7801\u67e5\u8be2\u5173\u8054\u4efb\u52a1\u7684\u5173\u8054\u8def\u7ebf\u7684\u5173\u8054\u5ba2\u6237")
    public ResponseModel findCustomersByVehicleCode(@RequestParam(value="vehicleCode") String vehicleCode) {
        try {
            List<DistributionRouteCustomerVo> customerVos = this.vehicleTaskVoService.findCustomersByVehicleCode(vehicleCode);
            return this.buildHttpResultW(customerVos, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53d1\u8d27\u5355\u53ef\u6dfb\u52a0\u7684\u51fa\u8f66\u4efb\u52a1")
    @GetMapping(value={"findVehicleTaskByDeliver"})
    public ResponseModel findVehicleTaskByDeliver(@PageableDefault(value=50) Pageable pageable, @RequestParam(required=false) @ApiParam(value="\u4ed3\u5e93\u7f16\u7801") String warehouseCode, @RequestParam(required=false) @ApiParam(value="\u5ba2\u6237\u7f16\u7801") String customerCode) {
        try {
            Page<VehicleTaskVo> result = this.vehicleTaskVoService.findVehicleTaskByDeliver(pageable, warehouseCode, customerCode);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u51fa\u8f66\u4efb\u52a1\u8be6\u60c5\u4e2d\u67e5\u770b\u8f66\u8f86\u7684\u5e93\u5b58")
    @GetMapping(value={"findVehicleProductStock"})
    public ResponseModel findVehicleProductStock(@PageableDefault(value=50) Pageable pageable, @RequestParam(required=false) @ApiParam(value="\u8f66\u8f86\u7f16\u7801") String vehicleCode, @RequestParam(required=false) @ApiParam(value="\u51fa\u8f66\u4efb\u52a1\u7f16\u7801") String vehicleTaskCode) {
        try {
            Page<VehicleProductStockVo> result = this.vehicleTaskVoService.findVehicleProductStock(pageable, vehicleCode, vehicleTaskCode);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u51fa\u8f66\u8ba1\u5212\u5b9a\u65f6\u4efb\u52a1\u6dfb\u52a0\u53d1\u8d27\u5355\u5230\u51fa\u8f66\u4efb\u52a1")
    @GetMapping(value={"addDeliverGoodToVehicleTask"})
    public ResponseModel addDeliverGoodToVehicleTask() {
        try {
            this.vehicleTaskVoService.addDeliverGoodToVehicleTask();
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"batachTransforProductType"})
    @ApiOperation(value="\u8f66\u8f86\u5e93\u5b58\u5546\u54c1\u8f6c\u6362\u5546\u54c1\u7c7b\u578b")
    public ResponseModel batachTransforProductType(@RequestBody VehicleTransformProductTypeVo vehicleTransforProductTypeVo) {
        try {
            this.vehicleTaskVoService.batachTransforProductType(vehicleTransforProductTypeVo);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

