/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.repository.outward;

import com.bizunited.empower.business.sales.entity.outward.OutwardPlan;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_OutwardPlanRepository")
public interface OutwardPlanRepository
extends JpaRepository<OutwardPlan, String>,
JpaSpecificationExecutor<OutwardPlan> {
    @Query(value="select distinct outwardPlan from OutwardPlan outwardPlan  left join fetch outwardPlan.route outwardPlan_route  left join fetch outwardPlan.planFrequency planFrequency  left join fetch outwardPlan.productMix mix  left join fetch mix.detail detail  where outwardPlan_route.id = :id and outwardPlan.delete = 0")
    public Set<OutwardPlan> findDetailsByRoute(@Param(value="id") String var1);

    @Query(value="select distinct outwardPlan from OutwardPlan outwardPlan  left join fetch outwardPlan.route outwardPlan_route  left join fetch outwardPlan.planFrequency planFrequency  left join fetch outwardPlan.productMix mix  left join fetch mix.detail detail  where mix.id = :id and outwardPlan.delete = 0")
    public Set<OutwardPlan> findDetailsByProductMix(@Param(value="id") String var1);

    @Query(value="select distinct outwardPlan from OutwardPlan outwardPlan  left join fetch outwardPlan.route outwardPlan_route  left join fetch outwardPlan.planFrequency planFrequency  left join fetch outwardPlan.productMix mix  left join fetch mix.detail detail  where outwardPlan.id=:id and outwardPlan.delete = 0")
    public OutwardPlan findDetailsById(@Param(value="id") String var1);

    @Query(value="from OutwardPlan e where e.code = :code and e.tenantCode = :tenantCode and e.delete = 0")
    public OutwardPlan findByCodeAndTenantCode(@Param(value="code") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select distinct e from OutwardPlan e left join fetch e.route route left join fetch e.planFrequency planFrequency left join fetch e.productMix pm  left join fetch pm.detail detail where e.code = :code and e.tenantCode = :tenantCode and e.delete = 0")
    public OutwardPlan findDetailsByCodeAndTenantCode(@Param(value="code") String var1, @Param(value="tenantCode") String var2);

    @Modifying
    @Query(value="update OutwardPlan e set e.tstatus = :tstatus where e.code = :code and e.tenantCode = :tenantCode and e.delete = 0")
    public void updateStatusByCodeAndTenantCode(@Param(value="code") String var1, @Param(value="tenantCode") String var2, @Param(value="tstatus") Integer var3);

    @Query(value="select distinct e from OutwardPlan e left join fetch e.route route left join fetch e.planFrequency planFrequency left join fetch e.productMix pm  left join fetch pm.detail detail where e.tenantCode=:tenantCode and route.code=:routeCode and e.tstatus=:planStatus and e.vehicleCode=:vehicleCode and e.delete = 0")
    public List<OutwardPlan> findByVehicleCodeAndRouteCodeAndPlanStatusAndTenantCode(@Param(value="vehicleCode") String var1, @Param(value="routeCode") String var2, @Param(value="planStatus") Integer var3, @Param(value="tenantCode") String var4);

    @Query(value="select distinct e from OutwardPlan e left join fetch e.route route left join fetch e.planFrequency planFrequency left join fetch e.productMix pm  left join fetch pm.detail detail where e.tenantCode=:tenantCode and e.tstatus=:planStatus and e.delete = 0")
    public Set<OutwardPlan> findAllDetailsByStatusAndTenantCode(@Param(value="planStatus") Integer var1, @Param(value="tenantCode") String var2);

    @Query(value="from OutwardPlan e where e.vehicleCode = :vehicleCode and e.tenantCode = :tenantCode and e.delete = 0")
    public List<OutwardPlan> findByVehicleCodeAndTenantCode(@Param(value="vehicleCode") String var1, @Param(value="tenantCode") String var2);

    @Query(value="from OutwardPlan e where e.name = :name and e.tenantCode = :tenantCode and e.delete = 0")
    public OutwardPlan findByNameAndTenantCode(@Param(value="name") String var1, @Param(value="tenantCode") String var2);

    @Query(value="from OutwardPlan e where e.route.code = :routeCode and e.tenantCode = :tenantCode and e.delete = 0")
    public List<OutwardPlan> findOutwardPlanByRouteCodeAndTenantCode(@Param(value="routeCode") String var1, @Param(value="tenantCode") String var2);

    @Query(value="from OutwardPlan e where e.route.code = :routeCode and e.tenantCode = :tenantCode and e.tstatus =1 and e.delete = 0")
    public List<OutwardPlan> findOutwardPlanByRouteCodeAndStatusAndTenantCode(@Param(value="routeCode") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select outwardPlan from OutwardPlan outwardPlan  where outwardPlan.tstatus =1 and outwardPlan.delete = false")
    public List<OutwardPlan> findAllByEnable();
}

