/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.repository.outward.internal;

import com.bizunited.empower.business.sales.dto.DistributionRouteDto;
import com.bizunited.empower.business.sales.repository.outward.internal.DistributionRouteRepositoryCustom;
import com.bizunited.empower.business.sales.vo.DistributionRouteVo;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import java.util.Date;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="_DistributionRouteRepositoryImpl")
public class DistributionRouteRepositoryImpl
implements DistributionRouteRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<DistributionRouteVo> queryPage(DistributionRouteDto dto, Pageable pageable) {
        StringBuilder hql = new StringBuilder("select id,name,code,tstatus,remark,drc.cnums customerNum,create_time createTime,tenant_code tenantCode from distribution_route c  inner join (select route_id,count(route_id) cnums from distribution_route_customer group by route_id) drc on c.id = drc.route_id where 1=1");
        StringBuilder countHql = new StringBuilder("select count(distinct c.id) from distribution_route c  inner join (select route_id,count(route_id) cnums from distribution_route_customer group by route_id) drc on c.id = drc.route_id where 1=1");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (dto != null) {
            Date endTime;
            Date startTime;
            if (StringUtils.isNotBlank((CharSequence)dto.getName())) {
                hql.append(" and name like concat('%',:name,'%')");
                countHql.append(" and name like concat('%',:name,'%')");
                parameters.put("name", dto.getName());
            }
            if (dto.getTstatus() != null) {
                hql.append(" and c.tstatus = :tstatus");
                countHql.append(" and c.tstatus = :tstatus");
                parameters.put("tstatus", dto.getTstatus());
            }
            if ((startTime = dto.getStartTime()) != null) {
                hql.append(" and c.create_time >= date_format(:startTime,'%Y-%m-%d')");
                countHql.append(" and c.create_time >= date_format(:startTime,'%Y-%m-%d')");
                parameters.put("startTime", startTime);
            }
            if ((endTime = dto.getEndTime()) != null) {
                hql.append(" and c.create_time <= date_format(:endTime,'%Y-%m-%d')");
                countHql.append(" and c.create_time <= date_format(:endTime,'%Y-%m-%d')");
                parameters.put("endTime", endTime);
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getTenantCode())) {
                hql.append(" and c.tenant_code = :tenantCode");
                countHql.append(" and c.tenant_code = :tenantCode");
                parameters.put("tenantCode", dto.getTenantCode());
            }
        }
        hql.append(" and c.is_delete = 0  order by c.create_time desc");
        countHql.append(" and c.is_delete = 0 ");
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, true, DistributionRouteVo.class);
    }
}

