/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.repository.outward.internal;

import com.bizunited.empower.business.sales.dto.OutwardPlanDto;
import com.bizunited.empower.business.sales.repository.outward.internal.OutwardPlanRepositoryCustom;
import com.bizunited.empower.business.sales.vo.OutwardPlanVo;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import java.util.Date;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="_OutwardPlanRepositoryImpl")
public class OutwardPlanRepositoryImpl
implements OutwardPlanRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<OutwardPlanVo> queryPage(OutwardPlanDto dto, Pageable pageable) {
        StringBuilder hql = new StringBuilder("select c.id,c.name,c.code,c.tstatus,c.vehicle_code vehicleCode,c.vehicle_name vehicleName,c.vehicle_number vehicleNumber,c.leader_name leaderName,c.leader_account leaderAccount,c.leader_phone leaderPhone,c.warehouse_code warehouseCode,c.warehouse_name warehouseName,d.code distributionRouteCode,d.name distributionRouteName,c.tenant_code tenantCode,c.create_account createAccount,c.create_time createTime,c.modify_time modifyTime,c.modify_account modifyAccount,opf.descr,c.remark  from outward_plan c  left join distribution_route d on d.id = c.route_id  left join outward_plan_frequency opf on opf.id = c.frequency_id where 1=1");
        StringBuilder countHql = new StringBuilder("select count(distinct c.id) FROM outward_plan c  left join distribution_route d on d.id = c.route_id  left join outward_plan_frequency opf on opf.id = c.frequency_id where 1=1");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (dto != null) {
            Date endTime;
            Date startTime;
            if (StringUtils.isNotBlank((CharSequence)dto.getName())) {
                hql.append(" and c.name like concat('%',:name,'%')");
                countHql.append(" and c.name like concat('%',:name,'%')");
                parameters.put("name", dto.getName());
            }
            if (dto.getTstatus() != null) {
                hql.append(" and c.tstatus = :tstatus");
                countHql.append(" and c.tstatus = :tstatus");
                parameters.put("tstatus", dto.getTstatus());
            }
            if ((startTime = dto.getStartTime()) != null) {
                hql.append(" and c.create_time >= date_format(:startTime,'%Y-%m-%d')");
                countHql.append(" and c.create_time >= date_format(:startTime,'%Y-%m-%d')");
                parameters.put("startTime", startTime);
            }
            if ((endTime = dto.getEndTime()) != null) {
                hql.append(" and c.create_time <= date_format(:endTime,'%Y-%m-%d')");
                countHql.append(" and c.create_time <= date_format(:endTime,'%Y-%m-%d')");
                parameters.put("endTime", endTime);
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getTenantCode())) {
                hql.append(" and c.tenant_code = :tenantCode");
                countHql.append(" and c.tenant_code = :tenantCode");
                parameters.put("tenantCode", dto.getTenantCode());
            }
        }
        countHql.append(" and c.is_delete = 0");
        hql.append(" and c.is_delete = 0 order by c.create_time desc,c.id desc");
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, true, OutwardPlanVo.class);
    }
}

