/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.repository.vehicle;

import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_VehicleTaskRepository")
public interface VehicleTaskRepository
extends JpaRepository<VehicleTask, String>,
JpaSpecificationExecutor<VehicleTask> {
    @Query(value="select distinct vehicleTask from VehicleTask vehicleTask  where vehicleTask.id=:id ")
    public VehicleTask findDetailsById(@Param(value="id") String var1);

    @Query(value="select  vehicleTask from VehicleTask vehicleTask where vehicleTask.vehicleTaskCode=:vehicleTaskCode and vehicleTask.tenantCode = :tenantCode")
    public VehicleTask findByVehicleTaskCode(@Param(value="vehicleTaskCode") String var1, @Param(value="tenantCode") String var2);

    @Modifying
    @Query(value="update vehicle_task  set vehicle_task_status = :vehicleTaskStatus where vehicle_task_code = :vehicleTaskCode and tenant_code = :tenantCode", nativeQuery=true)
    public void updateTaskStatusByTaskCodeAndTenantCode(@Param(value="vehicleTaskCode") String var1, @Param(value="vehicleTaskStatus") Integer var2, @Param(value="tenantCode") String var3);

    @Modifying
    @Query(value="update vehicle_task  set load_time = :loadTime where vehicle_task_code = :vehicleTaskCode and tenant_code = :tenantCode", nativeQuery=true)
    public void updateLoadTimeByVehicleTaskCode(@Param(value="vehicleTaskCode") String var1, @Param(value="loadTime") Date var2, @Param(value="tenantCode") String var3);

    @Modifying
    @Query(value="update vehicle_task  set vehicle_task_status = :vehicleTaskStatus and return_time = :returnTime and vehicle_return_amount =:vehicleReturnAmount and sale_order_quantity =:saleOrderQuantity where vehicle_task_code = :vehicleTaskCode and tenant_code = :tenantCode", nativeQuery=true)
    public void updateVehicleTaskByReturnVehicle(@Param(value="vehicleTaskCode") String var1, @Param(value="vehicleTaskStatus") Integer var2, @Param(value="returnTime") Date var3, @Param(value="vehicleReturnAmount") BigDecimal var4, @Param(value="saleOrderQuantity") BigDecimal var5, @Param(value="tenantCode") String var6);

    @Query(value="select  vehicleTask from VehicleTask vehicleTask where vehicleTask.vehicleCode=:vehicleCode and vehicleTask.vehicleTaskStatus = :vehicleTaskStatus and vehicleTask.tenantCode = :tenantCode")
    public VehicleTask findByVehicleCodeAndTaskStatus(@Param(value="vehicleCode") String var1, @Param(value="vehicleTaskStatus") Integer var2, @Param(value="tenantCode") String var3);

    @Query(value="select  vehicleTask from VehicleTask vehicleTask where vehicleTask.vehicleCode=:vehicleCode and vehicleTask.vehicleTaskStatus in (4,5)  and vehicleTask.tenantCode = :tenantCode")
    public VehicleTask findVehicleTaskByDriving(@Param(value="vehicleCode") String var1, @Param(value="tenantCode") String var2);

    @Modifying
    @Query(value="select distinct vt.vehicle_code from vehicle_task vt inner join vehicle_sale_man vsm  on vsm.vehicle_task_id = vt.id where vsm.user_account = :userAccount and vt.vehicle_task_status  in(3,4,5) and vt.tenant_code = :tenantCode", nativeQuery=true)
    public List<String> findByUserAccountAndDriving(@Param(value="userAccount") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select  vehicleTask from VehicleTask vehicleTask where vehicleTask.vehicleCode=:vehicleCode and vehicleTask.tenantCode = :tenantCode")
    public List<VehicleTask> findByVehicleCodeAndTenantCode(@Param(value="vehicleCode") String var1, @Param(value="tenantCode") String var2);

    @Modifying
    @Query(value="select  * from vehicle_task vehicleTask where vehicleTask.vehicle_code=:vehicleCode and vehicleTask.tenant_code = :tenantCode and vehicleTask.vehicle_task_status not in(:vehicleReturn , :cancel)", nativeQuery=true)
    public List<VehicleTask> findByVehicleCodeAndDriving(@Param(value="vehicleCode") String var1, @Param(value="vehicleReturn") Integer var2, @Param(value="cancel") Integer var3, @Param(value="tenantCode") String var4);

    @Modifying
    @Query(value="select  distinct vtem.expense_code from vehicle_task vehicleTask inner join vehicle_task_expense_mapping vtem on vehicleTask.vehicle_task_code = vtem.vehicle_task_code where vehicleTask.tenant_code = :tenantCode and vehicleTask.vehicle_task_status not in(:vehicleReturn , :cancel)", nativeQuery=true)
    public List<String> findByDriving(@Param(value="vehicleReturn") Integer var1, @Param(value="cancel") Integer var2, @Param(value="tenantCode") String var3);

    @Query(value="select  vehicleTask from VehicleTask vehicleTask where vehicleTask.routeCode=:routeCode and vehicleTask.tenantCode = :tenantCode")
    public List<VehicleTask> findVehicleTaskByRouteCodeAndTenantCode(@Param(value="routeCode") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select vehicleTask from VehicleTask vehicleTask where vehicleTask.taskTime >=:deliverTime and vehicleTask.routeCode =:routeCode and vehicleTask.vehicleTaskStatus =1 and vehicleTask.vehicleTaskWay =2 and vehicleTask.tenantCode = :tenantCode order by vehicleTask.taskTime asc ")
    public List<VehicleTask> findbyTaskTimeBeforeAndTenantCode(@Param(value="deliverTime") Date var1, @Param(value="routeCode") String var2, @Param(value="tenantCode") String var3);

    @Query(value="select vehicleTask from VehicleTask vehicleTask where vehicleTask.createTime >=:createTime and vehicleTask.vehicleTaskStatus =1 and vehicleTask.vehicleTaskWay =2 and vehicleTask.tenantCode = :tenantCode order by vehicleTask.taskTime asc ")
    public List<VehicleTask> findbyAutomaticAndCreateTimeBefore(@Param(value="createTime") Date var1, @Param(value="tenantCode") String var2);

    @Query(value="select vehicleTask from VehicleTask vehicleTask where vehicleTask.outwardPlanCode in :planCodes and vehicleTask.taskTime in :taskTimes and vehicleTask.vehicleTaskStatus <>7 and vehicleTask.vehicleTaskWay =2 ")
    public List<VehicleTask> findbyOutwardPlanCodeAndTaskTimeAndTenantCode(@Param(value="planCodes") List<String> var1, @Param(value="taskTimes") List<Date> var2);

    @Modifying
    @Query(value="select distinct * from vehicle_task v left join vehicle_task_expense_mapping e on e.vehicle_task_code = v.vehicle_task_code where v.vehicle_task_status not in(6,7) and e.deliver_good_code = :deliverGoodCode and v.tenant_code = :tenantCode", nativeQuery=true)
    public VehicleTask findbyDeliverGoodCodeAndTenantCode(@Param(value="deliverGoodCode") String var1, @Param(value="tenantCode") String var2);
}

