/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.repository.vehicle.internal;

import com.bizunited.empower.business.sales.dto.VehiclePickUpLoadDto;
import com.bizunited.empower.business.sales.entity.vehicle.VehiclePickUpLoad;
import com.bizunited.empower.business.sales.repository.vehicle.internal.VehiclePickUpLoadRepositoryCustom;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.script.context.InvokeParams;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="_VehiclePickUpLoadRepositoryImpl")
public class VehiclePickUpPickUpLoadRepositoryImpl
implements VehiclePickUpLoadRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<VehiclePickUpLoad> queryPage(Pageable pageable, InvokeParams conditions) {
        StringBuilder hql = new StringBuilder("from VehiclePickUpLoad c where 1=1");
        StringBuilder countHql = new StringBuilder("select count(*) FROM VehiclePickUpLoad c where 1=1");
        StringBuilder condition = new StringBuilder();
        HashMap parameters = new HashMap();
        if (conditions != null) {
            // empty if block
        }
        hql.append((CharSequence)condition);
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }

    @Override
    public Page<VehiclePickUpLoad> findByConditions(Pageable pageable, VehiclePickUpLoadDto dto) {
        StringBuilder hql = new StringBuilder("select distinct v.id,v.create_account createAccount,v.create_time createTime,v.modify_account modifyAccount, v.modify_time modifyTime,v.tenant_code tenantCode,v.load_time loadTime,v.remark,v.sale_man_account saleManAccount,v.sale_man_name saleManName, v.transfer_order_code transferOrderCode,v.vehicle_code vehicleCode,v.vehicle_pick_up_load_status vehiclePickUpLoadStatus, v.vehicle_name vehicleName,v.vehicle_task_code vehicleTaskCode,v.warehouse_code warehouseCode,v.warehouse_name warehouseName  from  vehicle_pick_up_load v left join vehicle_task vt on vt.vehicle_task_code = v.vehicle_task_code left join vehicle_sale_man vsm on vsm.vehicle_task_id = vt.id where 1=1");
        StringBuilder countHql = new StringBuilder("select count( distinct v.id) from  vehicle_pick_up_load v left join vehicle_task vt on vt.vehicle_task_code = v.vehicle_task_code left join vehicle_sale_man vsm on vsm.vehicle_task_id = vt.id");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (dto != null) {
            Date date;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String vehicleTaskCode = dto.getVehicleTaskCode();
            String transferOrderCode = dto.getTransferOrderCode();
            String warehouseCode = dto.getWarehouseCode();
            Integer vehiclePickUpLoadStatus = dto.getVehiclePickUpLoadStatus();
            String vehicleCode = dto.getVehicleCode();
            String startTime = dto.getStartTime();
            String endTime = dto.getEndTime();
            String userAccount = dto.getUserAccount();
            String tenantCode = dto.getTenantCode();
            if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
                condition.append(" and v.tenant_code = :tenantCode ");
                parameters.put("tenantCode", tenantCode);
            }
            if (StringUtils.isNotBlank((CharSequence)vehicleTaskCode)) {
                condition.append(" and v.vehicle_task_code = :vehicleTaskCode ");
                parameters.put("vehicleTaskCode", vehicleTaskCode);
            }
            if (StringUtils.isNotBlank((CharSequence)transferOrderCode)) {
                condition.append(" and v.transfer_order_code like concat('%',:transferOrderCode,'%') ");
                parameters.put("transferOrderCode", transferOrderCode);
            }
            if (null != vehiclePickUpLoadStatus) {
                condition.append(" and v.vehicle_pick_up_load_status = :vehiclePickUpLoadStatus ");
                parameters.put("vehiclePickUpLoadStatus", vehiclePickUpLoadStatus);
            }
            if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
                condition.append(" and v.warehouse_code = :warehouseCode ");
                parameters.put("warehouseCode", warehouseCode);
            }
            if (StringUtils.isNotBlank((CharSequence)vehicleCode)) {
                condition.append(" and v.vehicle_code = :vehicleCode ");
                parameters.put("vehicleCode", vehicleCode);
            }
            if (StringUtils.isNotBlank((CharSequence)userAccount)) {
                condition.append(" and vsm.user_account = :userAccount ");
                parameters.put("userAccount", userAccount);
            }
            if (StringUtils.isNotBlank((CharSequence)startTime)) {
                try {
                    date = simpleDateFormat.parse(startTime);
                    condition.append(" and v.load_time >= :startTime ");
                    parameters.put("startTime", date);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)endTime)) {
                try {
                    date = simpleDateFormat.parse(endTime);
                    condition.append(" and v.load_time < :endTime ");
                    parameters.put("endTime", date);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        hql.append((CharSequence)condition).append(" order by v.create_time desc");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, true, VehiclePickUpLoad.class);
    }
}

