/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.repository.vehicle.internal;

import com.bizunited.empower.business.sales.dto.DistributionTaskDto;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTaskExpenseMapping;
import com.bizunited.empower.business.sales.repository.vehicle.internal.VehicleTaskExpenseMappingRepositoryCustom;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="_VehicleTaskExpenseMappingRepositoryImpl")
public class VehicleTaskExpenseMappingRepositoryImpl
implements VehicleTaskExpenseMappingRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<VehicleTaskExpenseMapping> findByConditions(Pageable pageable, DistributionTaskDto dto) {
        StringBuilder hql = new StringBuilder("select v from VehicleTaskExpenseMapping v where 1=1");
        StringBuilder countHql = new StringBuilder("select count(*) FROM VehicleTaskExpenseMapping v where 1=1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (dto != null) {
            String vehicleTaskCode = dto.getVehicleTaskCode();
            String distributionTaskCode = dto.getDistributionTaskCode();
            String deliverGoodCode = dto.getDeliverGoodCode();
            String createAccount = dto.getCreateAccount();
            Integer distributionStatus = dto.getDistributionStatus();
            String customerName = dto.getCustomerName();
            String tenantCode = dto.getTenantCode();
            if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
                condition.append(" and v.tenantCode = :tenantCode ");
                parameters.put("tenantCode", tenantCode);
            }
            if (StringUtils.isNotBlank((CharSequence)vehicleTaskCode)) {
                condition.append(" and v.vehicleTaskCode = :vehicleTaskCode ");
                parameters.put("vehicleTaskCode", vehicleTaskCode);
            }
            if (StringUtils.isNotBlank((CharSequence)customerName)) {
                condition.append(" and v.customerName like concat('%',:customerName,'%') ");
                parameters.put("customerName", customerName);
            }
            if (StringUtils.isNotBlank((CharSequence)distributionTaskCode)) {
                condition.append(" and v.distributionTaskCode = :distributionTaskCode ");
                parameters.put("distributionTaskCode", distributionTaskCode);
            }
            if (StringUtils.isNotBlank((CharSequence)deliverGoodCode)) {
                condition.append(" and v.deliverGoodCode = :deliverGoodCode ");
                parameters.put("deliverGoodCode", deliverGoodCode);
            }
            if (StringUtils.isNotBlank((CharSequence)createAccount)) {
                condition.append(" and v.createAccount = :createAccount ");
                parameters.put("createAccount", createAccount);
            }
            if (null != distributionStatus) {
                condition.append(" and v.distributionStatus = :distributionStatus ");
                parameters.put("distributionStatus", distributionStatus);
            }
        }
        hql.append((CharSequence)condition).append(" order by v.createTime desc");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, VehicleTaskExpenseMapping.class);
    }
}

