/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.repository.vehicle.internal;

import com.bizunited.empower.business.sales.dto.VehicleTaskDto;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.repository.vehicle.internal.VehicleTaskRepositoryCustom;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.script.context.InvokeParams;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="_VehicleTaskRepositoryImpl")
public class VehicleTaskRepositoryImpl
implements VehicleTaskRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<VehicleTask> queryPage(Pageable pageable, InvokeParams conditions) {
        StringBuilder hql = new StringBuilder("from VehicleTask c where 1=1");
        StringBuilder countHql = new StringBuilder("select count(*) FROM VehicleTask c where 1=1");
        StringBuilder condition = new StringBuilder();
        HashMap parameters = new HashMap();
        if (conditions != null) {
            // empty if block
        }
        hql.append((CharSequence)condition);
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }

    @Override
    public Page<VehicleTask> findByConditions(Pageable pageable, VehicleTaskDto dto) {
        StringBuilder hql = new StringBuilder("select distinct v from VehicleTask v inner join v.saleMans sm where 1=1");
        StringBuilder countHql = new StringBuilder("select count(distinct v) FROM VehicleTask v inner join v.saleMans sm where 1=1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (dto != null) {
            Date date;
            Integer vehicleTaskStatus = dto.getVehicleTaskStatus();
            String tenantCode = dto.getTenantCode();
            String startTime = dto.getStartTime();
            String endTime = dto.getEndTime();
            String warehouseCode = dto.getWarehouseCode();
            List<String> routeCodes = dto.getRouteCodes();
            String carNumber = dto.getCarNumber();
            String routeCode = dto.getRouteCode();
            String saleManAccount = dto.getSaleManAccount();
            Integer vehicleTaskType = dto.getVehicleTaskType();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (null != vehicleTaskStatus) {
                condition.append(" and v.vehicleTaskStatus = :vehicleTaskStatus ");
                parameters.put("vehicleTaskStatus", vehicleTaskStatus);
            }
            if (null != vehicleTaskType) {
                condition.append(" and v.vehicleTaskType = :vehicleTaskType ");
                parameters.put("vehicleTaskType", vehicleTaskType);
            }
            if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
                condition.append(" and v.tenantCode = :tenantCode ");
                parameters.put("tenantCode", tenantCode);
            }
            if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
                condition.append(" and v.warehouseCode = :warehouseCode ");
                parameters.put("warehouseCode", warehouseCode);
            }
            if (!CollectionUtils.isEmpty(routeCodes)) {
                condition.append(" and v.routeCode in :routeCodes ");
                parameters.put("routeCodes", routeCodes);
            }
            if (StringUtils.isNotBlank((CharSequence)routeCode)) {
                condition.append(" and v.routeCode = :routeCode ");
                parameters.put("routeCode", routeCode);
            }
            if (StringUtils.isNotBlank((CharSequence)carNumber)) {
                condition.append(" and v.carNumber like CONCAT('%',:carNumber,'%')");
                parameters.put("carNumber", carNumber);
            }
            if (StringUtils.isNotBlank((CharSequence)saleManAccount)) {
                condition.append(" and sm.userAccount = :saleManAccount ");
                parameters.put("saleManAccount", saleManAccount);
            }
            if (StringUtils.isNotBlank((CharSequence)startTime)) {
                try {
                    date = simpleDateFormat.parse(startTime);
                    condition.append(" and v.taskTime >= :startTime ");
                    parameters.put("startTime", date);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)endTime)) {
                try {
                    date = simpleDateFormat.parse(endTime);
                    condition.append(" and v.taskTime < :endTime ");
                    parameters.put("endTime", date);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        hql.append((CharSequence)condition).append(" order by v.createTime desc");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, VehicleTask.class);
    }
}

