/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.outward;

import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.sales.entity.outward.DistributionRouteCustomer;
import com.bizunited.empower.business.sales.repository.outward.DistributionRouteCustomerRepository;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteCustomerService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DistributionRouteCustomerServiceImpl")
public class DistributionRouteCustomerServiceImpl
implements DistributionRouteCustomerService {
    @Autowired
    private DistributionRouteCustomerRepository distributionRouteCustomerRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CustomerService customerService;

    @Override
    @Transactional
    public DistributionRouteCustomer create(DistributionRouteCustomer distributionRouteCustomer) {
        return this.createForm(distributionRouteCustomer);
    }

    @Override
    @Transactional
    public DistributionRouteCustomer createForm(DistributionRouteCustomer distributionRouteCustomer) {
        this.createValidation(distributionRouteCustomer);
        this.distributionRouteCustomerRepository.saveAndFlush((Object)distributionRouteCustomer);
        return distributionRouteCustomer;
    }

    private void createValidation(DistributionRouteCustomer distributionRouteCustomer) {
        Validate.notNull((Object)((Object)distributionRouteCustomer), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)distributionRouteCustomer.getRoute()), (String)"\u914d\u9001\u8def\u7ebf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getReceiver(), (String)"\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getReceiverPhone(), (String)"\u6536\u8d27\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getReceiverAddress(), (String)"\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getProvinceName(), (String)"\u6536\u8d27\u5730\u5740(\u7701)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getCityName(), (String)"\u6536\u8d27\u5730\u5740(\u5e02)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getDistrictName(), (String)"\u6536\u8d27\u5730\u5740(\u533a)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)distributionRouteCustomer.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        distributionRouteCustomer.setId(null);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getCustomerCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getCustomerCode() == null || distributionRouteCustomer.getCustomerCode().length() < 64 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getReceiver() == null || distributionRouteCustomer.getReceiver().length() < 64 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getReceiverPhone() == null || distributionRouteCustomer.getReceiverPhone().length() < 128 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba\u624b\u673a\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getReceiverAddress() == null || distributionRouteCustomer.getReceiverAddress().length() < 1024 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba\u5730\u5740,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(1024)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getProvinceName() == null || distributionRouteCustomer.getProvinceName().length() < 64 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba\u5730\u5740(\u7701),\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getCityName() == null || distributionRouteCustomer.getCityName().length() < 64 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba\u5730\u5740(\u5e02),\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getDistrictName() == null || distributionRouteCustomer.getDistrictName().length() < 64 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba\u5730\u5740(\u533a),\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public List<DistributionRouteCustomer> update(List<DistributionRouteCustomer> customers) {
        Validate.notEmpty(customers, (String)"\u4fdd\u5b58\u65f6\uff0c\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet routeIds = Sets.newHashSet();
        for (DistributionRouteCustomer customer : customers) {
            Validate.notNull((Object)((Object)customer), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)customer.getRoute()), (String)"\u914d\u9001\u8def\u7ebf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)customer.getRoute().getId(), (String)"\u914d\u9001\u8def\u7ebf\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            routeIds.add(customer.getRoute().getId());
            Validate.isTrue((routeIds.size() == 1 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u5b58\u5728\u591a\u4e2a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)customer.getCustomerCode(), (String)"\u4fdd\u5b58\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((customer.getCustomerCode() == null || customer.getCustomerCode().length() < 64 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fdd\u5b58\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        }
        Set<DistributionRouteCustomer> dbCustomers = this.findDetailsByRoute((String)routeIds.iterator().next());
        HashSet needDelete = Sets.newHashSet();
        HashSet needAdd = Sets.newHashSet();
        HashSet needUpt = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy(customers, dbCustomers, DistributionRouteCustomer::getCustomerCode, (Collection)needDelete, (Collection)needUpt, (Collection)needAdd);
        if (!CollectionUtils.isEmpty((Collection)needDelete)) {
            this.distributionRouteCustomerRepository.deleteInBatch(needDelete);
            needDelete.forEach(dr -> this.customerService.updateCustomerDeliveryRoutes(dr.getCustomerCode(), null));
        }
        if (!CollectionUtils.isEmpty((Collection)needUpt)) {
            for (DistributionRouteCustomer customer : needUpt) {
                Validate.notNull((Object)((Object)customer.getRoute()), (String)"\u914d\u9001\u8def\u7ebf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getRoute().getId(), (String)"\u914d\u9001\u8def\u7ebf\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getReceiver(), (String)"\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getReceiverPhone(), (String)"\u6536\u8d27\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getReceiverAddress(), (String)"\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getProvinceName(), (String)"\u6536\u8d27\u5730\u5740(\u7701)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getCityName(), (String)"\u6536\u8d27\u5730\u5740(\u5e02)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getDistrictName(), (String)"\u6536\u8d27\u5730\u5740(\u533a)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            this.distributionRouteCustomerRepository.saveAll(needUpt);
            needUpt.forEach(dr -> this.customerService.updateCustomerDeliveryRoutes(dr.getCustomerCode(), dr.getRoute().getCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)needAdd)) {
            for (DistributionRouteCustomer customer : needAdd) {
                Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)customer.getId()), (String)"\u65b0\u589e\u5ba2\u6237\u65f6\uff0c\u5ba2\u6237\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
                customer.setId(null);
                Validate.notNull((Object)((Object)customer.getRoute()), (String)"\u914d\u9001\u8def\u7ebf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getRoute().getId(), (String)"\u914d\u9001\u8def\u7ebf\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getReceiver(), (String)"\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getReceiverPhone(), (String)"\u6536\u8d27\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getReceiverAddress(), (String)"\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getProvinceName(), (String)"\u6536\u8d27\u5730\u5740(\u7701)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getCityName(), (String)"\u6536\u8d27\u5730\u5740(\u5e02)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)customer.getDistrictName(), (String)"\u6536\u8d27\u5730\u5740(\u533a)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            this.distributionRouteCustomerRepository.saveAll(needAdd);
            needAdd.forEach(dr -> this.customerService.updateCustomerDeliveryRoutes(dr.getCustomerCode(), dr.getRoute().getCode()));
        }
        needUpt.addAll(needAdd);
        return Lists.newArrayList((Iterable)needUpt);
    }

    @Override
    @Transactional
    public DistributionRouteCustomer update(DistributionRouteCustomer distributionRouteCustomer) {
        return this.updateForm(distributionRouteCustomer);
    }

    @Override
    @Transactional
    public DistributionRouteCustomer updateForm(DistributionRouteCustomer distributionRouteCustomer) {
        this.updateValidation(distributionRouteCustomer);
        String currentId = distributionRouteCustomer.getId();
        Optional op_currentDistributionRouteCustomer = this.distributionRouteCustomerRepository.findById(currentId);
        DistributionRouteCustomer currentDistributionRouteCustomer = op_currentDistributionRouteCustomer.orElse(null);
        Validate.notNull((Object)((Object)currentDistributionRouteCustomer), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentDistributionRouteCustomer.setCustomerCode(distributionRouteCustomer.getCustomerCode());
        currentDistributionRouteCustomer.setRoute(distributionRouteCustomer.getRoute());
        currentDistributionRouteCustomer.setReceiver(distributionRouteCustomer.getReceiver());
        currentDistributionRouteCustomer.setReceiverPhone(distributionRouteCustomer.getReceiverPhone());
        currentDistributionRouteCustomer.setReceiverAddress(distributionRouteCustomer.getReceiverAddress());
        currentDistributionRouteCustomer.setProvinceName(distributionRouteCustomer.getProvinceName());
        currentDistributionRouteCustomer.setCityName(distributionRouteCustomer.getCityName());
        currentDistributionRouteCustomer.setDistrictName(distributionRouteCustomer.getDistrictName());
        this.distributionRouteCustomerRepository.saveAndFlush((Object)currentDistributionRouteCustomer);
        return currentDistributionRouteCustomer;
    }

    private void updateValidation(DistributionRouteCustomer distributionRouteCustomer) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)distributionRouteCustomer.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)distributionRouteCustomer.getRoute()), (String)"\u914d\u9001\u8def\u7ebf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getReceiver(), (String)"\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getReceiverPhone(), (String)"\u6536\u8d27\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getReceiverAddress(), (String)"\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getProvinceName(), (String)"\u6536\u8d27\u5730\u5740(\u7701)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getCityName(), (String)"\u6536\u8d27\u5730\u5740(\u5e02)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getDistrictName(), (String)"\u6536\u8d27\u5730\u5740(\u533a)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRouteCustomer.getCustomerCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getCustomerCode() == null || distributionRouteCustomer.getCustomerCode().length() < 64 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getReceiver() == null || distributionRouteCustomer.getReceiver().length() < 64 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getReceiverPhone() == null || distributionRouteCustomer.getReceiverPhone().length() < 128 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba\u624b\u673a\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getReceiverAddress() == null || distributionRouteCustomer.getReceiverAddress().length() < 1024 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba\u5730\u5740,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(1024)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getProvinceName() == null || distributionRouteCustomer.getProvinceName().length() < 64 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba\u5730\u5740(\u7701),\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getCityName() == null || distributionRouteCustomer.getCityName().length() < 64 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba\u5730\u5740(\u5e02),\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRouteCustomer.getDistrictName() == null || distributionRouteCustomer.getDistrictName().length() < 64 ? 1 : 0) != 0, (String)"\u6536\u8d27\u4eba\u5730\u5740(\u533a),\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<DistributionRouteCustomer> findDetailsByRoute(String route) {
        if (StringUtils.isBlank((CharSequence)route)) {
            return Sets.newHashSet();
        }
        return this.distributionRouteCustomerRepository.findDetailsByRoute(route);
    }

    @Override
    public Set<DistributionRouteCustomer> findDetailsByRouteCode(String routeCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{routeCode, TenantUtils.getTenantCode()})) {
            return Sets.newHashSet();
        }
        return this.distributionRouteCustomerRepository.findDetailsByRouteCodeAndTenantCode(routeCode, TenantUtils.getTenantCode());
    }

    @Override
    public DistributionRouteCustomer findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.distributionRouteCustomerRepository.findDetailsById(id);
    }

    @Override
    public DistributionRouteCustomer findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.distributionRouteCustomerRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DistributionRouteCustomer current = this.findById(id);
        if (current != null) {
            this.distributionRouteCustomerRepository.delete((Object)current);
        }
    }

    @Override
    public DistributionRouteCustomer findByCustomerCode(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        return this.distributionRouteCustomerRepository.findByCustomerCode(customerCode);
    }
}

