/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.outward;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.entity.CustomerDeliveryInfo;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.sales.dto.DistributionRouteDto;
import com.bizunited.empower.business.sales.entity.outward.DistributionRoute;
import com.bizunited.empower.business.sales.entity.outward.DistributionRouteCustomer;
import com.bizunited.empower.business.sales.entity.outward.OutwardPlan;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.repository.outward.DistributionRouteRepository;
import com.bizunited.empower.business.sales.repository.outward.internal.DistributionRouteRepositoryCustom;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteCustomerService;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteService;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.sales.vo.DistributionRouteCustomerVo;
import com.bizunited.empower.business.sales.vo.DistributionRouteDetailVo;
import com.bizunited.empower.business.sales.vo.DistributionRouteVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DistributionRouteServiceImpl")
public class DistributionRouteServiceImpl
implements DistributionRouteService {
    private static final String ROUTE_CODE_AUTO_INC_KEY = "distribut:route:code:index:%s";
    private static final String ROUTE_CODE_PREFIX = "DRT";
    @Autowired
    private DistributionRouteRepository distributionRouteRepository;
    @Autowired
    private DistributionRouteCustomerService distributionRouteCustomerService;
    @Autowired
    @Qualifier(value="_DistributionRouteRepositoryImpl")
    private DistributionRouteRepositoryCustom distributionRouteRepositoryCustom;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private VehicleTaskService vehicleTasksService;
    @Autowired
    private OutwardPlanService outwardPlanService;

    @Override
    @Transactional
    public DistributionRoute create(DistributionRoute distributionRoute) {
        return this.createForm(distributionRoute);
    }

    @Override
    @Transactional
    public DistributionRoute createForm(DistributionRoute distributionRoute) {
        Date now = new Date();
        String account = SecurityUtils.getUserAccount();
        String tenantCode = TenantUtils.getTenantCode();
        distributionRoute.setCreateAccount(account);
        distributionRoute.setModifyAccount(account);
        distributionRoute.setCreateTime(now);
        distributionRoute.setModifyTime(now);
        distributionRoute.setTenantCode(tenantCode);
        distributionRoute.setCode(this.generateCode(tenantCode));
        distributionRoute.setTstatus(1);
        this.createValidation(distributionRoute);
        this.distributionRouteRepository.saveAndFlush((Object)distributionRoute);
        List<DistributionRouteCustomer> customers = distributionRoute.getCustomers();
        for (DistributionRouteCustomer customer : customers) {
            customer.setRoute(distributionRoute);
            this.distributionRouteCustomerService.create(customer);
            this.customerService.updateCustomerDeliveryRoutes(customer.getCustomerCode(), customer.getRoute().getCode());
        }
        return distributionRoute;
    }

    private void createValidation(DistributionRoute distributionRoute) {
        Validate.notNull((Object)((Object)distributionRoute), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)distributionRoute.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        distributionRoute.setId(null);
        Validate.notBlank((CharSequence)distributionRoute.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRoute.getCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u914d\u9001\u8def\u7ebf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRoute.getName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u914d\u9001\u8def\u7ebf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)distributionRoute.getTstatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u914d\u9001\u8def\u7ebf\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(distributionRoute.getCustomers(), (String)"\u914d\u9001\u8def\u7ebf\u5fc5\u987b\u6307\u5b9a\u5ba2\u6237\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend1() == null || distributionRoute.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend2() == null || distributionRoute.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend3() == null || distributionRoute.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend4() == null || distributionRoute.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend5() == null || distributionRoute.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend6() == null || distributionRoute.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend7() == null || distributionRoute.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getTenantCode() == null || distributionRoute.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getCode() == null || distributionRoute.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getName() == null || distributionRoute.getName().length() < 255 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getRemark() == null || distributionRoute.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        DistributionRoute route = this.findByCode(distributionRoute.getCode());
        Validate.isTrue((route == null ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u7f16\u53f7\u5df2\u5b58\u5728", (Object[])new Object[0]);
        route = this.findByName(distributionRoute.getName());
        Validate.isTrue((route == null ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u7f16\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DistributionRoute update(DistributionRoute distributionRoute) {
        return this.updateForm(distributionRoute);
    }

    @Override
    @Transactional
    public DistributionRoute updateForm(DistributionRoute distributionRoute) {
        this.updateValidation(distributionRoute);
        String currentId = distributionRoute.getId();
        Optional op_currentDistributionRoute = this.distributionRouteRepository.findById(currentId);
        DistributionRoute currentDistributionRoute = op_currentDistributionRoute.orElse(null);
        Validate.notNull((Object)((Object)currentDistributionRoute), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1\u606f", (Object[])new Object[0]);
        Date now = new Date();
        currentDistributionRoute.setModifyAccount(SecurityUtils.getUserAccount());
        currentDistributionRoute.setModifyTime(now);
        currentDistributionRoute.setExtend1(distributionRoute.getExtend1());
        currentDistributionRoute.setExtend2(distributionRoute.getExtend2());
        currentDistributionRoute.setExtend3(distributionRoute.getExtend3());
        currentDistributionRoute.setExtend4(distributionRoute.getExtend4());
        currentDistributionRoute.setExtend5(distributionRoute.getExtend5());
        currentDistributionRoute.setExtend6(distributionRoute.getExtend6());
        currentDistributionRoute.setExtend7(distributionRoute.getExtend7());
        currentDistributionRoute.setExtend8(distributionRoute.getExtend8());
        currentDistributionRoute.setExtend9(distributionRoute.getExtend9());
        currentDistributionRoute.setExtend10(distributionRoute.getExtend10());
        currentDistributionRoute.setExtend11(distributionRoute.getExtend11());
        currentDistributionRoute.setTenantCode(distributionRoute.getTenantCode());
        currentDistributionRoute.setCode(distributionRoute.getCode());
        currentDistributionRoute.setName(distributionRoute.getName());
        currentDistributionRoute.setTstatus(distributionRoute.getTstatus());
        currentDistributionRoute.setRemark(distributionRoute.getRemark());
        currentDistributionRoute.setStartCustomerCode(distributionRoute.getStartCustomerCode());
        currentDistributionRoute.setEndCustomerCode(distributionRoute.getEndCustomerCode());
        this.distributionRouteRepository.saveAndFlush((Object)currentDistributionRoute);
        currentDistributionRoute.setCustomers(distributionRoute.getCustomers());
        for (DistributionRouteCustomer customer : currentDistributionRoute.getCustomers()) {
            customer.setRoute(currentDistributionRoute);
        }
        this.distributionRouteCustomerService.update(currentDistributionRoute.getCustomers());
        return currentDistributionRoute;
    }

    private void updateValidation(DistributionRoute distributionRoute) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)distributionRoute.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRoute.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRoute.getCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u914d\u9001\u8def\u7ebf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionRoute.getName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u914d\u9001\u8def\u7ebf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)distributionRoute.getTstatus(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u914d\u9001\u8def\u7ebf\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(distributionRoute.getCustomers(), (String)"\u914d\u9001\u8def\u7ebf\u5fc5\u987b\u6307\u5b9a\u5ba2\u6237\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend1() == null || distributionRoute.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend2() == null || distributionRoute.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend3() == null || distributionRoute.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend4() == null || distributionRoute.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend5() == null || distributionRoute.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend6() == null || distributionRoute.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getExtend7() == null || distributionRoute.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getTenantCode() == null || distributionRoute.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getCode() == null || distributionRoute.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getName() == null || distributionRoute.getName().length() < 255 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((distributionRoute.getRemark() == null || distributionRoute.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        DistributionRoute route = this.findByCode(distributionRoute.getCode());
        Validate.isTrue((route == null || StringUtils.equals((CharSequence)route.getId(), (CharSequence)distributionRoute.getId()) ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u7f16\u53f7\u5df2\u5b58\u5728", (Object[])new Object[0]);
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format(ROUTE_CODE_AUTO_INC_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        return StringUtils.join((Object[])new String[]{ROUTE_CODE_PREFIX, index});
    }

    @Override
    public DistributionRouteDetailVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DistributionRoute route = this.distributionRouteRepository.findDetailsById(id);
        if (route == null) {
            return null;
        }
        return this.buildRouteDetailVos(route);
    }

    @Override
    public DistributionRouteDetailVo findDetailsByCode(String code) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, tenantCode})) {
            return null;
        }
        DistributionRoute route = this.distributionRouteRepository.findDetailsByCodeAndTenantCode(code, tenantCode);
        if (route == null) {
            return null;
        }
        return this.buildRouteDetailVos(route);
    }

    @Override
    public DistributionRoute findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.distributionRouteRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public DistributionRoute findByCode(String code) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, tenantCode})) {
            return null;
        }
        return this.distributionRouteRepository.findByCodeAndTenantCode(code, tenantCode);
    }

    public DistributionRoute findByName(String name) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{name, tenantCode})) {
            return null;
        }
        return this.distributionRouteRepository.findByNameAndTenantCode(name, tenantCode);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DistributionRoute current = this.findById(id);
        if (current != null) {
            this.checkRelation(current.getCode());
            current.setDelete(true);
            this.distributionRouteRepository.save((Object)current);
        }
    }

    @Override
    @Transactional
    public void deleteByCode(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u7f16\u7801\u4fe1\u606f!!", (Object[])new Object[0]);
        DistributionRoute current = this.findByCode(code);
        if (current != null) {
            this.checkRelation(code);
            current.setDelete(true);
            this.distributionRouteRepository.save((Object)current);
        }
    }

    private void checkRelation(String code) {
        List<OutwardPlan> outwardPlanList = this.outwardPlanService.findOutwardPlanByRouteCode(code);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(outwardPlanList), (String)"\u8be5\u8def\u7ebf\u6709\u5173\u8054\u7684\u51fa\u8f66\u8ba1\u5212,\u4e0d\u53ef\u7981\u7528\u6216\u5220\u9664!", (Object[])new Object[0]);
        List<VehicleTask> vehicleTaskList = this.vehicleTasksService.findVehicleTaskByRouteCode(code);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(vehicleTaskList), (String)"\u8be5\u8def\u7ebf\u6709\u5173\u8054\u7684\u51fa\u8f66\u4efb\u52a1,\u4e0d\u53ef\u7981\u7528\u6216\u5220\u9664!", (Object[])new Object[0]);
    }

    @Override
    public Page<DistributionRouteVo> queryPage(DistributionRouteDto dto, Pageable pageable) {
        if (dto == null) {
            dto = new DistributionRouteDto();
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.distributionRouteRepositoryCustom.queryPage(dto, pageable);
    }

    @Override
    @Transactional
    public void updateStatusByCode(String code, Integer tstatus) {
        Validate.notBlank((CharSequence)code, (String)"\u7f16\u7801code\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)tstatus, (String)"\u72b6\u6001\u503c\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)"\u672a\u83b7\u53d6\u5230\u79df\u6237\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.checkRelation(code);
        this.distributionRouteRepository.updateStatusByCodeAndTenantCode(code, tenantCode, tstatus);
    }

    @Override
    public Set<String> findExistCustomerCodes() {
        if (StringUtils.isBlank((CharSequence)TenantUtils.getTenantCode())) {
            return Sets.newHashSet();
        }
        Set<DistributionRoute> distributionRoutes = this.distributionRouteRepository.findAllExistCustomerByStatusAndTenantCode(1, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(distributionRoutes)) {
            return Sets.newHashSet();
        }
        HashSet existCustomerCodes = Sets.newHashSet();
        for (DistributionRoute route : distributionRoutes) {
            if (CollectionUtils.isEmpty(route.getCustomers())) continue;
            Set customerCodes = route.getCustomers().stream().map(DistributionRouteCustomer::getCustomerCode).collect(Collectors.toSet());
            existCustomerCodes.addAll(customerCodes);
        }
        return existCustomerCodes;
    }

    @Override
    public Page<Customer> findCustomerByConditions(Pageable pageable, Map<String, Object> conditions) {
        Set<String> customerSet = this.findExistCustomerCodes();
        if (!CollectionUtils.isEmpty(customerSet)) {
            conditions.put("customerCodesNot", Lists.newArrayList(customerSet));
        }
        Page byConditions = this.customerService.findByConditions(pageable, conditions);
        return byConditions;
    }

    @Override
    public List<String> findRouteByCustomerCode(String customerCode) {
        if (StringUtils.isEmpty((CharSequence)customerCode)) {
            return Lists.newArrayList();
        }
        return this.distributionRouteRepository.findRouteByCustomerCode(customerCode, TenantUtils.getTenantCode());
    }

    @Override
    public DistributionRoute findByCustomerCode(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        return this.distributionRouteRepository.findByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), customerCode);
    }

    private DistributionRouteDetailVo buildRouteDetailVos(DistributionRoute route) {
        CustomerDeliveryInfo deliveryInfo;
        Customer endCustomer;
        CustomerDeliveryInfo deliveryInfo2;
        if (route == null) {
            return null;
        }
        List<DistributionRouteCustomer> routeCustomers = route.getCustomers();
        if (CollectionUtils.isEmpty(routeCustomers)) {
            return null;
        }
        List customerCodes = routeCustomers.stream().map(DistributionRouteCustomer::getCustomerCode).collect(Collectors.toList());
        List customers = this.customerService.findDetailsByCustomerCodes(customerCodes);
        if (CollectionUtils.isEmpty((Collection)customers)) {
            return null;
        }
        DistributionRouteDetailVo routeVo = (DistributionRouteDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)route, DistributionRouteDetailVo.class, HashSet.class, ArrayList.class, new String[]{""});
        ArrayList routeCustomerVos = Lists.newArrayList();
        routeVo.setCustomers(routeCustomerVos);
        block0: for (DistributionRouteCustomer routeCustomer : routeCustomers) {
            for (Customer customer : customers) {
                if (!StringUtils.equals((CharSequence)routeCustomer.getCustomerCode(), (CharSequence)customer.getCustomerCode())) continue;
                DistributionRouteCustomerVo customerVo = new DistributionRouteCustomerVo();
                customerVo.setId(customer.getId());
                customerVo.setCustomerCode(routeCustomer.getCustomerCode());
                customerVo.setCustomerName(customer.getCustomerName());
                customerVo.setEnabledState(customer.getEnabledState());
                customerVo.setPhone(customer.getPhone());
                customerVo.setRemark(customer.getRemark());
                if (customer.getCustomerCategory() != null) {
                    customerVo.setCustomerCategoryCode(customer.getCustomerCategory().getCode());
                    customerVo.setCustomerCategoryname(customer.getCustomerCategory().getName());
                }
                if (customer.getCustomerLevel() != null) {
                    customerVo.setLevelCode(customer.getCustomerLevel().getLevelCode());
                    customerVo.setLevelName(customer.getCustomerLevel().getLevelName());
                }
                if (customer.getSalesArea() != null) {
                    customerVo.setSalesAreaCode(customer.getSalesArea().getSalesAreaCode());
                    customerVo.setSalesAreaName(customer.getSalesArea().getSalesAreaName());
                }
                customerVo.setReceiver(routeCustomer.getReceiver());
                customerVo.setReceiverAddress(routeCustomer.getReceiverAddress());
                customerVo.setReceiverPhone(routeCustomer.getReceiverPhone());
                customerVo.setProvinceName(routeCustomer.getProvinceName());
                customerVo.setCityName(routeCustomer.getCityName());
                customerVo.setDistrictName(routeCustomer.getDistrictName());
                CustomerDeliveryInfo deliveryInfo3 = customer.getDeliveryInfos().stream().filter(o -> o.getDefaultUse()).findFirst().orElse(null);
                if (null != deliveryInfo3) {
                    customerVo.setLatitude(deliveryInfo3.getLatitude());
                    customerVo.setLongitude(deliveryInfo3.getLongitude());
                }
                routeCustomerVos.add(customerVo);
                continue block0;
            }
        }
        Customer startCustomer = this.customerService.findByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), route.getStartCustomerCode());
        if (null != startCustomer && null != (deliveryInfo2 = (CustomerDeliveryInfo)startCustomer.getDeliveryInfos().stream().filter(o -> o.getDefaultUse()).findFirst().orElse(null))) {
            routeVo.setStartLatitude(deliveryInfo2.getLatitude());
            routeVo.setStartLongitude(deliveryInfo2.getLongitude());
        }
        if (null != (endCustomer = this.customerService.findByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), route.getStartCustomerCode())) && null != (deliveryInfo = (CustomerDeliveryInfo)endCustomer.getDeliveryInfos().stream().filter(o -> o.getDefaultUse()).findFirst().orElse(null))) {
            routeVo.setEndLatitude(deliveryInfo.getLatitude());
            routeVo.setEndLongitude(deliveryInfo.getLongitude());
        }
        return routeVo;
    }
}

