/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.outward;

import com.bizunited.empower.business.sales.entity.outward.OutwardPlanFrequency;
import com.bizunited.empower.business.sales.enums.OutwardPlanFrequencyEnum;
import com.bizunited.empower.business.sales.repository.outward.OutwardPlanFrequencyRepository;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanFrequencyService;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="OutwardPlanFrequencyServiceImpl")
public class OutwardPlanFrequencyServiceImpl
implements OutwardPlanFrequencyService {
    @Autowired
    private OutwardPlanFrequencyRepository outwardPlanFrequencyRepository;

    @Override
    @Transactional
    public OutwardPlanFrequency create(OutwardPlanFrequency outwardPlanFrequency) {
        return this.createForm(outwardPlanFrequency);
    }

    @Override
    @Transactional
    public OutwardPlanFrequency createForm(OutwardPlanFrequency outwardPlanFrequency) {
        this.createValidation(outwardPlanFrequency);
        this.checkFrequency(outwardPlanFrequency);
        this.analysisFrequencyDescr(outwardPlanFrequency);
        this.outwardPlanFrequencyRepository.saveAndFlush((Object)outwardPlanFrequency);
        return outwardPlanFrequency;
    }

    private void createValidation(OutwardPlanFrequency outwardPlanFrequency) {
        Validate.notNull((Object)((Object)outwardPlanFrequency), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)outwardPlanFrequency.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        outwardPlanFrequency.setId(null);
        Validate.notNull((Object)outwardPlanFrequency.getEachNum(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6bcf\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlanFrequency.getUnitCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)outwardPlanFrequency.getSkipHolidays(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u8df3\u8fc7\u8282\u5047\u65e5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((outwardPlanFrequency.getUnitCode() == null || outwardPlanFrequency.getUnitCode().length() < 16 ? 1 : 0) != 0, (String)"\u9891\u7387\u5468\u671f\u5355\u4f4d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(16)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlanFrequency.getHms() == null || outwardPlanFrequency.getHms().length() < 16 ? 1 : 0) != 0, (String)"\u65f6\u5206\u79d2,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(16)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlanFrequency.getWeekRepeat() == null || outwardPlanFrequency.getWeekRepeat().length() < 255 ? 1 : 0) != 0, (String)"\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e3a\u5468\u65f6\uff0c\u91cd\u590d\u503c\uff0c\u9017\u53f7\u62fc\u63a5,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlanFrequency.getMonthRepeat() == null || outwardPlanFrequency.getMonthRepeat().length() < 512 ? 1 : 0) != 0, (String)"\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e3a\u6708\u65f6\uff0c\u91cd\u590d\u503c\uff0c\u9017\u53f7\u62fc\u63a5,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlanFrequency.getEachNum() > 0 && outwardPlanFrequency.getEachNum() < 100 ? 1 : 0) != 0, (String)"\u751f\u6210\u9891\u7387\u7684\u53ef\u586b\u5199\u8303\u56f4\u4e3a\uff1a1-99", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public OutwardPlanFrequency update(OutwardPlanFrequency outwardPlanFrequency) {
        return this.updateForm(outwardPlanFrequency);
    }

    @Override
    @Transactional
    public OutwardPlanFrequency updateForm(OutwardPlanFrequency outwardPlanFrequency) {
        this.updateValidation(outwardPlanFrequency);
        this.checkFrequency(outwardPlanFrequency);
        this.analysisFrequencyDescr(outwardPlanFrequency);
        String currentId = outwardPlanFrequency.getId();
        Optional op_currentOutwardPlanFrequency = this.outwardPlanFrequencyRepository.findById(currentId);
        OutwardPlanFrequency currentOutwardPlanFrequency = op_currentOutwardPlanFrequency.orElse(null);
        Validate.notNull((Object)((Object)currentOutwardPlanFrequency), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentOutwardPlanFrequency.setEachNum(outwardPlanFrequency.getEachNum());
        currentOutwardPlanFrequency.setUnitCode(outwardPlanFrequency.getUnitCode());
        currentOutwardPlanFrequency.setHms(outwardPlanFrequency.getHms());
        currentOutwardPlanFrequency.setWeekRepeat(outwardPlanFrequency.getWeekRepeat());
        currentOutwardPlanFrequency.setMonthRepeat(outwardPlanFrequency.getMonthRepeat());
        currentOutwardPlanFrequency.setSkipHolidays(outwardPlanFrequency.getSkipHolidays());
        currentOutwardPlanFrequency.setDescr(outwardPlanFrequency.getDescr());
        this.outwardPlanFrequencyRepository.saveAndFlush((Object)currentOutwardPlanFrequency);
        return currentOutwardPlanFrequency;
    }

    private void updateValidation(OutwardPlanFrequency outwardPlanFrequency) {
        Validate.notNull((Object)((Object)outwardPlanFrequency), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.isBlank((CharSequence)outwardPlanFrequency.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)outwardPlanFrequency.getEachNum(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6bcf\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlanFrequency.getUnitCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)outwardPlanFrequency.getSkipHolidays(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u8df3\u8fc7\u8282\u5047\u65e5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.analysisFrequencyDescr(outwardPlanFrequency);
        Validate.isTrue((outwardPlanFrequency.getUnitCode() == null || outwardPlanFrequency.getUnitCode().length() < 16 ? 1 : 0) != 0, (String)"\u9891\u7387\u5468\u671f\u5355\u4f4d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(16)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlanFrequency.getHms() == null || outwardPlanFrequency.getHms().length() < 16 ? 1 : 0) != 0, (String)"\u65f6\u5206\u79d2,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(16)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlanFrequency.getWeekRepeat() == null || outwardPlanFrequency.getWeekRepeat().length() < 255 ? 1 : 0) != 0, (String)"\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e3a\u5468\u65f6\uff0c\u91cd\u590d\u503c\uff0c\u9017\u53f7\u62fc\u63a5,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlanFrequency.getMonthRepeat() == null || outwardPlanFrequency.getMonthRepeat().length() < 512 ? 1 : 0) != 0, (String)"\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e3a\u6708\u65f6\uff0c\u91cd\u590d\u503c\uff0c\u9017\u53f7\u62fc\u63a5,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public OutwardPlanFrequency findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.outwardPlanFrequencyRepository.findDetailsById(id);
    }

    @Override
    public OutwardPlanFrequency findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.outwardPlanFrequencyRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        OutwardPlanFrequency current = this.findById(id);
        if (current != null) {
            this.outwardPlanFrequencyRepository.delete((Object)current);
        }
    }

    private void checkFrequency(OutwardPlanFrequency planFrequency) {
        Validate.notNull((Object)((Object)planFrequency), (String)"\u4efb\u52a1\u5468\u671f\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)planFrequency.getEachNum(), (String)"\u6bcf\u503c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)planFrequency.getUnitCode(), (String)"\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)planFrequency.getSkipHolidays(), (String)"\u662f\u5426\u8df3\u8fc7\u8282\u5047\u65e5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)planFrequency.getUnitCode(), (CharSequence)OutwardPlanFrequencyEnum.DAY.name())) {
            Validate.isTrue((StringUtils.isBlank((CharSequence)planFrequency.getWeekRepeat()) && StringUtils.isBlank((CharSequence)planFrequency.getMonthRepeat()) ? 1 : 0) != 0, (String)"\u5f53\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e3a\u3010%s\u3011\u65f6\uff0c\u91cd\u590d\u503c\u5fc5\u987b\u4e3a\u7a7a", (Object[])new Object[]{OutwardPlanFrequencyEnum.DAY.name()});
        }
        if (StringUtils.equals((CharSequence)planFrequency.getUnitCode(), (CharSequence)OutwardPlanFrequencyEnum.WEEK.name())) {
            Validate.notBlank((CharSequence)planFrequency.getWeekRepeat(), (String)"\u5f53\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e3a\u3010%s\u3011\u65f6\uff0c\u91cd\u590d\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{OutwardPlanFrequencyEnum.WEEK.name()});
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)planFrequency.getMonthRepeat()), (String)"\u5f53\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e3a\u3010%s\u3011\u65f6\uff0c\u6708\u91cd\u590d\u503c\u4e0d\u80fd\u6709\u503c", (Object[])new Object[]{OutwardPlanFrequencyEnum.WEEK.name()});
        }
        if (StringUtils.equals((CharSequence)planFrequency.getUnitCode(), (CharSequence)OutwardPlanFrequencyEnum.MONTH.name())) {
            Validate.notBlank((CharSequence)planFrequency.getMonthRepeat(), (String)"\u5f53\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e3a\u3010%s\u3011\u65f6\uff0c\u91cd\u590d\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{OutwardPlanFrequencyEnum.MONTH.name()});
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)planFrequency.getWeekRepeat()), (String)"\u5f53\u9891\u7387\u5468\u671f\u5355\u4f4d\u4e3a\u3010%s\u3011\u65f6\uff0c\u5468\u91cd\u590d\u503c\u4e0d\u80fd\u6709\u503c", (Object[])new Object[]{OutwardPlanFrequencyEnum.MONTH.name()});
        }
    }

    private void analysisFrequencyDescr(OutwardPlanFrequency planFrequency) {
        if (StringUtils.equals((CharSequence)planFrequency.getUnitCode(), (CharSequence)OutwardPlanFrequencyEnum.DAY.name())) {
            planFrequency.setDescr(String.format("\u6bcf%s\u65e5 \u914d\u9001", planFrequency.getEachNum() == 1 ? "" : planFrequency.getEachNum()));
            return;
        }
        if (StringUtils.equals((CharSequence)planFrequency.getUnitCode(), (CharSequence)OutwardPlanFrequencyEnum.WEEK.name())) {
            planFrequency.setDescr(String.format("\u6bcf%s\u5468%s \u914d\u9001", planFrequency.getEachNum() == 1 ? "" : planFrequency.getEachNum(), planFrequency.getWeekRepeat()));
            return;
        }
        if (StringUtils.equals((CharSequence)planFrequency.getUnitCode(), (CharSequence)OutwardPlanFrequencyEnum.MONTH.name())) {
            planFrequency.setDescr(String.format("\u6bcf%s\u6708%s \u914d\u9001", planFrequency.getEachNum() == 1 ? "" : planFrequency.getEachNum(), planFrequency.getMonthRepeat()));
        }
    }
}

