/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.outward;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.sales.dto.OutwardPlanDto;
import com.bizunited.empower.business.sales.entity.outward.DistributionRoute;
import com.bizunited.empower.business.sales.entity.outward.OutwardPlan;
import com.bizunited.empower.business.sales.entity.outward.OutwardPlanFrequency;
import com.bizunited.empower.business.sales.entity.outward.VehicleRecommendProductMix;
import com.bizunited.empower.business.sales.entity.outward.VehicleRecommendProductMixDetail;
import com.bizunited.empower.business.sales.repository.outward.OutwardPlanRepository;
import com.bizunited.empower.business.sales.repository.outward.internal.OutwardPlanRepositoryCustom;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteService;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanFrequencyService;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanService;
import com.bizunited.empower.business.sales.service.outward.VehicleRecommendProductMixService;
import com.bizunited.empower.business.sales.vo.OutwardPlanVo;
import com.bizunited.empower.business.warehouse.entity.WarehouseProduct;
import com.bizunited.empower.business.warehouse.service.WarehouseProductService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.script.context.InvokeParams;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="OutwardPlanServiceImpl")
public class OutwardPlanServiceImpl
implements OutwardPlanService {
    @Autowired
    private VehicleRecommendProductMixService vehicleRecommendProductMixService;
    @Autowired
    private OutwardPlanRepository outwardPlanRepository;
    @Autowired
    private OutwardPlanFrequencyService outwardPlanFrequencyService;
    @Autowired
    @Qualifier(value="_OutwardPlanRepositoryImpl")
    private OutwardPlanRepositoryCustom outwardPlanRepositoryCustom;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private WarehouseProductService warehouseProductService;
    @Autowired
    private DistributionRouteService distributionRouteService;

    @Override
    @Transactional
    public OutwardPlan create(OutwardPlan outwardPlan) {
        this.createForm(outwardPlan);
        return outwardPlan;
    }

    private OutwardPlan createForm(OutwardPlan outwardPlan) {
        Date now = new Date();
        String account = SecurityUtils.getUserAccount();
        String tenantCode = TenantUtils.getTenantCode();
        outwardPlan.setCreateTime(now);
        outwardPlan.setModifyTime(now);
        outwardPlan.setCreateAccount(account);
        outwardPlan.setModifyAccount(account);
        outwardPlan.setTenantCode(tenantCode);
        outwardPlan.setCode(this.generateCode(tenantCode));
        outwardPlan.setFirst(true);
        this.createValidation(outwardPlan);
        OutwardPlanFrequency planFrequency = outwardPlan.getPlanFrequency();
        this.outwardPlanFrequencyService.create(planFrequency);
        this.outwardPlanRepository.saveAndFlush((Object)outwardPlan);
        Set<VehicleRecommendProductMix> mixs = outwardPlan.getProductMix();
        if (!CollectionUtils.isEmpty(mixs)) {
            this.vehicleRecommendProductMixService.create(mixs, outwardPlan);
        }
        return outwardPlan;
    }

    private void createValidation(OutwardPlan outwardPlan) {
        Validate.notNull((Object)((Object)outwardPlan), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)outwardPlan.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        outwardPlan.setId(null);
        Validate.notBlank((CharSequence)outwardPlan.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u8ba1\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u8ba1\u5212\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getVehicleCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getVehicleName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getVehicleNumber(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u53f7\u724c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getLeaderAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8d1f\u8d23\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getLeaderName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8d1f\u8d23\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getWarehouseCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u63d0\u8d27\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getWarehouseName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u63d0\u8d27\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)outwardPlan.getPlanFrequency()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4efb\u52a1\u751f\u6210\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)outwardPlan.getTstatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u72b6\u6001\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend1() == null || outwardPlan.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend2() == null || outwardPlan.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend3() == null || outwardPlan.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend4() == null || outwardPlan.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend5() == null || outwardPlan.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend6() == null || outwardPlan.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend7() == null || outwardPlan.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getTenantCode() == null || outwardPlan.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getCode() == null || outwardPlan.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u8ba1\u5212\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getName() == null || outwardPlan.getName().length() < 255 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u8ba1\u5212\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getVehicleCode() == null || outwardPlan.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getVehicleName() == null || outwardPlan.getVehicleName().length() < 255 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getVehicleNumber() == null || outwardPlan.getVehicleNumber().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u53f7\u724c,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getWarehouseCode() == null || outwardPlan.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u63d0\u8d27\u4ed3\u5e93\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getWarehouseName() == null || outwardPlan.getWarehouseName().length() < 255 ? 1 : 0) != 0, (String)"\u63d0\u8d27\u4ed3\u5e93\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getLeaderName() == null || outwardPlan.getLeaderName().length() < 128 ? 1 : 0) != 0, (String)"\u8d1f\u8d23\u4eba\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getLeaderAccount() == null || outwardPlan.getLeaderAccount().length() < 64 ? 1 : 0) != 0, (String)"\u8d1f\u8d23\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getLeaderPhone() == null || outwardPlan.getLeaderPhone().length() < 64 ? 1 : 0) != 0, (String)"\u8d1f\u8d23\u4eba\u624b\u673a,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getRemark() == null || outwardPlan.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        OutwardPlan plan = this.findByCode(outwardPlan.getCode());
        Validate.isTrue((plan == null ? 1 : 0) != 0, (String)"\u51fa\u8f66\u8ba1\u5212\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        plan = this.findByName(outwardPlan.getName());
        Validate.isTrue((plan == null ? 1 : 0) != 0, (String)"\u51fa\u8f66\u8ba1\u5212\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        this.checkByStatusAndRoutId(outwardPlan);
    }

    @Override
    @Transactional
    public OutwardPlan update(OutwardPlan outwardPlan) {
        OutwardPlan currentOutwardPlan = this.updateForm(outwardPlan);
        return currentOutwardPlan;
    }

    private OutwardPlan updateForm(OutwardPlan outwardPlan) {
        this.updateValidation(outwardPlan);
        this.checkProductMix(outwardPlan);
        String currentId = outwardPlan.getId();
        Optional op_currentOutwardPlan = this.outwardPlanRepository.findById(currentId);
        OutwardPlan currentOutwardPlan = op_currentOutwardPlan.orElse(null);
        Validate.notNull((Object)((Object)currentOutwardPlan), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)currentOutwardPlan.getTstatus().equals(0), (String)"\u7f16\u8f91\u51fa\u8f66\u8ba1\u5212\u65f6,\u51fa\u8f66\u8ba1\u5212\u7684\u72b6\u6001\u5fc5\u987b\u4e3a\u7981\u7528", (Object[])new Object[0]);
        Date now = new Date();
        currentOutwardPlan.setModifyAccount(SecurityUtils.getUserAccount());
        currentOutwardPlan.setModifyTime(now);
        currentOutwardPlan.setExtend1(outwardPlan.getExtend1());
        currentOutwardPlan.setExtend2(outwardPlan.getExtend2());
        currentOutwardPlan.setExtend3(outwardPlan.getExtend3());
        currentOutwardPlan.setExtend4(outwardPlan.getExtend4());
        currentOutwardPlan.setExtend5(outwardPlan.getExtend5());
        currentOutwardPlan.setExtend6(outwardPlan.getExtend6());
        currentOutwardPlan.setExtend7(outwardPlan.getExtend7());
        currentOutwardPlan.setExtend8(outwardPlan.getExtend8());
        currentOutwardPlan.setExtend9(outwardPlan.getExtend9());
        currentOutwardPlan.setExtend10(outwardPlan.getExtend10());
        currentOutwardPlan.setExtend11(outwardPlan.getExtend11());
        currentOutwardPlan.setTenantCode(outwardPlan.getTenantCode());
        currentOutwardPlan.setCode(outwardPlan.getCode());
        currentOutwardPlan.setName(outwardPlan.getName());
        currentOutwardPlan.setVehicleCode(outwardPlan.getVehicleCode());
        currentOutwardPlan.setVehicleName(outwardPlan.getVehicleName());
        currentOutwardPlan.setVehicleNumber(outwardPlan.getVehicleNumber());
        currentOutwardPlan.setLeaderAccount(outwardPlan.getLeaderAccount());
        currentOutwardPlan.setLeaderName(outwardPlan.getLeaderName());
        currentOutwardPlan.setLeaderPhone(outwardPlan.getLeaderPhone());
        currentOutwardPlan.setWarehouseCode(outwardPlan.getWarehouseCode());
        currentOutwardPlan.setRoute(outwardPlan.getRoute());
        currentOutwardPlan.setPlanFrequency(outwardPlan.getPlanFrequency());
        currentOutwardPlan.setTstatus(outwardPlan.getTstatus());
        currentOutwardPlan.setWarehouseName(outwardPlan.getWarehouseName());
        currentOutwardPlan.setRemark(outwardPlan.getRemark());
        currentOutwardPlan.setFirst(true);
        this.outwardPlanFrequencyService.update(currentOutwardPlan.getPlanFrequency());
        this.outwardPlanRepository.saveAndFlush((Object)currentOutwardPlan);
        if (!CollectionUtils.isEmpty(outwardPlan.getProductMix())) {
            this.vehicleRecommendProductMixService.update(outwardPlan.getProductMix(), outwardPlan);
        }
        return currentOutwardPlan;
    }

    private void updateValidation(OutwardPlan outwardPlan) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)outwardPlan.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u8ba1\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u8ba1\u5212\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getVehicleCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getVehicleName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getVehicleNumber(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u53f7\u724c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getLeaderAccount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8d1f\u8d23\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getLeaderName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8d1f\u8d23\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getWarehouseCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u63d0\u8d27\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)outwardPlan.getWarehouseName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u63d0\u8d27\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)outwardPlan.getPlanFrequency()), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4efb\u52a1\u751f\u6210\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)outwardPlan.getTstatus(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u72b6\u6001\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        OutwardPlan plan = this.findByCode(outwardPlan.getCode());
        Validate.isTrue((plan == null || StringUtils.equals((CharSequence)plan.getId(), (CharSequence)outwardPlan.getId()) ? 1 : 0) != 0, (String)"\u51fa\u8f66\u8ba1\u5212\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend1() == null || outwardPlan.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend2() == null || outwardPlan.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend3() == null || outwardPlan.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend4() == null || outwardPlan.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend5() == null || outwardPlan.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend6() == null || outwardPlan.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getExtend7() == null || outwardPlan.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getTenantCode() == null || outwardPlan.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getCode() == null || outwardPlan.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u8ba1\u5212\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getName() == null || outwardPlan.getName().length() < 255 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u8ba1\u5212\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getVehicleCode() == null || outwardPlan.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getVehicleName() == null || outwardPlan.getVehicleName().length() < 255 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getVehicleNumber() == null || outwardPlan.getVehicleNumber().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u53f7\u724c,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getWarehouseCode() == null || outwardPlan.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u63d0\u8d27\u4ed3\u5e93\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getWarehouseName() == null || outwardPlan.getWarehouseName().length() < 255 ? 1 : 0) != 0, (String)"\u63d0\u8d27\u4ed3\u5e93\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getLeaderName() == null || outwardPlan.getLeaderName().length() < 128 ? 1 : 0) != 0, (String)"\u8d1f\u8d23\u4eba\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getLeaderAccount() == null || outwardPlan.getLeaderAccount().length() < 64 ? 1 : 0) != 0, (String)"\u8d1f\u8d23\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getLeaderPhone() == null || outwardPlan.getLeaderPhone().length() < 64 ? 1 : 0) != 0, (String)"\u8d1f\u8d23\u4eba\u624b\u673a,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan.getRemark() == null || outwardPlan.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        this.checkByStatusAndRoutId(outwardPlan);
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format("outward:plan:code:index:%s", tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        return StringUtils.join((Object[])new String[]{"CJ", index});
    }

    @Override
    public Set<OutwardPlan> findDetailsByRoute(String routeId) {
        if (StringUtils.isBlank((CharSequence)routeId)) {
            return Sets.newHashSet();
        }
        return this.outwardPlanRepository.findDetailsByRoute(routeId);
    }

    @Override
    public Set<OutwardPlan> findDetailsByProductMix(String productMixId) {
        if (StringUtils.isBlank((CharSequence)productMixId)) {
            return Sets.newHashSet();
        }
        return this.outwardPlanRepository.findDetailsByProductMix(productMixId);
    }

    @Override
    public OutwardPlan findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.outwardPlanRepository.findDetailsById(id);
    }

    @Override
    public OutwardPlan findDetailsByCode(String code) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, tenantCode})) {
            return null;
        }
        return this.outwardPlanRepository.findDetailsByCodeAndTenantCode(code, tenantCode);
    }

    @Override
    public OutwardPlan findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.outwardPlanRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public OutwardPlan findByCode(String code) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, tenantCode})) {
            return null;
        }
        return this.outwardPlanRepository.findByCodeAndTenantCode(code, tenantCode);
    }

    public OutwardPlan findByName(String name) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{name, tenantCode})) {
            return null;
        }
        return this.outwardPlanRepository.findByNameAndTenantCode(name, tenantCode);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        OutwardPlan outwardPlan = this.findById(id);
        Validate.notNull((Object)((Object)outwardPlan), (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u8ba1\u5212!", (Object[])new Object[0]);
        Validate.isTrue((boolean)outwardPlan.getTstatus().equals(0), (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u51fa\u8f66\u8ba1\u5212\u5fc5\u987b\u4e3a\u7981\u7528\u72b6\u6001!", (Object[])new Object[0]);
        outwardPlan.setDelete(true);
        this.outwardPlanRepository.save((Object)outwardPlan);
    }

    @Override
    @Transactional
    public void deleteByCode(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u7f16\u7801\u4fe1\u606f!!", (Object[])new Object[0]);
        OutwardPlan current = this.findByCode(code);
        if (current != null) {
            current.setDelete(true);
            this.outwardPlanRepository.save((Object)current);
        }
    }

    @Override
    @Transactional
    public void updateStatusByCode(String code, Integer tstatus) {
        Validate.notBlank((CharSequence)code, (String)"\u7f16\u7801code\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)tstatus, (String)"\u72b6\u6001\u503c\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)"\u672a\u83b7\u53d6\u5230\u79df\u6237\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        OutwardPlan outwardPlan = this.outwardPlanRepository.findByCodeAndTenantCode(code, tenantCode);
        Validate.notNull((Object)((Object)outwardPlan), (String)"\u67e5\u8be2\u5230\u7684\u51fa\u8f66\u8ba1\u5212\u4e3a\u7a7a", (Object[])new Object[0]);
        if (tstatus == 1) {
            this.checkByStatusAndRoutId(outwardPlan);
        }
        outwardPlan.setFirst(true);
        outwardPlan.setTriggerTime(null);
        outwardPlan.setGenerateTime(null);
        outwardPlan.setTstatus(tstatus);
        this.outwardPlanRepository.save((Object)outwardPlan);
    }

    @Override
    public Page<OutwardPlanVo> queryPage(OutwardPlanDto dto, Pageable pageable) {
        if (dto == null) {
            dto = new OutwardPlanDto();
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.outwardPlanRepositoryCustom.queryPage(dto, pageable);
    }

    private void checkProductMix(OutwardPlan plan) {
        Set<VehicleRecommendProductMix> mixs = plan.getProductMix();
        if (CollectionUtils.isEmpty(mixs)) {
            return;
        }
        for (VehicleRecommendProductMix mix : mixs) {
            mix.setPlan(plan);
            mix.setTenantCode(plan.getTenantCode());
            Validate.notNull((Object)((Object)mix.getPlan()), (String)"\u5173\u8054\u7684\u51fa\u8f66\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)mix.getTenantCode(), (String)"\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)mix.getName(), (String)"\u63a8\u8350\u7ec4\u5408\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)mix.getSelected(), (String)"\u662f\u5426\u9009\u4e2d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (CollectionUtils.isEmpty(mix.getDetail())) continue;
            for (VehicleRecommendProductMixDetail detail : mix.getDetail()) {
                detail.setProductMix(mix);
                Validate.notNull((Object)((Object)detail.getProductMix()), (String)"\u5173\u8054\u7684\u5546\u54c1\u7ec4\u5408\u4e3b\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)detail.getProductCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notNull((Object)detail.getLoadNum(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u88c5\u8f66\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public List<OutwardPlan> findByVehicleCodeAndRouteCodeAndPlanStatus(String vehicleCode, String routeCode, Integer planStatus) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{vehicleCode, routeCode, tenantCode})) {
            return Lists.newArrayList();
        }
        if (planStatus == null) {
            planStatus = 1;
        }
        return this.outwardPlanRepository.findByVehicleCodeAndRouteCodeAndPlanStatusAndTenantCode(vehicleCode, routeCode, planStatus, tenantCode);
    }

    @Override
    public Set<OutwardPlan> findAllDetailsByStatus(Integer status) {
        if (status == null || StringUtils.isBlank((CharSequence)TenantUtils.getTenantCode())) {
            return Sets.newHashSet();
        }
        return this.outwardPlanRepository.findAllDetailsByStatusAndTenantCode(status, TenantUtils.getTenantCode());
    }

    @Override
    public Page<ProductSpecificationVo> findProductByConditions(String warehouseCode, Pageable pageable, InvokeParams conditions) {
        if (StringUtils.isEmpty((CharSequence)warehouseCode) || null == conditions) {
            return Page.empty((Pageable)pageable);
        }
        Set warehouseProducts = this.warehouseProductService.findByWarehouseCode(warehouseCode);
        if (CollectionUtils.isEmpty((Collection)warehouseProducts)) {
            return Page.empty((Pageable)pageable);
        }
        Set specificationCodes = warehouseProducts.stream().filter(e -> e.getUsableInventory().compareTo(BigDecimal.ZERO) > 0).map(WarehouseProduct::getProductSpecificationCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(specificationCodes)) {
            return Page.empty((Pageable)pageable);
        }
        String productSpecificationCodes = StringUtils.join(specificationCodes, (String)",");
        conditions.putInvokeParam("productCodeList", (Object)productSpecificationCodes);
        return this.productSpecificationVoService.findByConditions(pageable, conditions);
    }

    @Override
    public List<OutwardPlan> findOutwardPlanByRouteCode(String routeCode) {
        if (StringUtils.isEmpty((CharSequence)routeCode)) {
            return Lists.newArrayList();
        }
        return this.outwardPlanRepository.findOutwardPlanByRouteCodeAndTenantCode(routeCode, TenantUtils.getTenantCode());
    }

    @Override
    public List<OutwardPlan> findAllByEnable() {
        return this.outwardPlanRepository.findAllByEnable();
    }

    @Override
    @Transactional
    public void updateOutwardPlanTime(String outwardPlanId, Date triggerTime, Date generateTime) {
        Validate.notBlank((CharSequence)outwardPlanId, (String)"\u636eid\u66f4\u6539\u51fa\u8f66\u8ba1\u5212\u4e2d\u7684 \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4 \u548c\u751f\u6210\u51fa\u8f66\u4efb\u52a1\u7684\u51fa\u8f66\u65f6\u95f4\u65f6 id\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
        OutwardPlan outwardPlan = this.outwardPlanRepository.findById(outwardPlanId).orElse(null);
        Validate.notNull((Object)((Object)outwardPlan), (String)"\u636eid\u66f4\u6539\u51fa\u8f66\u8ba1\u5212\u4e2d\u7684 \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4 \u548c\u751f\u6210\u51fa\u8f66\u4efb\u52a1\u7684\u51fa\u8f66\u65f6\u95f4\u65f6 \u67e5\u8be2\u5230\u7684\u51fa\u8f66\u8ba1\u5212\u4e3a\u7a7a", (Object[])new Object[0]);
        outwardPlan.setTriggerTime(triggerTime);
        outwardPlan.setGenerateTime(generateTime);
        outwardPlan.setFirst(false);
        this.outwardPlanRepository.save((Object)outwardPlan);
    }

    @Override
    @Transactional
    public void updateOutwardPlanFirst(String outwardPlanId) {
        Validate.notBlank((CharSequence)outwardPlanId, (String)"\u6839\u636eid\u66f4\u6539\u51fa\u8f66\u8ba1\u5212\u4e2d\u7684 \u662f\u5426\u4ece\u672a\u6267\u884c\u8fc7\u6216\u8005\u91cd\u65b0\u5f00\u59cb\u6267\u884c\u65f6 id\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
        OutwardPlan outwardPlan = this.outwardPlanRepository.findById(outwardPlanId).orElse(null);
        Validate.notNull((Object)((Object)outwardPlan), (String)"\u636eid\u66f4\u6539\u51fa\u8f66\u8ba1\u5212\u4e2d\u7684 \u662f\u5426\u4ece\u672a\u6267\u884c\u8fc7\u6216\u8005\u91cd\u65b0\u5f00\u59cb\u6267\u884c\u67e5\u8be2\u5230\u7684\u51fa\u8f66\u8ba1\u5212\u4e3a\u7a7a ", (Object[])new Object[0]);
        outwardPlan.setFirst(false);
        this.outwardPlanRepository.save((Object)outwardPlan);
    }

    @Override
    @Transactional
    public void updateInspectTime(String outwardPlanId, Date inspectTime) {
        Validate.notBlank((CharSequence)outwardPlanId, (String)"\u6839\u636eid\u66f4\u6539\u51fa\u8f66\u8ba1\u5212\u4e2d\u7684 \u4e0b\u6b21\u5b9a\u65f6\u4efb\u52a1\u68c0\u67e5\u65e5\u671f id\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
        OutwardPlan outwardPlan = this.outwardPlanRepository.findById(outwardPlanId).orElse(null);
        Validate.notNull((Object)((Object)outwardPlan), (String)"\u636eid\u66f4\u6539\u51fa\u8f66\u8ba1\u5212\u4e2d\u7684 \u4e0b\u6b21\u5b9a\u65f6\u4efb\u52a1\u68c0\u67e5\u65e5\u671f \u67e5\u8be2\u5230\u7684\u51fa\u8f66\u8ba1\u5212\u4e3a\u7a7a", (Object[])new Object[0]);
        outwardPlan.setFirst(false);
        outwardPlan.setInspectTime(inspectTime);
        this.outwardPlanRepository.save((Object)outwardPlan);
    }

    private void checkByStatusAndRoutId(OutwardPlan outwardPlan) {
        DistributionRoute distributionRoute = this.distributionRouteService.findById(outwardPlan.getRoute().getId());
        Validate.notNull((Object)((Object)distributionRoute), (String)"\u542f\u7528\u51fa\u8f66\u8ba1\u5212\u65f6,\u672a\u67e5\u8be2\u5230\u8def\u7ebf", (Object[])new Object[0]);
        List<OutwardPlan> outwardPlanList = this.outwardPlanRepository.findOutwardPlanByRouteCodeAndStatusAndTenantCode(distributionRoute.getCode(), TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(outwardPlanList)) {
            String outwardPlanCode = outwardPlanList.stream().map(OutwardPlan::getCode).filter(code -> !code.equals(outwardPlan.getCode())).findFirst().orElse(null);
            Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)outwardPlanCode), (String)("\u8be5\u8def\u7ebf\u5df2\u88ab\u5176\u4ed6\u51fa\u8f66\u8ba1\u5212\u5173\u8054,\u8ba1\u5212\u7f16\u53f7\u4e3a" + outwardPlanCode), (Object[])new Object[0]);
        }
    }
}

