/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.outward;

import com.bizunited.empower.business.product.optimize.service.ProductFlatService;
import com.bizunited.empower.business.product.optimize.vo.ProductFlatVo;
import com.bizunited.empower.business.product.optimize.vo.ProductSpecificationFlatVo;
import com.bizunited.empower.business.product.optimize.vo.ProductUnitAndPriceFlatVo;
import com.bizunited.empower.business.sales.entity.outward.OutwardPlan;
import com.bizunited.empower.business.sales.entity.outward.OutwardPlanFrequency;
import com.bizunited.empower.business.sales.entity.outward.VehicleRecommendProductMix;
import com.bizunited.empower.business.sales.entity.outward.VehicleRecommendProductMixDetail;
import com.bizunited.empower.business.sales.enums.OutwardPlanFrequencyEnum;
import com.bizunited.empower.business.sales.enums.vehicle.SettlementStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskTypeEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskWayEnum;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanService;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanTaskService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskVoService;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleSaleManVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleSalesProductVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleTaskVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="OutwardPlanTaskServiceImpl.java")
public class OutwardPlanTaskServiceImpl
implements OutwardPlanTaskService {
    private static final int DAY = 7;
    @Autowired
    private OutwardPlanService outwardPlanService;
    @Autowired
    private VehicleTaskVoService vehicleTaskVoService;
    @Autowired
    private ProductFlatService productFlatService;

    @Override
    @Transactional
    public void automaticVehicleTask() {
        ArrayList<VehicleTaskVo> allVehicleTaskVo = new ArrayList<VehicleTaskVo>();
        List<OutwardPlan> outwardPlanAll = this.outwardPlanService.findAllByEnable();
        if (!CollectionUtils.isEmpty(outwardPlanAll)) {
            for (OutwardPlan outwardPlan : outwardPlanAll) {
                List<VehicleTaskVo> vehicleTaskVos;
                OutwardPlanFrequencyEnum frequencyEnum = OutwardPlanFrequencyEnum.getInstance(outwardPlan.getPlanFrequency().getUnitCode());
                switch (frequencyEnum) {
                    case DAY: {
                        vehicleTaskVos = this.processDayFrequency(outwardPlan);
                        break;
                    }
                    case WEEK: {
                        vehicleTaskVos = this.processWeekFrequency(outwardPlan);
                        break;
                    }
                    case MONTH: {
                        vehicleTaskVos = this.processMonthFrequency(outwardPlan);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("\u672a\u77e5\u7684\u4efb\u52a1\u9891\u7387\uff0c\u8bf7\u68c0\u67e5\uff01\u5f53\u524d\u51fa\u8f66\u8ba1\u5212\u4e3a\uff1a\u3010%s\u3011", outwardPlan.getCode()));
                    }
                }
                if (CollectionUtils.isEmpty(vehicleTaskVos)) continue;
                allVehicleTaskVo.addAll(vehicleTaskVos);
            }
        }
        if (!CollectionUtils.isEmpty(allVehicleTaskVo)) {
            this.vehicleTaskVoService.batchSavePlanTask(allVehicleTaskVo);
        }
    }

    @Transactional
    public List<VehicleTaskVo> processDayFrequency(OutwardPlan outwardPlan) {
        ArrayList<VehicleTaskVo> allVehicleTaskVoList = new ArrayList<VehicleTaskVo>();
        OutwardPlanFrequency planFrequency = outwardPlan.getPlanFrequency();
        Integer eachNum = planFrequency.getEachNum();
        Date date = this.getTodayStart();
        Date sevenDate = DateUtils.addDays((Date)this.getTodayStart(), (int)7);
        if (outwardPlan.getFirst().booleanValue()) {
            for (int i = 0; i <= 7; ++i) {
                VehicleTaskVo vehicleTaskVo = this.buildVehicleTaskVo(outwardPlan, date);
                allVehicleTaskVoList.add(vehicleTaskVo);
                date = DateUtils.addDays((Date)date, (int)eachNum);
                if (sevenDate.before(date)) break;
            }
            Date triggerTime = DateUtils.addDays((Date)date, (int)-7);
            Date generateTime = date;
            this.outwardPlanService.updateOutwardPlanTime(outwardPlan.getId(), triggerTime, generateTime);
        } else if (DateUtils.isSameDay((Date)date, (Date)outwardPlan.getTriggerTime())) {
            VehicleTaskVo vehicleTaskVo = this.buildVehicleTaskVo(outwardPlan, outwardPlan.getGenerateTime());
            allVehicleTaskVoList.add(vehicleTaskVo);
            Date triggerTime = DateUtils.addDays((Date)outwardPlan.getTriggerTime(), (int)eachNum);
            Date generateTime = DateUtils.addDays((Date)outwardPlan.getGenerateTime(), (int)eachNum);
            this.outwardPlanService.updateOutwardPlanTime(outwardPlan.getId(), triggerTime, generateTime);
        }
        return allVehicleTaskVoList;
    }

    public List<VehicleTaskVo> processWeekFrequency(OutwardPlan outwardPlan) {
        ArrayList<VehicleTaskVo> allVehicleTaskVoList = new ArrayList<VehicleTaskVo>();
        Date date = this.getTodayStart();
        OutwardPlanFrequency planFrequency = outwardPlan.getPlanFrequency();
        Integer eachNum = planFrequency.getEachNum();
        String weekReapeat = planFrequency.getWeekRepeat();
        if (StringUtils.isEmpty((CharSequence)weekReapeat)) {
            return new ArrayList<VehicleTaskVo>();
        }
        List weekInt = Arrays.asList(weekReapeat.split(",")).stream().map(s -> Integer.parseInt(s.trim())).collect(Collectors.toList());
        if (eachNum > 1) {
            if (outwardPlan.getFirst().booleanValue()) {
                ArrayList already = Lists.newArrayList();
                for (int i = 1; i <= 7; ++i) {
                    int week = this.getWeek(date);
                    if (!CollectionUtils.isEmpty((Collection)already) && week < (Integer)already.get(0)) {
                        Date weekFirst = this.getWeekFirst();
                        Date inspectTime = DateUtils.addDays((Date)DateUtils.addMonths((Date)weekFirst, (int)eachNum), (int)-7);
                        this.outwardPlanService.updateInspectTime(outwardPlan.getId(), inspectTime);
                        break;
                    }
                    if (weekInt.contains(week)) {
                        already.add(week);
                        VehicleTaskVo vehicleTaskVo = this.buildVehicleTaskVo(outwardPlan, date);
                        allVehicleTaskVoList.add(vehicleTaskVo);
                    }
                    date = DateUtils.addDays((Date)date, (int)1);
                }
                this.outwardPlanService.updateOutwardPlanFirst(outwardPlan.getId());
            } else if (outwardPlan.getInspectTime() == null || !this.getTodayStart().before(outwardPlan.getInspectTime())) {
                Date sevenDate;
                int week;
                if (DateUtils.isSameDay((Date)this.getTodayStart(), (Date)this.getWeekFirst())) {
                    Date weekFirst = this.getWeekFirst();
                    Date inspectTime = DateUtils.addWeeks((Date)weekFirst, (int)(eachNum - 1));
                    this.outwardPlanService.updateInspectTime(outwardPlan.getId(), inspectTime);
                }
                if (weekInt.contains(week = this.getWeek(sevenDate = DateUtils.addDays((Date)this.getTodayStart(), (int)7)))) {
                    VehicleTaskVo vehicleTaskVo = this.buildVehicleTaskVo(outwardPlan, sevenDate);
                    allVehicleTaskVoList.add(vehicleTaskVo);
                }
            }
        } else if (outwardPlan.getFirst().booleanValue()) {
            for (int i = 1; i <= 7; ++i) {
                int week = this.getWeek(date);
                if (weekInt.contains(week)) {
                    VehicleTaskVo vehicleTaskVo = this.buildVehicleTaskVo(outwardPlan, date);
                    allVehicleTaskVoList.add(vehicleTaskVo);
                }
                date = DateUtils.addDays((Date)date, (int)1);
            }
            this.outwardPlanService.updateOutwardPlanFirst(outwardPlan.getId());
        } else {
            Date sevenDate = DateUtils.addDays((Date)this.getTodayStart(), (int)7);
            int month = this.getMonth(sevenDate);
            if (weekInt.contains(month)) {
                VehicleTaskVo vehicleTaskVo = this.buildVehicleTaskVo(outwardPlan, sevenDate);
                allVehicleTaskVoList.add(vehicleTaskVo);
            }
        }
        return allVehicleTaskVoList;
    }

    public List<VehicleTaskVo> processMonthFrequency(OutwardPlan outwardPlan) {
        ArrayList<VehicleTaskVo> allVehicleTaskVoList = new ArrayList<VehicleTaskVo>();
        Date date = this.getTodayStart();
        OutwardPlanFrequency planFrequency = outwardPlan.getPlanFrequency();
        Integer eachNum = planFrequency.getEachNum();
        String monthRepeat = planFrequency.getMonthRepeat();
        if (StringUtils.isEmpty((CharSequence)monthRepeat)) {
            return new ArrayList<VehicleTaskVo>();
        }
        List monthInt = Arrays.asList(monthRepeat.split(",")).stream().map(s -> Integer.parseInt(s.trim())).collect(Collectors.toList());
        if (eachNum > 1) {
            if (outwardPlan.getFirst().booleanValue()) {
                ArrayList already = Lists.newArrayList();
                for (int i = 1; i <= 7; ++i) {
                    int month = this.getMonth(date);
                    if (!CollectionUtils.isEmpty((Collection)already) && month < (Integer)already.get(0)) {
                        Date monthFirst = this.getMonthFirst();
                        Date inspectTime = DateUtils.addDays((Date)DateUtils.addMonths((Date)monthFirst, (int)eachNum), (int)-7);
                        this.outwardPlanService.updateInspectTime(outwardPlan.getId(), inspectTime);
                        break;
                    }
                    if (monthInt.contains(month)) {
                        already.add(month);
                        VehicleTaskVo vehicleTaskVo = this.buildVehicleTaskVo(outwardPlan, date);
                        allVehicleTaskVoList.add(vehicleTaskVo);
                    }
                    date = DateUtils.addDays((Date)date, (int)1);
                }
                this.outwardPlanService.updateOutwardPlanFirst(outwardPlan.getId());
            } else if (outwardPlan.getInspectTime() == null || !this.getTodayStart().before(outwardPlan.getInspectTime())) {
                int month;
                Date nextMonth;
                Date sevenDate = DateUtils.addDays((Date)this.getTodayStart(), (int)7);
                if (DateUtils.isSameDay((Date)sevenDate, (Date)(nextMonth = DateUtils.addMonths((Date)this.getMonthFirst(), (int)1)))) {
                    Date monthFirst = this.getMonthFirst();
                    Date inspectTime = DateUtils.addDays((Date)DateUtils.addMonths((Date)monthFirst, (int)eachNum), (int)-7);
                    this.outwardPlanService.updateInspectTime(outwardPlan.getId(), inspectTime);
                }
                if (monthInt.contains(month = this.getMonth(sevenDate))) {
                    VehicleTaskVo vehicleTaskVo = this.buildVehicleTaskVo(outwardPlan, sevenDate);
                    allVehicleTaskVoList.add(vehicleTaskVo);
                }
            }
        } else if (outwardPlan.getFirst().booleanValue()) {
            for (int i = 1; i <= 7; ++i) {
                int month = this.getMonth(date);
                if (monthInt.contains(month)) {
                    VehicleTaskVo vehicleTaskVo = this.buildVehicleTaskVo(outwardPlan, date);
                    allVehicleTaskVoList.add(vehicleTaskVo);
                }
                date = DateUtils.addDays((Date)date, (int)1);
            }
            this.outwardPlanService.updateOutwardPlanFirst(outwardPlan.getId());
        } else {
            Date sevenDate = DateUtils.addDays((Date)this.getTodayStart(), (int)7);
            int month = this.getMonth(sevenDate);
            if (monthInt.contains(month)) {
                VehicleTaskVo vehicleTaskVo = this.buildVehicleTaskVo(outwardPlan, sevenDate);
                allVehicleTaskVoList.add(vehicleTaskVo);
            }
        }
        return allVehicleTaskVoList;
    }

    private VehicleTaskVo buildVehicleTaskVo(OutwardPlan outwardPlan, Date vehicleTaskDate) {
        VehicleTaskVo vehicleTaskVo = new VehicleTaskVo();
        Date now = new Date();
        vehicleTaskVo.setCreateAccount(outwardPlan.getCreateAccount());
        vehicleTaskVo.setCreateTime(now);
        vehicleTaskVo.setModifyAccount(outwardPlan.getModifyAccount());
        vehicleTaskVo.setModifyTime(now);
        vehicleTaskVo.setTenantCode(outwardPlan.getTenantCode());
        vehicleTaskVo.setVehicleTaskWay(VehicleTaskWayEnum.AUTO.getType());
        vehicleTaskVo.setVehicleTaskStatus(VehicleTaskStatusEnum.WAIT_CONFIRM.getType());
        vehicleTaskVo.setRouteCode(outwardPlan.getRoute().getCode());
        vehicleTaskVo.setVehicleCode(outwardPlan.getVehicleCode());
        vehicleTaskVo.setVehicleName(outwardPlan.getVehicleName());
        vehicleTaskVo.setCarNumber(outwardPlan.getVehicleNumber());
        vehicleTaskVo.setWarehouseCode(outwardPlan.getWarehouseCode());
        vehicleTaskVo.setWarehouseName(outwardPlan.getWarehouseName());
        vehicleTaskVo.setTaskTime(vehicleTaskDate);
        vehicleTaskVo.setSettlementStatus(SettlementStatusEnum.WAIT_SETTLEMENT.getType());
        vehicleTaskVo.setRemark(outwardPlan.getRemark());
        vehicleTaskVo.setVehicleTaskType(VehicleTaskTypeEnum.DISTRIBUTION.getType());
        vehicleTaskVo.setOutwardPlanCode(outwardPlan.getCode());
        VehicleSaleManVo vehicleSaleManVo = new VehicleSaleManVo();
        vehicleSaleManVo.setHead(true);
        vehicleSaleManVo.setUserAccount(outwardPlan.getLeaderAccount());
        vehicleSaleManVo.setUserName(outwardPlan.getLeaderName());
        vehicleSaleManVo.setTenantCode(outwardPlan.getTenantCode());
        ArrayList<VehicleSaleManVo> vehicleSaleManVoList = new ArrayList<VehicleSaleManVo>();
        vehicleSaleManVoList.add(vehicleSaleManVo);
        vehicleTaskVo.setSaleManVos(vehicleSaleManVoList);
        ArrayList<VehicleSalesProductVo> vehicleSalesProductVoList = new ArrayList<VehicleSalesProductVo>();
        if (!CollectionUtils.isEmpty(outwardPlan.getProductMix())) {
            for (VehicleRecommendProductMix productMix : outwardPlan.getProductMix()) {
                if (CollectionUtils.isEmpty(productMix.getDetail())) continue;
                for (VehicleRecommendProductMixDetail productMixDetail : productMix.getDetail()) {
                    VehicleSalesProductVo filterVehicleSalesProductVo = vehicleSalesProductVoList.stream().filter(product -> product.getProductCode().equals(productMixDetail.getProductCode()) && product.getProductSpecificationCode().equals(productMixDetail.getProductSpecificationCode()) && product.getUnitCode().equals(productMixDetail.getUnitCode())).findFirst().orElse(null);
                    if (null == filterVehicleSalesProductVo) {
                        VehicleSalesProductVo vehicleSalesProductVo = new VehicleSalesProductVo();
                        vehicleSalesProductVo.setProductCode(productMixDetail.getProductCode());
                        vehicleSalesProductVo.setProductSpecificationCode(productMixDetail.getProductSpecificationCode());
                        vehicleSalesProductVo.setUnitCode(productMixDetail.getUnitCode());
                        vehicleSalesProductVo.setQuantity(new BigDecimal(productMixDetail.getLoadNum()));
                        vehicleSalesProductVoList.add(vehicleSalesProductVo);
                        continue;
                    }
                    filterVehicleSalesProductVo.setQuantity(filterVehicleSalesProductVo.getQuantity().add(new BigDecimal(productMixDetail.getLoadNum())));
                }
            }
        }
        if (!CollectionUtils.isEmpty(vehicleSalesProductVoList)) {
            List productCodes = vehicleSalesProductVoList.stream().map(VehicleSalesProductVo::getProductCode).collect(Collectors.toList());
            List productSet = this.productFlatService.findByProductCodeList(productCodes, TenantUtils.getTenantCode());
            Map<Object, Object> productMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)productSet)) {
                productMap = productSet.stream().collect(Collectors.toMap(ProductFlatVo::getProductCode, Function.identity()));
            }
            for (VehicleSalesProductVo vehicleSalesProductVo : vehicleSalesProductVoList) {
                if (productMap.containsKey(vehicleSalesProductVo.getProductCode())) {
                    Map unitAndPriceMap;
                    ProductFlatVo productFlatVo = (ProductFlatVo)productMap.get(vehicleSalesProductVo.getProductCode());
                    vehicleSalesProductVo.setProductName(productFlatVo.getProductName());
                    vehicleSalesProductVo.setRemainingQuantity(vehicleSalesProductVo.getQuantity());
                    vehicleSalesProductVo.setBarCode(productFlatVo.getBrandCode());
                    vehicleSalesProductVo.setCategoryCode(productFlatVo.getCategoryCode());
                    vehicleSalesProductVo.setCategoryName(productFlatVo.getCategoryName());
                    vehicleSalesProductVo.setBrandCode(productFlatVo.getBrandCode());
                    vehicleSalesProductVo.setBrandName(productFlatVo.getBrandName());
                    Map specificationMap = productFlatVo.getProductSpecificationMap();
                    if (!CollectionUtils.isEmpty((Map)specificationMap) && specificationMap.containsKey(vehicleSalesProductVo.getProductSpecificationCode())) {
                        ProductSpecificationFlatVo productSpecificationFlatVo = (ProductSpecificationFlatVo)specificationMap.get(vehicleSalesProductVo.getProductSpecificationCode());
                        vehicleSalesProductVo.setProductSpecificationName(productSpecificationFlatVo.getProductSpecificationName());
                        vehicleSalesProductVo.setRelativePath(productSpecificationFlatVo.getMainImagePath());
                        vehicleSalesProductVo.setFileName(productSpecificationFlatVo.getMainImageName());
                    }
                    if (!CollectionUtils.isEmpty((Map)(unitAndPriceMap = productFlatVo.getProductUnitAndPriceMap())) && unitAndPriceMap.containsKey(vehicleSalesProductVo.getUnitCode())) {
                        ProductUnitAndPriceFlatVo unitAndPriceFlatVo = (ProductUnitAndPriceFlatVo)unitAndPriceMap.get(vehicleSalesProductVo.getUnitCode());
                        vehicleSalesProductVo.setUnitName(unitAndPriceFlatVo.getUnitName());
                        vehicleSalesProductVo.setPurchasePrice(unitAndPriceFlatVo.getReferencePurchasePrice());
                        vehicleSalesProductVo.setSellingPrice(unitAndPriceFlatVo.getSellingPrice());
                    }
                }
                vehicleSalesProductVo.setVehicleCode(outwardPlan.getVehicleCode());
            }
            vehicleTaskVo.setVehicleSalesProductVos(vehicleSalesProductVoList);
        }
        return vehicleTaskVo;
    }

    private Date getTodayStart() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    private int getWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int i = calendar.get(7);
        if (i == 1) {
            return 7;
        }
        return i - 1;
    }

    private int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int i = calendar.get(5);
        return i;
    }

    private Date getMonthFirst() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date time = calendar.getTime();
        return time;
    }

    private Date getWeekFirst() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date time = calendar.getTime();
        return time;
    }
}

