/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.outward;

import com.bizunited.empower.business.sales.entity.outward.OutwardPlan;
import com.bizunited.empower.business.sales.entity.outward.VehicleRecommendProductMix;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanService;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanVoService;
import com.bizunited.empower.business.sales.service.outward.VehicleRecommendProductMixVoService;
import com.bizunited.empower.business.sales.vo.OutwardPlanVo;
import com.bizunited.empower.business.sales.vo.VehicleRecommendProductMixVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="OutwardPlanVoServiceImpl")
public class OutwardPlanVoServiceImpl
implements OutwardPlanVoService {
    @Autowired
    private OutwardPlanService outwardPlanService;
    @Autowired
    private VehicleRecommendProductMixVoService vehicleRecommendProductMixVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    private static final String[] DETAIL_PROPS = new String[]{"route", "productMix", "productMix.detail", "planFrequency"};

    @Override
    public OutwardPlanVo findDetailsById(String id) {
        Set<VehicleRecommendProductMix> productMix;
        OutwardPlan outwardPlan = this.outwardPlanService.findDetailsById(id);
        if (outwardPlan == null) {
            return null;
        }
        OutwardPlanVo outwardPlanVo = (OutwardPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)outwardPlan, OutwardPlanVo.class, LinkedHashSet.class, ArrayList.class, DETAIL_PROPS);
        if (null != outwardPlan.getRoute()) {
            outwardPlanVo.setDistributionRouteCode(outwardPlan.getRoute().getCode());
            outwardPlanVo.setDistributionRouteName(outwardPlan.getRoute().getName());
        }
        if (!CollectionUtils.isEmpty(productMix = outwardPlan.getProductMix())) {
            List<String> mixCodes = productMix.stream().map(VehicleRecommendProductMix::getCode).collect(Collectors.toList());
            List<VehicleRecommendProductMixVo> detailsByCodes = this.vehicleRecommendProductMixVoService.findDetailsByCodes(mixCodes);
            detailsByCodes.sort(Comparator.comparing(VehicleRecommendProductMixVo::getSortIndex));
            outwardPlanVo.setVehicleRecommendProductMixVos(detailsByCodes);
        }
        return outwardPlanVo;
    }
}

