/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.outward;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.sales.entity.outward.OutwardPlan;
import com.bizunited.empower.business.sales.entity.outward.VehicleRecommendProductMix;
import com.bizunited.empower.business.sales.entity.outward.VehicleRecommendProductMixDetail;
import com.bizunited.empower.business.sales.repository.outward.VehicleRecommendProductMixDetailRepository;
import com.bizunited.empower.business.sales.repository.outward.VehicleRecommendProductMixRepository;
import com.bizunited.empower.business.sales.service.outward.VehicleRecommendProductMixService;
import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="VehicleRecommendProductMixServiceImpl")
public class VehicleRecommendProductMixServiceImpl
implements VehicleRecommendProductMixService {
    @Autowired
    private VehicleRecommendProductMixRepository vehicleRecommendProductMixRepository;
    @Autowired
    private VehicleRecommendProductMixDetailRepository vehicleRecommendProductMixDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;

    @Override
    @Transactional
    public Set<VehicleRecommendProductMix> create(Set<VehicleRecommendProductMix> mixs, OutwardPlan outwardPlan) {
        Validate.notEmpty(mixs, (String)"\u4fdd\u5b58\u65f6\uff0c\u8f66\u9500\u63a8\u8350\u5546\u54c1\u7ec4\u5408\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((outwardPlan != null && StringUtils.isNotBlank((CharSequence)outwardPlan.getId()) ? 1 : 0) != 0, (String)"\u51fa\u8f66\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date now = new Date();
        String account = SecurityUtils.getUserAccount();
        String tenantCode = TenantUtils.getTenantCode();
        for (VehicleRecommendProductMix mix : mixs) {
            mix.setCreateTime(now);
            mix.setModifyTime(now);
            mix.setCreateAccount(account);
            mix.setModifyAccount(account);
            mix.setTenantCode(tenantCode);
            mix.setPlan(outwardPlan);
            mix.setCode(this.generateCode(tenantCode));
            this.createValidation(mix);
            this.vehicleRecommendProductMixRepository.saveAndFlush((Object)mix);
            if (CollectionUtils.isEmpty(mix.getDetail())) continue;
            for (VehicleRecommendProductMixDetail detail : mix.getDetail()) {
                detail.setId(null);
                detail.setProductMix(mix);
                this.requiredValidate(detail);
            }
            this.vehicleRecommendProductMixDetailRepository.saveAll(mix.getDetail());
        }
        return mixs;
    }

    @Override
    @Transactional
    public Set<VehicleRecommendProductMix> update(Set<VehicleRecommendProductMix> mixs, OutwardPlan outwardPlan) {
        Validate.isTrue((outwardPlan != null && StringUtils.isNotBlank((CharSequence)outwardPlan.getId()) ? 1 : 0) != 0, (String)"\u51fa\u8f66\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<VehicleRecommendProductMix> dbMixs = this.vehicleRecommendProductMixRepository.findDetailsByOutwardPlan(outwardPlan.getId());
        HashSet needDelete = Sets.newHashSet();
        HashSet needAdd = Sets.newHashSet();
        HashSet needUpt = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy(mixs, dbMixs, UuidEntity::getId, (Collection)needDelete, (Collection)needUpt, (Collection)needAdd);
        if (!CollectionUtils.isEmpty((Collection)needDelete)) {
            Set<String> productMixIds = needDelete.stream().map(UuidEntity::getId).collect(Collectors.toSet());
            this.vehicleRecommendProductMixDetailRepository.deleteByProductMixs(productMixIds);
            this.vehicleRecommendProductMixRepository.deleteInBatch(needDelete);
        }
        if (!CollectionUtils.isEmpty((Collection)needAdd)) {
            this.create(Sets.newHashSet((Iterable)needAdd), outwardPlan);
        }
        if (!CollectionUtils.isEmpty((Collection)needUpt)) {
            for (VehicleRecommendProductMix mix : needUpt) {
                VehicleRecommendProductMix frontMix = mixs.stream().filter(e -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)mix.getId())).findFirst().orElse(null);
                Validate.notNull((Object)((Object)frontMix), (String)"\u672a\u80fd\u5339\u914d\u66f4\u65b0\u7684\u7ec4\u5408\u6570\u636e", (Object[])new Object[0]);
                this.updateValidation(frontMix);
                frontMix.setCreateAccount(mix.getCreateAccount());
                frontMix.setCreateTime(mix.getCreateTime());
                frontMix.setModifyAccount(SecurityUtils.getUserAccount());
                frontMix.setModifyTime(new Date());
                this.vehicleRecommendProductMixRepository.saveAndFlush((Object)frontMix);
                HashSet needDeleteDetail = Sets.newHashSet();
                HashSet needAddDetail = Sets.newHashSet();
                HashSet needUptDetail = Sets.newHashSet();
                Set<Object> dbMixDetails = Sets.newHashSet();
                if (!CollectionUtils.isEmpty(mix.getDetail())) {
                    dbMixDetails = mix.getDetail();
                }
                this.nebulaToolkitService.collectionDiscrepancy(frontMix.getDetail(), (Collection)dbMixDetails, UuidEntity::getId, (Collection)needDeleteDetail, (Collection)needUptDetail, (Collection)needAddDetail);
                if (!CollectionUtils.isEmpty((Collection)needDeleteDetail)) {
                    this.vehicleRecommendProductMixDetailRepository.deleteInBatch(needDeleteDetail);
                }
                if (!CollectionUtils.isEmpty((Collection)needAddDetail)) {
                    for (VehicleRecommendProductMixDetail detail : needAddDetail) {
                        detail.setId(null);
                        detail.setProductMix(frontMix);
                        this.requiredValidate(detail);
                    }
                    this.vehicleRecommendProductMixDetailRepository.saveAll(needAddDetail);
                }
                if (CollectionUtils.isEmpty((Collection)needUptDetail)) continue;
                HashSet frontMixDetails = Sets.newHashSet();
                for (VehicleRecommendProductMixDetail detail : needUptDetail) {
                    VehicleRecommendProductMixDetail mixDetail = frontMix.getDetail().stream().filter(e -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)detail.getId())).findFirst().orElse(null);
                    Validate.notNull((Object)((Object)mixDetail), (String)"\u66f4\u65b0\u65f6\uff0c\u63a8\u8350\u5546\u54c1\u7ec4\u5408\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    mixDetail.setProductMix(frontMix);
                    this.requiredValidate(mixDetail);
                    frontMixDetails.add(mixDetail);
                }
                this.vehicleRecommendProductMixDetailRepository.saveAll(frontMixDetails);
            }
        }
        return mixs;
    }

    private void createValidation(VehicleRecommendProductMix vehicleRecommendProductMix) {
        Validate.notNull((Object)((Object)vehicleRecommendProductMix), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)vehicleRecommendProductMix.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        vehicleRecommendProductMix.setId(null);
        Validate.notBlank((CharSequence)vehicleRecommendProductMix.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleRecommendProductMix.getCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u63a8\u8350\u7ec4\u5408\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleRecommendProductMix.getName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u63a8\u8350\u7ec4\u5408\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleRecommendProductMix.getSelected(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u9009\u4e2d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend1() == null || vehicleRecommendProductMix.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend2() == null || vehicleRecommendProductMix.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend3() == null || vehicleRecommendProductMix.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend4() == null || vehicleRecommendProductMix.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend5() == null || vehicleRecommendProductMix.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend6() == null || vehicleRecommendProductMix.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend7() == null || vehicleRecommendProductMix.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getTenantCode() == null || vehicleRecommendProductMix.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getCode() == null || vehicleRecommendProductMix.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u63a8\u8350\u7ec4\u5408\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getName() == null || vehicleRecommendProductMix.getName().length() < 255 ? 1 : 0) != 0, (String)"\u63a8\u8350\u7ec4\u5408\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void updateValidation(VehicleRecommendProductMix vehicleRecommendProductMix) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)vehicleRecommendProductMix.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleRecommendProductMix.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleRecommendProductMix.getCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u63a8\u8350\u7ec4\u5408\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleRecommendProductMix.getName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u63a8\u8350\u7ec4\u5408\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleRecommendProductMix.getSelected(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u9009\u4e2d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend1() == null || vehicleRecommendProductMix.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend2() == null || vehicleRecommendProductMix.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend3() == null || vehicleRecommendProductMix.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend4() == null || vehicleRecommendProductMix.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend5() == null || vehicleRecommendProductMix.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend6() == null || vehicleRecommendProductMix.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getExtend7() == null || vehicleRecommendProductMix.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getTenantCode() == null || vehicleRecommendProductMix.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getCode() == null || vehicleRecommendProductMix.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u63a8\u8350\u7ec4\u5408\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleRecommendProductMix.getName() == null || vehicleRecommendProductMix.getName().length() < 255 ? 1 : 0) != 0, (String)"\u63a8\u8350\u7ec4\u5408\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format("vehicle:productMix:code:index:%s", tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        return StringUtils.join((Object[])new String[]{"RPM", index});
    }

    @Override
    public VehicleRecommendProductMix findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.vehicleRecommendProductMixRepository.findDetailsById(id);
    }

    @Override
    public VehicleRecommendProductMix findDetailsByCode(String code) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, TenantUtils.getTenantCode()})) {
            return null;
        }
        return this.vehicleRecommendProductMixRepository.findDetailsByCodeAndTenantCode(code, TenantUtils.getTenantCode());
    }

    @Override
    public VehicleRecommendProductMix findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.vehicleRecommendProductMixRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        VehicleRecommendProductMix current = this.findById(id);
        if (current != null) {
            this.vehicleRecommendProductMixRepository.delete((Object)current);
        }
    }

    @Override
    public List<VehicleRecommendProductMix> findDetailsByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<VehicleRecommendProductMix>();
        }
        return this.vehicleRecommendProductMixRepository.findDetailsByCodeAndTenantCodes(codes, TenantUtils.getTenantCode());
    }

    private void requiredValidate(VehicleRecommendProductMixDetail detail) {
        Validate.notBlank((CharSequence)detail.getUnitCode(), (String)"\u4fdd\u5b58\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getProductCode(), (String)"\u4fdd\u5b58\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getProductSpecificationCode(), (String)"\u4fdd\u5b58\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u89c4\u683c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)detail.getLoadNum(), (String)"\u4fdd\u5b58\u4fe1\u606f\u65f6\uff0c\u88c5\u8f66\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

