/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.outward;

import com.bizunited.empower.business.product.optimize.service.ProductFlatService;
import com.bizunited.empower.business.product.optimize.vo.ProductFlatVo;
import com.bizunited.empower.business.product.optimize.vo.ProductSpecificationFlatVo;
import com.bizunited.empower.business.product.optimize.vo.ProductUnitAndPriceFlatVo;
import com.bizunited.empower.business.sales.entity.outward.VehicleRecommendProductMix;
import com.bizunited.empower.business.sales.entity.outward.VehicleRecommendProductMixDetail;
import com.bizunited.empower.business.sales.service.outward.VehicleRecommendProductMixService;
import com.bizunited.empower.business.sales.service.outward.VehicleRecommendProductMixVoService;
import com.bizunited.empower.business.sales.vo.VehicleRecommendProductMixDetailVo;
import com.bizunited.empower.business.sales.vo.VehicleRecommendProductMixVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="VehicleRecommendProductMixVoServiceImpl")
public class VehicleRecommendProductMixVoServiceImpl
implements VehicleRecommendProductMixVoService {
    @Autowired
    private VehicleRecommendProductMixService vehicleRecommendProductMixService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProductFlatService productFlatService;

    @Override
    public VehicleRecommendProductMixVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        VehicleRecommendProductMix mix = this.vehicleRecommendProductMixService.findDetailsById(id);
        return this.returnMixVoData(mix);
    }

    private VehicleRecommendProductMixVo returnMixVoData(VehicleRecommendProductMix mix) {
        if (mix == null) {
            return null;
        }
        VehicleRecommendProductMixVo mixVo = (VehicleRecommendProductMixVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)mix, VehicleRecommendProductMixVo.class, HashSet.class, ArrayList.class, new String[]{""});
        if (CollectionUtils.isEmpty(mix.getDetail())) {
            return mixVo;
        }
        List productCodes = mix.getDetail().stream().map(VehicleRecommendProductMixDetail::getProductCode).distinct().collect(Collectors.toList());
        List productSet = this.productFlatService.findByProductCodeList(productCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty((Collection)productSet)) {
            return mixVo;
        }
        ArrayList detailVoList = Lists.newArrayList();
        for (VehicleRecommendProductMixDetail detail : mix.getDetail()) {
            VehicleRecommendProductMixDetailVo detailVo = this.buildMixDetailVo(productSet, detail);
            detailVoList.add(detailVo);
        }
        mixVo.setDetail(detailVoList);
        return mixVo;
    }

    private VehicleRecommendProductMixDetailVo buildMixDetailVo(List<ProductFlatVo> productSet, VehicleRecommendProductMixDetail detail) {
        VehicleRecommendProductMixDetailVo detailVo = new VehicleRecommendProductMixDetailVo();
        detailVo.setId(detail.getId());
        detailVo.setBarCode(detail.getBarCode());
        detailVo.setLoadNum(detail.getLoadNum());
        for (ProductFlatVo product : productSet) {
            Map unitAndPriceMap;
            ProductUnitAndPriceFlatVo unitAndPriceFlatDto;
            if (!StringUtils.equals((CharSequence)detail.getProductCode(), (CharSequence)product.getProductCode())) continue;
            detailVo.setProductCode(product.getProductCode());
            detailVo.setProductName(product.getProductName());
            detailVo.setBrandCode(product.getBrandCode());
            detailVo.setBrandName(product.getBrandName());
            detailVo.setCategoryCode(product.getCategoryCode());
            detailVo.setCategoryName(product.getCategoryName());
            Map specificationMap = product.getProductSpecificationMap();
            ProductSpecificationFlatVo specificationFlatDto = (ProductSpecificationFlatVo)specificationMap.get(detail.getProductSpecificationCode());
            if (specificationFlatDto != null) {
                detailVo.setProductSpecificationCode(specificationFlatDto.getProductSpecificationCode());
                detailVo.setProductSpecificationName(specificationFlatDto.getProductSpecificationName());
                detailVo.setMainImagePath(specificationFlatDto.getMainImagePath());
                detailVo.setMainImageName(specificationFlatDto.getMainImageName());
            }
            if ((unitAndPriceFlatDto = (ProductUnitAndPriceFlatVo)(unitAndPriceMap = product.getProductUnitAndPriceMap()).get(detail.getUnitCode())) == null) break;
            detailVo.setPurchasePrice(unitAndPriceFlatDto.getReferencePurchasePrice());
            detailVo.setUnitCode(unitAndPriceFlatDto.getUnitCode());
            detailVo.setUnitName(unitAndPriceFlatDto.getUnitName());
            detailVo.setSubtotalAmount(detailVo.getPurchasePrice().multiply(new BigDecimal(detailVo.getLoadNum())).setScale(4, 4));
            break;
        }
        return detailVo;
    }

    @Override
    public VehicleRecommendProductMixVo findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        VehicleRecommendProductMix mix = this.vehicleRecommendProductMixService.findDetailsByCode(code);
        return this.returnMixVoData(mix);
    }

    @Override
    public List<VehicleRecommendProductMixVo> findDetailsByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<VehicleRecommendProductMix> mixList = this.vehicleRecommendProductMixService.findDetailsByCodes(codes);
        ArrayList<VehicleRecommendProductMixVo> list = new ArrayList<VehicleRecommendProductMixVo>();
        for (VehicleRecommendProductMix vehicleRecommendProductMix : mixList) {
            VehicleRecommendProductMixVo vo = this.returnMixVoData(vehicleRecommendProductMix);
            list.add(vo);
        }
        return list;
    }
}

