/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.distribution.enums.DeliverStatus;
import com.bizunited.empower.business.distribution.service.DeliverGoodService;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.distribution.vo.DeliverGoodVo;
import com.bizunited.empower.business.distribution.vo.DeliverUpdateVo;
import com.bizunited.empower.business.order.dto.AuthorizeDto;
import com.bizunited.empower.business.order.service.ReturnInfoService;
import com.bizunited.empower.business.sales.dto.DistributionTaskDto;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTaskExpenseMapping;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskStatusEnum;
import com.bizunited.empower.business.sales.repository.vehicle.internal.VehicleTaskExpenseMappingRepositoryCustom;
import com.bizunited.empower.business.sales.service.vehicle.DistributionTaskVoService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskExpenseMappingService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.sales.vo.vehicle.DistributionTaskVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DistributionTaskVoServiceImpl")
public class DistributionTaskVoServiceImpl
implements DistributionTaskVoService {
    @Autowired
    @Qualifier(value="_VehicleTaskExpenseMappingRepositoryImpl")
    private VehicleTaskExpenseMappingRepositoryCustom vehicleTaskExpenseMappingRepositoryCustom;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DeliverGoodVoService deliverGoodVoService;
    @Autowired
    private VehicleTaskExpenseMappingService vehicleTaskExpenseMappingService;
    @Autowired
    private DeliverGoodService deliverGoodService;
    @Autowired
    private VehicleTaskService vehicleTaskService;
    @Autowired
    private ReturnInfoService returnInfoService;

    @Override
    public DistributionTaskVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        VehicleTaskExpenseMapping vehicleTaskExpenseMapping = this.vehicleTaskExpenseMappingService.findDetailsById(id);
        DistributionTaskVo distributionTaskVo = (DistributionTaskVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleTaskExpenseMapping, DistributionTaskVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"products", "deliverAttachments"}));
        DeliverGoodVo deliverGoodVo = this.deliverGoodVoService.findByDeliverGoodCode(distributionTaskVo.getDeliverGoodCode());
        this.deliverGoodVoToDistributionTaskVo(distributionTaskVo, deliverGoodVo);
        return distributionTaskVo;
    }

    @Override
    public Page<DistributionTaskVo> findByConditions(Pageable pageable, DistributionTaskDto dto) {
        PageImpl visitPlanPageVoPage;
        if (null == dto) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        Validate.notEmpty((CharSequence)dto.getVehicleTaskCode(), (String)"\u67e5\u8be2\u914d\u9001\u4efb\u52a1\u65f6,\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<VehicleTaskExpenseMapping> page = this.vehicleTaskExpenseMappingRepositoryCustom.findByConditions(pageable, dto);
        List content = page.getContent();
        if (!CollectionUtils.isEmpty((Collection)content)) {
            Collection distributionTaskVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)content, VehicleTaskExpenseMapping.class, DistributionTaskVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"products", "deliverAttachments"});
            this.buildDistributionTaskVo(content, distributionTaskVos);
            visitPlanPageVoPage = new PageImpl(new ArrayList(distributionTaskVos), pageable, page.getTotalElements());
        } else {
            visitPlanPageVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return visitPlanPageVoPage;
    }

    @Override
    @Transactional
    public void delayed(String distributionTaskCode) {
        Validate.notEmpty((CharSequence)distributionTaskCode, (String)"\u5ef6\u8fdf\u914d\u9001\u65f6,\u4f20\u5165\u7684\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        this.vehicleTaskExpenseMappingService.delayed(distributionTaskCode);
    }

    @Override
    @Transactional
    public void againDistribution(String distributionTaskCode) {
        Validate.notEmpty((CharSequence)distributionTaskCode, (String)"\u91cd\u65b0\u914d\u9001\u65f6,\u4f20\u5165\u7684\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        this.vehicleTaskExpenseMappingService.againDistribution(distributionTaskCode);
    }

    @Override
    @Transactional
    public void delivery(String distributionTaskCode) {
        Validate.notEmpty((CharSequence)distributionTaskCode, (String)"\u786e\u8ba4\u9001\u8fbe\u65f6,\u4f20\u5165\u7684\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        this.vehicleTaskExpenseMappingService.delivery(distributionTaskCode);
    }

    @Override
    @Transactional
    public void receivingGood(String distributionTaskCode) {
        Validate.notEmpty((CharSequence)distributionTaskCode, (String)"\u5f3a\u5236\u6536\u8d27\u65f6,\u4f20\u5165\u7684\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        this.vehicleTaskExpenseMappingService.receivingGood(distributionTaskCode);
    }

    @Override
    @Transactional
    public void handleRelevanceAuthorize(String vehicleTaskCode, String distributionTaskCode, AuthorizeDto authorizeDto) {
        Validate.notEmpty((CharSequence)vehicleTaskCode, (String)"\u6838\u51c6\u65f6,\u4f20\u5165\u7684\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)distributionTaskCode, (String)"\u6838\u51c6\u65f6,\u4f20\u5165\u7684\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)authorizeDto, (String)"\u6838\u51c6\u65f6,\u4f20\u5165\u7684\u6838\u51c6\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskService.findByVehicleTaskCode(vehicleTaskCode);
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u6838\u51c6\u65f6,\u67e5\u8be2\u5230\u7684\u51fa\u8f66\u4efb\u52a1\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskStatusEnum.VEHICLE_DRIVING.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u6838\u51c6\u65f6,\u51fa\u8f66\u4efb\u52a1\u5fc5\u987b\u4e3a\u51fa\u8f66\u4e2d", (Object[])new Object[0]);
        VehicleTaskExpenseMapping vehicleTaskExpenseMapping = this.vehicleTaskExpenseMappingService.findByDistributionTaskCode(distributionTaskCode);
        this.returnInfoService.orderApproval(authorizeDto);
        DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
        deliverUpdateVo.setDeliverGoodCode(vehicleTaskExpenseMapping.getDeliverGoodCode());
        deliverUpdateVo.setOldDeliverStatus(DeliverStatus.ALREADY_DELIVER.getType());
        deliverUpdateVo.setDeliverStatus(DeliverStatus.ALREADY_RECEIVE.getType());
        deliverUpdateVo.setTenantCode(vehicleTaskExpenseMapping.getTenantCode());
        deliverUpdateVo.setDeliveryTime(new Date());
        deliverUpdateVo.setNoticeVehicleTask(Boolean.valueOf(false));
        this.deliverGoodService.updateStatusByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
    }

    private void buildDistributionTaskVo(List<VehicleTaskExpenseMapping> content, Collection<DistributionTaskVo> distributionTaskVos) {
        List deliverGoodCodes = content.stream().map(VehicleTaskExpenseMapping::getDeliverGoodCode).collect(Collectors.toList());
        List deliverGoodVoList = this.deliverGoodVoService.findByDeliverGoodCodes(deliverGoodCodes);
        if (CollectionUtils.isEmpty((Collection)deliverGoodVoList)) {
            return;
        }
        Map deliverGoodVoMap = deliverGoodVoList.stream().collect(Collectors.toMap(DeliverGoodVo::getDeliverGoodCode, Function.identity()));
        for (DistributionTaskVo distributionTaskVo : distributionTaskVos) {
            if (!deliverGoodVoMap.containsKey(distributionTaskVo.getDeliverGoodCode())) continue;
            DeliverGoodVo deliverGoodVo = (DeliverGoodVo)deliverGoodVoMap.get(distributionTaskVo.getDeliverGoodCode());
            this.deliverGoodVoToDistributionTaskVo(distributionTaskVo, deliverGoodVo);
        }
    }

    private void deliverGoodVoToDistributionTaskVo(DistributionTaskVo distributionTaskVo, DeliverGoodVo deliverGoodVo) {
        distributionTaskVo.setRelevanceCode(deliverGoodVo.getRelevanceCode());
        distributionTaskVo.setDeliverStatus(deliverGoodVo.getDeliverStatus());
        distributionTaskVo.setOrderCode(deliverGoodVo.getOrderCode());
        distributionTaskVo.setDeliverWay(deliverGoodVo.getDeliverWay());
        distributionTaskVo.setWarehouseCode(deliverGoodVo.getWarehouseCode());
        distributionTaskVo.setWarehouseName(deliverGoodVo.getWarehouseName());
        distributionTaskVo.setCustomerCode(deliverGoodVo.getCustomerCode());
        distributionTaskVo.setCustomerName(deliverGoodVo.getCustomerName());
        distributionTaskVo.setPhone(deliverGoodVo.getPhone());
        distributionTaskVo.setReceiver(deliverGoodVo.getReceiver());
        distributionTaskVo.setReceiverPhone(deliverGoodVo.getReceiverPhone());
        distributionTaskVo.setReceivingAddress(deliverGoodVo.getReceivingAddress());
        distributionTaskVo.setRouteCode(deliverGoodVo.getRouteCode());
        distributionTaskVo.setRouteName(deliverGoodVo.getRouteName());
        distributionTaskVo.setExpenseTime(deliverGoodVo.getExpenseTime());
        distributionTaskVo.setDeliverTime(deliverGoodVo.getDeliverTime());
        distributionTaskVo.setDeliveryTime(deliverGoodVo.getDeliveryTime());
        distributionTaskVo.setRemark(deliverGoodVo.getRemark());
        distributionTaskVo.setDeliverAttachments(deliverGoodVo.getDeliverAttachments());
        distributionTaskVo.setProducts(deliverGoodVo.getProducts());
        distributionTaskVo.setProductTotalQuantity(deliverGoodVo.getProductTotalQuantity());
        distributionTaskVo.setProductTotalPrice(deliverGoodVo.getProductTotalPrice());
    }
}

