/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleDistributionProduct;
import com.bizunited.empower.business.sales.repository.vehicle.VehicleDistributionProductRepository;
import com.bizunited.empower.business.sales.service.vehicle.VehicleDistributionProductService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="VehicleDistributionProductServiceImpl")
public class VehicleDistributionProductServiceImpl
implements VehicleDistributionProductService {
    @Autowired
    private VehicleDistributionProductRepository vehicleDistributionProductRepository;

    @Override
    @Transactional
    public VehicleDistributionProduct create(VehicleDistributionProduct vehicleDistributionProduct) {
        VehicleDistributionProduct current = this.createForm(vehicleDistributionProduct);
        return current;
    }

    @Override
    @Transactional
    public VehicleDistributionProduct createForm(VehicleDistributionProduct vehicleDistributionProduct) {
        if (StringUtils.isEmpty((CharSequence)vehicleDistributionProduct.getTenantCode())) {
            vehicleDistributionProduct.setTenantCode(TenantUtils.getTenantCode());
            vehicleDistributionProduct.setCreateAccount(SecurityUtils.getUserAccount());
            vehicleDistributionProduct.setModifyAccount(SecurityUtils.getUserAccount());
        }
        Date now = new Date();
        vehicleDistributionProduct.setCreateTime(now);
        vehicleDistributionProduct.setModifyTime(now);
        this.createValidation(vehicleDistributionProduct);
        this.vehicleDistributionProductRepository.save((Object)vehicleDistributionProduct);
        return vehicleDistributionProduct;
    }

    private void createValidation(VehicleDistributionProduct vehicleDistributionProduct) {
        Validate.notNull((Object)((Object)vehicleDistributionProduct), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)vehicleDistributionProduct.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        vehicleDistributionProduct.setId(null);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getVehicleTaskCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getVehicleCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getProductCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getProductName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getRelativePath(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getFileName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getProductSpecificationCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getProductSpecificationName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getUnitCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getUnitName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleDistributionProduct.getQuantity(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleDistributionProduct.getRemainingQuantity(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5269\u4f59\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleDistributionProduct.getPurchasePrice(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u8003\u91c7\u8d2d\u4ef7\uff0c\u5343\u4f4d\u6570\u4ee3\u8868.000\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleDistributionProduct.getSubtotalAmount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5c0f\u8ba1\u91d1\u989d\uff0c\u5343\u4f4d\u6570\u4ee3\u8868.000\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend1() == null || vehicleDistributionProduct.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend2() == null || vehicleDistributionProduct.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend3() == null || vehicleDistributionProduct.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend4() == null || vehicleDistributionProduct.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend5() == null || vehicleDistributionProduct.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend6() == null || vehicleDistributionProduct.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend7() == null || vehicleDistributionProduct.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getTenantCode() == null || vehicleDistributionProduct.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getVehicleTaskCode() == null || vehicleDistributionProduct.getVehicleTaskCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getTransferOrderCode() == null || vehicleDistributionProduct.getTransferOrderCode().length() < 64 ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u7f16\u7801\uff08\u5355\u636e\u7f16\u7801\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getVehicleCode() == null || vehicleDistributionProduct.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getProductCode() == null || vehicleDistributionProduct.getProductCode().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getProductName() == null || vehicleDistributionProduct.getProductName().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getRelativePath() == null || vehicleDistributionProduct.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getFileName() == null || vehicleDistributionProduct.getFileName().length() < 255 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getProductSpecificationCode() == null || vehicleDistributionProduct.getProductSpecificationCode().length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getProductSpecificationName() == null || vehicleDistributionProduct.getProductSpecificationName().length() < 128 ? 1 : 0) != 0, (String)"\u89c4\u683c\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getUnitCode() == null || vehicleDistributionProduct.getUnitCode().length() < 64 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getUnitName() == null || vehicleDistributionProduct.getUnitName().length() < 128 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getBarCode() == null || vehicleDistributionProduct.getBarCode().length() < 255 ? 1 : 0) != 0, (String)"\u6761\u5f62\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public VehicleDistributionProduct update(VehicleDistributionProduct vehicleDistributionProduct) {
        VehicleDistributionProduct current = this.updateForm(vehicleDistributionProduct);
        return current;
    }

    @Override
    @Transactional
    public VehicleDistributionProduct updateForm(VehicleDistributionProduct vehicleDistributionProduct) {
        this.updateValidation(vehicleDistributionProduct);
        String currentId = vehicleDistributionProduct.getId();
        Optional op_currentVehicleProduct = this.vehicleDistributionProductRepository.findById(currentId);
        VehicleDistributionProduct currentVehicleDistributionProduct = op_currentVehicleProduct.orElse(null);
        currentVehicleDistributionProduct = (VehicleDistributionProduct)((Object)Validate.notNull((Object)((Object)currentVehicleDistributionProduct), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        Date now = new Date();
        currentVehicleDistributionProduct.setModifyAccount(SecurityUtils.getUserAccount());
        currentVehicleDistributionProduct.setModifyTime(now);
        currentVehicleDistributionProduct.setExtend1(vehicleDistributionProduct.getExtend1());
        currentVehicleDistributionProduct.setExtend2(vehicleDistributionProduct.getExtend2());
        currentVehicleDistributionProduct.setExtend3(vehicleDistributionProduct.getExtend3());
        currentVehicleDistributionProduct.setExtend4(vehicleDistributionProduct.getExtend4());
        currentVehicleDistributionProduct.setExtend5(vehicleDistributionProduct.getExtend5());
        currentVehicleDistributionProduct.setExtend6(vehicleDistributionProduct.getExtend6());
        currentVehicleDistributionProduct.setExtend7(vehicleDistributionProduct.getExtend7());
        currentVehicleDistributionProduct.setExtend8(vehicleDistributionProduct.getExtend8());
        currentVehicleDistributionProduct.setExtend9(vehicleDistributionProduct.getExtend9());
        currentVehicleDistributionProduct.setExtend10(vehicleDistributionProduct.getExtend10());
        currentVehicleDistributionProduct.setExtend11(vehicleDistributionProduct.getExtend11());
        currentVehicleDistributionProduct.setTenantCode(vehicleDistributionProduct.getTenantCode());
        currentVehicleDistributionProduct.setVehicleTaskCode(vehicleDistributionProduct.getVehicleTaskCode());
        currentVehicleDistributionProduct.setTransferOrderCode(vehicleDistributionProduct.getTransferOrderCode());
        currentVehicleDistributionProduct.setVehicleCode(vehicleDistributionProduct.getVehicleCode());
        currentVehicleDistributionProduct.setProductCode(vehicleDistributionProduct.getProductCode());
        currentVehicleDistributionProduct.setProductName(vehicleDistributionProduct.getProductName());
        currentVehicleDistributionProduct.setRelativePath(vehicleDistributionProduct.getRelativePath());
        currentVehicleDistributionProduct.setFileName(vehicleDistributionProduct.getFileName());
        currentVehicleDistributionProduct.setProductSpecificationCode(vehicleDistributionProduct.getProductSpecificationCode());
        currentVehicleDistributionProduct.setProductSpecificationName(vehicleDistributionProduct.getProductSpecificationName());
        currentVehicleDistributionProduct.setUnitCode(vehicleDistributionProduct.getUnitCode());
        currentVehicleDistributionProduct.setUnitName(vehicleDistributionProduct.getUnitName());
        currentVehicleDistributionProduct.setBarCode(vehicleDistributionProduct.getBarCode());
        currentVehicleDistributionProduct.setQuantity(vehicleDistributionProduct.getQuantity());
        currentVehicleDistributionProduct.setRemainingQuantity(vehicleDistributionProduct.getRemainingQuantity());
        currentVehicleDistributionProduct.setPurchasePrice(vehicleDistributionProduct.getPurchasePrice());
        currentVehicleDistributionProduct.setSubtotalAmount(vehicleDistributionProduct.getSubtotalAmount());
        this.vehicleDistributionProductRepository.saveAndFlush((Object)currentVehicleDistributionProduct);
        return currentVehicleDistributionProduct;
    }

    private void updateValidation(VehicleDistributionProduct vehicleDistributionProduct) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)vehicleDistributionProduct.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getVehicleTaskCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getVehicleCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getProductCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getProductName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getRelativePath(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getFileName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getProductSpecificationCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getProductSpecificationName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getUnitCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleDistributionProduct.getUnitName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleDistributionProduct.getQuantity(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleDistributionProduct.getRemainingQuantity(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5269\u4f59\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleDistributionProduct.getPurchasePrice(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u8003\u91c7\u8d2d\u4ef7\uff0c\u5343\u4f4d\u6570\u4ee3\u8868.000\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleDistributionProduct.getSubtotalAmount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5c0f\u8ba1\u91d1\u989d\uff0c\u5343\u4f4d\u6570\u4ee3\u8868.000\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend1() == null || vehicleDistributionProduct.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend2() == null || vehicleDistributionProduct.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend3() == null || vehicleDistributionProduct.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend4() == null || vehicleDistributionProduct.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend5() == null || vehicleDistributionProduct.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend6() == null || vehicleDistributionProduct.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getExtend7() == null || vehicleDistributionProduct.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getTenantCode() == null || vehicleDistributionProduct.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getVehicleTaskCode() == null || vehicleDistributionProduct.getVehicleTaskCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getTransferOrderCode() == null || vehicleDistributionProduct.getTransferOrderCode().length() < 64 ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u7f16\u7801\uff08\u5355\u636e\u7f16\u7801\uff09,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getVehicleCode() == null || vehicleDistributionProduct.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getProductCode() == null || vehicleDistributionProduct.getProductCode().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getProductName() == null || vehicleDistributionProduct.getProductName().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getRelativePath() == null || vehicleDistributionProduct.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getFileName() == null || vehicleDistributionProduct.getFileName().length() < 255 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getProductSpecificationCode() == null || vehicleDistributionProduct.getProductSpecificationCode().length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getProductSpecificationName() == null || vehicleDistributionProduct.getProductSpecificationName().length() < 128 ? 1 : 0) != 0, (String)"\u89c4\u683c\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getUnitCode() == null || vehicleDistributionProduct.getUnitCode().length() < 64 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getUnitName() == null || vehicleDistributionProduct.getUnitName().length() < 128 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleDistributionProduct.getBarCode() == null || vehicleDistributionProduct.getBarCode().length() < 255 ? 1 : 0) != 0, (String)"\u6761\u5f62\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public VehicleDistributionProduct findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.vehicleDistributionProductRepository.findDetailsById(id);
    }

    @Override
    public VehicleDistributionProduct findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.vehicleDistributionProductRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        VehicleDistributionProduct current = this.findById(id);
        if (current != null) {
            this.vehicleDistributionProductRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void deleteByVehicleTaskCode(String vehicleTaskCode) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u8fdb\u884c\u5220\u9664\u5173\u8054\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        this.vehicleDistributionProductRepository.deleteByVehicleTaskCodeAndTenantCode(vehicleTaskCode, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void batchSave(List<VehicleDistributionProduct> vehicleDistributionProducts) {
        Validate.notEmpty(vehicleDistributionProducts, (String)"\u8fdb\u884c\u4fdd\u5b58\u8f66\u8f86\u4e0e\u914d\u9001\u5546\u54c1\u5173\u8054\u4fe1\u606f\u65f6\uff0c\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        for (VehicleDistributionProduct vehicleDistributionProduct : vehicleDistributionProducts) {
            if (null == vehicleDistributionProduct.getId()) {
                this.create(vehicleDistributionProduct);
                continue;
            }
            this.vehicleDistributionProductRepository.save((Object)vehicleDistributionProduct);
        }
    }

    @Override
    public List<VehicleDistributionProduct> findByVehicleTaskCode(String vehicleTaskCode) {
        if (StringUtils.isEmpty((CharSequence)vehicleTaskCode)) {
            return Lists.newArrayList();
        }
        return this.vehicleDistributionProductRepository.findByVehicleTaskCode(vehicleTaskCode, TenantUtils.getTenantCode());
    }

    @Override
    public void updateTransferOrderCodeByVehicleTaskCode(String vehicleTaskCode, String transferOrderCode) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)transferOrderCode, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\u65f6\uff0c\u8c03\u62e8\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.vehicleDistributionProductRepository.updateTransferOrderCodeByVehicleTaskCode(transferOrderCode, vehicleTaskCode, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void updateRemainingQuantityByVehicleTaskCode(String vehicleTaskCode, String productSpecificationCode, BigDecimal quantity) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productSpecificationCode, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\u65f6\uff0c\u8c03\u62e8\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)quantity, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        VehicleDistributionProduct vehicleDistributionProduct = this.vehicleDistributionProductRepository.findByVehicleTaskCodeAndProductSpecificationCode(vehicleTaskCode, productSpecificationCode, TenantUtils.getTenantCode());
        BigDecimal remainingQuantity = vehicleDistributionProduct.getRemainingQuantity().subtract(quantity);
        vehicleDistributionProduct.setRemainingQuantity(remainingQuantity);
        this.vehicleDistributionProductRepository.save((Object)vehicleDistributionProduct);
    }
}

