/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.sales.entity.vehicle.VehiclePickUpLoad;
import com.bizunited.empower.business.sales.enums.vehicle.VehiclePickUpLoadStatusEnum;
import com.bizunited.empower.business.sales.repository.vehicle.VehiclePickUpLoadRepository;
import com.bizunited.empower.business.sales.service.vehicle.VehiclePickUpLoadService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="VehiclePickUpLoadServiceImpl")
public class VehiclePickUpLoadServiceImpl
implements VehiclePickUpLoadService {
    @Autowired
    private VehiclePickUpLoadRepository vehiclePickUpLoadRepository;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private VehicleTaskService vehicleTaskService;

    @Override
    @Transactional
    public VehiclePickUpLoad create(VehiclePickUpLoad vehiclePickUpLoad) {
        VehiclePickUpLoad current = this.createForm(vehiclePickUpLoad);
        return current;
    }

    @Override
    @Transactional
    public VehiclePickUpLoad createForm(VehiclePickUpLoad vehiclePickUpLoad) {
        Date now = new Date();
        vehiclePickUpLoad.setCreateAccount(SecurityUtils.getUserAccount());
        vehiclePickUpLoad.setCreateTime(now);
        vehiclePickUpLoad.setModifyAccount(SecurityUtils.getUserAccount());
        vehiclePickUpLoad.setModifyTime(now);
        vehiclePickUpLoad.setTenantCode(TenantUtils.getTenantCode());
        vehiclePickUpLoad.setTransferOrderCode(this.generateCode(TenantUtils.getTenantCode()));
        this.createValidation(vehiclePickUpLoad);
        this.vehiclePickUpLoadRepository.save((Object)vehiclePickUpLoad);
        return vehiclePickUpLoad;
    }

    private void createValidation(VehiclePickUpLoad vehiclePickUpLoad) {
        Validate.notNull((Object)((Object)vehiclePickUpLoad), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)vehiclePickUpLoad.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        vehiclePickUpLoad.setId(null);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehiclePickUpLoad.getVehiclePickUpLoadStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u63d0\u8d27\u88c5\u8f66\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getTransferOrderCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8c03\u62e8\u5355\u7f16\u7801\uff08\u5355\u636e\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getVehicleCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getVehicleName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getWarehouseCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getWarehouseName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getSaleManAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u7f16\u53f7(\u8d26\u53f7)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getSaleManName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend1() == null || vehiclePickUpLoad.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend2() == null || vehiclePickUpLoad.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend3() == null || vehiclePickUpLoad.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend4() == null || vehiclePickUpLoad.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend5() == null || vehiclePickUpLoad.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend6() == null || vehiclePickUpLoad.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend7() == null || vehiclePickUpLoad.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getTenantCode() == null || vehiclePickUpLoad.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getTransferOrderCode() == null || vehiclePickUpLoad.getTransferOrderCode().length() < 64 ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u7f16\u7801\uff08\u5355\u636e\u7f16\u7801\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getVehicleCode() == null || vehiclePickUpLoad.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getVehicleName() == null || vehiclePickUpLoad.getVehicleName().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getWarehouseCode() == null || vehiclePickUpLoad.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getWarehouseName() == null || vehiclePickUpLoad.getWarehouseName().length() < 255 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getSaleManAccount() == null || vehiclePickUpLoad.getSaleManAccount().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u7f16\u53f7(\u8d26\u53f7),\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getSaleManName() == null || vehiclePickUpLoad.getSaleManName().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getRemark() == null || vehiclePickUpLoad.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        VehiclePickUpLoad byTransferOrderCode = this.vehiclePickUpLoadRepository.findByVehiclePickUpLoadCode(vehiclePickUpLoad.getTransferOrderCode(), TenantUtils.getTenantCode());
        Validate.isTrue((byTransferOrderCode == null ? 1 : 0) != 0, (String)"\u63d0\u8d27\u88c5\u8f66\u8c03\u62e8\u5355\u7f16\u53f7\u91cd\u590d\uff01", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public VehiclePickUpLoad update(VehiclePickUpLoad vehiclePickUpLoad) {
        VehiclePickUpLoad current = this.updateForm(vehiclePickUpLoad);
        return current;
    }

    @Override
    @Transactional
    public VehiclePickUpLoad updateForm(VehiclePickUpLoad vehiclePickUpLoad) {
        this.updateValidation(vehiclePickUpLoad);
        String currentId = vehiclePickUpLoad.getId();
        Optional op_currentVehiclePickUpLoad = this.vehiclePickUpLoadRepository.findById(currentId);
        VehiclePickUpLoad currentVehiclePickUpLoad = op_currentVehiclePickUpLoad.orElse(null);
        currentVehiclePickUpLoad = (VehiclePickUpLoad)((Object)Validate.notNull((Object)((Object)currentVehiclePickUpLoad), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        Date now = new Date();
        currentVehiclePickUpLoad.setModifyAccount(SecurityUtils.getUserAccount());
        currentVehiclePickUpLoad.setModifyTime(now);
        currentVehiclePickUpLoad.setExtend1(vehiclePickUpLoad.getExtend1());
        currentVehiclePickUpLoad.setExtend2(vehiclePickUpLoad.getExtend2());
        currentVehiclePickUpLoad.setExtend3(vehiclePickUpLoad.getExtend3());
        currentVehiclePickUpLoad.setExtend4(vehiclePickUpLoad.getExtend4());
        currentVehiclePickUpLoad.setExtend5(vehiclePickUpLoad.getExtend5());
        currentVehiclePickUpLoad.setExtend6(vehiclePickUpLoad.getExtend6());
        currentVehiclePickUpLoad.setExtend7(vehiclePickUpLoad.getExtend7());
        currentVehiclePickUpLoad.setExtend8(vehiclePickUpLoad.getExtend8());
        currentVehiclePickUpLoad.setExtend9(vehiclePickUpLoad.getExtend9());
        currentVehiclePickUpLoad.setExtend10(vehiclePickUpLoad.getExtend10());
        currentVehiclePickUpLoad.setExtend11(vehiclePickUpLoad.getExtend11());
        currentVehiclePickUpLoad.setTenantCode(vehiclePickUpLoad.getTenantCode());
        currentVehiclePickUpLoad.setVehiclePickUpLoadStatus(vehiclePickUpLoad.getVehiclePickUpLoadStatus());
        currentVehiclePickUpLoad.setTransferOrderCode(vehiclePickUpLoad.getTransferOrderCode());
        currentVehiclePickUpLoad.setVehicleCode(vehiclePickUpLoad.getVehicleCode());
        currentVehiclePickUpLoad.setVehicleName(vehiclePickUpLoad.getVehicleName());
        currentVehiclePickUpLoad.setWarehouseCode(vehiclePickUpLoad.getWarehouseCode());
        currentVehiclePickUpLoad.setWarehouseName(vehiclePickUpLoad.getWarehouseName());
        currentVehiclePickUpLoad.setSaleManAccount(vehiclePickUpLoad.getSaleManAccount());
        currentVehiclePickUpLoad.setSaleManName(vehiclePickUpLoad.getSaleManName());
        currentVehiclePickUpLoad.setLoadTime(vehiclePickUpLoad.getLoadTime());
        currentVehiclePickUpLoad.setRemark(vehiclePickUpLoad.getRemark());
        this.vehiclePickUpLoadRepository.saveAndFlush((Object)currentVehiclePickUpLoad);
        return currentVehiclePickUpLoad;
    }

    private void updateValidation(VehiclePickUpLoad vehiclePickUpLoad) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)vehiclePickUpLoad.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehiclePickUpLoad.getVehiclePickUpLoadStatus(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u63d0\u8d27\u88c5\u8f66\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getTransferOrderCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8c03\u62e8\u5355\u7f16\u7801\uff08\u5355\u636e\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getVehicleCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getVehicleName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getWarehouseCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getWarehouseName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getSaleManAccount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u7f16\u53f7(\u8d26\u53f7)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehiclePickUpLoad.getSaleManName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend1() == null || vehiclePickUpLoad.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend2() == null || vehiclePickUpLoad.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend3() == null || vehiclePickUpLoad.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend4() == null || vehiclePickUpLoad.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend5() == null || vehiclePickUpLoad.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend6() == null || vehiclePickUpLoad.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getExtend7() == null || vehiclePickUpLoad.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getTenantCode() == null || vehiclePickUpLoad.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getTransferOrderCode() == null || vehiclePickUpLoad.getTransferOrderCode().length() < 64 ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u7f16\u7801\uff08\u5355\u636e\u7f16\u7801\uff09,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getVehicleCode() == null || vehiclePickUpLoad.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getVehicleName() == null || vehiclePickUpLoad.getVehicleName().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getWarehouseCode() == null || vehiclePickUpLoad.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getWarehouseName() == null || vehiclePickUpLoad.getWarehouseName().length() < 255 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getSaleManAccount() == null || vehiclePickUpLoad.getSaleManAccount().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u7f16\u53f7(\u8d26\u53f7),\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getSaleManName() == null || vehiclePickUpLoad.getSaleManName().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehiclePickUpLoad.getRemark() == null || vehiclePickUpLoad.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format("vehicle:pick:up:load:code:index:%s", tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{"LH", format.format(new Date()), index});
    }

    @Override
    public VehiclePickUpLoad findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.vehiclePickUpLoadRepository.findDetailsById(id);
    }

    @Override
    public VehiclePickUpLoad findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.vehiclePickUpLoadRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        VehiclePickUpLoad current = this.findById(id);
        if (current != null) {
            this.vehiclePickUpLoadRepository.delete((Object)current);
        }
    }

    @Override
    public void deliverGoods(String vehiclePickUpLoadCode) {
        Validate.notBlank((CharSequence)vehiclePickUpLoadCode, (String)"\u786e\u8ba4\u88c5\u8f66\u65f6\uff0c\u8c03\u62e8\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        VehiclePickUpLoad vehiclePickUpLoad = this.vehiclePickUpLoadRepository.findByVehiclePickUpLoadCode(vehiclePickUpLoadCode, TenantUtils.getTenantCode());
        this.vehicleTaskService.deliverGoods(vehiclePickUpLoad.getVehicleTaskCode());
    }

    @Override
    @Transactional
    public void updateVehicleLoadStatus(String vehiclePickUpLoadCode, Integer vehicleLoadStatus) {
        Validate.notBlank((CharSequence)vehiclePickUpLoadCode, (String)"\u6839\u636e\u63d0\u8d27\u88c5\u8f66\u8c03\u62e8\u5355\u7f16\u53f7\u4fee\u6539\u72b6\u6001\u65f6\uff0c\u8c03\u62e8\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        this.vehiclePickUpLoadRepository.updateVehicleLoadStatusByTransferOrderCode(vehiclePickUpLoadCode, vehicleLoadStatus, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public String updateVehicleLoadStatusByVehicleTaskCode(String vehicleTaskCode, Integer vehicleLoadStatus) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u4fee\u6539\u72b6\u6001\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        VehiclePickUpLoad vehiclePickUpLoad = this.findByVehicleTaskCode(vehicleTaskCode);
        Validate.notNull((Object)((Object)vehiclePickUpLoad), (String)"\u67e5\u8be2\u5230\u7684\u63d0\u8d27\u88c5\u8f66\u8bb0\u5f55\u4e3a\u7a7a!!", (Object[])new Object[0]);
        vehiclePickUpLoad.setVehiclePickUpLoadStatus(vehicleLoadStatus);
        if (vehicleLoadStatus.equals(VehiclePickUpLoadStatusEnum.COMPLETE.getType())) {
            vehiclePickUpLoad.setLoadTime(new Date());
            this.vehiclePickUpLoadRepository.save((Object)vehiclePickUpLoad);
        }
        return vehiclePickUpLoad.getTransferOrderCode();
    }

    @Override
    public VehiclePickUpLoad findByVehicleTaskCode(String vehicleTaskCode) {
        if (StringUtils.isEmpty((CharSequence)vehicleTaskCode)) {
            return null;
        }
        return this.vehiclePickUpLoadRepository.findByVehicleTaskCode(vehicleTaskCode, TenantUtils.getTenantCode());
    }
}

