/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.order.service.ReturnInfoService;
import com.bizunited.empower.business.order.service.ReturnInfoVoService;
import com.bizunited.empower.business.order.vo.ReturnInfoVo;
import com.bizunited.empower.business.order.vo.ReturnProductVo;
import com.bizunited.empower.business.product.optimize.vo.ProductUnitAndPriceFlatVo;
import com.bizunited.empower.business.product.service.ProductUnitAndPriceService;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleSaleMan;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskStatusEnum;
import com.bizunited.empower.business.sales.service.vehicle.VehicleReturnOrderVoService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleReceiveReturnProductVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleReceiveReturnVo;
import com.bizunited.empower.business.vehicle.entity.VehicleLoad;
import com.bizunited.empower.business.vehicle.entity.VehicleLoadProduct;
import com.bizunited.empower.business.vehicle.entity.VehicleProductStock;
import com.bizunited.empower.business.vehicle.enums.VehicleLoadStatusEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleLoadTypeEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleProductTypeEnum;
import com.bizunited.empower.business.vehicle.service.VehicleLoadService;
import com.bizunited.empower.business.vehicle.service.VehicleProductStockService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class VehicleReturnOrderVoServiceImpl
implements VehicleReturnOrderVoService {
    @Autowired
    private ReturnInfoVoService returnInfoVoService;
    @Autowired
    private VehicleTaskService vehicleTaskService;
    @Autowired
    private VehicleLoadService vehicleLoadService;
    @Autowired
    private VehicleProductStockService vehicleProductStockService;
    @Autowired
    private ProductUnitAndPriceService productUnitAndPriceService;
    @Autowired
    private ReturnInfoService returnInfoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void receiveReturnInfo(String vehicleTaskCode, String returnCode) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u6839\u636e\u9000\u8d27\u5355\u7f16\u53f7\u6536\u53d6\u5168\u90e8\u9000\u8d27\u5546\u54c1\u65f6,\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnCode, (String)"\u6839\u636e\u9000\u8d27\u5355\u7f16\u53f7\u6536\u53d6\u5168\u90e8\u9000\u8d27\u5546\u54c1\u65f6,\u9000\u8d27\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskService.findByVehicleTaskCode(vehicleTaskCode);
        Validate.isTrue((null != vehicleTask && VehicleTaskStatusEnum.VEHICLE_DRIVING.getType().equals(vehicleTask.getVehicleTaskStatus()) ? 1 : 0) != 0, (String)"\u6839\u636e\u9000\u8d27\u5355\u7f16\u53f7\u6536\u53d6\u5168\u90e8\u9000\u8d27\u5546\u54c1\u65f6,\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1\u6216\u8005\u72b6\u6001\u4e0d\u5728\u51fa\u8f66\u4e2d", (Object[])new Object[0]);
        ReturnInfoVo returnInfoVo = this.returnInfoVoService.findDetailsByReturnCode(returnCode);
        Validate.notNull((Object)returnInfoVo, (String)"\u6536\u53d6\u9000\u8d27\u5546\u54c1\u65f6,\u672a\u67e5\u8be2\u5230\u9000\u8d27\u5355", (Object[])new Object[0]);
        Validate.isTrue((1 == returnInfoVo.getDeliveryStatus() ? 1 : 0) != 0, (String)"\u6536\u53d6\u9000\u8d27\u5546\u54c1\u65f6,\u9000\u8d27\u5355\u6536\u8d27\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u6536\u8d27", (Object[])new Object[0]);
        VehicleLoad vehicleLoad = this.buildReturnInfoToVehicleLoad(vehicleTask, returnInfoVo, VehicleProductTypeEnum.NOT_SALE.getType(), returnInfoVo.getReturnProducts());
        vehicleLoad = this.vehicleLoadService.saveVehicleLoad(vehicleLoad);
        this.vehicleLoadService.updateStatusByVehicleLoadCode(vehicleLoad.getVehicleLoadCode(), VehicleLoadStatusEnum.CONFIRM);
        ArrayList<VehicleProductStock> vehicleProductStockList = new ArrayList<VehicleProductStock>();
        for (VehicleLoadProduct product : vehicleLoad.getProducts()) {
            VehicleProductStock vehicleProductStock = this.vehicleLoadProductToVehicleProductStock(product, VehicleProductTypeEnum.NOT_SALE.getType());
            this.repeatProduct(vehicleProductStockList, vehicleProductStock);
        }
        this.vehicleProductStockService.batchAdd(vehicleTask.getVehicleCode(), vehicleProductStockList);
        this.returnInfoService.receiveByVehicle(returnInfoVo.getReturnCode());
    }

    @Override
    @Transactional
    public void receiveReturnProductToSale(VehicleReceiveReturnVo vehicleReceiveReturnVo) {
        VehicleProductStock vehicleProductStock;
        ReturnProductVo returnProductVo;
        Validate.notNull((Object)((Object)vehicleReceiveReturnVo), (String)"\u6839\u636e\u9000\u8d27\u5355\u6536\u53d6\u9000\u8d27\u5546\u54c1\u65f6,\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskService.findByVehicleTaskCode(vehicleReceiveReturnVo.getVehicleTaskCode());
        Validate.isTrue((null != vehicleTask && VehicleTaskStatusEnum.VEHICLE_DRIVING.getType().equals(vehicleTask.getVehicleTaskStatus()) ? 1 : 0) != 0, (String)"\u6536\u53d6\u9000\u8d27\u5546\u54c1\u65f6,\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1\u6216\u8005\u72b6\u6001\u4e0d\u5728\u51fa\u8f66\u4e2d", (Object[])new Object[0]);
        ReturnInfoVo returnInfoVo = this.returnInfoVoService.findDetailsByReturnCode(vehicleReceiveReturnVo.getReturnCode());
        Validate.notNull((Object)returnInfoVo, (String)"\u6536\u53d6\u9000\u8d27\u5546\u54c1\u65f6,\u672a\u67e5\u8be2\u5230\u9000\u8d27\u5355", (Object[])new Object[0]);
        Validate.isTrue((1 == returnInfoVo.getDeliveryStatus() ? 1 : 0) != 0, (String)"\u6536\u53d6\u9000\u8d27\u5546\u54c1\u65f6,\u9000\u8d27\u5355\u6536\u8d27\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u6536\u8d27", (Object[])new Object[0]);
        Map returnInfoProductMap = returnInfoVo.getReturnProducts().stream().collect(Collectors.toMap(UuidVo::getId, Function.identity()));
        Map receiveReturnProductMap = vehicleReceiveReturnVo.getProductVos().stream().collect(Collectors.toMap(VehicleReceiveReturnProductVo::getId, Function.identity()));
        HashSet saleReturnProductVos = Sets.newHashSet();
        HashSet notSaleReturnProductVos = Sets.newHashSet();
        for (VehicleReceiveReturnProductVo productVo : vehicleReceiveReturnVo.getProductVos()) {
            Validate.isTrue((boolean)returnInfoProductMap.containsKey(productVo.getId()), (String)"\u5546\u54c1\u3010%s\u3011\u89c4\u683c\u3010%s\u3011\u4e0d\u5728\u8be5\u9000\u8d27\u5355\u4e2d", (Object[])new Object[]{productVo.getProductName(), productVo.getProductSpecificationName()});
            returnProductVo = (ReturnProductVo)this.nebulaToolkitService.copyObjectByWhiteList(returnInfoProductMap.get(productVo.getId()), ReturnProductVo.class, HashSet.class, ArrayList.class, new String[0]);
            Validate.isTrue((productVo.getQuantity().compareTo(returnProductVo.getReturnQuantity()) != 1 ? 1 : 0) != 0, (String)"\u88c5\u8f66\u7684\u9000\u8d27\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u9000\u8d27\u5355\u4e2d\u7684\u9000\u8d27\u6570\u91cf", (Object[])new Object[0]);
            returnProductVo.setReturnQuantity(productVo.getQuantity());
            if (BigDecimal.ZERO.compareTo(returnProductVo.getReturnQuantity()) != -1) continue;
            saleReturnProductVos.add(returnProductVo);
        }
        for (ReturnProductVo returnProduct : returnInfoVo.getReturnProducts()) {
            returnProductVo = (ReturnProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)returnProduct, ReturnProductVo.class, HashSet.class, ArrayList.class, new String[0]);
            if (receiveReturnProductMap.containsKey(returnProduct.getId())) {
                VehicleReceiveReturnProductVo vehicleReceiveReturnProductVo = (VehicleReceiveReturnProductVo)receiveReturnProductMap.get(returnProduct.getId());
                BigDecimal quantity = returnProduct.getReturnQuantity().subtract(vehicleReceiveReturnProductVo.getQuantity());
                returnProductVo.setReturnQuantity(quantity);
            }
            if (BigDecimal.ZERO.compareTo(returnProductVo.getReturnQuantity()) != -1) continue;
            notSaleReturnProductVos.add(returnProductVo);
        }
        ArrayList<VehicleProductStock> vehicleProductStockList = new ArrayList<VehicleProductStock>();
        if (!CollectionUtils.isEmpty((Collection)saleReturnProductVos)) {
            VehicleLoad saleVehicleLoad = this.buildReturnInfoToVehicleLoad(vehicleTask, returnInfoVo, VehicleProductTypeEnum.VEHICLE_SALES.getType(), saleReturnProductVos);
            this.vehicleLoadService.saveVehicleLoad(saleVehicleLoad);
            this.vehicleLoadService.updateStatusByVehicleLoadCode(saleVehicleLoad.getVehicleLoadCode(), VehicleLoadStatusEnum.CONFIRM);
            for (VehicleLoadProduct product : saleVehicleLoad.getProducts()) {
                vehicleProductStock = this.vehicleLoadProductToVehicleProductStock(product, VehicleProductTypeEnum.VEHICLE_SALES.getType());
                this.repeatProduct(vehicleProductStockList, vehicleProductStock);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)notSaleReturnProductVos)) {
            VehicleLoad notSaleVehicleLoad = this.buildReturnInfoToVehicleLoad(vehicleTask, returnInfoVo, VehicleProductTypeEnum.NOT_SALE.getType(), notSaleReturnProductVos);
            this.vehicleLoadService.saveVehicleLoad(notSaleVehicleLoad);
            this.vehicleLoadService.updateStatusByVehicleLoadCode(notSaleVehicleLoad.getVehicleLoadCode(), VehicleLoadStatusEnum.CONFIRM);
            for (VehicleLoadProduct product : notSaleVehicleLoad.getProducts()) {
                vehicleProductStock = this.vehicleLoadProductToVehicleProductStock(product, VehicleProductTypeEnum.NOT_SALE.getType());
                this.repeatProduct(vehicleProductStockList, vehicleProductStock);
            }
        }
        this.vehicleProductStockService.batchAdd(vehicleTask.getVehicleCode(), vehicleProductStockList);
        this.returnInfoService.receiveByVehicle(returnInfoVo.getReturnCode());
    }

    private VehicleLoad buildReturnInfoToVehicleLoad(VehicleTask vehicleTask, ReturnInfoVo returnInfoVo, Integer vehicleProductType, Set<ReturnProductVo> returnProductVos) {
        VehicleLoad vehicleLoad = new VehicleLoad();
        vehicleLoad.setVehicleLoadType(VehicleLoadTypeEnum.SALE_RETURN.getType());
        vehicleLoad.setVehicleProductType(vehicleProductType);
        vehicleLoad.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        vehicleLoad.setRelevanceCode(returnInfoVo.getReturnCode());
        vehicleLoad.setCustomerCode(returnInfoVo.getCustomerCode());
        vehicleLoad.setCustomerName(returnInfoVo.getCustomerName());
        VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
        if (null != vehicleSaleMan) {
            vehicleLoad.setSaleManAccount(vehicleSaleMan.getUserAccount());
            vehicleLoad.setSaleManName(vehicleSaleMan.getUserName());
        }
        vehicleLoad.setVehicleCode(vehicleTask.getVehicleCode());
        vehicleLoad.setVehicleName(vehicleTask.getVehicleName());
        vehicleLoad.setProducts(this.buildReturnInfoVehicleLoadProduct(vehicleLoad, returnProductVos));
        return vehicleLoad;
    }

    private Set<VehicleLoadProduct> buildReturnInfoVehicleLoadProduct(VehicleLoad vehicleLoad, Set<ReturnProductVo> returnProductVos) {
        HashSet products = Sets.newHashSet();
        for (ReturnProductVo returnProductVo : returnProductVos) {
            if (returnProductVo.getReturnQuantity().compareTo(BigDecimal.ZERO) != 1) continue;
            VehicleLoadProduct product = new VehicleLoadProduct();
            product.setTenantCode(TenantUtils.getTenantCode());
            product.setVehicleLoad(vehicleLoad);
            product.setBarCode(returnProductVo.getInternationalBarcode());
            product.setProductCode(returnProductVo.getProductCode());
            product.setProductName(returnProductVo.getProductName());
            product.setProductSpecificationCode(returnProductVo.getProductSpecificationCode());
            product.setProductSpecificationName(returnProductVo.getProductSpecificationName());
            product.setPurchasePrice(returnProductVo.getUnitPrice());
            product.setQuantity(returnProductVo.getReturnQuantity());
            product.setSubtotalAmount(returnProductVo.getSubtotalAmount());
            product.setUnitCode(returnProductVo.getUnitCode());
            product.setUnitName(returnProductVo.getUnitName());
            product.setRelativePath(returnProductVo.getMainImagePath());
            product.setFileName(returnProductVo.getMainImageName());
            products.add(product);
        }
        return products;
    }

    private VehicleProductStock vehicleLoadProductToVehicleProductStock(VehicleLoadProduct vehicleLoadProduct, Integer vehicleProductType) {
        VehicleProductStock vehicleProductStock = new VehicleProductStock();
        vehicleProductStock.setVehicleProductType(vehicleProductType);
        vehicleProductStock.setProductCode(vehicleLoadProduct.getProductCode());
        vehicleProductStock.setProductName(vehicleLoadProduct.getProductName());
        vehicleProductStock.setProductSpecificationCode(vehicleLoadProduct.getProductSpecificationCode());
        vehicleProductStock.setProductSpecificationName(vehicleLoadProduct.getProductSpecificationName());
        vehicleProductStock.setRelativePath(vehicleLoadProduct.getRelativePath());
        vehicleProductStock.setFileName(vehicleLoadProduct.getFileName());
        vehicleProductStock.setBarCode(vehicleLoadProduct.getBarCode());
        BigDecimal stockQuantity = this.vehicleProductStockService.conversionUnit(vehicleLoadProduct.getProductSpecificationCode(), vehicleLoadProduct.getQuantity(), vehicleLoadProduct.getUnitCode());
        ProductUnitAndPriceFlatVo productUnitAndPrice = this.productUnitAndPriceService.findBasicBySpecificationCode(vehicleLoadProduct.getProductSpecificationCode());
        Validate.isTrue((null != productUnitAndPrice ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5546\u54c1\u57fa\u672c\u5355\u4f4d\u5931\u8d25", (Object[])new Object[0]);
        vehicleProductStock.setUnitCode(productUnitAndPrice.getUnitCode());
        vehicleProductStock.setUnitName(productUnitAndPrice.getUnitName());
        vehicleProductStock.setInventory(stockQuantity);
        vehicleProductStock.setPreemptInventory(BigDecimal.ZERO);
        vehicleProductStock.setUsableInventory(stockQuantity);
        return vehicleProductStock;
    }

    private void repeatProduct(List<VehicleProductStock> vehicleProductStockList, VehicleProductStock vehicleProductStock) {
        VehicleProductStock filterProductStock = vehicleProductStockList.stream().filter(product -> product.getProductCode().equals(vehicleProductStock.getProductCode()) && product.getProductSpecificationCode().equals(vehicleProductStock.getProductSpecificationCode()) && product.getUnitCode().equals(vehicleProductStock.getUnitCode()) && product.getVehicleProductType().equals(vehicleProductStock.getVehicleProductType())).findFirst().orElse(null);
        if (null == filterProductStock) {
            vehicleProductStockList.add(vehicleProductStock);
        } else {
            filterProductStock.setInventory(filterProductStock.getInventory().add(vehicleProductStock.getInventory()));
            filterProductStock.setUsableInventory(filterProductStock.getUsableInventory().add(vehicleProductStock.getUsableInventory()));
        }
    }
}

