/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleReturn;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTaskExpenseMapping;
import com.bizunited.empower.business.sales.enums.vehicle.DistributionStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleReturnStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskStatusEnum;
import com.bizunited.empower.business.sales.repository.vehicle.VehicleReturnRepository;
import com.bizunited.empower.business.sales.service.vehicle.VehicleReturnService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskExpenseMappingService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.sales.vo.vehicle.ApplyVehicleReturnVo;
import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.empower.business.vehicle.entity.VehicleUnload;
import com.bizunited.empower.business.vehicle.enums.VehicleUnloadStatusEnum;
import com.bizunited.empower.business.vehicle.service.VehicleProductStockService;
import com.bizunited.empower.business.vehicle.service.VehicleService;
import com.bizunited.empower.business.vehicle.service.VehicleUnloadService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="VehicleReturnServiceImpl")
public class VehicleReturnServiceImpl
implements VehicleReturnService {
    @Autowired
    private VehicleReturnRepository vehicleReturnRepository;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private VehicleTaskService vehicleTaskService;
    @Autowired
    private VehicleUnloadService vehicleUnloadService;
    @Autowired
    private VehicleService vehicleService;
    @Autowired
    private VehicleProductStockService vehicleProductStockService;
    @Autowired
    private VehicleTaskExpenseMappingService vehicleTaskExpenseMappingService;

    @Override
    @Transactional
    public VehicleReturn create(VehicleReturn vehicleReturn) {
        VehicleReturn current = this.createForm(vehicleReturn);
        return current;
    }

    @Override
    @Transactional
    public VehicleReturn createForm(VehicleReturn vehicleReturn) {
        Date now = new Date();
        vehicleReturn.setCreateAccount(SecurityUtils.getUserAccount());
        vehicleReturn.setCreateTime(now);
        vehicleReturn.setModifyAccount(SecurityUtils.getUserAccount());
        vehicleReturn.setModifyTime(now);
        vehicleReturn.setTenantCode(TenantUtils.getTenantCode());
        vehicleReturn.setVehicleReturnCode(this.generateCode(TenantUtils.getTenantCode()));
        this.createValidation(vehicleReturn);
        this.vehicleReturnRepository.save((Object)vehicleReturn);
        return vehicleReturn;
    }

    private void createValidation(VehicleReturn vehicleReturn) {
        Validate.notNull((Object)((Object)vehicleReturn), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)vehicleReturn.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        vehicleReturn.setId(null);
        Validate.notBlank((CharSequence)vehicleReturn.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getVehicleTaskCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleReturn.getVehicleReturnStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6536\u8f66\u9000\u8d27\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getTransferOrderCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8c03\u62e8\u5355\u7f16\u7801\uff08\u5355\u636e\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getVehicleCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getVehicleName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getWarehouseCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getWarehouseName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getSaleManAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u7f16\u53f7(\u8d26\u53f7)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getSaleManName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleReturn.getLoadTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u63d0\u8d27\u65f6\u95f4(\u88c5\u8f66\u65f6\u95f4)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getVehicleReturnCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6536\u8f66\u9000\u8d27\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend1() == null || vehicleReturn.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend2() == null || vehicleReturn.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend3() == null || vehicleReturn.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend4() == null || vehicleReturn.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend5() == null || vehicleReturn.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend6() == null || vehicleReturn.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend7() == null || vehicleReturn.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getTenantCode() == null || vehicleReturn.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getTransferOrderCode() == null || vehicleReturn.getTransferOrderCode().length() < 64 ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u7f16\u7801\uff08\u5355\u636e\u7f16\u7801\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getVehicleCode() == null || vehicleReturn.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getVehicleName() == null || vehicleReturn.getVehicleName().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getWarehouseCode() == null || vehicleReturn.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getWarehouseName() == null || vehicleReturn.getWarehouseName().length() < 255 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getSaleManAccount() == null || vehicleReturn.getSaleManAccount().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u7f16\u53f7(\u8d26\u53f7),\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getSaleManName() == null || vehicleReturn.getSaleManName().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getRemark() == null || vehicleReturn.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        VehicleReturn byVehicleReturnCode = this.vehicleReturnRepository.findByVehicleReturnCode(vehicleReturn.getVehicleReturnCode(), TenantUtils.getTenantCode());
        Validate.isTrue((byVehicleReturnCode == null ? 1 : 0) != 0, (String)"\u6536\u8f66\u9000\u8d27\u7f16\u53f7\u91cd\u590d\uff01", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public VehicleReturn update(VehicleReturn vehicleReturn) {
        VehicleReturn current = this.updateForm(vehicleReturn);
        return current;
    }

    @Override
    @Transactional
    public VehicleReturn updateForm(VehicleReturn vehicleReturn) {
        this.updateValidation(vehicleReturn);
        String currentId = vehicleReturn.getId();
        Optional op_currentVehicleReturn = this.vehicleReturnRepository.findById(currentId);
        VehicleReturn currentVehicleReturn = op_currentVehicleReturn.orElse(null);
        currentVehicleReturn = (VehicleReturn)((Object)Validate.notNull((Object)((Object)currentVehicleReturn), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        Date now = new Date();
        currentVehicleReturn.setModifyAccount(SecurityUtils.getUserAccount());
        currentVehicleReturn.setModifyTime(now);
        currentVehicleReturn.setExtend1(vehicleReturn.getExtend1());
        currentVehicleReturn.setExtend2(vehicleReturn.getExtend2());
        currentVehicleReturn.setExtend3(vehicleReturn.getExtend3());
        currentVehicleReturn.setExtend4(vehicleReturn.getExtend4());
        currentVehicleReturn.setExtend5(vehicleReturn.getExtend5());
        currentVehicleReturn.setExtend6(vehicleReturn.getExtend6());
        currentVehicleReturn.setExtend7(vehicleReturn.getExtend7());
        currentVehicleReturn.setExtend8(vehicleReturn.getExtend8());
        currentVehicleReturn.setExtend9(vehicleReturn.getExtend9());
        currentVehicleReturn.setExtend10(vehicleReturn.getExtend10());
        currentVehicleReturn.setExtend11(vehicleReturn.getExtend11());
        currentVehicleReturn.setTenantCode(vehicleReturn.getTenantCode());
        currentVehicleReturn.setVehicleReturnStatus(vehicleReturn.getVehicleReturnStatus());
        currentVehicleReturn.setTransferOrderCode(vehicleReturn.getTransferOrderCode());
        currentVehicleReturn.setVehicleCode(vehicleReturn.getVehicleCode());
        currentVehicleReturn.setVehicleName(vehicleReturn.getVehicleName());
        currentVehicleReturn.setWarehouseCode(vehicleReturn.getWarehouseCode());
        currentVehicleReturn.setWarehouseName(vehicleReturn.getWarehouseName());
        currentVehicleReturn.setSaleManAccount(vehicleReturn.getSaleManAccount());
        currentVehicleReturn.setSaleManName(vehicleReturn.getSaleManName());
        currentVehicleReturn.setLoadTime(vehicleReturn.getLoadTime());
        currentVehicleReturn.setReturnTime(vehicleReturn.getReturnTime());
        currentVehicleReturn.setRemark(vehicleReturn.getRemark());
        this.vehicleReturnRepository.saveAndFlush((Object)currentVehicleReturn);
        return currentVehicleReturn;
    }

    private void updateValidation(VehicleReturn vehicleReturn) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)vehicleReturn.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleReturn.getVehicleReturnStatus(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6536\u8f66\u9000\u8d27\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getTransferOrderCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8c03\u62e8\u5355\u7f16\u7801\uff08\u5355\u636e\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getVehicleCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getVehicleName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getWarehouseCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getWarehouseName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getSaleManAccount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u7f16\u53f7(\u8d26\u53f7)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleReturn.getSaleManName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleReturn.getLoadTime(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u63d0\u8d27\u65f6\u95f4(\u88c5\u8f66\u65f6\u95f4)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend1() == null || vehicleReturn.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend2() == null || vehicleReturn.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend3() == null || vehicleReturn.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend4() == null || vehicleReturn.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend5() == null || vehicleReturn.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend6() == null || vehicleReturn.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getExtend7() == null || vehicleReturn.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getTenantCode() == null || vehicleReturn.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getTransferOrderCode() == null || vehicleReturn.getTransferOrderCode().length() < 64 ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u7f16\u7801\uff08\u5355\u636e\u7f16\u7801\uff09,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getVehicleCode() == null || vehicleReturn.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getVehicleName() == null || vehicleReturn.getVehicleName().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getWarehouseCode() == null || vehicleReturn.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getWarehouseName() == null || vehicleReturn.getWarehouseName().length() < 255 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getSaleManAccount() == null || vehicleReturn.getSaleManAccount().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u7f16\u53f7(\u8d26\u53f7),\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getSaleManName() == null || vehicleReturn.getSaleManName().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleReturn.getRemark() == null || vehicleReturn.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format("vehicle:return:code:index:%s", tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{"SC", format.format(new Date()), index});
    }

    @Override
    public VehicleReturn findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.vehicleReturnRepository.findDetailsById(id);
    }

    @Override
    public VehicleReturn findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.vehicleReturnRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        VehicleReturn current = this.findById(id);
        if (current != null) {
            this.vehicleReturnRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void applyVehicleReturn(ApplyVehicleReturnVo applyVehicleReturnVo) {
        Validate.notBlank((CharSequence)applyVehicleReturnVo.getVehicleReturnCode(), (String)"\u7533\u8bf7\u6536\u8f66\u65f6\uff0c\u6536\u8f66\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        VehicleReturn vehicleReturn = this.vehicleReturnRepository.findByVehicleReturnCode(applyVehicleReturnVo.getVehicleReturnCode(), TenantUtils.getTenantCode());
        this.returnVehicleDistribution(vehicleReturn.getVehicleTaskCode());
        Validate.isTrue((boolean)VehicleReturnStatusEnum.WAIT_LAUNCH.getType().equals(vehicleReturn.getVehicleReturnStatus()), (String)"\u7533\u8bf7\u6536\u8f66\u65f6,\u6536\u8f66\u5165\u5e93\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u53d1\u8d77", (Object[])new Object[0]);
        List vehicleUnloads = this.vehicleUnloadService.findByVehicleTaskCodeAndUnloadStatus(vehicleReturn.getVehicleTaskCode(), VehicleUnloadStatusEnum.WAIT_DELIVERY);
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)vehicleUnloads), (String)("\u7533\u8bf7\u6536\u8f66\u65f6\uff0c\u6240\u6709\u5378\u8d27\u5355\u5fc5\u987b\u5df2\u4ea4\u8d27(\u6709\u8ba2\u5355\u672a\u4ea4\u8d27)\uff01\u5378\u8d27\u5355\u7f16\u53f7\u4e3a" + StringUtils.join((Iterable)vehicleUnloads.stream().map(VehicleUnload::getRelevanceCode).collect(Collectors.toList()), (String)",")), (Object[])new Object[0]);
        Vehicle vehicle = this.vehicleService.findByVehicleCode(vehicleReturn.getVehicleCode());
        Validate.notNull((Object)vehicle, (String)"\u7533\u8bf7\u6536\u8f66\u65f6\uff0c\u67e5\u8be2\u7684\u8f66\u8f86\u4e3a\u7a7a!", (Object[])new Object[0]);
        Set vehicleProductStockSet = this.vehicleProductStockService.findDetailsByVehicle(vehicle.getId());
        Validate.notEmpty((Collection)vehicleProductStockSet, (String)"\u7533\u8bf7\u6536\u8f66\u65f6\uff0c\u83b7\u53d6\u8f66\u8f86\u5e93\u5b58\u4e3a\u7a7a!", (Object[])new Object[0]);
        vehicleReturn.setVehicleReturnStatus(VehicleReturnStatusEnum.WAIT_CONFIRM.getType());
        vehicleReturn.setRemark(applyVehicleReturnVo.getRemark());
        this.vehicleReturnRepository.save((Object)vehicleReturn);
        this.vehicleTaskService.updateVehicleTaskStatusByVehicleTaskCode(vehicleReturn.getVehicleTaskCode(), VehicleTaskStatusEnum.APPLY_RETURN.getType());
    }

    @Override
    @Transactional
    public void updateVehicleReturnStatusByVehicleTaskCode(String vehicleTaskCode, VehicleTaskStatusEnum applyReturn) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u6839\u636e\u4efb\u52a1\u7f16\u53f7\u66f4\u6539\u63d0\u8d27\u6536\u8f66\u5355\u72b6\u6001\u65f6\uff0c\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)applyReturn), (String)"\u6839\u636e\u4efb\u52a1\u7f16\u53f7\u66f4\u6539\u63d0\u8d27\u6536\u8f66\u5355\u72b6\u6001\u65f6\uff0c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        this.vehicleReturnRepository.updateVehicleReturnStatusByVehicleTaskCode(vehicleTaskCode, VehicleReturnStatusEnum.COMPLETE.getType(), TenantUtils.getTenantCode());
    }

    private void returnVehicleDistribution(String vehicleTaskCode) {
        List<VehicleTaskExpenseMapping> VehicleTaskExpenseMappings = this.vehicleTaskExpenseMappingService.findByVehicleTaskCode(vehicleTaskCode);
        if (!CollectionUtils.isEmpty(VehicleTaskExpenseMappings)) {
            for (VehicleTaskExpenseMapping vehicleTaskExpenseMapping : VehicleTaskExpenseMappings) {
                Validate.isTrue((!DistributionStatusEnum.WAIT_DISTRIBUTION.getType().equals(vehicleTaskExpenseMapping.getDistributionStatus()) ? 1 : 0) != 0, (String)"\u6536\u8f66\u5165\u5e93\u65f6,\u6709\u914d\u9001\u4efb\u52a1\u672a\u914d\u9001", (Object[])new Object[0]);
            }
        }
    }
}

