/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.sales.dto.VehicleReturnDto;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleReturn;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskStatusEnum;
import com.bizunited.empower.business.sales.repository.vehicle.internal.VehicleReturnRepositoryCustom;
import com.bizunited.empower.business.sales.service.vehicle.VehicleReturnService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleReturnVoService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleReturnProductVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleReturnVo;
import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.empower.business.vehicle.entity.VehicleProductStock;
import com.bizunited.empower.business.vehicle.entity.VehicleUnload;
import com.bizunited.empower.business.vehicle.entity.VehicleUnloadProduct;
import com.bizunited.empower.business.vehicle.enums.VehicleProductTypeEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleUnloadTypeEnum;
import com.bizunited.empower.business.vehicle.service.VehicleProductStockService;
import com.bizunited.empower.business.vehicle.service.VehicleService;
import com.bizunited.empower.business.vehicle.service.VehicleUnloadService;
import com.bizunited.platform.common.constant.Constants;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="VehicleReturnVoServiceImpl")
public class VehicleReturnVoServiceImpl
implements VehicleReturnVoService {
    @Autowired
    private VehicleReturnService vehicleReturnService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    @Qualifier(value="_VehicleReturnRepositoryImpl")
    private VehicleReturnRepositoryCustom vehicleReturnRepositoryCustom;
    @Autowired
    private VehicleProductStockService vehicleProductStockService;
    @Autowired
    private VehicleService vehicleService;
    @Autowired
    private VehicleTaskService vehicleTaskService;
    @Autowired
    private VehicleUnloadService vehicleUnloadService;

    @Override
    public VehicleReturnVo findDetailsById(String id) {
        List vehicleUnloadList;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        VehicleReturn vehicleReturn = this.vehicleReturnService.findDetailsById(id);
        Validate.notNull((Object)((Object)vehicleReturn), (String)"\u672a\u67e5\u8be2\u5230\u6536\u8f66\u9000\u8d27\u5355", (Object[])new Object[0]);
        VehicleReturnVo vehicleReturnVo = (VehicleReturnVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleReturn, VehicleReturnVo.class, HashSet.class, ArrayList.class, new String[0]));
        VehicleTask vehicleTask = this.vehicleTaskService.findByVehicleTaskCode(vehicleReturn.getVehicleTaskCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1", (Object[])new Object[0]);
        ArrayList<VehicleReturnProductVo> vehicleSalesProductVos = new ArrayList<VehicleReturnProductVo>();
        ArrayList<VehicleReturnProductVo> vehicleDistributionProductVos = new ArrayList<VehicleReturnProductVo>();
        ArrayList<VehicleReturnProductVo> vehicleNotSalesProductVos = new ArrayList<VehicleReturnProductVo>();
        if (VehicleTaskStatusEnum.VEHICLE_DRIVING.getType().equals(vehicleTask.getVehicleTaskStatus()) || VehicleTaskStatusEnum.APPLY_RETURN.getType().equals(vehicleTask.getVehicleTaskStatus())) {
            Vehicle vehicle = this.vehicleService.findByVehicleCode(vehicleReturn.getVehicleCode());
            if (null == vehicle) {
                return new VehicleReturnVo();
            }
            Set vehicleProductStockSet = this.vehicleProductStockService.findDetailsByVehicle(vehicle.getId());
            if (!CollectionUtils.isEmpty((Collection)vehicleProductStockSet)) {
                List notSaleProductList;
                List distributionProductList;
                List vehicleSalesProductList = vehicleProductStockSet.stream().filter(product -> VehicleProductTypeEnum.VEHICLE_SALES.getType().equals(product.getVehicleProductType())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(vehicleSalesProductList)) {
                    for (Object vehicleProductStock : vehicleSalesProductList) {
                        VehicleReturnProductVo vehicleReturnProductVo = (VehicleReturnProductVo)this.nebulaToolkitService.copyObjectByWhiteList(vehicleProductStock, VehicleReturnProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        vehicleReturnProductVo.setQuantity(vehicleProductStock.getInventory());
                        vehicleSalesProductVos.add(vehicleReturnProductVo);
                    }
                    vehicleReturnVo.setVehicleSalesProductVos(vehicleSalesProductVos);
                }
                if (!CollectionUtils.isEmpty(distributionProductList = vehicleProductStockSet.stream().filter(product -> VehicleProductTypeEnum.DISTRIBUTION.getType().equals(product.getVehicleProductType())).collect(Collectors.toList()))) {
                    for (Object vehicleProductStock : distributionProductList) {
                        VehicleReturnProductVo vehicleReturnProductVo = (VehicleReturnProductVo)this.nebulaToolkitService.copyObjectByWhiteList(vehicleProductStock, VehicleReturnProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        vehicleReturnProductVo.setQuantity(vehicleProductStock.getInventory());
                        vehicleDistributionProductVos.add(vehicleReturnProductVo);
                    }
                    vehicleReturnVo.setVehicleDistributionProductVos(vehicleDistributionProductVos);
                }
                if (!CollectionUtils.isEmpty(notSaleProductList = vehicleProductStockSet.stream().filter(product -> VehicleProductTypeEnum.NOT_SALE.getType().equals(product.getVehicleProductType())).collect(Collectors.toList()))) {
                    for (VehicleProductStock vehicleProductStock : notSaleProductList) {
                        VehicleReturnProductVo vehicleReturnProductVo = (VehicleReturnProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleProductStock, VehicleReturnProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        vehicleReturnProductVo.setQuantity(vehicleProductStock.getInventory());
                        vehicleNotSalesProductVos.add(vehicleReturnProductVo);
                    }
                    vehicleReturnVo.setVehicleNotSalesProductVos(vehicleNotSalesProductVos);
                }
            }
        } else if (VehicleTaskStatusEnum.VEHICLE_RETURN.getType().equals(vehicleTask.getVehicleTaskStatus()) && !CollectionUtils.isEmpty((Collection)(vehicleUnloadList = this.vehicleUnloadService.findByVehicleTaskCodeAndUnloadType(vehicleTask.getVehicleTaskCode(), VehicleUnloadTypeEnum.RETURN.getType())))) {
            VehicleUnload notSaleVehicleUnload;
            VehicleUnload distributionVehicleUnload;
            VehicleUnload salesVehicleUnload = vehicleUnloadList.stream().filter(product -> VehicleProductTypeEnum.VEHICLE_SALES.getType().equals(product.getVehicleProductType())).findFirst().orElse(null);
            if (null != salesVehicleUnload) {
                for (Object vehicleUnloadProduct : salesVehicleUnload.getProducts()) {
                    VehicleReturnProductVo vehicleReturnProductVo = (VehicleReturnProductVo)this.nebulaToolkitService.copyObjectByWhiteList(vehicleUnloadProduct, VehicleReturnProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    vehicleSalesProductVos.add(vehicleReturnProductVo);
                }
                vehicleReturnVo.setVehicleSalesProductVos(vehicleSalesProductVos);
            }
            if (null != (distributionVehicleUnload = (VehicleUnload)vehicleUnloadList.stream().filter(product -> VehicleProductTypeEnum.DISTRIBUTION.getType().equals(product.getVehicleProductType())).findFirst().orElse(null))) {
                for (VehicleUnloadProduct vehicleUnloadProduct : distributionVehicleUnload.getProducts()) {
                    VehicleReturnProductVo vehicleReturnProductVo = (VehicleReturnProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleUnloadProduct, VehicleReturnProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    vehicleDistributionProductVos.add(vehicleReturnProductVo);
                }
                vehicleReturnVo.setVehicleDistributionProductVos(vehicleDistributionProductVos);
            }
            if (null != (notSaleVehicleUnload = (VehicleUnload)vehicleUnloadList.stream().filter(product -> VehicleProductTypeEnum.NOT_SALE.getType().equals(product.getVehicleProductType())).findFirst().orElse(null))) {
                for (VehicleUnloadProduct vehicleUnloadProduct : notSaleVehicleUnload.getProducts()) {
                    VehicleReturnProductVo vehicleReturnProductVo = (VehicleReturnProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleUnloadProduct, VehicleReturnProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    vehicleNotSalesProductVos.add(vehicleReturnProductVo);
                }
                vehicleReturnVo.setVehicleNotSalesProductVos(vehicleNotSalesProductVos);
            }
        }
        return vehicleReturnVo;
    }

    @Override
    public Page<VehicleReturnVo> findByConditions(Pageable pageable, VehicleReturnDto dto) {
        PageImpl vehicleReturnVoPage;
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)Constants.DEFAULT_PAGEABLE);
        Page<VehicleReturn> byConditions = this.vehicleReturnRepositoryCustom.findByConditions(pageable, dto);
        List content = byConditions.getContent();
        if (!CollectionUtils.isEmpty((Collection)content)) {
            Collection vehiclePickUpLoadVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)content, VehicleReturn.class, VehicleReturnVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            vehicleReturnVoPage = new PageImpl(new ArrayList(vehiclePickUpLoadVos), pageable, byConditions.getTotalElements());
        } else {
            vehicleReturnVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return vehicleReturnVoPage;
    }
}

