/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.sales.entity.vehicle.VehicleSaleMan;
import com.bizunited.empower.business.sales.repository.vehicle.VehicleSaleManRepository;
import com.bizunited.empower.business.sales.service.vehicle.VehicleSaleManService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="VehicleSaleManServiceImpl")
public class VehicleSaleManServiceImpl
implements VehicleSaleManService {
    @Autowired
    private VehicleSaleManRepository vehicleSaleManRepository;

    @Override
    @Transactional
    public VehicleSaleMan create(VehicleSaleMan vehicleSaleMan) {
        VehicleSaleMan current = this.createForm(vehicleSaleMan);
        return current;
    }

    @Override
    @Transactional
    public VehicleSaleMan createForm(VehicleSaleMan vehicleSaleMan) {
        this.createValidation(vehicleSaleMan);
        this.vehicleSaleManRepository.save((Object)vehicleSaleMan);
        return vehicleSaleMan;
    }

    private void createValidation(VehicleSaleMan vehicleSaleMan) {
        Validate.notNull((Object)((Object)vehicleSaleMan), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)vehicleSaleMan.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        vehicleSaleMan.setId(null);
        Validate.notBlank((CharSequence)vehicleSaleMan.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSaleMan.getUserAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSaleMan.getUserName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleSaleMan.getHead(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u662f\u4efb\u52a1\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleSaleMan.getTenantCode() == null || vehicleSaleMan.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSaleMan.getUserAccount() == null || vehicleSaleMan.getUserAccount().length() < 64 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSaleMan.getUserName() == null || vehicleSaleMan.getUserName().length() < 64 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public VehicleSaleMan update(VehicleSaleMan vehicleSaleMan) {
        VehicleSaleMan current = this.updateForm(vehicleSaleMan);
        return current;
    }

    @Override
    @Transactional
    public VehicleSaleMan updateForm(VehicleSaleMan vehicleSaleMan) {
        this.updateValidation(vehicleSaleMan);
        String currentId = vehicleSaleMan.getId();
        Optional op_currentVehicleSaleMan = this.vehicleSaleManRepository.findById(currentId);
        VehicleSaleMan currentVehicleSaleMan = op_currentVehicleSaleMan.orElse(null);
        currentVehicleSaleMan = (VehicleSaleMan)((Object)Validate.notNull((Object)((Object)currentVehicleSaleMan), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentVehicleSaleMan.setTenantCode(vehicleSaleMan.getTenantCode());
        currentVehicleSaleMan.setUserAccount(vehicleSaleMan.getUserAccount());
        currentVehicleSaleMan.setUserName(vehicleSaleMan.getUserName());
        currentVehicleSaleMan.setHead(vehicleSaleMan.getHead());
        currentVehicleSaleMan.setVehicleTask(vehicleSaleMan.getVehicleTask());
        this.vehicleSaleManRepository.saveAndFlush((Object)currentVehicleSaleMan);
        return currentVehicleSaleMan;
    }

    private void updateValidation(VehicleSaleMan vehicleSaleMan) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)vehicleSaleMan.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSaleMan.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSaleMan.getUserAccount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSaleMan.getUserName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleSaleMan.getHead(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u662f\u5426\u662f\u4efb\u52a1\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleSaleMan.getTenantCode() == null || vehicleSaleMan.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSaleMan.getUserAccount() == null || vehicleSaleMan.getUserAccount().length() < 64 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u8d26\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSaleMan.getUserName() == null || vehicleSaleMan.getUserName().length() < 64 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<VehicleSaleMan> findDetailsByVehicleTask(String vehicleTask) {
        if (StringUtils.isBlank((CharSequence)vehicleTask)) {
            return Sets.newHashSet();
        }
        return this.vehicleSaleManRepository.findDetailsByVehicleTask(vehicleTask);
    }

    @Override
    public VehicleSaleMan findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.vehicleSaleManRepository.findDetailsById(id);
    }

    @Override
    public VehicleSaleMan findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.vehicleSaleManRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        VehicleSaleMan current = this.findById(id);
        if (current != null) {
            this.vehicleSaleManRepository.delete((Object)current);
        }
    }

    @Override
    public void deleteByVehicleTaskId(String vehicleTaskId) {
        Validate.notBlank((CharSequence)vehicleTaskId, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u51fa\u8f66\u4efb\u52a1id!!", (Object[])new Object[0]);
        this.vehicleSaleManRepository.deleteByVehicleTaskIdAndTenantCode(vehicleTaskId, TenantUtils.getTenantCode());
    }

    @Override
    public void batchSave(String vehicleTaskId, List<VehicleSaleMan> vehicleSaleManList) {
        Validate.notBlank((CharSequence)vehicleTaskId, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u51fa\u8f66\u4efb\u52a1id!!", (Object[])new Object[0]);
        this.deleteByVehicleTaskId(vehicleTaskId);
        this.vehicleSaleManRepository.saveAll(vehicleSaleManList);
    }
}

