/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.sales.dto.VehicleSalesCustomerConditionsDto;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleSalesCustomerService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.sales.vo.DistributionRouteCustomerVo;
import com.bizunited.empower.business.sales.vo.DistributionRouteDetailVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.user2.sdk.service.user.UserVoService;
import com.bizunited.platform.user2.sdk.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class VehicleSalesCustomerServiceImpl
implements VehicleSalesCustomerService {
    @Autowired
    private VehicleTaskService vehicleTaskService;
    @Autowired
    private DistributionRouteService distributionRouteService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private UserVoService userService;

    @Override
    public Page<Customer> findDetailsByConditions(VehicleSalesCustomerConditionsDto dto, Pageable pageable) {
        Set customerCodes;
        DistributionRouteDetailVo route;
        if (dto == null) {
            dto = new VehicleSalesCustomerConditionsDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        String routeCode = null;
        Set<Object> routeCustomerCodes = Sets.newHashSet();
        HashMap conditions = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)dto.getVehicleTaskCode())) {
            VehicleTask vehicleTask = this.vehicleTaskService.findByVehicleTaskCode(dto.getVehicleTaskCode());
            if (vehicleTask == null) {
                if (StringUtils.isNotBlank((CharSequence)dto.getVehicleCode()) && (vehicleTask = this.vehicleTaskService.findVehicleTaskByVehicleCode(dto.getVehicleCode())) != null) {
                    routeCode = vehicleTask.getRouteCode();
                }
            } else {
                routeCode = vehicleTask.getRouteCode();
            }
        }
        if (StringUtils.isNotBlank(routeCode) && (route = this.distributionRouteService.findDetailsByCode(routeCode)) != null && !CollectionUtils.isEmpty(route.getCustomers())) {
            routeCustomerCodes = route.getCustomers().stream().map(DistributionRouteCustomerVo::getCustomerCode).collect(Collectors.toSet());
        }
        List<Object> relevanceUsers = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)dto.getRelevanceUser())) {
            Set users = this.userService.findByTenantCodeAndAccountLikeOrNameLike(TenantUtils.getTenantCode(), dto.getRelevanceUser());
            if (CollectionUtils.isEmpty((Collection)users)) {
                return Page.empty((Pageable)pageable);
            }
            relevanceUsers = users.stream().map(UserVo::getAccount).distinct().collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)relevanceUsers) && !CollectionUtils.isEmpty((Collection)(customerCodes = this.customerService.findByRelevanceUserAccount((List)relevanceUsers)))) {
            routeCustomerCodes.addAll(customerCodes);
        }
        if (CollectionUtils.isEmpty((Collection)routeCustomerCodes)) {
            return Page.empty((Pageable)pageable);
        }
        conditions.put("customerCodes", routeCustomerCodes);
        conditions.put("enabledState", dto.getEnabledState());
        conditions.put("keyword", dto.getKeyword());
        conditions.put("levelCode", dto.getLevelCode());
        conditions.put("categoryCode", dto.getCategoryCode());
        conditions.put("saleAreaCode", dto.getSaleAreaCode());
        conditions.put("enabledState", true);
        return this.customerService.findDetailsByConditions(pageable, (Map)conditions);
    }
}

