/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.allowable.service.CustomerBuyableProductService;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.entity.CustomerDeliveryInfo;
import com.bizunited.empower.business.customer.entity.CustomerLevel;
import com.bizunited.empower.business.customer.service.CustomerDeliveryInfoService;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.customer.vo.CustomerDeliveryInfoVo;
import com.bizunited.empower.business.order.dto.OrderFileDto;
import com.bizunited.empower.business.order.dto.OrderInfoConditionDto;
import com.bizunited.empower.business.order.dto.OrderInfoDto;
import com.bizunited.empower.business.order.dto.OrderInfoRebateProductsResultDto;
import com.bizunited.empower.business.order.dto.OrderInfoRebateResultDto;
import com.bizunited.empower.business.order.dto.OrderLogisticsInfoDto;
import com.bizunited.empower.business.order.dto.OrderProductDto;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.service.OrderInfoService;
import com.bizunited.empower.business.order.service.OrderInfoVoService;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.order.vo.OrderInfoVo;
import com.bizunited.empower.business.order.vo.OrderProductVo;
import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.empower.business.payment.entity.ReceiptInfo;
import com.bizunited.empower.business.payment.entity.ReceivableInfo;
import com.bizunited.empower.business.payment.service.DefrayInfoService;
import com.bizunited.empower.business.payment.service.ReceiptInfoService;
import com.bizunited.empower.business.payment.service.ReceivableInfoService;
import com.bizunited.empower.business.payment.vo.ReceiptInfoVo;
import com.bizunited.empower.business.payment.vo.ReceivableInfoVo;
import com.bizunited.empower.business.product.common.aspect.LabelPreferentialItems;
import com.bizunited.empower.business.product.optimize.service.ProductFlatService;
import com.bizunited.empower.business.product.optimize.vo.ProductFlatVo;
import com.bizunited.empower.business.product.optimize.vo.ProductSpecificationFlatVo;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.service.ProductVoService;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductUnitSpecificationAndPriceVo;
import com.bizunited.empower.business.product.vo.ProductUnitVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.empower.business.sales.constant.VehicleConstants;
import com.bizunited.empower.business.sales.dto.AllowAndExistVehicleProductDto;
import com.bizunited.empower.business.sales.dto.VehicleAttachsDto;
import com.bizunited.empower.business.sales.dto.VehicleSalesOrderDto;
import com.bizunited.empower.business.sales.dto.VehicleSalesOrderProductDto;
import com.bizunited.empower.business.sales.entity.outward.DistributionRouteCustomer;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskStatusEnum;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteCustomerService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleSalesOrderVoService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.sales.vo.vehicle.CurdateStatisticsVo;
import com.bizunited.empower.business.sales.vo.vehicle.IncomeExpenditureDetailsVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleSalesOrderForCopyVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleSalesOrderVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleSalesProductForCopyVo;
import com.bizunited.empower.business.vehicle.entity.VehicleProductStock;
import com.bizunited.empower.business.vehicle.entity.VehicleUnload;
import com.bizunited.empower.business.vehicle.entity.VehicleUnloadProduct;
import com.bizunited.empower.business.vehicle.enums.VehicleProductTypeEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleUnloadStatusEnum;
import com.bizunited.empower.business.vehicle.service.VehicleProductStockService;
import com.bizunited.empower.business.vehicle.service.VehicleUnloadService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.script.context.InvokeParams;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class VehicleSalesOrderVoServiceImpl
implements VehicleSalesOrderVoService {
    @Autowired
    private CustomerBuyableProductService customerBuyableProductService;
    @Autowired
    private VehicleUnloadService vehicleUnloadService;
    @Autowired
    private OrderInfoService orderInfoService;
    @Autowired
    private OrderInfoVoService orderInfoVoService;
    @Autowired
    private VehicleProductStockService vehicleProductStockService;
    @Autowired
    private VehicleTaskService vehicleTaskService;
    @Autowired
    private ReceiptInfoService receiptInfoService;
    @Autowired
    private ReceivableInfoService receivableInfoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DistributionRouteCustomerService distributionRouteCustomerService;
    @Autowired
    private CustomerDeliveryInfoService customerDeliveryInfoService;
    @Autowired
    private DefrayInfoService defrayInfoService;
    @Autowired
    private ProductVoService productVoService;
    @Autowired
    private ProductFlatService productFlatService;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private CustomerService customerService;

    @Override
    @Transactional
    public void confirm(VehicleSalesOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u521b\u5efa\u8f66\u9500\u8ba2\u5355\u65f6\uff0c\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskService.findVehicleTaskByVehicleCode(dto.getVehicleCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u8ba2\u5355\u521b\u5efa\u5931\u8d25\uff1a\u672a\u80fd\u83b7\u53d6\u5230\u51fa\u8f66\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u8f66\u8f86\u53ca\u51fa\u8f66\u4efb\u52a1\u72b6\u6001", (Object[])new Object[0]);
        Validate.isTrue((boolean)vehicleTask.getVehicleTaskStatus().equals(VehicleTaskStatusEnum.VEHICLE_DRIVING.getType()), (String)"\u5f53\u524d\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u51fa\u8f66\u4e2d", (Object[])new Object[0]);
        dto.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        Validate.isTrue((dto.getOrderTotalPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a0\u6216\u8d1f\u6570", (Object[])new Object[0]);
        Validate.isTrue((dto.getOrderTotalPrice().compareTo(new BigDecimal("0.01")) >= 0 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u5c11\u4e8e1\u5206\u94b1", (Object[])new Object[0]);
        this.requiredValidate(dto);
        this.allowableValidate(dto);
        OrderInfoDto orderInfoDto = this.buildOrderInfoDto(dto);
        OrderInfo orderInfo = this.orderInfoService.create(orderInfoDto);
        dto.setRelevanceCode(orderInfo.getOrderCode());
        VehicleUnload vehicleUnload = this.buildVehicleUnload(dto);
        this.vehicleUnloadService.saveVehicleUnload(vehicleUnload);
    }

    private void requiredValidate(VehicleSalesOrderDto dto) {
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4fe1\u606f\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerName(), (String)"\u5ba2\u6237\u59d3\u540d\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getVehicleCode(), (String)"\u8f66\u8f86\u7f16\u7801\u4fe1\u606f\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getVehicleTaskCode(), (String)"\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getVehicleName(), (String)"\u8f66\u8f86\u540d\u79f0\u4fe1\u606f\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSaleManAccount(), (String)"\u4e1a\u52a1\u5458\u8d26\u53f7\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSaleManName(), (String)"\u4e1a\u52a1\u5458\u540d\u79f0\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        Validate.notEmpty(dto.getProducts(), (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getFare(), (String)"\u8fd0\u8d39\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOrderDiscountPrice(), (String)"\u8ba2\u5355\u4f18\u60e0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOrderSpecialPrice(), (String)"\u8ba2\u5355\u7279\u6279\u51cf\u4ef7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOrderTotalPrice(), (String)"\u8ba2\u5355\u5e94\u4ed8\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (VehicleSalesOrderProductDto productDto : dto.getProducts()) {
            this.commodityValidate(productDto, dto.getVehicleCode());
        }
        if (!CollectionUtils.isEmpty(dto.getGifts())) {
            for (VehicleSalesOrderProductDto giftDto : dto.getGifts()) {
                this.commodityValidate(giftDto, dto.getVehicleCode());
            }
        }
        if (!CollectionUtils.isEmpty(dto.getAttachs())) {
            this.filesValidate(dto);
        }
    }

    private void commodityValidate(VehicleSalesOrderProductDto productDto, String vehicleCode) {
        Validate.notBlank((CharSequence)productDto.getProductSpecificationCode(), (String)"\u89c4\u683c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getProductSpecificationName(), (String)"\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getUnitCode(), (String)"\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getUnitName(), (String)"\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productDto.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productDto.getQuantity(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productDto.getSubtotalAmount(), (String)"\u884c\u5546\u54c1\u5c0f\u8ba1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productDto.getPurchasePrice(), (String)"\u91c7\u8d2d\u53c2\u8003\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)productDto.getSellingPrice(), (String)"\u9500\u552e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean flag = this.vehicleProductStockService.validateVehicleStock(productDto.getProductSpecificationCode(), vehicleCode, productDto.getQuantity(), productDto.getUnitCode(), Integer.valueOf(2));
        Validate.isTrue((flag != null && flag != false ? 1 : 0) != 0, (String)"\u3010%s\u3011\u8f66\u8f86\u5e93\u5b58\u4e0d\u8db3", (Object[])new Object[]{productDto.getProductName()});
    }

    private void allowableValidate(VehicleSalesOrderDto dto) {
        Set productCodes;
        String customerCode = dto.getCustomerCode();
        Set allowCodes = dto.getProducts().stream().map(VehicleSalesOrderProductDto::getProductSpecificationCode).collect(Collectors.toSet());
        Sets.SetView intersections = Sets.intersection(allowCodes, (Set)(productCodes = this.customerBuyableProductService.findSpecificationsByCustomerCode(customerCode)));
        Validate.isTrue((intersections.size() == allowCodes.size() ? 1 : 0) != 0, (String)"\u8be5\u8ba2\u5355\u542b\u6709\u975e\u5141\u9500\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    private void filesValidate(VehicleSalesOrderDto dto) {
        if (!CollectionUtils.isEmpty(dto.getAttachs())) {
            Validate.isTrue((dto.getAttachs().size() <= VehicleConstants.SALE_VEHICLE_ORDER_ATTCHS_UPLOAD_MAX_NUM ? 1 : 0) != 0, (String)"\u9644\u4ef6\u4e0a\u4f20\u8d85\u8fc7\u6700\u5927\u6570\u91cf%d", (long)VehicleConstants.SALE_VEHICLE_ORDER_ATTCHS_UPLOAD_MAX_NUM.intValue());
            for (VehicleAttachsDto attachsDto : dto.getAttachs()) {
                Validate.notBlank((CharSequence)attachsDto.getFileName(), (String)"\u9644\u4ef6\u91cd\u547d\u540d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)attachsDto.getRelativePath(), (String)"\u9644\u4ef6\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)attachsDto.getOriginalFileName(), (String)"\u539f\u59cb\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
    }

    private VehicleUnload buildVehicleUnload(VehicleSalesOrderDto dto) {
        VehicleUnload vehicleUnload = new VehicleUnload();
        vehicleUnload.setVehicleUnloadType(Integer.valueOf(2));
        vehicleUnload.setVehicleProductType(VehicleProductTypeEnum.VEHICLE_SALES.getType());
        vehicleUnload.setVehicleUnloadStatus(VehicleUnloadStatusEnum.WAIT_DELIVERY.getType());
        vehicleUnload.setVehicleTaskCode(dto.getVehicleTaskCode());
        vehicleUnload.setCustomerCode(dto.getCustomerCode());
        vehicleUnload.setCustomerName(dto.getCustomerName());
        vehicleUnload.setSaleManAccount(dto.getSaleManAccount());
        vehicleUnload.setSaleManName(dto.getSaleManName());
        vehicleUnload.setVehicleCode(dto.getVehicleCode());
        vehicleUnload.setVehicleName(dto.getVehicleName());
        vehicleUnload.setRelevanceCode(dto.getRelevanceCode());
        vehicleUnload.setProducts(this.buildVehicleUnloadProduct(dto, vehicleUnload));
        return vehicleUnload;
    }

    private Set<VehicleUnloadProduct> buildVehicleUnloadProduct(VehicleSalesOrderDto dto, VehicleUnload vehicleUnload) {
        Set<VehicleSalesOrderProductDto> productDtos = dto.getProducts();
        productDtos.addAll(dto.getGifts());
        HashSet products = Sets.newHashSet();
        List productCodes = productDtos.stream().map(VehicleSalesOrderProductDto::getProductCode).distinct().collect(Collectors.toList());
        List productSet = this.productFlatService.findByProductCodeList(productCodes, TenantUtils.getTenantCode());
        Map map = productSet.stream().collect(Collectors.toMap(ProductFlatVo::getProductCode, Function.identity()));
        for (VehicleSalesOrderProductDto productDto : productDtos) {
            ProductFlatVo productData;
            Map specificationMap;
            ProductSpecificationFlatVo specificationFlatDto;
            VehicleUnloadProduct product = new VehicleUnloadProduct();
            product.setTenantCode(TenantUtils.getTenantCode());
            product.setVehicleUnload(vehicleUnload);
            product.setBarCode(productDto.getBarCode());
            product.setProductCode(productDto.getProductCode());
            product.setProductName(productDto.getProductName());
            product.setProductSpecificationCode(productDto.getProductSpecificationCode());
            product.setProductSpecificationName(productDto.getProductSpecificationName());
            product.setPurchasePrice(productDto.getPurchasePrice());
            product.setQuantity(productDto.getQuantity());
            product.setSubtotalAmount(productDto.getSubtotalAmount());
            product.setUnitCode(productDto.getUnitCode());
            product.setUnitName(productDto.getUnitName());
            if (map.containsKey(productDto.getProductCode()) && (specificationFlatDto = (ProductSpecificationFlatVo)(specificationMap = (productData = (ProductFlatVo)map.get(productDto.getProductCode())).getProductSpecificationMap()).get(productDto.getProductSpecificationCode())) != null) {
                product.setRelativePath(specificationFlatDto.getMainImagePath());
                product.setFileName(specificationFlatDto.getMainImageName());
            }
            products.add(product);
        }
        return products;
    }

    private OrderInfoDto buildOrderInfoDto(VehicleSalesOrderDto dto) {
        OrderInfoDto orderInfoDto = new OrderInfoDto();
        orderInfoDto.setCustomerCode(dto.getCustomerCode());
        orderInfoDto.setFare(dto.getFare());
        orderInfoDto.setOrderSpecialPrice(dto.getOrderSpecialPrice());
        orderInfoDto.setProductTotalPrice(dto.getProductTotalPrice());
        orderInfoDto.setRemark(dto.getRemark());
        orderInfoDto.setSaleAccount(dto.getSaleManAccount());
        orderInfoDto.setSaleName(dto.getSaleManName());
        orderInfoDto.setOrderSource("vehicleSales");
        orderInfoDto.setOrderType(Integer.valueOf(2));
        HashSet productDtoSet = Sets.newHashSet();
        orderInfoDto.setOrderProducts((Set)productDtoSet);
        HashSet fileDtoSet = Sets.newHashSet();
        orderInfoDto.setOrderFiles((Set)fileDtoSet);
        if (!CollectionUtils.isEmpty(dto.getRebateResults())) {
            for (OrderInfoRebateResultDto rebateResultDto : dto.getRebateResults()) {
                Validate.notBlank((CharSequence)rebateResultDto.getRebatePolicyCode(), (String)"\u8ba2\u5355\u6d89\u53ca\u5230\u7684\u8fd4\u5229\u7f16\u53f7\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
                if (rebateResultDto.getDiscountAmount() == null) {
                    Validate.notEmpty((Collection)rebateResultDto.getProductsResults(), (String)"\u8fd4\u5229\u7684\u5546\u54c1\u4fe1\u606f\u9700\u8981\u4f20\u5165", (Object[])new Object[0]);
                    for (OrderInfoRebateProductsResultDto productsResultDto : rebateResultDto.getProductsResults()) {
                        Validate.notBlank((CharSequence)productsResultDto.getProductCode(), (String)"\u8fd4\u5229\u4fe1\u606f\u7684\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)productsResultDto.getProductSpecificationCode(), (String)"\u8fd4\u5229\u4fe1\u606f\u7684\u5546\u54c1\u89c4\u683c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notBlank((CharSequence)productsResultDto.getUnitCode(), (String)"\u8fd4\u5229\u4fe1\u606f\u7684\u5546\u54c1\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.isTrue((productsResultDto.getQuantity() != null && productsResultDto.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u4fe1\u606f\u7684\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
                    }
                    continue;
                }
                Validate.isTrue((rebateResultDto.getDiscountAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570", (Object[])new Object[0]);
            }
            orderInfoDto.setRebateResults(dto.getRebateResults());
        }
        for (VehicleSalesOrderProductDto productDto : dto.getProducts()) {
            OrderProductDto orderProductDto = new OrderProductDto();
            orderProductDto.setGift(Integer.valueOf(0));
            orderProductDto.setInternationalBarcode(productDto.getBarCode());
            orderProductDto.setOrderQuantity(productDto.getQuantity());
            orderProductDto.setProductSpecificationCode(productDto.getProductSpecificationCode());
            orderProductDto.setProductSpecificationName(productDto.getProductSpecificationName());
            orderProductDto.setUnitCode(productDto.getUnitCode());
            orderProductDto.setUnitName(productDto.getUnitName());
            orderProductDto.setUnitPrice(productDto.getSellingPrice());
            orderProductDto.setSubtotalAmount(productDto.getSubtotalAmount());
            productDtoSet.add(orderProductDto);
        }
        if (!CollectionUtils.isEmpty(dto.getGifts())) {
            for (VehicleSalesOrderProductDto giftDto : dto.getGifts()) {
                OrderProductDto orderGiftDto = new OrderProductDto();
                orderGiftDto.setGift(Integer.valueOf(1));
                orderGiftDto.setInternationalBarcode(giftDto.getBarCode());
                orderGiftDto.setOrderQuantity(giftDto.getQuantity());
                orderGiftDto.setProductSpecificationCode(giftDto.getProductSpecificationCode());
                orderGiftDto.setProductSpecificationName(giftDto.getProductSpecificationName());
                orderGiftDto.setUnitCode(giftDto.getUnitCode());
                orderGiftDto.setUnitName(giftDto.getUnitName());
                orderGiftDto.setUnitPrice(BigDecimal.ZERO);
                orderGiftDto.setSubtotalAmount(BigDecimal.ZERO);
                productDtoSet.add(orderGiftDto);
            }
        }
        if (!CollectionUtils.isEmpty(dto.getAttachs())) {
            for (VehicleAttachsDto attchDto : dto.getAttachs()) {
                OrderFileDto orderFileDto = new OrderFileDto();
                orderFileDto.setFileName(attchDto.getOriginalFileName());
                orderFileDto.setReFileName(attchDto.getFileName());
                orderFileDto.setRelativePath(attchDto.getRelativePath());
                fileDtoSet.add(orderFileDto);
            }
        }
        orderInfoDto.setLogisticsInfo((Set)Sets.newHashSet());
        Customer customer = this.customerService.findDetailsByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), orderInfoDto.getCustomerCode());
        Validate.notNull((Object)customer, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u5ba2\u6237\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5ba2\u6237\u4fe1\u606f", (Object[])new Object[]{orderInfoDto.getCustomerCode()});
        Validate.notEmpty((Collection)customer.getDeliveryInfos(), (String)"\u5ba2\u6237\u6536\u8d27\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrderLogisticsInfoDto orderLogisticsInfoDto = new OrderLogisticsInfoDto();
        CustomerDeliveryInfo deliveryInfo = (CustomerDeliveryInfo)customer.getDeliveryInfos().iterator().next();
        orderLogisticsInfoDto.setAddress(StringUtils.join((Object[])new String[]{deliveryInfo.getProvinceName(), deliveryInfo.getCityName(), deliveryInfo.getDistrictName(), deliveryInfo.getAddress()}));
        orderLogisticsInfoDto.setContactPerson(customer.getContactPerson());
        orderLogisticsInfoDto.setPhone(customer.getPhone());
        orderLogisticsInfoDto.setDeliveryDate(new Date());
        orderInfoDto.getLogisticsInfo().add(orderLogisticsInfoDto);
        return orderInfoDto;
    }

    @Override
    @Transactional
    public void cancel(String orderCode) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrderInfo orderInfo = this.orderInfoService.findDetailsByOrderCode(orderCode);
        Validate.notNull((Object)orderInfo, (String)"\u6839\u636e\u8ba2\u5355\u7f16\u7801\u3010%s\u3011\u672a\u80fd\u67e5\u8be2\u5230\u8f66\u9500\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        Validate.isTrue((orderInfo.getOrderType() != null && orderInfo.getOrderType() == 2 ? 1 : 0) != 0, (String)"\u8be5\u8ba2\u5355\u4e0d\u662f\u8f66\u9500\u8ba2\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u53d6\u6d88\u64cd\u4f5c", (Object[])new Object[0]);
        Validate.isTrue((boolean)OrderStrategyEvent.BeReceived.getEventTarget().equals(orderInfo.getOrderStatus()), (String)"\u4ec5\u652f\u6301\u3010\u5f85\u6536\u8d27\u3011\u72b6\u6001\u7684\u8ba2\u5355\u53d6\u6d88", (Object[])new Object[0]);
        this.orderInfoService.cancel(orderInfo.getOrderCode());
        this.vehicleUnloadService.cancelByRelevanceCode(orderCode);
    }

    @Override
    @Transactional
    public void confirmDelivery(String orderCode) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleUnload vehicleUnload = this.vehicleUnloadService.findByRelevanceCode(orderCode);
        Validate.notNull((Object)vehicleUnload, (String)"\u6839\u636e\u5173\u8054\u8ba2\u5355\u7f16\u53f7\u3010%s\u3011,\u672a\u80fd\u67e5\u8be2\u5230\u5378\u8d27\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((vehicleUnload.getVehicleUnloadStatus() == 1 ? 1 : 0) != 0, (String)"\u5378\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u4ea4\u8d27\u72b6\u6001", (Object[])new Object[0]);
        this.vehicleUnloadService.deliveryVehicleUnload(vehicleUnload.getVehicleUnloadCode());
    }

    @Override
    @Transactional
    public void createReceipt(ReceiptInfo receiptInfo, String orderCode) {
        Validate.notNull((Object)receiptInfo, (String)"\u4f20\u5165\u7684\u6536\u6b3e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderCode, (String)"\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrderInfo orderInfo = this.orderInfoService.findByOrderCode(orderCode);
        Validate.notNull((Object)orderInfo, (String)"\u6839\u636e\u8ba2\u5355\u7f16\u7801\u3010%s\u3011\u672a\u80fd\u67e5\u8be2\u5230\u8f66\u9500\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        Validate.isTrue((orderInfo.getOrderType() != null && orderInfo.getOrderType() == 2 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u7c7b\u578b\u5339\u914d\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        Validate.isTrue((orderInfo.getOrderStatus() == 1 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u7f16\u7801\u3010%s\u3011\u8ba2\u5355\u72b6\u6001\u5fc5\u987b\u5904\u4e8e\u5f85\u4ed8\u6b3e\u72b6\u6001", (Object[])new Object[]{orderInfo.getOrderCode()});
        Validate.isTrue((orderInfo.getReceivableStatus() == 1 || orderInfo.getReceivableStatus() == 2 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u7f16\u7801\u3010%s\u3011\u6536\u6b3e\u72b6\u6001\u5fc5\u987b\u5904\u4e8e\u672a\u4ed8\u6b3e\u6216\u90e8\u5206\u4ed8\u6b3e\u72b6\u6001", (Object[])new Object[]{orderInfo.getOrderCode()});
        Validate.isTrue((orderInfo.getDeliveryStatus() == 3 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u7f16\u7801\u3010%s\u3011\u8ba2\u5355\u914d\u9001\u72b6\u6001\u5fc5\u987b\u5904\u4e8e\u5df2\u4ea4\u8d27\u72b6\u6001", (Object[])new Object[]{orderInfo.getOrderCode()});
        Validate.notNull((Object)receiptInfo.getReceiptAmount(), (String)"\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((receiptInfo.getReceiptAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a0\u6216\u8d1f\u6570!", (Object[])new Object[0]);
        Validate.isTrue((receiptInfo.getReceiptAmount().compareTo(new BigDecimal("0.01")) >= 0 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e1\u5206\u94b1!", (Object[])new Object[0]);
        Validate.notNull((Object)receiptInfo.getReceiptTime(), (String)"\u6536\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)receiptInfo.getFundsChannel(), (String)"\u652f\u4ed8\u6e20\u9053\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        FundsChannelType fundsChannelType = FundsChannelType.valueOfType((Integer)receiptInfo.getFundsChannel());
        Validate.isTrue((fundsChannelType != null && (fundsChannelType.getValue() == 2 || fundsChannelType.getValue() == 4) ? 1 : 0) != 0, (String)"\u8f66\u9500\u6536\u6b3e\u5355\u76ee\u524d\u53ea\u652f\u6301\u73b0\u91d1\u6216\u5fae\u4fe1\u652f\u4ed8", (Object[])new Object[0]);
        ReceivableInfo receivableInfo = this.receivableInfoService.findByAssociatedCode(orderCode);
        Validate.notNull((Object)receivableInfo, (String)"\u6839\u636e\u5173\u8054\u5355\u53f7\u3010%s\u3011\uff0c\u672a\u67e5\u8be2\u5230\u5e94\u6536\u6570\u636e\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        receiptInfo.setReceivableInfo(receivableInfo);
        this.receiptInfoService.create(receiptInfo);
        if (fundsChannelType.getValue() == 4) {
            this.confirmReceipt(receiptInfo.getReceiptCode());
        }
    }

    @Override
    @Transactional
    public void confirmReceipt(String receiptCode) {
        Validate.notBlank((CharSequence)receiptCode, (String)"\u786e\u8ba4\u6536\u6b3e\u65f6\uff0c\u6536\u6b3e\u5355\u7f16\u53f7\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        this.receiptInfoService.confirm(receiptCode);
    }

    @Override
    @Transactional
    public void confirmReceipts(String receiptCodes) {
        String[] receiptCodesArr;
        Validate.notBlank((CharSequence)receiptCodes, (String)"\u6536\u6b3e\u5355\u7f16\u7801\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        for (String receiptCode : receiptCodesArr = StringUtils.split((String)",")) {
            this.confirmReceipt(StringUtils.trim((String)receiptCode));
        }
    }

    @Override
    @Transactional
    public void cancelReceipt(String receiptCode) {
        Validate.notBlank((CharSequence)receiptCode, (String)"\u53d6\u6d88\u6536\u6b3e\u65f6\uff0c\u6536\u6b3e\u5355\u7f16\u53f7\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        this.receiptInfoService.cancelByReceiptCode(receiptCode);
    }

    @Override
    public Set<ReceiptInfoVo> findReceiptInfoByTaskCodeAndVehicleCode(String taskCode, String vehicleCode) {
        List receivableInfos;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{taskCode, vehicleCode})) {
            return Sets.newHashSet();
        }
        List vehicleUnloads = this.vehicleUnloadService.findByVehicleTaskCodeAndVehicleCode(taskCode, vehicleCode);
        Set<Object> relevanceCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)vehicleUnloads)) {
            relevanceCodes = vehicleUnloads.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getRelevanceCode())).map(VehicleUnload::getRelevanceCode).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty((Collection)(receivableInfos = this.receivableInfoService.findByAssociatedCodes((Set)relevanceCodes)))) {
            return Sets.newHashSet();
        }
        LinkedHashSet receiptInfoVos = Sets.newLinkedHashSet();
        this.buildReceiptInfoVos(receiptInfoVos, receivableInfos);
        return receiptInfoVos;
    }

    @Override
    public VehicleSalesOrderVo findDetailsByVehicleOrderCode(String vehicleOrderCode) {
        VehicleUnload vehicleUnload;
        if (StringUtils.isBlank((CharSequence)vehicleOrderCode)) {
            return null;
        }
        OrderInfoVo orderInfoVo = this.orderInfoVoService.findDetailsByOrderCode(vehicleOrderCode);
        if (orderInfoVo == null) {
            return null;
        }
        VehicleSalesOrderVo vehicleSalesOrderVo = (VehicleSalesOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)orderInfoVo, VehicleSalesOrderVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"orderProducts", "orderFiles"});
        CustomerDeliveryInfo customerDeliveryInfo = this.customerDeliveryInfoService.findDefaultByCustomerCode(vehicleSalesOrderVo.getCustomerCode());
        if (customerDeliveryInfo != null) {
            String detailAddress = StringUtils.join((Object[])new String[]{customerDeliveryInfo.getProvinceName(), customerDeliveryInfo.getCityName(), customerDeliveryInfo.getDistrictName(), customerDeliveryInfo.getAddress()});
            vehicleSalesOrderVo.setCustomerAddress(detailAddress);
        }
        if ((vehicleUnload = this.vehicleUnloadService.findByRelevanceCode(vehicleOrderCode)) == null) {
            return vehicleSalesOrderVo;
        }
        VehicleTask vehicleTask = this.vehicleTaskService.findByVehicleTaskCode(vehicleUnload.getVehicleTaskCode());
        if (vehicleTask == null) {
            return vehicleSalesOrderVo;
        }
        Set<DistributionRouteCustomer> routeCustomers = this.distributionRouteCustomerService.findDetailsByRouteCode(vehicleTask.getRouteCode());
        if (CollectionUtils.isEmpty(routeCustomers)) {
            return vehicleSalesOrderVo;
        }
        for (DistributionRouteCustomer routeCustomer : routeCustomers) {
            if (!StringUtils.equals((CharSequence)vehicleSalesOrderVo.getCustomerCode(), (CharSequence)routeCustomer.getCustomerCode())) continue;
            CustomerDeliveryInfoVo deliveryInfoVo = new CustomerDeliveryInfoVo();
            deliveryInfoVo.setPhone(routeCustomer.getReceiverPhone());
            deliveryInfoVo.setAddress(routeCustomer.getReceiverAddress());
            deliveryInfoVo.setCityName(routeCustomer.getCityName());
            deliveryInfoVo.setProvinceName(routeCustomer.getProvinceName());
            deliveryInfoVo.setDistrictName(routeCustomer.getDistrictName());
            deliveryInfoVo.setReceiver(routeCustomer.getReceiver());
            vehicleSalesOrderVo.setCustomerDeliveryInfo(deliveryInfoVo);
            break;
        }
        return vehicleSalesOrderVo;
    }

    @Override
    public Page<VehicleSalesOrderVo> findByConditions(OrderInfoConditionDto dto, Pageable pageable, String vehicleTaskCode, String startTime, String endTime) {
        List vehicleUnloads;
        Date date;
        if (dto == null) {
            dto = new OrderInfoConditionDto();
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        dto.setOrderType(Integer.valueOf(2));
        if (dto.getOrderStatus() != null && dto.getOrderStatus() == 0) {
            dto.setDeliveryStatus(null);
            dto.setOrderStatus(null);
            dto.setReceivableStatus(null);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            try {
                date = simpleDateFormat.parse(startTime);
                dto.setCreateTimeStart(date);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            try {
                date = simpleDateFormat.parse(endTime);
                dto.setCreateTimeEnd(date);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(vehicleUnloads = this.vehicleUnloadService.findByVehicleTaskCodeAndProductType(vehicleTaskCode, VehicleProductTypeEnum.VEHICLE_SALES)))) {
            return Page.empty((Pageable)pageable);
        }
        List relevanceOrderCodes = vehicleUnloads.stream().map(VehicleUnload::getRelevanceCode).collect(Collectors.toList());
        dto.setOrderCodes(relevanceOrderCodes);
        Page pages = this.orderInfoVoService.findByConditions(pageable, dto);
        List orderInfoVos = pages.getContent();
        if (!CollectionUtils.isEmpty((Collection)orderInfoVos)) {
            Collection collections = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)orderInfoVos, OrderInfoVo.class, VehicleSalesOrderVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"orderProducts"});
            ArrayList vehicleSalesOrderVoList = Lists.newArrayList((Iterable)collections);
            for (VehicleSalesOrderVo vo : vehicleSalesOrderVoList) {
                if (CollectionUtils.isEmpty((Collection)vo.getOrderProducts())) continue;
                BigDecimal productsNum = vo.getOrderProducts().stream().map(OrderProductVo::getOrderQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setProductsNum(productsNum);
            }
            return new PageImpl((List)vehicleSalesOrderVoList, pageable, pages.getTotalElements());
        }
        return Page.empty((Pageable)pageable);
    }

    @Override
    public VehicleSalesOrderForCopyVo copy(String orderCode, String vehicleCode) {
        List vehicleProductStocks;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{orderCode, TenantUtils.getTenantCode()})) {
            return null;
        }
        OrderInfoVo orderInfoVo = this.orderInfoVoService.findDetailsByOrderCode(orderCode);
        if (orderInfoVo == null) {
            return null;
        }
        orderInfoVo.setId(null);
        orderInfoVo.setOrderCode(null);
        orderInfoVo.setPayType(null);
        orderInfoVo.setSaleAccount(null);
        orderInfoVo.setSaleName(null);
        orderInfoVo.setRelevanceCode(null);
        orderInfoVo.setGiftsNumber(Integer.valueOf(0));
        orderInfoVo.setProductsNumber(Integer.valueOf(0));
        orderInfoVo.setProductTotalPrice(BigDecimal.ZERO);
        orderInfoVo.setFare(BigDecimal.ZERO);
        orderInfoVo.setOrderSpecialPrice(BigDecimal.ZERO);
        orderInfoVo.setOrderDiscountPrice(BigDecimal.ZERO);
        orderInfoVo.setDiscountPoolPrice(BigDecimal.ZERO);
        orderInfoVo.setOrderPointPrice(BigDecimal.ZERO);
        orderInfoVo.setOrderTotalPrice(BigDecimal.ZERO);
        orderInfoVo.setOrderStatus(null);
        orderInfoVo.setDeliveryStatus(null);
        orderInfoVo.setDeliveryMethod(null);
        orderInfoVo.setDeliveryMethod(null);
        orderInfoVo.setReceivableStatus(null);
        orderInfoVo.setCreateAccount(null);
        orderInfoVo.setCreateTime(null);
        orderInfoVo.setModifyAccount(null);
        orderInfoVo.setModifyTime(null);
        orderInfoVo.setRemark(null);
        orderInfoVo.setAuditInstance(null);
        orderInfoVo.setAuditStatus(null);
        orderInfoVo.setAuditVersion(null);
        orderInfoVo.setCancelAuditInstance(null);
        orderInfoVo.setCancelAuditStatus(null);
        orderInfoVo.setCancelAuditVersion(null);
        orderInfoVo.setTenantCode(TenantUtils.getTenantCode());
        orderInfoVo.setOrderFiles((Set)Sets.newHashSet());
        orderInfoVo.setLogisticsInfo((Set)Sets.newHashSet());
        orderInfoVo.setOrderStatusLoggers((Set)Sets.newHashSet());
        Customer customer = this.customerService.findDetailsByTenantCodeAndCustomerCode(orderInfoVo.getTenantCode(), orderInfoVo.getCustomerCode());
        Validate.notNull((Object)customer, (String)"\u8ba2\u5355\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        CustomerLevel customerLevel = customer.getCustomerLevel();
        Validate.notNull((Object)customerLevel, (String)"\u8ba2\u5355\u5ba2\u6237\u7b49\u7ea7\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        BigDecimal fullRebate = new BigDecimal(100);
        BigDecimal customerRebate = customerLevel.getRebate() == null ? fullRebate : customerLevel.getRebate();
        VehicleSalesOrderForCopyVo copyVo = (VehicleSalesOrderForCopyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)orderInfoVo, VehicleSalesOrderForCopyVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"orderProducts"});
        Collection copyProductVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)orderInfoVo.getOrderProducts(), OrderProductVo.class, VehicleSalesProductForCopyVo.class, LinkedHashSet.class, ArrayList.class, new String[]{""});
        Set productForCopyVos = copyProductVos.stream().filter(e -> e.getGift() == 0).collect(Collectors.toSet());
        copyVo.setProductVoSet(Sets.newHashSet(productForCopyVos));
        if (CollectionUtils.isEmpty(copyVo.getProductVoSet())) {
            return copyVo;
        }
        Set productSpecificationCodes = copyVo.getProductVoSet().stream().map(OrderProductVo::getProductSpecificationCode).collect(Collectors.toSet());
        InvokeParams conditions = new InvokeParams();
        conditions.putInvokeParam("tenantCode", (Object)TenantUtils.getTenantCode());
        conditions.putInvokeParam("productCodeList", (Object)StringUtils.join(productSpecificationCodes, (String)","));
        conditions.putInvokeParam("customerCode", (Object)customer.getCustomerCode());
        Page productVos = this.productVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE), conditions);
        block0: for (VehicleSalesProductForCopyVo vo : copyVo.getProductVoSet()) {
            for (ProductVo productVo : productVos) {
                if (!StringUtils.equals((CharSequence)productVo.getProductCode(), (CharSequence)vo.getProductCode())) continue;
                vo.setBrandCode(productVo.getProductBrand().getBrandCode());
                vo.setBrandName(productVo.getProductBrand().getBrandName());
                vo.setCategoryCode(productVo.getProductCategory().getCode());
                vo.setCategoryName(productVo.getProductCategory().getName());
                vo.setTags(productVo.getTags());
                Set unitAndPriceVos = productVo.getProductUnitSpecificationAndPrices();
                for (ProductSpecificationVo specificationVo : productVo.getProductSpecifications()) {
                    if (!StringUtils.equals((CharSequence)vo.getProductSpecificationCode(), (CharSequence)specificationVo.getProductSpecificationCode())) continue;
                    vo.setMinimumOrderQuantity(specificationVo.getMinimumOrderQuantity());
                    vo.setMaximumOrderQuantity(specificationVo.getMaximumOrderQuantity());
                    vo.setProductPreferentialItems(specificationVo.getPreferentialItems());
                    break;
                }
                for (ProductUnitSpecificationAndPriceVo unitAndPriceVo : unitAndPriceVos) {
                    ProductUnitVo productUnitVo = unitAndPriceVo.getProductUnit();
                    if (productUnitVo == null || !StringUtils.equals((CharSequence)productUnitVo.getUnitCode(), (CharSequence)vo.getUnitCode())) continue;
                    vo.setUnitPrice(unitAndPriceVo.getSellingPrice());
                    vo.setPurchasePrice(unitAndPriceVo.getReferencePurchasePrice());
                    vo.setSellingPrice(unitAndPriceVo.getSellingPrice().multiply(customerRebate.divide(fullRebate.setScale(2, 4))));
                    vo.setConversionRatio(unitAndPriceVo.getConversionRatio());
                    vo.setDefaultPurchase(unitAndPriceVo.getDefaultPurchase());
                    vo.setAllowPurchase(unitAndPriceVo.getAllowPurchase());
                    continue block0;
                }
                continue block0;
            }
        }
        if (orderInfoVo.getOrderType() == 2 && !CollectionUtils.isEmpty((Collection)(vehicleProductStocks = this.vehicleProductStockService.findEffectiveVehicleSaleStockByVehicleCode(vehicleCode)))) {
            Map map = vehicleProductStocks.stream().collect(Collectors.toMap(VehicleProductStock::getProductSpecificationCode, Function.identity()));
            for (VehicleSalesProductForCopyVo vehicleSalesProductForCopyVo : copyVo.getProductVoSet()) {
                if (!map.containsKey(vehicleSalesProductForCopyVo.getProductSpecificationCode())) continue;
                vehicleSalesProductForCopyVo.setUsableInventory(((VehicleProductStock)map.get(vehicleSalesProductForCopyVo.getProductSpecificationCode())).getUsableInventory());
            }
        }
        return copyVo;
    }

    private void buildReceiptInfoVos(Set<ReceiptInfoVo> receiptInfoVos, List<ReceivableInfo> receivableInfos) {
        for (ReceivableInfo receivableInfo : receivableInfos) {
            for (ReceiptInfo receiptInfo : receivableInfo.getReceiptInfos()) {
                ReceiptInfoVo infoVo = new ReceiptInfoVo();
                infoVo.setCustomerCode(receivableInfo.getCustomerCode());
                infoVo.setCustomerName(receivableInfo.getCustomerName());
                infoVo.setFundsChannel(receiptInfo.getFundsChannel());
                infoVo.setReceiptAmount(receiptInfo.getReceiptAmount());
                infoVo.setReceiptCode(receiptInfo.getReceiptCode());
                infoVo.setReceiptStatus(receiptInfo.getReceiptStatus());
                infoVo.setReceiptTime(receiptInfo.getReceiptTime());
                infoVo.setRemark(receiptInfo.getRemark());
                ReceivableInfoVo receivableInfoVo = new ReceivableInfoVo();
                receivableInfoVo.setAssociatedCode(receivableInfo.getAssociatedCode());
                infoVo.setReceivableInfo(receivableInfoVo);
                receiptInfoVos.add(infoVo);
            }
        }
    }

    private BigDecimal sumCurdateOrderTotalAmount(String account, Date startTime, Date endTime) {
        return this.orderInfoService.sumOrderTotalPriceByOrderTypeAndCreateTimeBetween(Integer.valueOf(2), account, startTime, endTime);
    }

    private BigInteger countCurdateVehicleOrderTotalNum(String account, Date startTime, Date endTime) {
        return BigInteger.valueOf(this.orderInfoService.countByOrderTypeAndCreateTimeBetween(Integer.valueOf(2), account, startTime, endTime));
    }

    private BigDecimal sumCurdateTotalReceipt(String account, Date now) {
        return this.receiptInfoService.sumTotalReceiptAmountByAccountAndReceiptTime(account, now);
    }

    private BigDecimal calcCurdateCustomerUnitPrice(String account, Date now) {
        OrderInfoConditionDto dto = new OrderInfoConditionDto();
        String nowStr = DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = DateUtils.parseDate((String)(nowStr + " 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            endTime = DateUtils.parseDate((String)(nowStr + " 23:59:59"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        }
        catch (ParseException e2) {
            return BigDecimal.ZERO;
        }
        dto.setCreateAccount(account);
        dto.setOrderType(Integer.valueOf(2));
        dto.setCreateTimeStart(startTime);
        dto.setCreateTimeEnd(endTime);
        Page orderInfoVoPage = this.orderInfoVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE), dto);
        if (orderInfoVoPage == null || CollectionUtils.isEmpty((Collection)orderInfoVoPage.getContent())) {
            return BigDecimal.ZERO;
        }
        List finalOrderInfoVos = orderInfoVoPage.getContent().stream().filter(e -> e.getOrderStatus() != 5).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(finalOrderInfoVos)) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalAmount = finalOrderInfoVos.stream().map(OrderInfoVo::getOrderTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        int customerNums = finalOrderInfoVos.stream().map(OrderInfoVo::getCustomerCode).collect(Collectors.toSet()).size();
        return totalAmount.divide(new BigDecimal(String.valueOf(customerNums)), 2, RoundingMode.HALF_UP);
    }

    private BigInteger countCurdateCustomerPlacingOrdersNum(String account, Date now) {
        OrderInfoConditionDto dto = new OrderInfoConditionDto();
        String nowStr = DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = DateUtils.parseDate((String)(nowStr + " 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            endTime = DateUtils.parseDate((String)(nowStr + " 23:59:59"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        }
        catch (ParseException e2) {
            return BigInteger.ZERO;
        }
        dto.setCreateAccount(account);
        dto.setOrderType(Integer.valueOf(2));
        dto.setCreateTimeStart(startTime);
        dto.setCreateTimeEnd(endTime);
        Page orderInfoVoPage = this.orderInfoVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE), dto);
        if (orderInfoVoPage == null || CollectionUtils.isEmpty((Collection)orderInfoVoPage.getContent())) {
            return BigInteger.ZERO;
        }
        List finalOrderInfoVos = orderInfoVoPage.getContent().stream().filter(e -> e.getOrderStatus() != 5).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(finalOrderInfoVos)) {
            return BigInteger.ZERO;
        }
        return BigInteger.valueOf(finalOrderInfoVos.stream().map(OrderInfoVo::getCustomerCode).collect(Collectors.toSet()).size());
    }

    private BigInteger countCurdateTotalReceiptNum(String account, Date now) {
        return this.receiptInfoService.countTotalReceiptNumByAccountAndReceiptTime(account, now);
    }

    private BigDecimal sumCurdateTotalPaymentAmount(String account, Date now) {
        return this.defrayInfoService.sumTotalDefrayAmountByAccountAndDefrayTime(account, now);
    }

    private BigInteger countCurdateTotalPaymentNum(String account, Date now) {
        return this.defrayInfoService.countTotalDefrayNumByAccountAndDefrayTime(account, now);
    }

    @Override
    public CurdateStatisticsVo sumAndCountVehicleSalesToday() {
        String account = SecurityUtils.getUserAccount();
        Date now = new Date();
        CurdateStatisticsVo result = new CurdateStatisticsVo();
        String nowStr = DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = DateUtils.parseDate((String)(nowStr + " 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            endTime = DateUtils.parseDate((String)(nowStr + " 23:59:59"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        }
        catch (ParseException e) {
            return result;
        }
        result.setVehicleOrderTotalAmount(this.sumCurdateOrderTotalAmount(account, startTime, endTime).setScale(2, 4));
        result.setVehicleOrderTotalNum(this.countCurdateVehicleOrderTotalNum(account, startTime, endTime));
        result.setReceiptTotalAmount(this.sumCurdateTotalReceipt(account, now).setScale(2, 4));
        result.setCustomerUnitPrice(this.calcCurdateCustomerUnitPrice(account, now).setScale(2, 4));
        return result;
    }

    @Override
    public IncomeExpenditureDetailsVo incomeExpenditureDetailsToday() {
        String account = SecurityUtils.getUserAccount();
        Date now = new Date();
        IncomeExpenditureDetailsVo result = new IncomeExpenditureDetailsVo();
        String nowStr = DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = DateUtils.parseDate((String)(nowStr + " 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            endTime = DateUtils.parseDate((String)(nowStr + " 23:59:59"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        }
        catch (ParseException e) {
            return result;
        }
        result.setCustomerNum(this.countCurdateCustomerPlacingOrdersNum(account, now));
        result.setOrderTotalAmount(this.sumCurdateOrderTotalAmount(account, startTime, endTime));
        result.setOrderTotalNum(this.countCurdateVehicleOrderTotalNum(account, startTime, endTime));
        result.setPaymentAmount(this.sumCurdateTotalPaymentAmount(account, now));
        result.setPaymentNum(this.countCurdateTotalPaymentNum(account, now));
        result.setReceiptAmount(this.sumCurdateTotalReceipt(account, now));
        result.setReceiptNum(this.countCurdateTotalReceiptNum(account, now));
        return result;
    }

    @Override
    public Page<ProductVo> findAllowAndExistVehicleProductsByConditions(AllowAndExistVehicleProductDto dto, Pageable pageable) {
        List vehicleProductStocks;
        if (dto == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getCustomerCode(), dto.getVehicleCode()})) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (CollectionUtils.isEmpty((Collection)(vehicleProductStocks = this.vehicleProductStockService.findEffectiveVehicleSaleStockByVehicleCode(dto.getVehicleCode())))) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getProductCode())) {
            vehicleProductStocks = vehicleProductStocks.stream().filter(o -> o.getProductCode().equals(dto.getProductCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getProductName())) {
            vehicleProductStocks = vehicleProductStocks.stream().filter(o -> StringUtils.containsAny((CharSequence)o.getProductName(), (CharSequence)dto.getProductName())).collect(Collectors.toList());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getBrandCode())) {
            vehicleProductStocks = vehicleProductStocks.stream().filter(o -> o.getBrandCode().equals(dto.getBrandCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getCategoryCode())) {
            vehicleProductStocks = vehicleProductStocks.stream().filter(o -> o.getCategoryCode().equals(dto.getCategoryCode())).collect(Collectors.toList());
        }
        Set allowSpecs = dto.getGift() != null && dto.getGift() == false ? this.customerBuyableProductService.findSpecificationsByCustomerCode(dto.getCustomerCode()) : Sets.newHashSet();
        List effectiveProducts = null;
        effectiveProducts = !CollectionUtils.isEmpty((Collection)allowSpecs) ? vehicleProductStocks.stream().filter(e -> allowSpecs.contains(e.getProductSpecificationCode())).collect(Collectors.toList()) : vehicleProductStocks;
        InvokeParams conditions = new InvokeParams();
        List productSpecificationCodeList = effectiveProducts.stream().map(VehicleProductStock::getProductSpecificationCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(productSpecificationCodeList)) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        String productSpecificationCodes = StringUtils.join(productSpecificationCodeList, (String)",");
        conditions.putInvokeParam("tenantCode", (Object)TenantUtils.getTenantCode());
        conditions.putInvokeParam("productCodeList", (Object)productSpecificationCodes);
        Page byConditions = this.productVoService.findByConditions(pageable, conditions);
        Map<Object, Object> stockMap = new HashMap();
        if (!CollectionUtils.isEmpty(vehicleProductStocks)) {
            stockMap = vehicleProductStocks.stream().collect(Collectors.toMap(VehicleProductStock::getProductSpecificationCode, Function.identity()));
        }
        for (ProductVo vo : byConditions) {
            Set sortedSpecVos = vo.getProductSpecifications().stream().sorted(Comparator.comparing(ProductSpecificationVo::getProductSpecificationName)).collect(Collectors.toCollection(LinkedHashSet::new));
            for (ProductSpecificationVo sortedSpecVo : sortedSpecVos) {
                if (!stockMap.containsKey(sortedSpecVo.getProductSpecificationCode())) continue;
                sortedSpecVo.setUsableInventory(((VehicleProductStock)stockMap.get(sortedSpecVo.getProductSpecificationCode())).getUsableInventory());
            }
            BigDecimal usableInventory = sortedSpecVos.stream().map(ProductSpecificationVo::getUsableInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setProductSpecifications(sortedSpecVos);
            vo.setUsableInventory(usableInventory);
        }
        return byConditions;
    }

    @Override
    @LabelPreferentialItems(value="#dto.customerCode")
    public Page<ProductVo> findAllowProductsByConditions(AllowAndExistVehicleProductDto dto, Pageable pageable) {
        if (dto == null || StringUtils.isBlank((CharSequence)dto.getCustomerCode())) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        InvokeParams conditions = new InvokeParams();
        if (dto.getGift() == null) {
            dto.setGift(false);
        }
        if (dto.getGift() != null && !dto.getGift().booleanValue()) {
            Set allowSpecs = this.customerBuyableProductService.findSpecificationsByCustomerCode(dto.getCustomerCode());
            if (CollectionUtils.isEmpty((Collection)allowSpecs)) {
                return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
            }
            String productSpecificationCodes = StringUtils.join((Iterable)allowSpecs, (String)",");
            conditions.putInvokeParam("productCodeList", (Object)productSpecificationCodes);
        }
        conditions.putInvokeParam("tenantCode", (Object)TenantUtils.getTenantCode());
        conditions.putInvokeParam("productCode", (Object)dto.getProductCode());
        conditions.putInvokeParam("categoryCode", (Object)dto.getCategoryCode());
        conditions.putInvokeParam("brandCode", (Object)dto.getBrandCode());
        conditions.putInvokeParam("customerCode", (Object)dto.getCustomerCode());
        Page byConditions = this.productVoService.findByConditions(pageable, conditions);
        for (ProductVo vo : byConditions) {
            Set sortedSpecVos = vo.getProductSpecifications().stream().sorted(Comparator.comparing(ProductSpecificationVo::getProductSpecificationName)).collect(Collectors.toCollection(LinkedHashSet::new));
            vo.setProductSpecifications(sortedSpecVos);
        }
        return byConditions;
    }

    @Override
    public List<ProductSpecificationVo> findBySpecificationCodes(List<String> specificationCodes, String vehicleCode) {
        if (CollectionUtils.isEmpty(specificationCodes) || StringUtils.isEmpty((CharSequence)vehicleCode)) {
            return Lists.newArrayList();
        }
        List productSpecificationVoList = this.productSpecificationVoService.findBySpecificationCodeList(specificationCodes);
        if (!CollectionUtils.isEmpty((Collection)productSpecificationVoList)) {
            List productSpecificationCodes = productSpecificationVoList.stream().map(ProductSpecificationVo::getProductSpecificationCode).collect(Collectors.toList());
            List vehicleProductStockList = this.vehicleProductStockService.findByVehicleCodeAndProductTypeAndProductSpecificationCodes(vehicleCode, VehicleProductTypeEnum.VEHICLE_SALES.getType(), productSpecificationCodes);
            Map<Object, Object> map = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)vehicleProductStockList)) {
                map = vehicleProductStockList.stream().collect(Collectors.toMap(VehicleProductStock::getProductSpecificationCode, Function.identity()));
            }
            for (ProductSpecificationVo productSpecificationVo : productSpecificationVoList) {
                if (map.containsKey(productSpecificationVo.getProductSpecificationCode())) {
                    productSpecificationVo.setUsableInventory(((VehicleProductStock)map.get(productSpecificationVo.getProductSpecificationCode())).getUsableInventory());
                    continue;
                }
                productSpecificationVo.setUsableInventory(BigDecimal.ZERO);
            }
        }
        return productSpecificationVoList;
    }

    @Override
    public ProductSpecificationVo findByBarCode(String barCode, String customerCode, String vehicleCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{barCode, customerCode, vehicleCode})) {
            return null;
        }
        ProductSpecificationVo productSpecificationVo = this.productSpecificationVoService.findByBarCode(barCode, customerCode);
        if (null == productSpecificationVo) {
            return null;
        }
        VehicleProductStock vehicleProductStock = this.vehicleProductStockService.findByVehicleCodeAndProductTypeAndProductSpecificationCode(vehicleCode, VehicleProductTypeEnum.VEHICLE_SALES.getType(), productSpecificationVo.getProductSpecificationCode());
        if (null != vehicleProductStock) {
            productSpecificationVo.setUsableInventory(vehicleProductStock.getUsableInventory());
        }
        return productSpecificationVo;
    }
}

