/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleSalesProduct;
import com.bizunited.empower.business.sales.repository.vehicle.VehicleSalesProductRepository;
import com.bizunited.empower.business.sales.service.vehicle.VehicleSalesProductService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="VehicleSalesProductServiceImpl")
public class VehicleSalesProductServiceImpl
implements VehicleSalesProductService {
    @Autowired
    private VehicleSalesProductRepository vehicleSalesProductRepository;

    @Override
    @Transactional
    public VehicleSalesProduct create(VehicleSalesProduct vehicleSalesProduct) {
        VehicleSalesProduct current = this.createForm(vehicleSalesProduct);
        return current;
    }

    @Override
    @Transactional
    public VehicleSalesProduct createForm(VehicleSalesProduct vehicleSalesProduct) {
        Date now = new Date();
        vehicleSalesProduct.setCreateAccount(SecurityUtils.getUserAccount());
        vehicleSalesProduct.setCreateTime(now);
        vehicleSalesProduct.setModifyAccount(SecurityUtils.getUserAccount());
        vehicleSalesProduct.setModifyTime(now);
        vehicleSalesProduct.setTenantCode(TenantUtils.getTenantCode());
        this.createValidation(vehicleSalesProduct);
        this.vehicleSalesProductRepository.save((Object)vehicleSalesProduct);
        return vehicleSalesProduct;
    }

    private void createValidation(VehicleSalesProduct vehicleSalesProduct) {
        Validate.notNull((Object)((Object)vehicleSalesProduct), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)vehicleSalesProduct.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        vehicleSalesProduct.setId(null);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getVehicleTaskCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getVehicleCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getProductCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getProductName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getRelativePath(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getFileName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getProductSpecificationCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getProductSpecificationName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getUnitCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getUnitName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleSalesProduct.getQuantity(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleSalesProduct.getRemainingQuantity(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5269\u4f59\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleSalesProduct.getPurchasePrice(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u8003\u91c7\u8d2d\u4ef7\uff0c\u5343\u4f4d\u6570\u4ee3\u8868.000\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleSalesProduct.getSubtotalAmount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5c0f\u8ba1\u91d1\u989d\uff0c\u5343\u4f4d\u6570\u4ee3\u8868.000\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend1() == null || vehicleSalesProduct.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend2() == null || vehicleSalesProduct.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend3() == null || vehicleSalesProduct.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend4() == null || vehicleSalesProduct.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend5() == null || vehicleSalesProduct.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend6() == null || vehicleSalesProduct.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend7() == null || vehicleSalesProduct.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getTenantCode() == null || vehicleSalesProduct.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getVehicleTaskCode() == null || vehicleSalesProduct.getVehicleTaskCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getVehicleCode() == null || vehicleSalesProduct.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getProductCode() == null || vehicleSalesProduct.getProductCode().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getProductName() == null || vehicleSalesProduct.getProductName().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getRelativePath() == null || vehicleSalesProduct.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getFileName() == null || vehicleSalesProduct.getFileName().length() < 255 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getProductSpecificationCode() == null || vehicleSalesProduct.getProductSpecificationCode().length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getProductSpecificationName() == null || vehicleSalesProduct.getProductSpecificationName().length() < 128 ? 1 : 0) != 0, (String)"\u89c4\u683c\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getUnitCode() == null || vehicleSalesProduct.getUnitCode().length() < 64 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getUnitName() == null || vehicleSalesProduct.getUnitName().length() < 128 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getBarCode() == null || vehicleSalesProduct.getBarCode().length() < 255 ? 1 : 0) != 0, (String)"\u6761\u5f62\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public VehicleSalesProduct update(VehicleSalesProduct vehicleSalesProduct) {
        VehicleSalesProduct current = this.updateForm(vehicleSalesProduct);
        return current;
    }

    @Override
    @Transactional
    public VehicleSalesProduct updateForm(VehicleSalesProduct vehicleSalesProduct) {
        this.updateValidation(vehicleSalesProduct);
        String currentId = vehicleSalesProduct.getId();
        Optional op_currentVehicleSalesProduct = this.vehicleSalesProductRepository.findById(currentId);
        VehicleSalesProduct currentVehicleSalesProduct = op_currentVehicleSalesProduct.orElse(null);
        currentVehicleSalesProduct = (VehicleSalesProduct)((Object)Validate.notNull((Object)((Object)currentVehicleSalesProduct), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        Date now = new Date();
        currentVehicleSalesProduct.setModifyAccount(SecurityUtils.getUserAccount());
        currentVehicleSalesProduct.setModifyTime(now);
        currentVehicleSalesProduct.setExtend1(vehicleSalesProduct.getExtend1());
        currentVehicleSalesProduct.setExtend2(vehicleSalesProduct.getExtend2());
        currentVehicleSalesProduct.setExtend3(vehicleSalesProduct.getExtend3());
        currentVehicleSalesProduct.setExtend4(vehicleSalesProduct.getExtend4());
        currentVehicleSalesProduct.setExtend5(vehicleSalesProduct.getExtend5());
        currentVehicleSalesProduct.setExtend6(vehicleSalesProduct.getExtend6());
        currentVehicleSalesProduct.setExtend7(vehicleSalesProduct.getExtend7());
        currentVehicleSalesProduct.setExtend8(vehicleSalesProduct.getExtend8());
        currentVehicleSalesProduct.setExtend9(vehicleSalesProduct.getExtend9());
        currentVehicleSalesProduct.setExtend10(vehicleSalesProduct.getExtend10());
        currentVehicleSalesProduct.setExtend11(vehicleSalesProduct.getExtend11());
        currentVehicleSalesProduct.setTenantCode(vehicleSalesProduct.getTenantCode());
        currentVehicleSalesProduct.setVehicleTaskCode(vehicleSalesProduct.getVehicleTaskCode());
        currentVehicleSalesProduct.setTransferOrderCode(vehicleSalesProduct.getTransferOrderCode());
        currentVehicleSalesProduct.setVehicleCode(vehicleSalesProduct.getVehicleCode());
        currentVehicleSalesProduct.setProductCode(vehicleSalesProduct.getProductCode());
        currentVehicleSalesProduct.setProductName(vehicleSalesProduct.getProductName());
        currentVehicleSalesProduct.setRelativePath(vehicleSalesProduct.getRelativePath());
        currentVehicleSalesProduct.setFileName(vehicleSalesProduct.getFileName());
        currentVehicleSalesProduct.setProductSpecificationCode(vehicleSalesProduct.getProductSpecificationCode());
        currentVehicleSalesProduct.setProductSpecificationName(vehicleSalesProduct.getProductSpecificationName());
        currentVehicleSalesProduct.setUnitCode(vehicleSalesProduct.getUnitCode());
        currentVehicleSalesProduct.setUnitName(vehicleSalesProduct.getUnitName());
        currentVehicleSalesProduct.setBarCode(vehicleSalesProduct.getBarCode());
        currentVehicleSalesProduct.setQuantity(vehicleSalesProduct.getQuantity());
        currentVehicleSalesProduct.setRemainingQuantity(vehicleSalesProduct.getRemainingQuantity());
        currentVehicleSalesProduct.setPurchasePrice(vehicleSalesProduct.getPurchasePrice());
        currentVehicleSalesProduct.setSubtotalAmount(vehicleSalesProduct.getSubtotalAmount());
        this.vehicleSalesProductRepository.saveAndFlush((Object)currentVehicleSalesProduct);
        return currentVehicleSalesProduct;
    }

    private void updateValidation(VehicleSalesProduct vehicleSalesProduct) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)vehicleSalesProduct.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getVehicleTaskCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getVehicleCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getProductCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getProductName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getRelativePath(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getFileName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getProductSpecificationCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getProductSpecificationName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getUnitCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleSalesProduct.getUnitName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleSalesProduct.getQuantity(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleSalesProduct.getRemainingQuantity(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5269\u4f59\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleSalesProduct.getPurchasePrice(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u8003\u91c7\u8d2d\u4ef7\uff0c\u5343\u4f4d\u6570\u4ee3\u8868.000\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleSalesProduct.getSubtotalAmount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5c0f\u8ba1\u91d1\u989d\uff0c\u5343\u4f4d\u6570\u4ee3\u8868.000\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend1() == null || vehicleSalesProduct.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend2() == null || vehicleSalesProduct.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend3() == null || vehicleSalesProduct.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend4() == null || vehicleSalesProduct.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend5() == null || vehicleSalesProduct.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend6() == null || vehicleSalesProduct.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getExtend7() == null || vehicleSalesProduct.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getTenantCode() == null || vehicleSalesProduct.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getVehicleTaskCode() == null || vehicleSalesProduct.getVehicleTaskCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getVehicleCode() == null || vehicleSalesProduct.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getProductCode() == null || vehicleSalesProduct.getProductCode().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getProductName() == null || vehicleSalesProduct.getProductName().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getRelativePath() == null || vehicleSalesProduct.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getFileName() == null || vehicleSalesProduct.getFileName().length() < 255 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getProductSpecificationCode() == null || vehicleSalesProduct.getProductSpecificationCode().length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getProductSpecificationName() == null || vehicleSalesProduct.getProductSpecificationName().length() < 128 ? 1 : 0) != 0, (String)"\u89c4\u683c\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getUnitCode() == null || vehicleSalesProduct.getUnitCode().length() < 64 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getUnitName() == null || vehicleSalesProduct.getUnitName().length() < 128 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleSalesProduct.getBarCode() == null || vehicleSalesProduct.getBarCode().length() < 255 ? 1 : 0) != 0, (String)"\u6761\u5f62\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public VehicleSalesProduct findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.vehicleSalesProductRepository.findDetailsById(id);
    }

    @Override
    public VehicleSalesProduct findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.vehicleSalesProductRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        VehicleSalesProduct current = this.findById(id);
        if (current != null) {
            this.vehicleSalesProductRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void batchSave(List<VehicleSalesProduct> vehicleSalesProducts) {
        Validate.notEmpty(vehicleSalesProducts, (String)"\u8fdb\u884c\u4fdd\u5b58\u8f66\u8f86\u4e0e\u4e1a\u52a1\u5458\u5173\u8054\u4fe1\u606f\u65f6\uff0c\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        for (VehicleSalesProduct vehicleSalesProduct : vehicleSalesProducts) {
            this.create(vehicleSalesProduct);
        }
    }

    @Override
    @Transactional
    public void deleteByVehicleTaskCode(String vehicleTaskCode) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u8fdb\u884c\u5220\u9664\u5173\u8054\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)TenantUtils.getTenantCode(), (String)"\u8fdb\u884c\u5220\u9664\u5173\u8054\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.vehicleSalesProductRepository.deleteByVehicleTaskCodeAndTenantCode(vehicleTaskCode, TenantUtils.getTenantCode());
    }

    @Override
    public List<VehicleSalesProduct> findByVehicleTaskCode(String vehicleTaskCode) {
        if (StringUtils.isEmpty((CharSequence)vehicleTaskCode)) {
            return Lists.newArrayList();
        }
        return this.vehicleSalesProductRepository.findByVehicleTaskCode(vehicleTaskCode, TenantUtils.getTenantCode());
    }

    @Override
    public void updateTransferOrderCodeByVehicleTaskCode(String vehicleTaskCode, String transferOrderCode) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)transferOrderCode, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\u65f6\uff0c\u8c03\u62e8\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)TenantUtils.getTenantCode(), (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.vehicleSalesProductRepository.updateTransferOrderCodeByVehicleTaskCode(transferOrderCode, vehicleTaskCode, TenantUtils.getTenantCode());
    }

    @Override
    public void updateRemainingQuantityByVehicleTaskCode(String vehicleTaskCode, String productSpecificationCode, BigDecimal quantity) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productSpecificationCode, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\u65f6\uff0c\u8c03\u62e8\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)quantity, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u8d4b\u503c\u8c03\u62e8\u5355\u7f16\u53f7\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        VehicleSalesProduct vehicleSalesProduct = this.vehicleSalesProductRepository.findByVehicleTaskCodeAndProductSpecificationCode(vehicleTaskCode, productSpecificationCode, TenantUtils.getTenantCode());
        BigDecimal remainingQuantity = vehicleSalesProduct.getRemainingQuantity().subtract(quantity);
        vehicleSalesProduct.setRemainingQuantity(remainingQuantity);
        this.vehicleSalesProductRepository.save((Object)vehicleSalesProduct);
    }
}

