/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.distribution.enums.DeliverStatus;
import com.bizunited.empower.business.distribution.service.DeliverGoodService;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.distribution.vo.DeliverGoodVo;
import com.bizunited.empower.business.distribution.vo.DeliverProductVo;
import com.bizunited.empower.business.distribution.vo.DeliverUpdateVo;
import com.bizunited.empower.business.product.entity.ProductBarCodeInfo;
import com.bizunited.empower.business.product.optimize.service.ProductFlatService;
import com.bizunited.empower.business.product.optimize.vo.ProductFlatVo;
import com.bizunited.empower.business.product.optimize.vo.ProductSpecificationFlatVo;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleSaleMan;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTaskExpenseMapping;
import com.bizunited.empower.business.sales.enums.vehicle.DistributionStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskStatusEnum;
import com.bizunited.empower.business.sales.repository.vehicle.VehicleTaskExpenseMappingRepository;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskExpenseMappingService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.tenant.utils.DealerTenantUtils;
import com.bizunited.empower.business.vehicle.entity.VehicleUnload;
import com.bizunited.empower.business.vehicle.entity.VehicleUnloadProduct;
import com.bizunited.empower.business.vehicle.enums.VehicleProductTypeEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleUnloadStatusEnum;
import com.bizunited.empower.business.vehicle.service.VehicleProductStockService;
import com.bizunited.empower.business.vehicle.service.VehicleUnloadService;
import com.bizunited.empower.business.warehouse.common.enums.WarehouseProductsExpenseType;
import com.bizunited.empower.business.warehouse.dto.WarehouseProductsExpenseDto;
import com.bizunited.empower.business.warehouse.dto.WarehouseProductsExpenseProductDto;
import com.bizunited.empower.business.warehouse.entity.WarehouseProduct;
import com.bizunited.empower.business.warehouse.service.WarehouseActionService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsExpenseVoService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="VehicleTaskExpenseMappingServiceImpl")
public class VehicleTaskExpenseMappingServiceImpl
implements VehicleTaskExpenseMappingService {
    @Autowired
    private VehicleTaskExpenseMappingRepository vehicleTaskExpenseMappingRepository;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private DeliverGoodService deliverGoodService;
    @Autowired
    private DeliverGoodVoService deliverGoodVoService;
    @Autowired
    private VehicleUnloadService vehicleUnloadService;
    @Autowired
    private VehicleTaskService vehicleTaskService;
    @Autowired
    private ProductFlatService productFlatService;
    @Autowired
    private VehicleProductStockService vehicleProductStockService;
    @Autowired
    private WarehouseProductService warehouseProductService;
    @Autowired
    private WarehouseActionService warehouseActionService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private WarehouseProductsExpenseVoService warehouseProductsExpenseVoService;

    @Override
    @Transactional
    public VehicleTaskExpenseMapping create(VehicleTaskExpenseMapping vehicleTaskExpenseMapping) {
        VehicleTaskExpenseMapping current = this.createForm(vehicleTaskExpenseMapping);
        return current;
    }

    @Override
    @Transactional
    public VehicleTaskExpenseMapping createForm(VehicleTaskExpenseMapping vehicleTaskExpenseMapping) {
        if (StringUtils.isEmpty((CharSequence)vehicleTaskExpenseMapping.getTenantCode())) {
            vehicleTaskExpenseMapping.setCreateAccount(SecurityUtils.getUserAccount());
            vehicleTaskExpenseMapping.setModifyAccount(SecurityUtils.getUserAccount());
            vehicleTaskExpenseMapping.setTenantCode(TenantUtils.getTenantCode());
        }
        Date now = new Date();
        vehicleTaskExpenseMapping.setCreateTime(now);
        vehicleTaskExpenseMapping.setModifyTime(now);
        vehicleTaskExpenseMapping.setDistributionTaskCode(this.generateCode(vehicleTaskExpenseMapping.getTenantCode()));
        this.createValidation(vehicleTaskExpenseMapping);
        this.vehicleTaskExpenseMappingRepository.save((Object)vehicleTaskExpenseMapping);
        return vehicleTaskExpenseMapping;
    }

    private void createValidation(VehicleTaskExpenseMapping vehicleTaskExpenseMapping) {
        Validate.notNull((Object)((Object)vehicleTaskExpenseMapping), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)vehicleTaskExpenseMapping.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        vehicleTaskExpenseMapping.setId(null);
        Validate.notBlank((CharSequence)vehicleTaskExpenseMapping.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTaskExpenseMapping.getVehicleTaskCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTaskExpenseMapping.getExpenseCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleTaskExpenseMapping.getTenantCode() == null || vehicleTaskExpenseMapping.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTaskExpenseMapping.getVehicleTaskCode() == null || vehicleTaskExpenseMapping.getVehicleTaskCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTaskExpenseMapping.getExpenseCode() == null || vehicleTaskExpenseMapping.getExpenseCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u5e93\u5355\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public VehicleTaskExpenseMapping update(VehicleTaskExpenseMapping vehicleTaskExpenseMapping) {
        VehicleTaskExpenseMapping current = this.updateForm(vehicleTaskExpenseMapping);
        return current;
    }

    @Override
    @Transactional
    public VehicleTaskExpenseMapping updateForm(VehicleTaskExpenseMapping vehicleTaskExpenseMapping) {
        this.updateValidation(vehicleTaskExpenseMapping);
        String currentId = vehicleTaskExpenseMapping.getId();
        Optional op_currentVehicleTaskExpenseMapping = this.vehicleTaskExpenseMappingRepository.findById(currentId);
        VehicleTaskExpenseMapping currentVehicleTaskExpenseMapping = op_currentVehicleTaskExpenseMapping.orElse(null);
        currentVehicleTaskExpenseMapping = (VehicleTaskExpenseMapping)((Object)Validate.notNull((Object)((Object)currentVehicleTaskExpenseMapping), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentVehicleTaskExpenseMapping.setTenantCode(vehicleTaskExpenseMapping.getTenantCode());
        currentVehicleTaskExpenseMapping.setVehicleTaskCode(vehicleTaskExpenseMapping.getVehicleTaskCode());
        currentVehicleTaskExpenseMapping.setExpenseCode(vehicleTaskExpenseMapping.getExpenseCode());
        this.vehicleTaskExpenseMappingRepository.saveAndFlush((Object)currentVehicleTaskExpenseMapping);
        return currentVehicleTaskExpenseMapping;
    }

    private void updateValidation(VehicleTaskExpenseMapping vehicleTaskExpenseMapping) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)vehicleTaskExpenseMapping.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTaskExpenseMapping.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTaskExpenseMapping.getVehicleTaskCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTaskExpenseMapping.getExpenseCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleTaskExpenseMapping.getTenantCode() == null || vehicleTaskExpenseMapping.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTaskExpenseMapping.getVehicleTaskCode() == null || vehicleTaskExpenseMapping.getVehicleTaskCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTaskExpenseMapping.getExpenseCode() == null || vehicleTaskExpenseMapping.getExpenseCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u5e93\u5355\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format("distribution:task:code:index:%s", tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{"PS", format.format(new Date()), index});
    }

    @Override
    public VehicleTaskExpenseMapping findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.vehicleTaskExpenseMappingRepository.findDetailsById(id);
    }

    @Override
    public VehicleTaskExpenseMapping findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.vehicleTaskExpenseMappingRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        VehicleTaskExpenseMapping current = this.findById(id);
        if (current != null) {
            this.vehicleTaskExpenseMappingRepository.delete((Object)current);
        }
    }

    @Override
    public List<VehicleTaskExpenseMapping> findByVehicleTaskCode(String vehicleTaskCode) {
        if (StringUtils.isEmpty((CharSequence)vehicleTaskCode)) {
            return Lists.newArrayList();
        }
        return this.vehicleTaskExpenseMappingRepository.findByVehicleTaskCodeAndTenantCode(vehicleTaskCode, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void deleteByVehicleTaskCode(String vehicleTaskCode) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u8fdb\u884c\u5220\u9664\u5173\u8054\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        List<VehicleTaskExpenseMapping> vehicleTaskExpenseMappings = this.vehicleTaskExpenseMappingRepository.findByVehicleTaskCodeAndTenantCode(vehicleTaskCode, TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(vehicleTaskExpenseMappings)) {
            List deliverGoodCodes = vehicleTaskExpenseMappings.stream().map(VehicleTaskExpenseMapping::getDeliverGoodCode).collect(Collectors.toList());
            DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
            deliverUpdateVo.setDeliverGoodCodes(deliverGoodCodes);
            deliverUpdateVo.setPlan(Boolean.valueOf(false));
            deliverUpdateVo.setTenantCode(TenantUtils.getTenantCode());
            deliverUpdateVo.setNoticeVehicleTask(Boolean.valueOf(false));
            this.deliverGoodService.batchUpdatePlanByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
            this.vehicleTaskExpenseMappingRepository.deleteByVehicleTaskCodeAndTenantCode(vehicleTaskCode, TenantUtils.getTenantCode());
        }
    }

    @Override
    @Transactional
    public void batchSave(List<VehicleTaskExpenseMapping> vehicleTaskExpenses) {
        Validate.notEmpty(vehicleTaskExpenses, (String)"\u8fdb\u884c\u4fdd\u5b58\u51fa\u8f66\u4efb\u52a1\u4e0e\u53d1\u8d27\u5355\u5173\u8054\u4fe1\u606f\u65f6\uff0c\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Set deliverGoodCodeSet = vehicleTaskExpenses.stream().map(VehicleTaskExpenseMapping::getDeliverGoodCode).collect(Collectors.toSet());
        Validate.isTrue((deliverGoodCodeSet.size() == vehicleTaskExpenses.size() ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u5173\u8054\u7684\u53d1\u8d27\u5355\u6709\u91cd\u590d\u6570\u636e", (Object[])new Object[0]);
        ArrayList deliverGoodCodeList = Lists.newArrayList(deliverGoodCodeSet);
        List<VehicleTaskExpenseMapping> expenseMappingList = this.vehicleTaskExpenseMappingRepository.findByDeliverGoodCodesAndTenantCode(deliverGoodCodeList, TenantUtils.getTenantCode(), VehicleTaskStatusEnum.CANCEL.getType());
        expenseMappingList = expenseMappingList.stream().filter(item -> !DistributionStatusEnum.CANCEL.getType().equals(item.getDistributionStatus())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(expenseMappingList)) {
            StringBuffer s = new StringBuffer("\u51fa\u8f66\u4efb\u52a1\u6dfb\u52a0\u53d1\u8d27\u5355\u65f6,");
            for (VehicleTaskExpenseMapping vehicleTaskExpenseMapping : expenseMappingList) {
                s.append("(\u53d1\u8d27\u5355" + vehicleTaskExpenseMapping.getDistributionTaskCode() + "\u5df2\u5b58\u5728\u4e8e\u51fa\u8f66\u4efb\u52a1").append(vehicleTaskExpenseMapping.getVehicleTaskCode()).append("\u4e2d)");
            }
            throw new IllegalArgumentException(s.toString());
        }
        for (VehicleTaskExpenseMapping vehicleTaskExpenseMapping : vehicleTaskExpenses) {
            this.create(vehicleTaskExpenseMapping);
        }
    }

    @Override
    public List<VehicleTaskExpenseMapping> findByDeliverGoodCodes(List<String> expenseCodeList) {
        if (CollectionUtils.isEmpty(expenseCodeList)) {
            return Lists.newArrayList();
        }
        return this.vehicleTaskExpenseMappingRepository.findByDeliverGoodCodesAndTenantCode(expenseCodeList, TenantUtils.getTenantCode(), VehicleTaskStatusEnum.CANCEL.getType());
    }

    @Override
    @Transactional
    public void delayed(String distributionTaskCode) {
        Validate.notEmpty((CharSequence)distributionTaskCode, (String)"\u5ef6\u8fdf\u914d\u9001\u65f6,\u4f20\u5165\u7684\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTaskExpenseMapping vehicleTaskExpense = this.vehicleTaskExpenseMappingRepository.findByDistributionTaskCodeAndTenantCode(distributionTaskCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTaskExpense), (String)"\u5ef6\u8fdf\u914d\u9001\u65f6,\u672a\u67e5\u8be2\u5230\u914d\u9001\u4efb\u52a1\u5173\u8054\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)DistributionStatusEnum.WAIT_DISTRIBUTION.getType().equals(vehicleTaskExpense.getDistributionStatus()), (String)"\u5ef6\u8fdf\u914d\u9001\u65f6\uff0c\u914d\u9001\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u914d\u9001", (Object[])new Object[0]);
        DeliverGoodVo deliverGoodVo = this.deliverGoodVoService.findByDeliverGoodCode(vehicleTaskExpense.getDeliverGoodCode());
        Validate.isTrue((boolean)DeliverStatus.ALREADY_DELIVER.getType().equals(deliverGoodVo.getDeliverStatus()), (String)"\u5ef6\u8fdf\u914d\u9001\u65f6\uff0c\u914d\u9001\u4efb\u52a1\u72b6\u4e0b\u7684\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u6536\u8d27", (Object[])new Object[0]);
        vehicleTaskExpense.setDistributionStatus(DistributionStatusEnum.DELAY_DISTRIBUTION.getType());
        this.vehicleTaskExpenseMappingRepository.save((Object)vehicleTaskExpense);
    }

    @Override
    @Transactional
    public void againDistribution(String distributionTaskCode) {
        Validate.notEmpty((CharSequence)distributionTaskCode, (String)"\u91cd\u65b0\u914d\u9001\u65f6,\u4f20\u5165\u7684\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTaskExpenseMapping vehicleTaskExpense = this.vehicleTaskExpenseMappingRepository.findByDistributionTaskCodeAndTenantCode(distributionTaskCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTaskExpense), (String)"\u91cd\u65b0\u914d\u9001\u65f6,\u672a\u67e5\u8be2\u5230\u914d\u9001\u4efb\u52a1\u5173\u8054\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)DistributionStatusEnum.DELAY_DISTRIBUTION.getType().equals(vehicleTaskExpense.getDistributionStatus()), (String)"\u91cd\u65b0\u914d\u9001\u65f6\uff0c\u914d\u9001\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u5ef6\u8fdf\u914d\u9001", (Object[])new Object[0]);
        vehicleTaskExpense.setDistributionStatus(DistributionStatusEnum.WAIT_DISTRIBUTION.getType());
        this.vehicleTaskExpenseMappingRepository.save((Object)vehicleTaskExpense);
    }

    @Override
    @Transactional
    public void delivery(String distributionTaskCode) {
        Validate.notEmpty((CharSequence)distributionTaskCode, (String)"\u786e\u8ba4\u9001\u8fbe\u65f6,\u4f20\u5165\u7684\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTaskExpenseMapping vehicleTaskExpense = this.vehicleTaskExpenseMappingRepository.findByDistributionTaskCodeAndTenantCode(distributionTaskCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTaskExpense), (String)"\u786e\u8ba4\u9001\u8fbe\u65f6,\u672a\u67e5\u8be2\u5230\u914d\u9001\u4efb\u52a1\u5173\u8054\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((DistributionStatusEnum.WAIT_DISTRIBUTION.getType().equals(vehicleTaskExpense.getDistributionStatus()) || DistributionStatusEnum.ALREADY_DISTRIBUTION.getType().equals(vehicleTaskExpense.getDistributionStatus()) ? 1 : 0) != 0, (String)"\u786e\u8ba4\u9001\u8fbe\u65f6\uff0c\u914d\u9001\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u914d\u9001", (Object[])new Object[0]);
        vehicleTaskExpense.setDistributionStatus(DistributionStatusEnum.ALREADY_DISTRIBUTION.getType());
        this.vehicleTaskExpenseMappingRepository.save((Object)vehicleTaskExpense);
        DeliverGoodVo deliverGoodVo = this.deliverGoodVoService.findByDeliverGoodCode(vehicleTaskExpense.getDeliverGoodCode());
        Validate.isTrue((DeliverStatus.ALREADY_DELIVER.getType().equals(deliverGoodVo.getDeliverStatus()) || DeliverStatus.ALREADY_RECEIVE.getType().equals(deliverGoodVo.getDeliverStatus()) ? 1 : 0) != 0, (String)"\u786e\u8ba4\u9001\u8fbe\u65f6,\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u6536\u8d27\u6216\u8005\u5df2\u6536\u8d27", (Object[])new Object[0]);
        this.deliverGoodService.updateDeliveryTimeByDeliverGoodCodeAndTenantCode(deliverGoodVo.getDeliverGoodCode(), new Date(), TenantUtils.getTenantCode());
        VehicleTask vehicleTask = this.vehicleTaskService.findByVehicleTaskCode(vehicleTaskExpense.getVehicleTaskCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u751f\u6210\u5378\u8d27\u5355\u65f6\u67e5\u8be2\u5230\u7684\u51fa\u8f66\u4efb\u52a1\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskStatusEnum.VEHICLE_DRIVING.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u751f\u6210\u5378\u8d27\u5355\u65f6,\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u51fa\u8f66\u4e2d", (Object[])new Object[0]);
        VehicleUnload vehicleUnload = this.buildVehicleUnload(vehicleTask, deliverGoodVo);
        vehicleUnload = this.vehicleUnloadService.saveVehicleUnload(vehicleUnload);
        this.vehicleUnloadService.deliveryVehicleUnload(vehicleUnload.getVehicleUnloadCode());
    }

    @Override
    @Transactional
    public void receivingGood(String distributionTaskCode) {
        Validate.notEmpty((CharSequence)distributionTaskCode, (String)"\u5f3a\u5236\u6536\u8d27\u65f6,\u4f20\u5165\u7684\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTaskExpenseMapping vehicleTaskExpense = this.vehicleTaskExpenseMappingRepository.findByDistributionTaskCodeAndTenantCode(distributionTaskCode, TenantUtils.getTenantCode());
        this.receiving(vehicleTaskExpense);
    }

    @Override
    public VehicleTaskExpenseMapping findByDistributionTaskCode(String distributionTaskCode) {
        if (StringUtils.isEmpty((CharSequence)distributionTaskCode)) {
            return null;
        }
        return this.vehicleTaskExpenseMappingRepository.findByDistributionTaskCodeAndTenantCode(distributionTaskCode, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void receivingGoodByDeliverGoodCode(String deliverGoodCode) {
        Validate.notEmpty((CharSequence)deliverGoodCode, (String)"\u5f3a\u5236\u6536\u8d27\u65f6,\u4f20\u5165\u7684\u53d1\u8d27\u5355\u7f16\u53f7\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTaskExpenseMapping vehicleTaskExpense = this.vehicleTaskExpenseMappingRepository.findByDeliverGoodCodeAndTenantCode(deliverGoodCode, TenantUtils.getTenantCode(), VehicleTaskStatusEnum.CANCEL.getType());
        this.receiving(vehicleTaskExpense);
    }

    @Override
    public List<VehicleTaskExpenseMapping> findByVehicleTaskCodeAndTenantCode(String vehicleTaskCode, String tenantCode) {
        if (StringUtils.isEmpty((CharSequence)vehicleTaskCode) || StringUtils.isEmpty((CharSequence)tenantCode)) {
            return Lists.newArrayList();
        }
        return this.vehicleTaskExpenseMappingRepository.findByVehicleTaskCodeAndTenantCode(vehicleTaskCode, tenantCode);
    }

    @Override
    @Transactional
    public void deliverGoodToVehicleSaleByDistributionTaskCode(String distributionTaskCode) {
        Validate.notBlank((CharSequence)distributionTaskCode, (String)"\u6839\u636e\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u5c06\u53d1\u8d27\u5355\u4e2d\u7684\u5546\u54c1\u8f6c\u6362\u4e3a\u8f66\u9500\u5546\u54c1,\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTaskExpenseMapping vehicleTaskExpenseMapping = this.vehicleTaskExpenseMappingRepository.findByDistributionTaskCodeAndTenantCode(distributionTaskCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTaskExpenseMapping), (String)"\u6839\u636e\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u5c06\u53d1\u8d27\u5355\u4e2d\u7684\u5546\u54c1\u8f6c\u6362\u4e3a\u8f66\u9500\u5546\u54c1,\u67e5\u8be2\u5230\u7684\u914d\u9001\u4efb\u52a1\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskService.findByVehicleTaskCode(vehicleTaskExpenseMapping.getVehicleTaskCode());
        Validate.isTrue((null != vehicleTask && VehicleTaskStatusEnum.VEHICLE_DRIVING.getType().equals(vehicleTask.getVehicleTaskStatus()) ? 1 : 0) != 0, (String)"\u6839\u636e\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u5c06\u53d1\u8d27\u5355\u4e2d\u7684\u5546\u54c1\u8f6c\u6362\u4e3a\u8f66\u9500\u5546\u54c1\u65f6,\u51fa\u8f66\u4efb\u52a1\u5fc5\u987b\u4e3a\u51fa\u8f66\u4e2d", (Object[])new Object[0]);
        Validate.isTrue((boolean)DistributionStatusEnum.WAIT_DISTRIBUTION.getType().equals(vehicleTaskExpenseMapping.getDistributionStatus()), (String)"\u6839\u636e\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u5c06\u53d1\u8d27\u5355\u4e2d\u7684\u5546\u54c1\u8f6c\u6362\u4e3a\u8f66\u9500\u5546\u54c1,\u914d\u9001\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u914d\u9001", (Object[])new Object[0]);
        DeliverGoodVo deliverGoodVo = this.deliverGoodVoService.findByDeliverGoodCode(vehicleTaskExpenseMapping.getDeliverGoodCode());
        Validate.notNull((Object)deliverGoodVo, (String)"\u6839\u636e\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u5c06\u53d1\u8d27\u5355\u4e2d\u7684\u5546\u54c1\u8f6c\u6362\u4e3a\u8f66\u9500\u5546\u54c1,\u67e5\u8be2\u5230\u7684\u53d1\u8d27\u5355\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)DeliverStatus.ALREADY_DELIVER.getType().equals(deliverGoodVo.getDeliverStatus()), (String)"\u6839\u636e\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u5c06\u53d1\u8d27\u5355\u4e2d\u7684\u5546\u54c1\u8f6c\u6362\u4e3a\u8f66\u9500\u5546\u54c1,\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u6536\u8d27", (Object[])new Object[0]);
        Set products = deliverGoodVo.getProducts();
        Boolean overflowWarehouseStatus = DealerTenantUtils.getOverflowWarehouseStatus();
        overflowWarehouseStatus = BooleanUtils.toBooleanDefaultIfNull((Boolean)overflowWarehouseStatus, (boolean)true);
        if (overflowWarehouseStatus.booleanValue()) {
            for (DeliverProductVo product : products) {
                WarehouseProduct warehouseProduct = this.warehouseProductService.findByProductSpecificationCodeAndWarehouseCode(product.getProductSpecificationCode(), deliverGoodVo.getWarehouseCode());
                BigDecimal quantity = this.warehouseActionService.conversionUnit(product.getProductSpecificationCode(), product.getUnitCode(), product.getDeliverQuantity());
                Validate.isTrue((null != warehouseProduct && quantity.compareTo(warehouseProduct.getUsableInventory()) != 1 ? 1 : 0) != 0, (String)"\u63d0\u8d27\u4ed3\u5e93\u5185\u5546\u54c1\u53ef\u7528\u914d\u9001\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u53ef\u8f6c\u4e3a\u8f66\u9500\u5e93\u5b58,\u5546\u54c1\u3010%s\u3011 \u5546\u54c1\u89c4\u683c\u7f16\u53f7\u3010%s\u3011", (Object[])new Object[]{product.getProductName(), product.getProductSpecificationCode()});
            }
        }
        WarehouseProductsExpenseDto warehouseProductsExpenseDto = this.buildWarehouseProductsExpenseDto(deliverGoodVo);
        this.warehouseProductsExpenseVoService.createCompleteByWarehouseExpense(warehouseProductsExpenseDto);
        this.updateDeliverGoodStatus(deliverGoodVo);
        for (DeliverProductVo product : deliverGoodVo.getProducts()) {
            this.vehicleProductStockService.transforVehicleProductType(vehicleTask.getVehicleCode(), product.getProductSpecificationCode(), product.getDeliverQuantity(), VehicleProductTypeEnum.DISTRIBUTION.getType(), VehicleProductTypeEnum.VEHICLE_SALES.getType());
        }
        vehicleTaskExpenseMapping.setDistributionStatus(DistributionStatusEnum.CANCEL.getType());
        this.vehicleTaskExpenseMappingRepository.saveAndFlush((Object)vehicleTaskExpenseMapping);
    }

    private WarehouseProductsExpenseDto buildWarehouseProductsExpenseDto(DeliverGoodVo deliverGoodVo) {
        WarehouseProductsExpenseDto warehouseProductsExpenseDto = new WarehouseProductsExpenseDto();
        warehouseProductsExpenseDto.setWarehouseCode(deliverGoodVo.getWarehouseCode());
        warehouseProductsExpenseDto.setType(WarehouseProductsExpenseType.VEHICLE_EXPENSE.getType());
        warehouseProductsExpenseDto.setExpenseDate(new Date());
        warehouseProductsExpenseDto.setAgentUser(SecurityUtils.getUserAccount());
        warehouseProductsExpenseDto.setRemark(deliverGoodVo.getRemark());
        ArrayList expenseProducts = Lists.newArrayList();
        for (DeliverProductVo deliverProductVo : deliverGoodVo.getProducts()) {
            WarehouseProductsExpenseProductDto warehouseProductsExpenseProductDto = (WarehouseProductsExpenseProductDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)deliverProductVo, WarehouseProductsExpenseProductDto.class, HashSet.class, ArrayList.class, new String[0]);
            warehouseProductsExpenseProductDto.setQuantity(deliverProductVo.getDeliverQuantity());
            expenseProducts.add(warehouseProductsExpenseProductDto);
            warehouseProductsExpenseDto.setExpenseProducts((List)expenseProducts);
        }
        return warehouseProductsExpenseDto;
    }

    private void updateDeliverGoodStatus(DeliverGoodVo deliverGoodVo) {
        DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
        deliverUpdateVo.setVehicleTaskCode(deliverGoodVo.getVehicleTaskCode());
        deliverUpdateVo.setDeliverGoodCode(deliverGoodVo.getDeliverGoodCode());
        deliverUpdateVo.setOldDeliverStatus(DeliverStatus.ALREADY_DELIVER.getType());
        deliverUpdateVo.setDeliverStatus(DeliverStatus.WAIT_DELIVER.getType());
        deliverUpdateVo.setPlan(Boolean.valueOf(false));
        deliverUpdateVo.setTenantCode(TenantUtils.getTenantCode());
        deliverUpdateVo.setNoticeVehicleTask(Boolean.valueOf(false));
        this.deliverGoodService.updateStatusByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
    }

    private void receiving(VehicleTaskExpenseMapping vehicleTaskExpense) {
        Validate.notNull((Object)((Object)vehicleTaskExpense), (String)"\u5f3a\u5236\u6536\u8d27\u65f6,\u672a\u67e5\u8be2\u5230\u914d\u9001\u4efb\u52a1\u5173\u8054\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)DistributionStatusEnum.ALREADY_DISTRIBUTION.getType().equals(vehicleTaskExpense.getDistributionStatus()), (String)"\u5f3a\u5236\u6536\u8d27\u65f6\uff0c\u914d\u9001\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u914d\u9001", (Object[])new Object[0]);
        vehicleTaskExpense.setDistributionStatus(DistributionStatusEnum.ALREADY_DISTRIBUTION.getType());
        this.vehicleTaskExpenseMappingRepository.save((Object)vehicleTaskExpense);
        DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
        deliverUpdateVo.setDeliverGoodCode(vehicleTaskExpense.getDeliverGoodCode());
        deliverUpdateVo.setOldDeliverStatus(DeliverStatus.ALREADY_DELIVER.getType());
        deliverUpdateVo.setDeliverStatus(DeliverStatus.ALREADY_RECEIVE.getType());
        deliverUpdateVo.setTenantCode(vehicleTaskExpense.getTenantCode());
        deliverUpdateVo.setDeliveryTime(new Date());
        deliverUpdateVo.setNoticeVehicleTask(Boolean.valueOf(false));
        this.deliverGoodService.updateStatusByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
    }

    private VehicleUnload buildVehicleUnload(VehicleTask vehicleTask, DeliverGoodVo deliverGoodVo) {
        VehicleUnload vehicleUnload = new VehicleUnload();
        vehicleUnload.setVehicleUnloadType(Integer.valueOf(2));
        vehicleUnload.setVehicleProductType(VehicleProductTypeEnum.DISTRIBUTION.getType());
        vehicleUnload.setVehicleUnloadStatus(VehicleUnloadStatusEnum.WAIT_DELIVERY.getType());
        vehicleUnload.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        vehicleUnload.setCustomerCode(deliverGoodVo.getCustomerCode());
        vehicleUnload.setCustomerName(deliverGoodVo.getCustomerName());
        VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
        if (null != vehicleSaleMan) {
            vehicleUnload.setSaleManAccount(vehicleSaleMan.getUserAccount());
            vehicleUnload.setSaleManName(vehicleSaleMan.getUserName());
        }
        vehicleUnload.setVehicleCode(vehicleTask.getVehicleCode());
        vehicleUnload.setVehicleName(vehicleTask.getVehicleName());
        vehicleUnload.setRelevanceCode(deliverGoodVo.getOrderCode());
        vehicleUnload.setProducts(this.buildVehicleUnloadProduct(deliverGoodVo, vehicleUnload));
        return vehicleUnload;
    }

    private Set<VehicleUnloadProduct> buildVehicleUnloadProduct(DeliverGoodVo deliverGoodVo, VehicleUnload vehicleUnload) {
        Set deliverProductVos = deliverGoodVo.getProducts();
        HashSet products = Sets.newHashSet();
        List productCodes = deliverProductVos.stream().map(DeliverProductVo::getProductCode).distinct().collect(Collectors.toList());
        List productSet = this.productFlatService.findByProductCodeList(productCodes, TenantUtils.getTenantCode());
        Map map = productSet.stream().collect(Collectors.toMap(ProductFlatVo::getProductCode, Function.identity()));
        for (DeliverProductVo deliverProductVo : deliverProductVos) {
            VehicleUnloadProduct product = new VehicleUnloadProduct();
            product.setTenantCode(TenantUtils.getTenantCode());
            product.setVehicleUnload(vehicleUnload);
            product.setProductCode(deliverProductVo.getProductCode());
            product.setProductName(deliverProductVo.getProductName());
            product.setProductSpecificationCode(deliverProductVo.getProductSpecificationCode());
            product.setProductSpecificationName(deliverProductVo.getProductSpecificationName());
            BigDecimal unitPrice = deliverProductVo.getUnitPrice();
            product.setPurchasePrice(unitPrice);
            product.setSubtotalAmount(deliverProductVo.getSubtotalAmount());
            product.setQuantity(deliverProductVo.getDeliverQuantity());
            product.setUnitCode(deliverProductVo.getUnitCode());
            product.setUnitName(deliverProductVo.getUnitName());
            if (map.containsKey(deliverProductVo.getProductCode())) {
                ProductFlatVo productData = (ProductFlatVo)map.get(deliverProductVo.getProductCode());
                Set productSpecifications = productData.getProductSpecifications();
                for (ProductSpecificationFlatVo productSpecification : productSpecifications) {
                    ProductBarCodeInfo productBarCodeInfo;
                    if (!StringUtils.equals((CharSequence)deliverProductVo.getProductSpecificationCode(), (CharSequence)productSpecification.getProductSpecificationCode())) continue;
                    product.setRelativePath(productSpecification.getMainImagePath());
                    product.setFileName(productSpecification.getMainImageName());
                    if (CollectionUtils.isEmpty((Collection)productSpecification.getProductBarCodeInfos()) || (productBarCodeInfo = (ProductBarCodeInfo)productSpecification.getProductBarCodeInfos().stream().filter(item -> StringUtils.equals((CharSequence)item.getUnitCode(), (CharSequence)product.getUnitCode())).findFirst().orElse(null)) == null) break;
                    product.setBarCode(productBarCodeInfo.getBarCode());
                    break;
                }
            }
            products.add(product);
        }
        return products;
    }
}

