/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.distribution.dto.DeliverGoodDto;
import com.bizunited.empower.business.distribution.entity.DeliverGood;
import com.bizunited.empower.business.distribution.enums.DeliverStatus;
import com.bizunited.empower.business.distribution.enums.DeliverWay;
import com.bizunited.empower.business.distribution.service.DeliverGoodService;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.distribution.vo.DeliverGoodVo;
import com.bizunited.empower.business.distribution.vo.DeliverProductVo;
import com.bizunited.empower.business.distribution.vo.DeliverUpdateVo;
import com.bizunited.empower.business.order.dto.OrderInfoConditionDto;
import com.bizunited.empower.business.order.service.OrderInfoVoService;
import com.bizunited.empower.business.order.vo.OrderInfoVo;
import com.bizunited.empower.business.product.optimize.service.ProductFlatService;
import com.bizunited.empower.business.product.optimize.vo.ProductFlatVo;
import com.bizunited.empower.business.product.optimize.vo.ProductSpecificationFlatVo;
import com.bizunited.empower.business.product.optimize.vo.ProductUnitAndPriceFlatVo;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.service.ProductUnitAndPriceService;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.sales.entity.outward.DistributionRoute;
import com.bizunited.empower.business.sales.entity.outward.OutwardPlan;
import com.bizunited.empower.business.sales.entity.outward.OutwardPlanFrequency;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleDistributionProduct;
import com.bizunited.empower.business.sales.entity.vehicle.VehiclePickUpLoad;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleReturn;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleSaleMan;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleSalesProduct;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTaskExpenseMapping;
import com.bizunited.empower.business.sales.enums.vehicle.DistributionStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.SettlementStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehiclePickUpLoadStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleReturnStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskTypeEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskWayEnum;
import com.bizunited.empower.business.sales.repository.vehicle.VehicleTaskRepository;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteService;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleDistributionProductService;
import com.bizunited.empower.business.sales.service.vehicle.VehiclePickUpLoadService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleReturnService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleSaleManService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleSalesProductService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskExpenseMappingService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskVoService;
import com.bizunited.empower.business.sales.vo.DistributionRouteCustomerVo;
import com.bizunited.empower.business.sales.vo.DistributionRouteDetailVo;
import com.bizunited.empower.business.sales.vo.vehicle.DeliverGoodProductVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleDistributionProductVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleSaleManVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleTaskExpenseVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleTaskVo;
import com.bizunited.empower.business.sales.vo.vehicle.WarehouseExpenseProductVo;
import com.bizunited.empower.business.tenant.entity.TenantInfo;
import com.bizunited.empower.business.tenant.service.TenantInfoService;
import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.empower.business.vehicle.entity.VehicleLoad;
import com.bizunited.empower.business.vehicle.entity.VehicleLoadProduct;
import com.bizunited.empower.business.vehicle.entity.VehicleProductStock;
import com.bizunited.empower.business.vehicle.entity.VehicleUnload;
import com.bizunited.empower.business.vehicle.entity.VehicleUnloadProduct;
import com.bizunited.empower.business.vehicle.enums.VehicleLoadStatusEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleLoadTypeEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleProductTypeEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleStatusEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleTransportStatusEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleUnloadStatusEnum;
import com.bizunited.empower.business.vehicle.enums.VehicleUnloadTypeEnum;
import com.bizunited.empower.business.vehicle.service.VehicleLoadService;
import com.bizunited.empower.business.vehicle.service.VehicleProductStockService;
import com.bizunited.empower.business.vehicle.service.VehicleService;
import com.bizunited.empower.business.vehicle.service.VehicleUnloadService;
import com.bizunited.empower.business.vehicle.vo.VehicleProductStockVo;
import com.bizunited.empower.business.warehouse.dto.WarehouseProductsEnterDto;
import com.bizunited.empower.business.warehouse.dto.WarehouseProductsEnterProductDto;
import com.bizunited.empower.business.warehouse.dto.WarehouseProductsExpenseDto;
import com.bizunited.empower.business.warehouse.dto.WarehouseProductsExpenseProductDto;
import com.bizunited.empower.business.warehouse.entity.WarehouseProduct;
import com.bizunited.empower.business.warehouse.entity.WarehouseProductsExpense;
import com.bizunited.empower.business.warehouse.entity.WarehouseProductsExpenseProduct;
import com.bizunited.empower.business.warehouse.service.WarehouseActionService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsEnterService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsExpenseService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsExpenseVoService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantContextHolder;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.script.context.InvokeParams;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="VehicleTaskServiceImpl")
public class VehicleTaskServiceImpl
implements VehicleTaskService {
    @Autowired
    private VehicleTaskRepository vehicleTaskRepository;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private VehicleTaskExpenseMappingService vehicleTaskExpenseMappingService;
    @Autowired
    private VehicleService vehicleService;
    @Autowired
    private VehiclePickUpLoadService vehiclePickUpLoadService;
    @Autowired
    private VehicleReturnService vehicleReturnService;
    @Autowired
    private VehicleDistributionProductService vehicleDistributionProductService;
    @Autowired
    private VehicleSalesProductService vehicleSalesProductService;
    @Autowired
    private VehicleProductStockService vehicleProductStockService;
    @Autowired
    private VehicleUnloadService vehicleUnloadService;
    @Autowired
    private WarehouseProductsEnterService warehouseProductsEnterService;
    @Autowired
    private TenantInfoService tenantInfoService;
    @Autowired
    private VehicleLoadService vehicleLoadService;
    @Autowired
    private WarehouseProductsExpenseVoService warehouseProductsExpenseVoService;
    @Autowired
    private WarehouseProductsExpenseService warehouseProductsExpenseService;
    @Autowired
    private ProductUnitAndPriceService productUnitAndPriceService;
    @Autowired
    private VehicleSaleManService vehicleSaleManService;
    @Autowired
    private DistributionRouteService distributionRouteService;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProductFlatService productFlatService;
    @Autowired
    private OrderInfoVoService orderInfoVoService;
    @Autowired
    private WarehouseActionService warehouseActionService;
    @Autowired
    private OutwardPlanService outwardPlanService;
    @Autowired
    private VehicleTaskVoService vehicleTaskVoService;
    @Autowired
    private WarehouseProductService warehouseProductService;
    @Autowired
    private DeliverGoodVoService deliverGoodVoService;
    @Autowired
    private DeliverGoodService deliverGoodService;
    private static final Logger LOGGER = LoggerFactory.getLogger(VehicleTaskServiceImpl.class);

    @Override
    @Transactional
    public VehicleTask create(VehicleTask vehicleTask) {
        VehicleTask current = this.createForm(vehicleTask);
        return current;
    }

    @Override
    @Transactional
    public VehicleTask createForm(VehicleTask vehicleTask) {
        vehicleTask.setVehicleTaskCode(this.generateCode(TenantUtils.getTenantCode()));
        vehicleTask.setVehicleTaskStatus(VehicleTaskStatusEnum.WAIT_CONFIRM.getType());
        vehicleTask.setSettlementStatus(SettlementStatusEnum.WAIT_SETTLEMENT.getType());
        if (null == vehicleTask.getVehicleTaskWay()) {
            vehicleTask.setVehicleTaskWay(VehicleTaskWayEnum.MANUAL.getType());
            Date now = new Date();
            vehicleTask.setCreateAccount(SecurityUtils.getUserAccount());
            vehicleTask.setCreateTime(now);
            vehicleTask.setModifyAccount(SecurityUtils.getUserAccount());
            vehicleTask.setModifyTime(now);
            vehicleTask.setTenantCode(TenantUtils.getTenantCode());
        }
        this.createValidation(vehicleTask);
        this.vehicleTaskRepository.save((Object)vehicleTask);
        return vehicleTask;
    }

    private void createValidation(VehicleTask vehicleTask) {
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)vehicleTask.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        vehicleTask.setId(null);
        Validate.notBlank((CharSequence)vehicleTask.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getVehicleTaskCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleTask.getVehicleTaskStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getRouteCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u914d\u9001\u8def\u7ebf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getVehicleCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getCarNumber(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8f66\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getWarehouseCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getWarehouseName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleTask.getTaskTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u65e5\u671f(\u4efb\u52a1\u65e5\u671f)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleTask.getVehicleLoadAmount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u63d0\u8d27\u88c5\u8f66\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleTask.getSettlementStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7ed3\u7b97\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend1() == null || vehicleTask.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend2() == null || vehicleTask.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend3() == null || vehicleTask.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend4() == null || vehicleTask.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend5() == null || vehicleTask.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend6() == null || vehicleTask.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend7() == null || vehicleTask.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getTenantCode() == null || vehicleTask.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getVehicleTaskCode() == null || vehicleTask.getVehicleTaskCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getRouteCode() == null || vehicleTask.getRouteCode().length() < 64 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getVehicleCode() == null || vehicleTask.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getCarNumber() == null || vehicleTask.getCarNumber().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u724c\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getWarehouseCode() == null || vehicleTask.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getWarehouseName() == null || vehicleTask.getWarehouseName().length() < 255 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        VehicleTask byVehicleTaskCode = this.vehicleTaskRepository.findByVehicleTaskCode(vehicleTask.getVehicleTaskCode(), vehicleTask.getTenantCode());
        Validate.isTrue((byVehicleTaskCode == null ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u91cd\u590d\uff01", (Object[])new Object[0]);
        Vehicle vehicle = this.vehicleService.findByVehicleCodeAndTenantCode(vehicleTask.getVehicleCode(), vehicleTask.getTenantCode());
        Validate.notNull((Object)vehicle, (String)"\u521b\u5efa\u4efb\u52a1\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5173\u8054\u8f66\u8f86", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleStatusEnum.ENABLE.getType().equals(vehicle.getVehicleStatus()), (String)"\u521b\u5efa\u4efb\u52a1\u65f6\uff0c\u5173\u8054\u7684\u8f66\u8f86\u72b6\u6001\u5fc5\u987b\u4e3a\u542f\u7528\u72b6\u6001\uff01", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public VehicleTask update(VehicleTask vehicleTask) {
        VehicleTask current = this.updateForm(vehicleTask);
        return current;
    }

    @Override
    @Transactional
    public VehicleTask updateForm(VehicleTask vehicleTask) {
        this.updateValidation(vehicleTask);
        String currentId = vehicleTask.getId();
        Optional op_currentVehicleTask = this.vehicleTaskRepository.findById(currentId);
        VehicleTask currentVehicleTask = op_currentVehicleTask.orElse(null);
        currentVehicleTask = (VehicleTask)((Object)Validate.notNull((Object)((Object)currentVehicleTask), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        Date now = new Date();
        currentVehicleTask.setModifyAccount(SecurityUtils.getUserAccount());
        currentVehicleTask.setModifyTime(now);
        currentVehicleTask.setExtend1(vehicleTask.getExtend1());
        currentVehicleTask.setExtend2(vehicleTask.getExtend2());
        currentVehicleTask.setExtend3(vehicleTask.getExtend3());
        currentVehicleTask.setExtend4(vehicleTask.getExtend4());
        currentVehicleTask.setExtend5(vehicleTask.getExtend5());
        currentVehicleTask.setExtend6(vehicleTask.getExtend6());
        currentVehicleTask.setExtend7(vehicleTask.getExtend7());
        currentVehicleTask.setExtend8(vehicleTask.getExtend8());
        currentVehicleTask.setExtend9(vehicleTask.getExtend9());
        currentVehicleTask.setExtend10(vehicleTask.getExtend10());
        currentVehicleTask.setExtend11(vehicleTask.getExtend11());
        currentVehicleTask.setTenantCode(vehicleTask.getTenantCode());
        currentVehicleTask.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        currentVehicleTask.setVehicleTaskStatus(vehicleTask.getVehicleTaskStatus());
        currentVehicleTask.setRouteCode(vehicleTask.getRouteCode());
        currentVehicleTask.setVehicleCode(vehicleTask.getVehicleCode());
        currentVehicleTask.setVehicleName(vehicleTask.getVehicleName());
        currentVehicleTask.setCarNumber(vehicleTask.getCarNumber());
        currentVehicleTask.setWarehouseCode(vehicleTask.getWarehouseCode());
        currentVehicleTask.setWarehouseName(vehicleTask.getWarehouseName());
        currentVehicleTask.setTaskTime(vehicleTask.getTaskTime());
        currentVehicleTask.setVehicleLoadAmount(vehicleTask.getVehicleLoadAmount());
        currentVehicleTask.setVehicleReturnAmount(vehicleTask.getVehicleReturnAmount());
        currentVehicleTask.setSaleOrderQuantity(vehicleTask.getSaleOrderQuantity());
        currentVehicleTask.setLoadTime(vehicleTask.getLoadTime());
        currentVehicleTask.setReturnTime(vehicleTask.getReturnTime());
        currentVehicleTask.setSettlementStatus(vehicleTask.getSettlementStatus());
        currentVehicleTask.setRemark(vehicleTask.getRemark());
        currentVehicleTask.setOutwardPlanCode(vehicleTask.getOutwardPlanCode());
        this.vehicleTaskRepository.saveAndFlush((Object)currentVehicleTask);
        return currentVehicleTask;
    }

    private void updateValidation(VehicleTask vehicleTask) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)vehicleTask.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getVehicleTaskCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleTask.getVehicleTaskStatus(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getRouteCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u914d\u9001\u8def\u7ebf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getVehicleCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u8f86\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getCarNumber(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8f66\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getWarehouseCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTask.getWarehouseName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleTask.getTaskTime(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u51fa\u8f66\u65e5\u671f(\u4efb\u52a1\u65e5\u671f)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleTask.getVehicleLoadAmount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u63d0\u8d27\u88c5\u8f66\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)vehicleTask.getSettlementStatus(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u7ed3\u7b97\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend1() == null || vehicleTask.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend2() == null || vehicleTask.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend3() == null || vehicleTask.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend4() == null || vehicleTask.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend5() == null || vehicleTask.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend6() == null || vehicleTask.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getExtend7() == null || vehicleTask.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getTenantCode() == null || vehicleTask.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getVehicleTaskCode() == null || vehicleTask.getVehicleTaskCode().length() < 64 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getRouteCode() == null || vehicleTask.getRouteCode().length() < 64 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getVehicleCode() == null || vehicleTask.getVehicleCode().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u8f86\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getCarNumber() == null || vehicleTask.getCarNumber().length() < 64 ? 1 : 0) != 0, (String)"\u8f66\u724c\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getWarehouseCode() == null || vehicleTask.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((vehicleTask.getWarehouseName() == null || vehicleTask.getWarehouseName().length() < 255 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskWayEnum.MANUAL.getType().equals(vehicleTask.getVehicleTaskWay()), (String)"\u81ea\u52a8\u751f\u6210\u7684\u4efb\u52a1\u4e0d\u53ef\u7f16\u8f91", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskStatusEnum.WAIT_PICK.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u81ea\u52a8\u751f\u6210\u7684\u4efb\u52a1\u4e0d\u53ef\u7f16\u8f91", (Object[])new Object[0]);
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format("vehicle:task:code:index:%s", tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{"CC", format.format(new Date()), index});
    }

    @Override
    public VehicleTask findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.vehicleTaskRepository.findDetailsById(id);
    }

    @Override
    public VehicleTask findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.vehicleTaskRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public VehicleTask findByVehicleTaskCode(String code) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, TenantUtils.getTenantCode()})) {
            return null;
        }
        return this.vehicleTaskRepository.findByVehicleTaskCode(code, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        VehicleTask current = this.findById(id);
        if (current != null) {
            Validate.isTrue((boolean)VehicleTaskStatusEnum.WAIT_CONFIRM.getType().equals(current.getVehicleTaskStatus()), (String)"\u5220\u9664\u4efb\u52a1\u65f6,\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001", (Object[])new Object[0]);
            if (!CollectionUtils.isEmpty(current.getSaleMans())) {
                for (VehicleSaleMan saleMan : current.getSaleMans()) {
                    this.vehicleSaleManService.deleteById(saleMan.getId());
                }
            }
            this.vehicleTaskExpenseMappingService.deleteByVehicleTaskCode(current.getVehicleTaskCode());
            this.vehicleDistributionProductService.deleteByVehicleTaskCode(current.getVehicleTaskCode());
            this.vehicleSalesProductService.deleteByVehicleTaskCode(current.getVehicleTaskCode());
            this.vehicleTaskRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void confirm(String vehicleTaskCode) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u786e\u8ba4\u4efb\u52a1\u65f6\uff0c\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskRepository.findByVehicleTaskCode(vehicleTaskCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u786e\u8ba4\u4efb\u52a1\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskStatusEnum.WAIT_CONFIRM.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u786e\u8ba4\u4efb\u52a1\u65f6,\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001", (Object[])new Object[0]);
        vehicleTask.setVehicleTaskStatus(VehicleTaskStatusEnum.WAIT_PICK.getType());
        List<VehicleDistributionProduct> distributionProducts = this.vehicleDistributionProductService.findByVehicleTaskCode(vehicleTaskCode);
        List<VehicleSalesProduct> salesProduct = this.vehicleSalesProductService.findByVehicleTaskCode(vehicleTaskCode);
        Validate.isTrue((!CollectionUtils.isEmpty(distributionProducts) || !CollectionUtils.isEmpty(salesProduct) ? 1 : 0) != 0, (String)"\u786e\u8ba4\u4efb\u52a1\u65f6,\u51fa\u8f66\u4efb\u52a1\u4e2d\u672a\u67e5\u8be2\u5230\u5546\u54c1", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(distributionProducts) && !CollectionUtils.isEmpty(salesProduct)) {
            vehicleTask.setVehicleTaskType(VehicleTaskTypeEnum.SALE_DISTRIBUTION.getType());
        } else if (!CollectionUtils.isEmpty(distributionProducts)) {
            vehicleTask.setVehicleTaskType(VehicleTaskTypeEnum.DISTRIBUTION.getType());
        } else if (!CollectionUtils.isEmpty(salesProduct)) {
            vehicleTask.setVehicleTaskType(VehicleTaskTypeEnum.SALE.getType());
        }
        this.vehicleTaskRepository.save((Object)vehicleTask);
        VehiclePickUpLoad vehiclePickUpLoad = this.transformVehicleTaskToVehiclePickUpLoad(vehicleTask);
        vehiclePickUpLoad = this.vehiclePickUpLoadService.create(vehiclePickUpLoad);
        this.vehicleSalesProductService.updateTransferOrderCodeByVehicleTaskCode(vehicleTaskCode, vehiclePickUpLoad.getTransferOrderCode());
        this.vehicleDistributionProductService.updateTransferOrderCodeByVehicleTaskCode(vehicleTaskCode, vehiclePickUpLoad.getTransferOrderCode());
        this.updateDeliverGoodByVehicleTask(vehicleTask);
    }

    @Override
    @Transactional
    public void cancel(String vehicleTaskCode) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u53d6\u6d88\u4efb\u52a1\u65f6\uff0c\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskRepository.findByVehicleTaskCode(vehicleTaskCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u53d6\u6d88\u4efb\u52a1\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskStatusEnum.WAIT_PICK.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u53d6\u6d88\u4efb\u52a1\u65f6,\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u786e\u8ba4\u72b6\u6001", (Object[])new Object[0]);
        vehicleTask.setVehicleTaskStatus(VehicleTaskStatusEnum.CANCEL.getType());
        this.vehicleTaskRepository.save((Object)vehicleTask);
        List<VehicleTaskExpenseMapping> vehicleTaskExpenseMappingList = this.vehicleTaskExpenseMappingService.findByVehicleTaskCode(vehicleTaskCode);
        if (!CollectionUtils.isEmpty(vehicleTaskExpenseMappingList)) {
            List deliverGoodCodes = vehicleTaskExpenseMappingList.stream().map(VehicleTaskExpenseMapping::getDeliverGoodCode).collect(Collectors.toList());
            DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
            deliverUpdateVo.setVehicleTaskCode(vehicleTaskCode);
            deliverUpdateVo.setDeliverGoodCodes(deliverGoodCodes);
            deliverUpdateVo.setOldDeliverStatus(DeliverStatus.ALREADY_DELIVER.getType());
            deliverUpdateVo.setDeliverStatus(DeliverStatus.WAIT_DELIVER.getType());
            deliverUpdateVo.setPlan(Boolean.valueOf(false));
            deliverUpdateVo.setTenantCode(TenantUtils.getTenantCode());
            deliverUpdateVo.setNoticeVehicleTask(Boolean.valueOf(false));
            this.deliverGoodService.batchUpdateStatusByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
        }
    }

    @Override
    @Transactional
    public void completePick(String vehicleTaskCode) {
        VehicleLoad vehicleLoad;
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u6839\u636e\u4efb\u52a1\u7f16\u53f7\u4fee\u6539\u72b6\u6001\u65f6\uff0c\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskRepository.findByVehicleTaskCode(vehicleTaskCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u6839\u636e\u4efb\u52a1\u7f16\u53f7\u4fee\u6539\u72b6\u6001\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskStatusEnum.WAIT_PICK.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u5b8c\u6210\u62e3\u8d27\u65f6,\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u62e3\u8d27\u72b6\u6001", (Object[])new Object[0]);
        List<VehicleDistributionProduct> distributionProducts = this.vehicleDistributionProductService.findByVehicleTaskCode(vehicleTaskCode);
        List<VehicleSalesProduct> salesProduct = this.vehicleSalesProductService.findByVehicleTaskCode(vehicleTaskCode);
        Validate.isTrue((!CollectionUtils.isEmpty(distributionProducts) || !CollectionUtils.isEmpty(salesProduct) ? 1 : 0) != 0, (String)"\u786e\u8ba4\u4efb\u52a1\u65f6,\u51fa\u8f66\u4efb\u52a1\u4e2d\u672a\u67e5\u8be2\u5230\u5546\u54c1", (Object[])new Object[0]);
        VehicleTask drivingVehicleTask = this.vehicleTaskRepository.findVehicleTaskByDriving(vehicleTask.getVehicleCode(), TenantUtils.getTenantCode());
        String taskCode = drivingVehicleTask == null ? "" : drivingVehicleTask.getVehicleTaskCode();
        Validate.isTrue((null == drivingVehicleTask ? 1 : 0) != 0, (String)("\u8be5\u8f66\u8f86\u6709\u5176\u4ed6\u4efb\u52a1\u8fdb\u884c,\u4e0d\u53ef\u5b8c\u6210\u62e3\u8d27\uff01\u4efb\u52a1\u7f16\u53f7\u4e3a" + taskCode), (Object[])new Object[0]);
        Vehicle vehicle = this.vehicleService.findByVehicleCode(vehicleTask.getVehicleCode());
        Validate.notNull((Object)vehicle, (String)"\u6839\u636e\u8f66\u8f86\u7f16\u53f7\u67e5\u8be2\u5230\u7684\u8f66\u8f86\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTransportStatusEnum.VACANT.getType().equals(vehicle.getVehicleTransportStatus()), (String)"\u5b8c\u6210\u62e3\u8d27\u65f6,\u8f66\u8f86\u72b6\u6001\u5fc5\u987b\u4e3a\u7a7a\u7f6e", (Object[])new Object[0]);
        this.vehicleTaskRepository.updateTaskStatusByTaskCodeAndTenantCode(vehicleTaskCode, VehicleTaskStatusEnum.WAIT_DELIVERY.getType(), TenantUtils.getTenantCode());
        List<VehicleSalesProduct> salesProducts = this.vehicleSalesProductService.findByVehicleTaskCode(vehicleTaskCode);
        if (!CollectionUtils.isEmpty(salesProducts)) {
            vehicleLoad = this.buildSalesVehicleLoad(vehicleTask, salesProducts);
            vehicleLoad = this.vehicleLoadService.saveVehicleLoad(vehicleLoad);
            WarehouseProductsExpenseDto warehouseProductsExpenseDto = this.bulidWarehouseProductsExpense(vehicleTask, vehicleLoad);
            this.warehouseProductsExpenseVoService.create(warehouseProductsExpenseDto);
        }
        if (!CollectionUtils.isEmpty(distributionProducts)) {
            vehicleLoad = this.buildDistributionVehicleLoad(vehicleTask, distributionProducts);
            this.vehicleLoadService.saveVehicleLoad(vehicleLoad);
        }
        this.vehiclePickUpLoadService.updateVehicleLoadStatusByVehicleTaskCode(vehicleTaskCode, VehiclePickUpLoadStatusEnum.WAIT_CONFIRM.getType());
    }

    @Override
    @Transactional
    public void deliverGoods(String vehicleTaskCode) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u88c5\u8f66\u53d1\u8d27\u65f6\uff0c\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskRepository.findByVehicleTaskCode(vehicleTaskCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u88c5\u8f66\u53d1\u8d27\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskStatusEnum.WAIT_DELIVERY.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u88c5\u8f66\u53d1\u8d27\u65f6,\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u53d1\u8d27", (Object[])new Object[0]);
        VehicleTask drivingVehicleTask = this.vehicleTaskRepository.findVehicleTaskByDriving(vehicleTask.getVehicleCode(), TenantUtils.getTenantCode());
        Validate.isTrue((null == drivingVehicleTask ? 1 : 0) != 0, (String)"\u8be5\u8f66\u8f86\u6709\u5176\u4ed6\u4efb\u52a1\u8fdb\u884c\u4e2d,\u4e0d\u53ef\u88c5\u8f66\u53d1\u8d27\uff01", (Object[])new Object[0]);
        Vehicle vehicle = this.vehicleService.findByVehicleCode(vehicleTask.getVehicleCode());
        Validate.notNull((Object)vehicle, (String)"\u6839\u636e\u8f66\u8f86\u7f16\u53f7\u67e5\u8be2\u5230\u7684\u8f66\u8f86\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTransportStatusEnum.VACANT.getType().equals(vehicle.getVehicleTransportStatus()), (String)"\u88c5\u8f66\u53d1\u8d27\u65f6,\u8f66\u8f86\u72b6\u6001\u5fc5\u987b\u4e3a\u7a7a\u7f6e", (Object[])new Object[0]);
        List vehicleLoads = this.vehicleLoadService.findByVehicleTaskCode(vehicleTaskCode);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)vehicleLoads) ? 1 : 0) != 0, (String)"\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u67e5\u8be2\u7684\u88c5\u8d27\u5355\u4e3a\u7a7a", (Object[])new Object[0]);
        for (VehicleLoad vehicleLoad : vehicleLoads) {
            if (vehicleLoad.getVehicleProductType().equals(VehicleProductTypeEnum.VEHICLE_SALES.getType())) {
                List warehouseProductsExpenses = this.warehouseProductsExpenseService.findByRelevanceCode(vehicleLoad.getVehicleLoadCode());
                Validate.isTrue((!CollectionUtils.isEmpty((Collection)warehouseProductsExpenses) ? 1 : 0) != 0, (String)"\u6839\u636e\u88c5\u8d27\u5355\u7f16\u7801\u67e5\u8be2\u51fa\u5e93\u5355\u4e3a\u7a7a", (Object[])new Object[0]);
                for (WarehouseProductsExpense warehouseProductsExpense : warehouseProductsExpenses) {
                    this.warehouseProductsExpenseVoService.complete(warehouseProductsExpense.getExpenseCode());
                }
            }
            this.vehicleLoadService.updateStatusByVehicleLoadCode(vehicleLoad.getVehicleLoadCode(), VehicleLoadStatusEnum.CONFIRM);
        }
        this.vehicleTaskRepository.updateTaskStatusByTaskCodeAndTenantCode(vehicleTaskCode, VehicleTaskStatusEnum.VEHICLE_DRIVING.getType(), TenantUtils.getTenantCode());
        this.vehicleService.updateVehicleTransportStatus(vehicle.getVehicleCode(), VehicleTransportStatusEnum.OCCUPY.getType());
        String transferOrderCode = this.vehiclePickUpLoadService.updateVehicleLoadStatusByVehicleTaskCode(vehicleTaskCode, VehiclePickUpLoadStatusEnum.COMPLETE.getType());
        this.vehicleTaskRepository.updateLoadTimeByVehicleTaskCode(vehicleTaskCode, new Date(), TenantUtils.getTenantCode());
        VehicleReturn vehicleReturn = this.transformVehicleTaskToVehicleReturn(vehicleTask, transferOrderCode);
        this.vehicleReturnService.create(vehicleReturn);
        this.saveVehicleProductStock(vehicleTask.getVehicleCode(), vehicleTaskCode);
    }

    @Override
    @Transactional
    public void returnVehicle(String vehicleTaskCode) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u6536\u8f66\u5165\u5e93\u65f6\uff0c\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskRepository.findByVehicleTaskCode(vehicleTaskCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u6536\u8f66\u5165\u5e93\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskStatusEnum.APPLY_RETURN.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u6536\u8f66\u5165\u5e93\u65f6,\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u7533\u8bf7\u6536\u8f66", (Object[])new Object[0]);
        Vehicle vehicle = this.vehicleService.findByVehicleCode(vehicleTask.getVehicleCode());
        Validate.notNull((Object)vehicle, (String)"\u6839\u636e\u8f66\u8f86\u7f16\u53f7\u67e5\u8be2\u5230\u7684\u8f66\u8f86\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTransportStatusEnum.OCCUPY.getType().equals(vehicle.getVehicleTransportStatus()), (String)"\u6536\u8f66\u5165\u5e93\u65f6\u8f66\u8f86\u72b6\u6001\u5fc5\u987b\u4e3a\u5360\u7528", (Object[])new Object[0]);
        List vehicleUnloads = this.vehicleUnloadService.findByVehicleTaskCodeAndProductTypeAndUnloadStatus(vehicleTaskCode, VehicleProductTypeEnum.VEHICLE_SALES, VehicleUnloadStatusEnum.DELIVERY);
        BigDecimal saleOrderQuantity = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)vehicleUnloads)) {
            saleOrderQuantity = new BigDecimal(vehicleUnloads.size());
        }
        vehicleTask.setVehicleTaskStatus(VehicleTaskStatusEnum.VEHICLE_RETURN.getType());
        vehicleTask.setReturnTime(new Date());
        BigDecimal vehicleReturnAmount = BigDecimal.ZERO;
        vehicleTask.setSaleOrderQuantity(saleOrderQuantity);
        List vehicleProductStock = this.vehicleService.findProductStockStatistics(vehicle.getId(), TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty((Collection)vehicleProductStock)) {
            List<VehicleProductStockVo> notSaleProductStock;
            List<VehicleProductStockVo> vehicleDistributionProductStock;
            List<VehicleProductStockVo> vehicleSalesProductStock = vehicleProductStock.stream().filter(produt -> VehicleProductTypeEnum.VEHICLE_SALES.getType().equals(produt.getVehicleProductType()) && produt.getInventory().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(vehicleSalesProductStock)) {
                VehicleUnload vehicleSalesUnload = this.buildVehicleStockVehicleUnload(vehicleTask, vehicleSalesProductStock, VehicleProductTypeEnum.VEHICLE_SALES.getType());
                vehicleSalesUnload = this.vehicleUnloadService.saveVehicleUnload(vehicleSalesUnload);
                WarehouseProductsEnterDto warehouseProductsEnterDto = this.buildWarehouseProductsEnter(vehicleTask, vehicleSalesUnload);
                this.warehouseProductsEnterService.create(warehouseProductsEnterDto);
                this.warehouseProductsEnterService.confirmEnterByRelevanceCode(vehicleSalesUnload.getVehicleUnloadCode(), warehouseProductsEnterDto.getWarehouseCode());
                BigDecimal vehicleSalesAmount = vehicleSalesUnload.getProducts().stream().map(VehicleUnloadProduct::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                vehicleReturnAmount.add(vehicleSalesAmount);
            }
            if (!CollectionUtils.isEmpty(vehicleDistributionProductStock = vehicleProductStock.stream().filter(produt -> VehicleProductTypeEnum.DISTRIBUTION.getType().equals(produt.getVehicleProductType()) && produt.getInventory().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList()))) {
                VehicleUnload vehicleDistributionUnload = this.buildVehicleStockVehicleUnload(vehicleTask, vehicleDistributionProductStock, VehicleProductTypeEnum.DISTRIBUTION.getType());
                vehicleDistributionUnload = this.vehicleUnloadService.saveVehicleUnload(vehicleDistributionUnload);
                BigDecimal vehicleDistributionAmount = vehicleDistributionUnload.getProducts().stream().map(VehicleUnloadProduct::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                vehicleReturnAmount.add(vehicleDistributionAmount);
            }
            if (!CollectionUtils.isEmpty(notSaleProductStock = vehicleProductStock.stream().filter(produt -> VehicleProductTypeEnum.NOT_SALE.getType().equals(produt.getVehicleProductType()) && produt.getInventory().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList()))) {
                VehicleUnload vehicleNotSaleUnload = this.buildVehicleStockVehicleUnload(vehicleTask, notSaleProductStock, VehicleProductTypeEnum.NOT_SALE.getType());
                vehicleNotSaleUnload = this.vehicleUnloadService.saveVehicleUnload(vehicleNotSaleUnload);
                WarehouseProductsEnterDto warehouseProductsEnterDto = this.buildWarehouseProductsEnter(vehicleTask, vehicleNotSaleUnload);
                this.warehouseProductsEnterService.create(warehouseProductsEnterDto);
                this.warehouseProductsEnterService.confirmEnterByRelevanceCode(vehicleNotSaleUnload.getVehicleUnloadCode(), warehouseProductsEnterDto.getWarehouseCode());
                BigDecimal vehicleDistributionAmount = vehicleNotSaleUnload.getProducts().stream().map(VehicleUnloadProduct::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                vehicleReturnAmount.add(vehicleDistributionAmount);
            }
        }
        vehicleTask.setVehicleReturnAmount(vehicleReturnAmount);
        this.vehicleTaskRepository.save((Object)vehicleTask);
        this.vehicleReturnService.updateVehicleReturnStatusByVehicleTaskCode(vehicleTaskCode, VehicleTaskStatusEnum.APPLY_RETURN);
        this.vehicleService.returnVehicleByVehicleCode(vehicle.getVehicleCode());
        this.returnVehicleDistribution(vehicleTaskCode);
    }

    private void returnVehicleDistribution(String vehicleTaskCode) {
        List<VehicleTaskExpenseMapping> VehicleTaskExpenseMappings = this.vehicleTaskExpenseMappingService.findByVehicleTaskCode(vehicleTaskCode);
        if (!CollectionUtils.isEmpty(VehicleTaskExpenseMappings)) {
            for (VehicleTaskExpenseMapping vehicleTaskExpenseMapping : VehicleTaskExpenseMappings) {
                Validate.isTrue((!DistributionStatusEnum.WAIT_DISTRIBUTION.getType().equals(vehicleTaskExpenseMapping.getDistributionStatus()) ? 1 : 0) != 0, (String)"\u6536\u8f66\u5165\u5e93\u65f6,\u6709\u914d\u9001\u4efb\u52a1\u672a\u914d\u9001", (Object[])new Object[0]);
            }
            List deliverGoodCodes = VehicleTaskExpenseMappings.stream().filter(item -> DistributionStatusEnum.DELAY_DISTRIBUTION.getType().equals(item.getDistributionStatus())).map(VehicleTaskExpenseMapping::getDeliverGoodCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(deliverGoodCodes)) {
                DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
                deliverUpdateVo.setVehicleTaskCode(vehicleTaskCode);
                deliverUpdateVo.setDeliverGoodCodes(deliverGoodCodes);
                deliverUpdateVo.setOldDeliverStatus(DeliverStatus.ALREADY_DELIVER.getType());
                deliverUpdateVo.setDeliverStatus(DeliverStatus.WAIT_DELIVER.getType());
                deliverUpdateVo.setPlan(Boolean.valueOf(false));
                deliverUpdateVo.setTenantCode(TenantUtils.getTenantCode());
                deliverUpdateVo.setNoticeVehicleTask(Boolean.valueOf(false));
                this.deliverGoodService.batchUpdateStatusByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
            }
        }
    }

    @Override
    @Transactional
    public void addDeliverToVehicleTask(String deliverGoodCode, String vehicleTaskCode) {
        Validate.notBlank((CharSequence)deliverGoodCode, (String)"\u53d1\u8d27\u5355\u6dfb\u52a0\u5230\u51fa\u8f66\u4efb\u52a1\u65f6\uff0c\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u53d1\u8d27\u5355\u6dfb\u52a0\u5230\u51fa\u8f66\u4efb\u52a1\u65f6\uff0c\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskRepository.findByVehicleTaskCode(vehicleTaskCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u53d1\u8d27\u5355\u6dfb\u52a0\u5230\u51fa\u8f66\u4efb\u52a1\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskStatusEnum.WAIT_CONFIRM.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u53d1\u8d27\u5355\u6dfb\u52a0\u5230\u51fa\u8f66\u4efb\u52a1\u65f6,\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001", (Object[])new Object[0]);
        List<VehicleTaskExpenseMapping> vehicleTaskExpenseMappingList = this.vehicleTaskExpenseMappingService.findByVehicleTaskCode(vehicleTaskCode);
        if (!CollectionUtils.isEmpty(vehicleTaskExpenseMappingList)) {
            List list = vehicleTaskExpenseMappingList.stream().map(VehicleTaskExpenseMapping::getDeliverGoodCode).collect(Collectors.toList());
            Validate.isTrue((!list.contains(deliverGoodCode) ? 1 : 0) != 0, (String)"\u53d1\u8d27\u5355\u6dfb\u52a0\u5230\u51fa\u8f66\u4efb\u52a1\u65f6,\u53d1\u8d27\u5355\u53f7\u5df2\u5b58\u5728\u8be5\u51fa\u8f66\u4efb\u52a1\u4e2d", (Object[])new Object[0]);
        }
        ArrayList<String> deliverGoodCodeList = new ArrayList<String>();
        deliverGoodCodeList.add(deliverGoodCode);
        this.checkVehicleTaskDeliverGood(deliverGoodCodeList);
        DeliverGoodVo deliverGoodVo = this.deliverGoodVoService.findByDeliverGoodCode(deliverGoodCode);
        Validate.notNull((Object)deliverGoodVo, (String)"\u67e5\u8be2\u5230\u7684\u53d1\u8d27\u5355\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)DeliverStatus.WAIT_DELIVER.getType().equals(deliverGoodVo.getDeliverStatus()), (String)"\u53d1\u8d27\u5355\u6dfb\u52a0\u5230\u51fa\u8f66\u4efb\u52a1\u65f6,\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u53d1\u8d27", (Object[])new Object[0]);
        Validate.isTrue((deliverGoodVo.getPlan() == false ? 1 : 0) != 0, (String)"\u53d1\u8d27\u5355\u6dfb\u52a0\u5230\u51fa\u8f66\u4efb\u52a1\u65f6,\u53d1\u8d27\u5355\u5fc5\u987b\u4e3a\u5f85\u89c4\u5212", (Object[])new Object[0]);
        ArrayList<String> expenseCodeList = new ArrayList<String>();
        expenseCodeList.add(deliverGoodVo.getRelevanceCode());
        List<WarehouseExpenseProductVo> warehouseExpenseProductVoList = this.findByExpenseCodeList(expenseCodeList);
        ArrayList<VehicleDistributionProduct> vehicleDistributionProducts = new ArrayList<VehicleDistributionProduct>();
        for (WarehouseExpenseProductVo warehouseExpenseProductVo : warehouseExpenseProductVoList) {
            VehicleDistributionProduct vehicleDistributionProduct = this.transExpenseProductVoToDistributionProduct(warehouseExpenseProductVo, vehicleTask);
            vehicleDistributionProducts.add(vehicleDistributionProduct);
        }
        ArrayList<VehicleDistributionProduct> saveList = new ArrayList<VehicleDistributionProduct>();
        List<VehicleDistributionProduct> byVehicleTaskCode = this.vehicleDistributionProductService.findByVehicleTaskCode(vehicleTaskCode);
        if (!CollectionUtils.isEmpty(byVehicleTaskCode)) {
            for (VehicleDistributionProduct product : vehicleDistributionProducts) {
                VehicleDistributionProduct oldProduct = byVehicleTaskCode.stream().filter(o -> o.getProductSpecificationCode().equals(product.getProductSpecificationCode()) && o.getUnitCode().equals(product.getUnitCode())).findFirst().orElse(null);
                if (null != oldProduct) {
                    oldProduct.setQuantity(oldProduct.getQuantity().add(product.getQuantity()));
                    oldProduct.setRemainingQuantity(oldProduct.getRemainingQuantity().add(product.getRemainingQuantity()));
                    oldProduct.setSubtotalAmount(oldProduct.getSubtotalAmount().add(product.getSubtotalAmount()));
                    continue;
                }
                saveList.add(product);
            }
            saveList.addAll(byVehicleTaskCode);
        } else {
            saveList = vehicleDistributionProducts;
        }
        this.vehicleDistributionProductService.batchSave(saveList);
        VehicleTaskExpenseMapping deliverGoodMapping = new VehicleTaskExpenseMapping();
        deliverGoodMapping.setDeliverGoodCode(deliverGoodVo.getDeliverGoodCode());
        deliverGoodMapping.setVehicleTaskCode(vehicleTaskCode);
        deliverGoodMapping.setExpenseCode(deliverGoodVo.getRelevanceCode());
        deliverGoodMapping.setDistributionStatus(DistributionStatusEnum.WAIT_DISTRIBUTION.getType());
        deliverGoodMapping.setId(null);
        deliverGoodMapping.setCustomerCode(deliverGoodVo.getCustomerCode());
        deliverGoodMapping.setCustomerName(deliverGoodVo.getCustomerName());
        this.vehicleTaskExpenseMappingService.create(deliverGoodMapping);
        DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
        deliverUpdateVo.setDeliverGoodCode(deliverGoodVo.getDeliverGoodCode());
        deliverUpdateVo.setPlan(Boolean.valueOf(true));
        deliverUpdateVo.setTenantCode(vehicleTask.getTenantCode());
        deliverUpdateVo.setRouteCode(vehicleTask.getRouteCode());
        DistributionRoute distributionRoute = this.distributionRouteService.findByCode(vehicleTask.getRouteCode());
        if (null != distributionRoute) {
            deliverUpdateVo.setRouteName(distributionRoute.getName());
        }
        deliverUpdateVo.setCarNumber(vehicleTask.getCarNumber());
        deliverUpdateVo.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
        if (null != vehicleSaleMan) {
            deliverUpdateVo.setSaleManAccount(vehicleSaleMan.getUserAccount());
            deliverUpdateVo.setSaleManName(vehicleSaleMan.getUserName());
        }
        deliverUpdateVo.setNoticeVehicleTask(Boolean.valueOf(false));
        this.deliverGoodService.updatePlanByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
        BigDecimal distributionProductSubtotalAmount = saveList.stream().map(VehicleDistributionProduct::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        vehicleTask.setVehicleLoadAmount(vehicleTask.getVehicleLoadAmount().add(distributionProductSubtotalAmount));
        this.vehicleTaskRepository.save((Object)vehicleTask);
    }

    @Override
    @Transactional
    public void removeDeliverToVehicleTask(DeliverGood deliverGood) {
        Validate.notBlank((CharSequence)deliverGood.getVehicleTaskCode(), (String)"\u53d1\u8d27\u5355\u5173\u8054\u7684\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskRepository.findByVehicleTaskCode(deliverGood.getVehicleTaskCode(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u6839\u636e\u53d1\u8d27\u5355\u4e2d\u7684\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1", (Object[])new Object[0]);
        Validate.isTrue((VehicleTaskStatusEnum.WAIT_CONFIRM.getType().equals(vehicleTask.getVehicleTaskStatus()) || VehicleTaskStatusEnum.WAIT_PICK.getType().equals(vehicleTask.getVehicleTaskStatus()) || VehicleTaskStatusEnum.CANCEL.getType().equals(vehicleTask.getVehicleTaskStatus()) ? 1 : 0) != 0, (String)("\u8be5\u53d1\u8d27\u5355\u5df2\u7ecf\u5173\u8054(\u975e\u5f85\u786e\u8ba4\u6216\u5df2\u53d6\u6d88\u72b6\u6001\u7684)\u51fa\u8f66\u4efb\u52a1" + vehicleTask.getVehicleTaskCode() + "\u4e0d\u53ef\u64a4\u9500"), (Object[])new Object[0]);
        ArrayList finalDeliverGoodList = Lists.newArrayList();
        List<VehicleTaskExpenseMapping> vehicleTaskExpenseMappingList = this.vehicleTaskExpenseMappingService.findByVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        for (VehicleTaskExpenseMapping vehicleTaskExpenseMapping : vehicleTaskExpenseMappingList) {
            if (vehicleTaskExpenseMapping.getDeliverGoodCode().equals(deliverGood.getDeliverGoodCode())) {
                this.vehicleTaskExpenseMappingService.deleteById(vehicleTaskExpenseMapping.getId());
                continue;
            }
            finalDeliverGoodList.add(vehicleTaskExpenseMapping);
        }
        this.vehicleDistributionProductService.deleteByVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        if (!CollectionUtils.isEmpty((Collection)finalDeliverGoodList)) {
            List deliverGoodCodes = finalDeliverGoodList.stream().map(VehicleTaskExpenseMapping::getDeliverGoodCode).collect(Collectors.toList());
            List deliverGoodVos = this.deliverGoodVoService.findByDeliverGoodCodes(deliverGoodCodes);
            HashSet deliverProductVoSet = new HashSet();
            for (Object deliverGoodVo : deliverGoodVos) {
                Set products = deliverGoodVo.getProducts();
                deliverProductVoSet.addAll(products);
            }
            ArrayList<VehicleDistributionProduct> vehicleDistributionProducts = new ArrayList<VehicleDistributionProduct>();
            for (Object deliverProductVo : deliverProductVoSet) {
                VehicleDistributionProduct vehicleDistributionProduct = this.transDeliverGoodProductVoToDistributionProduct((DeliverProductVo)deliverProductVo, vehicleTask);
                vehicleDistributionProducts.add(vehicleDistributionProduct);
            }
            ArrayList<VehicleDistributionProduct> saveList = new ArrayList<VehicleDistributionProduct>();
            for (VehicleDistributionProduct product : vehicleDistributionProducts) {
                VehicleDistributionProduct oldProduct = saveList.stream().filter(o -> o.getProductSpecificationCode().equals(product.getProductSpecificationCode()) && o.getUnitCode().equals(product.getUnitCode())).findFirst().orElse(null);
                if (null != oldProduct) {
                    oldProduct.setQuantity(oldProduct.getQuantity().add(product.getQuantity()));
                    oldProduct.setRemainingQuantity(oldProduct.getRemainingQuantity().add(product.getRemainingQuantity()));
                    oldProduct.setSubtotalAmount(oldProduct.getSubtotalAmount().add(product.getSubtotalAmount()));
                    continue;
                }
                saveList.add(product);
            }
            this.vehicleDistributionProductService.batchSave(saveList);
            BigDecimal distributionProductSubtotalAmount = saveList.stream().map(VehicleDistributionProduct::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            vehicleTask.setVehicleLoadAmount(vehicleTask.getVehicleLoadAmount().add(distributionProductSubtotalAmount));
            this.vehicleTaskRepository.save((Object)vehicleTask);
        }
    }

    private VehicleDistributionProduct transExpenseProductVoToDistributionProduct(WarehouseExpenseProductVo warehouseExpenseProductVo, VehicleTask vehicleTask) {
        Validate.isTrue((warehouseExpenseProductVo.getQuantity().compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0", (Object[])new Object[0]);
        VehicleDistributionProduct vehicleDistributionProduct = (VehicleDistributionProduct)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)warehouseExpenseProductVo, VehicleDistributionProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        vehicleDistributionProduct.setFileName(warehouseExpenseProductVo.getMainImageName());
        vehicleDistributionProduct.setRelativePath(warehouseExpenseProductVo.getMainImagePath());
        vehicleDistributionProduct.setPurchasePrice(warehouseExpenseProductVo.getUnitPrice());
        vehicleDistributionProduct.setSubtotalAmount(vehicleDistributionProduct.getPurchasePrice().multiply(vehicleDistributionProduct.getQuantity()).setScale(4, RoundingMode.HALF_UP));
        vehicleDistributionProduct.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        vehicleDistributionProduct.setVehicleCode(vehicleTask.getVehicleCode());
        vehicleDistributionProduct.setRemainingQuantity(vehicleDistributionProduct.getQuantity());
        vehicleDistributionProduct.setId(null);
        return vehicleDistributionProduct;
    }

    private VehicleDistributionProductVo transExpenseProductVoToDistributionProductVo(WarehouseExpenseProductVo warehouseExpenseProductVo, OutwardPlan plan) {
        Validate.isTrue((warehouseExpenseProductVo.getQuantity().compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0", (Object[])new Object[0]);
        VehicleDistributionProductVo vehicleDistributionProductVo = (VehicleDistributionProductVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)warehouseExpenseProductVo, VehicleDistributionProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        vehicleDistributionProductVo.setFileName(warehouseExpenseProductVo.getMainImageName());
        vehicleDistributionProductVo.setRelativePath(warehouseExpenseProductVo.getMainImagePath());
        vehicleDistributionProductVo.setPurchasePrice(warehouseExpenseProductVo.getUnitPrice());
        vehicleDistributionProductVo.setSubtotalAmount(vehicleDistributionProductVo.getPurchasePrice().multiply(vehicleDistributionProductVo.getQuantity()).setScale(4, RoundingMode.HALF_UP));
        vehicleDistributionProductVo.setVehicleCode(plan.getVehicleCode());
        vehicleDistributionProductVo.setRemainingQuantity(vehicleDistributionProductVo.getQuantity());
        vehicleDistributionProductVo.setId(null);
        Boolean aBoolean = this.warehouseActionService.validateStock(vehicleDistributionProductVo.getProductSpecificationCode(), plan.getWarehouseCode(), vehicleDistributionProductVo.getQuantity(), vehicleDistributionProductVo.getUnitCode());
        Validate.isTrue((null != aBoolean && aBoolean != false ? 1 : 0) != 0, (String)("\u5546\u54c1\u7f16\u53f7" + vehicleDistributionProductVo.getProductCode() + "\u5728\u4ed3\u5e93" + plan.getWarehouseCode() + "\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3"), (Object[])new Object[0]);
        return vehicleDistributionProductVo;
    }

    @Override
    public void updateVehicleTaskStatusByVehicleTaskCode(String vehicleTaskCode, Integer vehicleTaskStatus) {
        Validate.notBlank((CharSequence)vehicleTaskCode, (String)"\u66f4\u6539\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u65f6\uff0c\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        this.vehicleTaskRepository.updateTaskStatusByTaskCodeAndTenantCode(vehicleTaskCode, vehicleTaskStatus, TenantUtils.getTenantCode());
    }

    @Override
    public VehicleTask findVehicleTaskByVehicleCode(String vehicleCode) {
        if (StringUtils.isEmpty((CharSequence)vehicleCode)) {
            return null;
        }
        return this.vehicleTaskRepository.findByVehicleCodeAndTaskStatus(vehicleCode, VehicleTaskStatusEnum.VEHICLE_DRIVING.getType(), TenantUtils.getTenantCode());
    }

    @Override
    public VehicleTask findVehicleTaskByDriving(String vehicleCode) {
        if (StringUtils.isEmpty((CharSequence)vehicleCode)) {
            return null;
        }
        return this.vehicleTaskRepository.findVehicleTaskByDriving(vehicleCode, TenantUtils.getTenantCode());
    }

    private VehiclePickUpLoad transformVehicleTaskToVehiclePickUpLoad(VehicleTask vehicleTask) {
        VehiclePickUpLoad vehiclePickUpLoad = new VehiclePickUpLoad();
        vehiclePickUpLoad.setVehiclePickUpLoadStatus(VehiclePickUpLoadStatusEnum.WAIT_LOAD.getType());
        vehiclePickUpLoad.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        vehiclePickUpLoad.setVehicleCode(vehicleTask.getVehicleCode());
        vehiclePickUpLoad.setVehicleName(vehicleTask.getVehicleName());
        vehiclePickUpLoad.setWarehouseCode(vehicleTask.getWarehouseCode());
        vehiclePickUpLoad.setWarehouseName(vehicleTask.getWarehouseName());
        VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
        vehiclePickUpLoad.setSaleManAccount(vehicleSaleMan.getUserAccount());
        vehiclePickUpLoad.setSaleManName(vehicleSaleMan.getUserName());
        vehiclePickUpLoad.setLoadTime(null);
        vehiclePickUpLoad.setRemark(vehicleTask.getRemark());
        return vehiclePickUpLoad;
    }

    private VehicleReturn transformVehicleTaskToVehicleReturn(VehicleTask vehicleTask, String transferOrderCode) {
        VehicleReturn vehicleReturn = new VehicleReturn();
        vehicleReturn.setVehicleReturnStatus(VehicleReturnStatusEnum.WAIT_LAUNCH.getType());
        vehicleReturn.setTransferOrderCode(transferOrderCode);
        vehicleReturn.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        vehicleReturn.setVehicleCode(vehicleTask.getVehicleCode());
        vehicleReturn.setVehicleName(vehicleTask.getVehicleName());
        vehicleReturn.setWarehouseCode(vehicleTask.getWarehouseCode());
        vehicleReturn.setWarehouseName(vehicleTask.getWarehouseName());
        VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
        vehicleReturn.setSaleManAccount(vehicleSaleMan.getUserAccount());
        vehicleReturn.setSaleManName(vehicleSaleMan.getUserName());
        vehicleReturn.setLoadTime(new Date());
        vehicleReturn.setReturnTime(null);
        vehicleReturn.setRemark(null);
        return vehicleReturn;
    }

    private void saveVehicleProductStock(String vehicleCode, String vehicleTaskCode) {
        List<VehicleSalesProduct> salesProduct;
        ArrayList<VehicleProductStock> vehicleProductStockList = new ArrayList<VehicleProductStock>();
        List<VehicleDistributionProduct> distributionProduct = this.vehicleDistributionProductService.findByVehicleTaskCode(vehicleTaskCode);
        if (!CollectionUtils.isEmpty(distributionProduct)) {
            for (VehicleDistributionProduct vehicleDistributionProduct : distributionProduct) {
                VehicleProductStock vehicleProductStock = this.vehicleDistributionProductToVehicleProductStock(vehicleDistributionProduct);
                this.repeatProduct(vehicleProductStockList, vehicleProductStock);
            }
        }
        if (!CollectionUtils.isEmpty(salesProduct = this.vehicleSalesProductService.findByVehicleTaskCode(vehicleTaskCode))) {
            for (VehicleSalesProduct vehicleSalesProduct : salesProduct) {
                VehicleProductStock vehicleProductStock = this.vehicleVehicleSalesProductToVehicleProductStock(vehicleSalesProduct);
                this.repeatProduct(vehicleProductStockList, vehicleProductStock);
            }
        }
        this.vehicleProductStockService.batchSave(vehicleCode, vehicleProductStockList);
    }

    private void repeatProduct(List<VehicleProductStock> vehicleProductStockList, VehicleProductStock vehicleProductStock) {
        VehicleProductStock filterProductStock = vehicleProductStockList.stream().filter(product -> product.getProductCode().equals(vehicleProductStock.getProductCode()) && product.getProductSpecificationCode().equals(vehicleProductStock.getProductSpecificationCode()) && product.getUnitCode().equals(vehicleProductStock.getUnitCode()) && product.getVehicleProductType().equals(vehicleProductStock.getVehicleProductType())).findFirst().orElse(null);
        if (null == filterProductStock) {
            vehicleProductStockList.add(vehicleProductStock);
        } else {
            filterProductStock.setInventory(filterProductStock.getInventory().add(vehicleProductStock.getInventory()));
            filterProductStock.setUsableInventory(filterProductStock.getUsableInventory().add(vehicleProductStock.getUsableInventory()));
        }
    }

    private VehicleProductStock vehicleDistributionProductToVehicleProductStock(VehicleDistributionProduct vehicleDistributionProduct) {
        VehicleProductStock vehicleProductStock = new VehicleProductStock();
        vehicleProductStock.setVehicleProductType(VehicleProductTypeEnum.DISTRIBUTION.getType());
        vehicleProductStock.setProductCode(vehicleDistributionProduct.getProductCode());
        vehicleProductStock.setProductName(vehicleDistributionProduct.getProductName());
        vehicleProductStock.setBrandCode(vehicleDistributionProduct.getBrandCode());
        vehicleProductStock.setBrandName(vehicleDistributionProduct.getBrandName());
        vehicleProductStock.setCategoryCode(vehicleDistributionProduct.getCategoryCode());
        vehicleProductStock.setCategoryName(vehicleDistributionProduct.getCategoryName());
        vehicleProductStock.setProductSpecificationCode(vehicleDistributionProduct.getProductSpecificationCode());
        vehicleProductStock.setProductSpecificationName(vehicleDistributionProduct.getProductSpecificationName());
        vehicleProductStock.setRelativePath(vehicleDistributionProduct.getRelativePath());
        vehicleProductStock.setFileName(vehicleDistributionProduct.getFileName());
        vehicleProductStock.setBarCode(vehicleDistributionProduct.getBarCode());
        BigDecimal stockQuantity = this.vehicleProductStockService.conversionUnit(vehicleDistributionProduct.getProductSpecificationCode(), vehicleDistributionProduct.getQuantity(), vehicleDistributionProduct.getUnitCode());
        ProductUnitAndPriceFlatVo productUnitAndPrice = this.productUnitAndPriceService.findBasicBySpecificationCode(vehicleDistributionProduct.getProductSpecificationCode());
        Validate.isTrue((null != productUnitAndPrice ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5546\u54c1\u57fa\u672c\u5355\u4f4d\u5931\u8d25", (Object[])new Object[0]);
        vehicleProductStock.setUnitCode(productUnitAndPrice.getUnitCode());
        vehicleProductStock.setUnitName(productUnitAndPrice.getUnitName());
        vehicleProductStock.setInventory(stockQuantity);
        vehicleProductStock.setPreemptInventory(BigDecimal.ZERO);
        vehicleProductStock.setUsableInventory(stockQuantity);
        return vehicleProductStock;
    }

    private VehicleProductStock vehicleVehicleSalesProductToVehicleProductStock(VehicleSalesProduct vehicleSalesProduct) {
        VehicleProductStock vehicleProductStock = new VehicleProductStock();
        vehicleProductStock.setVehicleProductType(VehicleProductTypeEnum.VEHICLE_SALES.getType());
        vehicleProductStock.setProductCode(vehicleSalesProduct.getProductCode());
        vehicleProductStock.setProductName(vehicleSalesProduct.getProductName());
        vehicleProductStock.setBrandCode(vehicleSalesProduct.getBrandCode());
        vehicleProductStock.setBrandName(vehicleSalesProduct.getBrandName());
        vehicleProductStock.setCategoryCode(vehicleSalesProduct.getCategoryCode());
        vehicleProductStock.setCategoryName(vehicleSalesProduct.getCategoryName());
        vehicleProductStock.setProductSpecificationCode(vehicleSalesProduct.getProductSpecificationCode());
        vehicleProductStock.setProductSpecificationName(vehicleSalesProduct.getProductSpecificationName());
        vehicleProductStock.setRelativePath(vehicleSalesProduct.getRelativePath());
        vehicleProductStock.setFileName(vehicleSalesProduct.getFileName());
        vehicleProductStock.setBarCode(vehicleSalesProduct.getBarCode());
        BigDecimal stockQuantity = this.vehicleProductStockService.conversionUnit(vehicleSalesProduct.getProductSpecificationCode(), vehicleSalesProduct.getQuantity(), vehicleSalesProduct.getUnitCode());
        ProductUnitAndPriceFlatVo productUnitAndPrice = this.productUnitAndPriceService.findBasicBySpecificationCode(vehicleSalesProduct.getProductSpecificationCode());
        Validate.isTrue((null != productUnitAndPrice ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5546\u54c1\u57fa\u672c\u5355\u4f4d\u5931\u8d25", (Object[])new Object[0]);
        vehicleProductStock.setUnitCode(productUnitAndPrice.getUnitCode());
        vehicleProductStock.setUnitName(productUnitAndPrice.getUnitName());
        vehicleProductStock.setInventory(stockQuantity);
        vehicleProductStock.setPreemptInventory(BigDecimal.ZERO);
        vehicleProductStock.setUsableInventory(stockQuantity);
        return vehicleProductStock;
    }

    private WarehouseProductsEnterDto buildWarehouseProductsEnter(VehicleTask vehicleTask, VehicleUnload vehicleUnload) {
        WarehouseProductsEnterDto warehouseProductsEnterDto = new WarehouseProductsEnterDto();
        warehouseProductsEnterDto.setWarehouseCode(vehicleTask.getWarehouseCode());
        warehouseProductsEnterDto.setRelevanceCode(vehicleUnload.getVehicleUnloadCode());
        TenantInfo byCode = this.tenantInfoService.findByCode(TenantUtils.getTenantCode());
        Validate.notNull((Object)byCode, (String)"\u751f\u6210\u5165\u5e93\u5355\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01", (Object[])new Object[0]);
        warehouseProductsEnterDto.setSupplierCustomerCode(TenantUtils.getTenantCode());
        warehouseProductsEnterDto.setSupplierCustomerName(byCode.getTenantName());
        warehouseProductsEnterDto.setType(Integer.valueOf(4));
        HashSet<WarehouseProductsEnterProductDto> products = new HashSet<WarehouseProductsEnterProductDto>();
        for (VehicleUnloadProduct product : vehicleUnload.getProducts()) {
            WarehouseProductsEnterProductDto warehouseProductsEnterProductDto = new WarehouseProductsEnterProductDto();
            warehouseProductsEnterProductDto.setProductSpecificationCode(product.getProductSpecificationCode());
            warehouseProductsEnterProductDto.setUnitCode(product.getUnitCode());
            warehouseProductsEnterProductDto.setUnitName(product.getUnitName());
            warehouseProductsEnterProductDto.setPrice(product.getPurchasePrice());
            warehouseProductsEnterProductDto.setQuantity(product.getQuantity());
            warehouseProductsEnterProductDto.setRemark(null);
            warehouseProductsEnterProductDto.setType(Integer.valueOf(1));
            warehouseProductsEnterProductDto.setRelevanceDetailCode(vehicleUnload.getVehicleUnloadCode());
            products.add(warehouseProductsEnterProductDto);
        }
        warehouseProductsEnterDto.setProducts(products);
        return warehouseProductsEnterDto;
    }

    private VehicleLoad buildSalesVehicleLoad(VehicleTask vehicleTask, List<VehicleSalesProduct> salesProducts) {
        VehicleLoad vehicleLoad = new VehicleLoad();
        vehicleLoad.setVehicleLoadType(VehicleLoadTypeEnum.TRANSFER.getType());
        vehicleLoad.setVehicleProductType(VehicleProductTypeEnum.VEHICLE_SALES.getType());
        vehicleLoad.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        vehicleLoad.setCustomerCode(null);
        vehicleLoad.setCustomerName(null);
        VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
        if (null != vehicleSaleMan) {
            vehicleLoad.setSaleManAccount(vehicleSaleMan.getUserAccount());
            vehicleLoad.setSaleManName(vehicleSaleMan.getUserName());
        }
        vehicleLoad.setVehicleCode(vehicleTask.getVehicleCode());
        vehicleLoad.setVehicleName(vehicleTask.getVehicleName());
        vehicleLoad.setProducts(this.buildSalesVehicleLoadProduct(vehicleLoad, salesProducts));
        return vehicleLoad;
    }

    private Set<VehicleLoadProduct> buildSalesVehicleLoadProduct(VehicleLoad vehicleLoad, List<VehicleSalesProduct> salesProducts) {
        HashSet products = Sets.newHashSet();
        for (VehicleSalesProduct vehicleSalesProduct : salesProducts) {
            if (vehicleSalesProduct.getRemainingQuantity().compareTo(BigDecimal.ZERO) != 1) continue;
            VehicleLoadProduct product = new VehicleLoadProduct();
            product.setTenantCode(TenantUtils.getTenantCode());
            product.setVehicleLoad(vehicleLoad);
            product.setBarCode(vehicleSalesProduct.getBarCode());
            product.setProductCode(vehicleSalesProduct.getProductCode());
            product.setProductName(vehicleSalesProduct.getProductName());
            product.setProductSpecificationCode(vehicleSalesProduct.getProductSpecificationCode());
            product.setProductSpecificationName(vehicleSalesProduct.getProductSpecificationName());
            product.setPurchasePrice(vehicleSalesProduct.getPurchasePrice());
            product.setQuantity(vehicleSalesProduct.getQuantity());
            product.setSubtotalAmount(vehicleSalesProduct.getSubtotalAmount());
            product.setUnitCode(vehicleSalesProduct.getUnitCode());
            product.setUnitName(vehicleSalesProduct.getUnitName());
            product.setRelativePath(vehicleSalesProduct.getRelativePath());
            product.setFileName(vehicleSalesProduct.getFileName());
            products.add(product);
        }
        return products;
    }

    private VehicleLoad buildDistributionVehicleLoad(VehicleTask vehicleTask, List<VehicleDistributionProduct> distributionProducts) {
        VehicleLoad vehicleLoad = new VehicleLoad();
        vehicleLoad.setVehicleLoadType(VehicleLoadTypeEnum.TRANSFER.getType());
        vehicleLoad.setVehicleProductType(VehicleProductTypeEnum.DISTRIBUTION.getType());
        vehicleLoad.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        vehicleLoad.setCustomerCode(null);
        vehicleLoad.setCustomerName(null);
        VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
        if (null != vehicleSaleMan) {
            vehicleLoad.setSaleManAccount(vehicleSaleMan.getUserAccount());
            vehicleLoad.setSaleManName(vehicleSaleMan.getUserName());
        }
        vehicleLoad.setVehicleCode(vehicleTask.getVehicleCode());
        vehicleLoad.setVehicleName(vehicleTask.getVehicleName());
        vehicleLoad.setProducts(this.buildDistributionVehicleLoadProduct(vehicleLoad, distributionProducts));
        return vehicleLoad;
    }

    private Set<VehicleLoadProduct> buildDistributionVehicleLoadProduct(VehicleLoad vehicleLoad, List<VehicleDistributionProduct> distributionProducts) {
        HashSet products = Sets.newHashSet();
        for (VehicleDistributionProduct vehicleDistributionProduct : distributionProducts) {
            if (vehicleDistributionProduct.getRemainingQuantity().compareTo(BigDecimal.ZERO) != 1) continue;
            VehicleLoadProduct product = new VehicleLoadProduct();
            product.setTenantCode(TenantUtils.getTenantCode());
            product.setVehicleLoad(vehicleLoad);
            product.setBarCode(vehicleDistributionProduct.getBarCode());
            product.setProductCode(vehicleDistributionProduct.getProductCode());
            product.setProductName(vehicleDistributionProduct.getProductName());
            product.setProductSpecificationCode(vehicleDistributionProduct.getProductSpecificationCode());
            product.setProductSpecificationName(vehicleDistributionProduct.getProductSpecificationName());
            product.setPurchasePrice(vehicleDistributionProduct.getPurchasePrice());
            product.setQuantity(vehicleDistributionProduct.getQuantity());
            product.setSubtotalAmount(vehicleDistributionProduct.getSubtotalAmount());
            product.setUnitCode(vehicleDistributionProduct.getUnitCode());
            product.setUnitName(vehicleDistributionProduct.getUnitName());
            product.setRelativePath(vehicleDistributionProduct.getRelativePath());
            product.setFileName(vehicleDistributionProduct.getFileName());
            products.add(product);
        }
        return products;
    }

    private WarehouseProductsExpenseDto bulidWarehouseProductsExpense(VehicleTask vehicleTask, VehicleLoad vehicleLoad) {
        WarehouseProductsExpenseDto warehouseProductsExpenseDto = new WarehouseProductsExpenseDto();
        warehouseProductsExpenseDto.setWarehouseCode(vehicleTask.getWarehouseCode());
        warehouseProductsExpenseDto.setRelevanceCode(vehicleLoad.getVehicleLoadCode());
        warehouseProductsExpenseDto.setSupplierCustomerCode(TenantUtils.getTenantCode());
        warehouseProductsExpenseDto.setType(Integer.valueOf(4));
        warehouseProductsExpenseDto.setExpenseDate(new Date());
        warehouseProductsExpenseDto.setAgentUser(null);
        warehouseProductsExpenseDto.setRemark(null);
        ArrayList<WarehouseProductsExpenseProductDto> expenseProducts = new ArrayList<WarehouseProductsExpenseProductDto>();
        for (VehicleLoadProduct product : vehicleLoad.getProducts()) {
            WarehouseProductsExpenseProductDto warehouseProductsExpenseProductDto = new WarehouseProductsExpenseProductDto();
            warehouseProductsExpenseProductDto.setProductSpecificationCode(product.getProductSpecificationCode());
            warehouseProductsExpenseProductDto.setQuantity(product.getQuantity());
            warehouseProductsExpenseProductDto.setRemark(null);
            warehouseProductsExpenseProductDto.setOrderQuantity(null);
            warehouseProductsExpenseProductDto.setUnitCode(product.getUnitCode());
            warehouseProductsExpenseProductDto.setUnitName(product.getUnitName());
            warehouseProductsExpenseProductDto.setUnitPrice(product.getPurchasePrice());
            warehouseProductsExpenseProductDto.setOrderProductId(null);
            expenseProducts.add(warehouseProductsExpenseProductDto);
        }
        warehouseProductsExpenseDto.setExpenseProducts(expenseProducts);
        return warehouseProductsExpenseDto;
    }

    private VehicleUnload buildVehicleStockVehicleUnload(VehicleTask vehicleTask, List<VehicleProductStockVo> vehicleProductStocks, Integer productType) {
        VehicleUnload vehicleUnload = new VehicleUnload();
        vehicleUnload.setVehicleUnloadType(VehicleUnloadTypeEnum.RETURN.getType());
        vehicleUnload.setVehicleProductType(productType);
        vehicleUnload.setVehicleUnloadStatus(VehicleUnloadStatusEnum.DELIVERY.getType());
        vehicleUnload.setVehicleUnloadTime(new Date());
        vehicleUnload.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        vehicleUnload.setCustomerCode(null);
        vehicleUnload.setCustomerName(null);
        VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
        if (null != vehicleSaleMan) {
            vehicleUnload.setSaleManAccount(vehicleSaleMan.getUserAccount());
            vehicleUnload.setSaleManName(vehicleSaleMan.getUserName());
        }
        vehicleUnload.setVehicleCode(vehicleTask.getVehicleCode());
        vehicleUnload.setVehicleName(vehicleTask.getVehicleName());
        vehicleUnload.setProducts(this.buildVehicleStockProductVehicleUnloadProduct(vehicleUnload, vehicleProductStocks));
        return vehicleUnload;
    }

    private Set<VehicleUnloadProduct> buildVehicleStockProductVehicleUnloadProduct(VehicleUnload vehicleUnload, List<VehicleProductStockVo> vehicleProductStocks) {
        HashSet products = Sets.newHashSet();
        List productCodes = vehicleProductStocks.stream().map(VehicleProductStockVo::getProductCode).distinct().collect(Collectors.toList());
        List productSet = this.productFlatService.findByProductCodeList(productCodes, TenantUtils.getTenantCode());
        Map map = productSet.stream().collect(Collectors.toMap(ProductFlatVo::getProductCode, Function.identity()));
        for (VehicleProductStockVo vehicleProductStockVo : vehicleProductStocks) {
            if (0 == vehicleProductStockVo.getInventory().compareTo(BigDecimal.ZERO)) continue;
            VehicleUnloadProduct product = new VehicleUnloadProduct();
            product.setTenantCode(TenantUtils.getTenantCode());
            product.setVehicleUnload(vehicleUnload);
            product.setBarCode(vehicleProductStockVo.getBarCode());
            product.setProductCode(vehicleProductStockVo.getProductCode());
            product.setProductName(vehicleProductStockVo.getProductName());
            product.setProductSpecificationCode(vehicleProductStockVo.getProductSpecificationCode());
            product.setProductSpecificationName(vehicleProductStockVo.getProductSpecificationName());
            product.setQuantity(vehicleProductStockVo.getInventory());
            ProductUnitAndPriceFlatVo productUnitAndPrice = this.productUnitAndPriceService.findBySpecificationCodeAndUnitCode(vehicleProductStockVo.getProductSpecificationCode(), vehicleProductStockVo.getUnitCode());
            if (null != productUnitAndPrice) {
                product.setPurchasePrice(productUnitAndPrice.getReferencePurchasePrice());
                product.setSubtotalAmount(productUnitAndPrice.getReferencePurchasePrice().multiply(vehicleProductStockVo.getInventory()));
            } else {
                product.setPurchasePrice(BigDecimal.ZERO);
                product.setSubtotalAmount(BigDecimal.ZERO);
            }
            if (map.containsKey(vehicleProductStockVo.getProductCode())) {
                ProductFlatVo productData = (ProductFlatVo)map.get(vehicleProductStockVo.getProductCode());
                Set productSpecifications = productData.getProductSpecifications();
                for (ProductSpecificationFlatVo productSpecification : productSpecifications) {
                    if (!StringUtils.equals((CharSequence)vehicleProductStockVo.getProductSpecificationCode(), (CharSequence)productSpecification.getProductSpecificationCode())) continue;
                    vehicleProductStockVo.setRelativePath(productSpecification.getMainImagePath());
                    vehicleProductStockVo.setFileName(productSpecification.getMainImageName());
                    break;
                }
            }
            product.setUnitCode(vehicleProductStockVo.getUnitCode());
            product.setUnitName(vehicleProductStockVo.getUnitName());
            product.setRelativePath(vehicleProductStockVo.getRelativePath());
            product.setFileName(vehicleProductStockVo.getFileName());
            products.add(product);
        }
        return products;
    }

    @Override
    public void checkVehicleTaskDeliverGood(List<String> deliverGoodCodeList) {
        List<VehicleTaskExpenseMapping> expenseMappingList = this.vehicleTaskExpenseMappingService.findByDeliverGoodCodes(deliverGoodCodeList);
        if (!CollectionUtils.isEmpty(expenseMappingList = expenseMappingList.stream().filter(item -> !DistributionStatusEnum.CANCEL.getType().equals(item.getDistributionStatus())).collect(Collectors.toList()))) {
            StringBuffer s = new StringBuffer("\u51fa\u8f66\u4efb\u52a1\u6dfb\u52a0\u53d1\u8d27\u5355\u65f6,");
            for (VehicleTaskExpenseMapping vehicleTaskExpenseMapping : expenseMappingList) {
                s.append("(\u53d1\u8d27\u5355" + vehicleTaskExpenseMapping.getDeliverGoodCode() + "\u5df2\u5b58\u5728\u4e8e\u51fa\u8f66\u4efb\u52a1").append(vehicleTaskExpenseMapping.getVehicleTaskCode()).append("\u4e2d)");
            }
            throw new IllegalArgumentException(s.toString());
        }
    }

    @Override
    public List<Vehicle> findVehicleByUserAccount(String userAccount) {
        if (StringUtils.isEmpty((CharSequence)userAccount)) {
            return Lists.newArrayList();
        }
        List<Object> list = new ArrayList<Vehicle>();
        List<String> vehicleCodeList = this.vehicleTaskRepository.findByUserAccountAndDriving(userAccount, TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(vehicleCodeList)) {
            list = this.vehicleService.findByVehicleCodes(vehicleCodeList);
        }
        return list;
    }

    @Override
    public Page<WarehouseProductsExpense> findExpenseByConditions(String routeCode, String warehouseCode, Pageable pageable, InvokeParams conditions) {
        if (StringUtils.isBlank((CharSequence)routeCode) || StringUtils.isBlank((CharSequence)warehouseCode) || null == conditions) {
            return Page.empty((Pageable)pageable);
        }
        DistributionRouteDetailVo detailsByCode = this.distributionRouteService.findDetailsByCode(routeCode);
        if (null == detailsByCode || CollectionUtils.isEmpty(detailsByCode.getCustomers())) {
            return Page.empty((Pageable)pageable);
        }
        List<DistributionRouteCustomerVo> customers = detailsByCode.getCustomers();
        List customerCodeList = customers.stream().map(DistributionRouteCustomerVo::getCustomerCode).collect(Collectors.toList());
        OrderInfoConditionDto orderInfoConditionDto = new OrderInfoConditionDto();
        orderInfoConditionDto.setCustomerCodes(customerCodeList);
        orderInfoConditionDto.setOrderType(Integer.valueOf(1));
        orderInfoConditionDto.setDeliveryStatus((List)Lists.newArrayList((Object[])new Integer[]{1, 2}));
        Page orderPage = this.orderInfoVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE), orderInfoConditionDto);
        if (CollectionUtils.isEmpty((Collection)orderPage.getContent())) {
            return Page.empty((Pageable)pageable);
        }
        List orderCodes = orderPage.getContent().stream().map(OrderInfoVo::getOrderCode).collect(Collectors.toList());
        List<String> expenseCodesNot = this.vehicleTaskRepository.findByDriving(VehicleTaskStatusEnum.VEHICLE_RETURN.getType(), VehicleTaskStatusEnum.CANCEL.getType(), TenantUtils.getTenantCode());
        conditions.putInvokeParam("warehouseCode", (Object)warehouseCode);
        conditions.putInvokeParam("relevanceCodes", orderCodes);
        conditions.putInvokeParam("expenseCodesNot", expenseCodesNot);
        conditions.putInvokeParam("state", (Object)"1");
        return this.warehouseProductsExpenseService.findByConditions(pageable, conditions);
    }

    @Override
    public Page<DeliverGoodVo> findDeliverGoodByConditions(String routeCode, String warehouseCode, String deliverGoodCode, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)routeCode) || StringUtils.isBlank((CharSequence)warehouseCode)) {
            return Page.empty((Pageable)pageable);
        }
        DistributionRouteDetailVo detailsByCode = this.distributionRouteService.findDetailsByCode(routeCode);
        if (null == detailsByCode || CollectionUtils.isEmpty(detailsByCode.getCustomers())) {
            return Page.empty((Pageable)pageable);
        }
        List<DistributionRouteCustomerVo> customers = detailsByCode.getCustomers();
        List customerCodeList = customers.stream().map(DistributionRouteCustomerVo::getCustomerCode).collect(Collectors.toList());
        OrderInfoConditionDto orderInfoConditionDto = new OrderInfoConditionDto();
        orderInfoConditionDto.setCustomerCodes(customerCodeList);
        orderInfoConditionDto.setOrderType(Integer.valueOf(1));
        Page orderPage = this.orderInfoVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE), orderInfoConditionDto);
        if (CollectionUtils.isEmpty((Collection)orderPage.getContent())) {
            return Page.empty((Pageable)pageable);
        }
        List orderCodes = orderPage.getContent().stream().map(OrderInfoVo::getOrderCode).collect(Collectors.toList());
        DeliverGoodDto deliverGoodDto = new DeliverGoodDto();
        deliverGoodDto.setDeliverStatus(DeliverStatus.WAIT_DELIVER.getType());
        deliverGoodDto.setWarehouseCode(warehouseCode);
        deliverGoodDto.setOrderCodes(orderCodes);
        deliverGoodDto.setDeliverWay(DeliverWay.DISTRIBUTION.getType());
        deliverGoodDto.setDeliverGoodCode(deliverGoodCode);
        deliverGoodDto.setPlan(Boolean.valueOf(false));
        deliverGoodDto.setNotDeliverWay(DeliverWay.SELF_EXTRACTION.getType());
        return this.deliverGoodVoService.findByConditions(pageable, deliverGoodDto);
    }

    @Override
    public Page<ProductSpecificationVo> findProductByConditions(String warehouseCode, Pageable pageable, InvokeParams conditions) {
        if (StringUtils.isBlank((CharSequence)warehouseCode) || null == conditions) {
            return Page.empty((Pageable)pageable);
        }
        Set warehouseProducts = this.warehouseProductService.findByWarehouseCode(warehouseCode);
        if (CollectionUtils.isEmpty((Collection)warehouseProducts)) {
            return Page.empty((Pageable)pageable);
        }
        Set specificationCodes = warehouseProducts.stream().filter(e -> e.getInventory().compareTo(BigDecimal.ZERO) > 0).map(WarehouseProduct::getProductSpecificationCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(specificationCodes)) {
            return Page.empty((Pageable)pageable);
        }
        String productSpecificationCodes = StringUtils.join(specificationCodes, (String)",");
        conditions.putInvokeParam("productCodeList", (Object)productSpecificationCodes);
        conditions.putInvokeParam("warehouseCode", (Object)warehouseCode);
        return this.productSpecificationVoService.findByConditions(pageable, conditions);
    }

    @Override
    public List<WarehouseExpenseProductVo> findByExpenseCodeList(List<String> expenseCodeList) {
        ArrayList<WarehouseExpenseProductVo> warehouseExpenseProductVos = new ArrayList<WarehouseExpenseProductVo>();
        if (CollectionUtils.isEmpty(expenseCodeList)) {
            return warehouseExpenseProductVos;
        }
        List byExpenseCodeList = this.warehouseProductsExpenseService.findByExpenseCodeList(expenseCodeList);
        for (WarehouseProductsExpense warehouseProductsExpense : byExpenseCodeList) {
            for (WarehouseProductsExpenseProduct expenseProduct : warehouseProductsExpense.getExpenseProducts()) {
                WarehouseExpenseProductVo warehouseExpenseProductVo = (WarehouseExpenseProductVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)expenseProduct, WarehouseExpenseProductVo.class, HashSet.class, ArrayList.class, new String[0]));
                warehouseExpenseProductVos.add(warehouseExpenseProductVo);
            }
        }
        if (!CollectionUtils.isEmpty(warehouseExpenseProductVos)) {
            List productCodes = warehouseExpenseProductVos.stream().map(WarehouseExpenseProductVo::getProductCode).distinct().collect(Collectors.toList());
            List productSet = this.productFlatService.findByProductCodeList(productCodes, TenantUtils.getTenantCode());
            Map map = productSet.stream().collect(Collectors.toMap(ProductFlatVo::getProductCode, Function.identity()));
            for (WarehouseExpenseProductVo warehouseExpenseProductVo : warehouseExpenseProductVos) {
                if (!map.containsKey(warehouseExpenseProductVo.getProductCode())) continue;
                ProductFlatVo product = (ProductFlatVo)map.get(warehouseExpenseProductVo.getProductCode());
                warehouseExpenseProductVo.setBrandCode(product.getBrandCode());
                warehouseExpenseProductVo.setBrandName(product.getBrandName());
                warehouseExpenseProductVo.setCategoryCode(product.getCategoryCode());
                warehouseExpenseProductVo.setCategoryName(product.getCategoryName());
            }
        }
        return warehouseExpenseProductVos;
    }

    @Override
    public List<DeliverGoodProductVo> findBydeliverGoodCodeList(List<String> deliverGoodCodeList) {
        ArrayList<DeliverGoodProductVo> deliverGoodProductVos = new ArrayList<DeliverGoodProductVo>();
        if (CollectionUtils.isEmpty(deliverGoodCodeList)) {
            return deliverGoodProductVos;
        }
        List deliverGoodVos = this.deliverGoodVoService.findByDeliverGoodCodes(deliverGoodCodeList);
        for (DeliverGoodVo deliverGoodVo : deliverGoodVos) {
            for (DeliverProductVo product : deliverGoodVo.getProducts()) {
                DeliverGoodProductVo deliverGoodProductVo = (DeliverGoodProductVo)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)product, DeliverGoodProductVo.class, HashSet.class, ArrayList.class, new String[0]));
                deliverGoodProductVo.setQuantity(product.getDeliverQuantity());
                deliverGoodProductVo.setMainImagePath(product.getRelativePath());
                deliverGoodProductVo.setMainImageName(product.getFileName());
                deliverGoodProductVos.add(deliverGoodProductVo);
            }
        }
        if (!CollectionUtils.isEmpty(deliverGoodProductVos)) {
            List productCodes = deliverGoodProductVos.stream().map(DeliverGoodProductVo::getProductCode).distinct().collect(Collectors.toList());
            List productSet = this.productFlatService.findByProductCodeList(productCodes, TenantUtils.getTenantCode());
            Map map = productSet.stream().collect(Collectors.toMap(ProductFlatVo::getProductCode, Function.identity()));
            for (DeliverGoodProductVo deliverGoodProductVo : deliverGoodProductVos) {
                if (!map.containsKey(deliverGoodProductVo.getProductCode())) continue;
                ProductFlatVo product = (ProductFlatVo)map.get(deliverGoodProductVo.getProductCode());
                deliverGoodProductVo.setBrandCode(product.getBrandCode());
                deliverGoodProductVo.setBrandName(product.getBrandName());
                deliverGoodProductVo.setCategoryCode(product.getCategoryCode());
                deliverGoodProductVo.setCategoryName(product.getCategoryName());
            }
        }
        return deliverGoodProductVos;
    }

    @Override
    public List<VehicleTask> findVehicleTaskByRouteCode(String routeCode) {
        if (StringUtils.isEmpty((CharSequence)routeCode)) {
            return Lists.newArrayList();
        }
        return this.vehicleTaskRepository.findVehicleTaskByRouteCodeAndTenantCode(routeCode, TenantUtils.getTenantCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void autoCreateByOutwardPlan(String planCode, String appCode, String tenantCode) {
        Validate.isTrue((!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{planCode, tenantCode}) ? 1 : 0) != 0, (String)"\u5b9a\u65f6\u4efb\u52a1\u81ea\u52a8\u751f\u6210\u51fa\u8f66\u8ba1\u5212\u65f6\uff0c\u5fc5\u8981\u7f16\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            TenantContextHolder.setTenant((String)tenantCode);
        }
        try {
            OutwardPlan plan = this.outwardPlanService.findDetailsByCode(planCode);
            Validate.notNull((Object)((Object)plan), (String)"\u6839\u636e\u51fa\u8f66\u8ba1\u5212\u7f16\u7801\u3010%s\u3011,\u672a\u80fd\u67e5\u8be2\u5230\u76f8\u5173\u8ba1\u5212\u4fe1\u606f", (Object[])new Object[]{planCode});
            DistributionRoute route = plan.getRoute();
            Validate.notNull((Object)((Object)route), (String)"\u51fa\u8f66\u8ba1\u5212\u3010%s\u3011\u7684\u8def\u7ebf\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{planCode});
            Vehicle vehicle = this.vehicleService.findByVehicleCode(plan.getVehicleCode());
            if (!vehicle.getVehicleTransportStatus().equals(VehicleTransportStatusEnum.VACANT.getType())) {
                LOGGER.warn("\u5f53\u524d\u5b9a\u65f6\u4efb\u52a1\u3010{}\u3011\u5df2\u6267\u884c\uff0c\u4f46\u8f66\u8f86\u4e0d\u662f\u7a7a\u7f6e\u72b6\u6001\uff0c\u51fa\u8f66\u4efb\u52a1\u6ca1\u6709\u751f\u6210\uff01", (Object)planCode);
                return;
            }
            Page<WarehouseProductsExpense> warehouseProductsExpensePage = this.findExpenseByConditions(route.getCode(), plan.getWarehouseCode(), (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE), new InvokeParams());
            if (CollectionUtils.isEmpty((Collection)warehouseProductsExpensePage.getContent())) {
                LOGGER.warn("\u5f53\u524d\u5b9a\u65f6\u4efb\u52a1\u3010{}\u3011\u5df2\u6267\u884c\uff0c\u4f46\u672a\u5339\u914d\u5230\u5f85\u53d1\u8d27\u51fa\u5e93\u5355\u4fe1\u606f\uff0c\u51fa\u8f66\u4efb\u52a1\u6ca1\u6709\u751f\u6210\uff01", (Object)planCode);
                return;
            }
            List warehouseProductsExpenses = warehouseProductsExpensePage.getContent();
            Set<WarehouseProductsExpense> filterResult = this.filterWarehouseProductsExpenses(plan, warehouseProductsExpenses);
            if (CollectionUtils.isEmpty(filterResult)) {
                LOGGER.warn("\u5f53\u524d\u5b9a\u65f6\u4efb\u52a1\u3010{}\u3011\u5df2\u6267\u884c\uff0c\u4f46\u672a\u80fd\u53d1\u73b0\u6ee1\u8db3\u8981\u6c42\u7684\u51fa\u5e93\u5355\u4fe1\u606f\uff0c\u51fa\u8f66\u4efb\u52a1\u6ca1\u6709\u751f\u6210\uff01", (Object)planCode);
                return;
            }
            VehicleTaskVo task = this.buildVehicleTaskVo(plan, filterResult);
            this.vehicleTaskVoService.create(task);
        }
        finally {
            TenantContextHolder.setTenant(null);
        }
    }

    private VehicleTaskVo buildVehicleTaskVo(OutwardPlan plan, Set<WarehouseProductsExpense> filterResult) {
        VehicleTaskVo task = new VehicleTaskVo();
        task.setOutwardPlanCode(plan.getCode());
        task.setVehicleTaskStatus(VehicleTaskStatusEnum.WAIT_CONFIRM.getType());
        task.setRouteCode(plan.getRoute().getCode());
        task.setRouteName(plan.getRoute().getName());
        task.setVehicleCode(plan.getVehicleCode());
        task.setVehicleName(plan.getVehicleName());
        task.setCarNumber(plan.getVehicleNumber());
        task.setWarehouseCode(plan.getWarehouseCode());
        task.setWarehouseName(plan.getWarehouseName());
        task.setTaskTime(new Date());
        task.setSaleOrderQuantity(BigDecimal.ZERO);
        task.setSettlementStatus(SettlementStatusEnum.WAIT_SETTLEMENT.getType());
        ArrayList saleManVos = Lists.newArrayList();
        VehicleSaleManVo manVo = new VehicleSaleManVo();
        manVo.setUserAccount(plan.getLeaderAccount());
        manVo.setUserName(plan.getLeaderName());
        manVo.setPhone(plan.getLeaderPhone());
        manVo.setHead(true);
        manVo.setTenantCode(TenantUtils.getTenantCode());
        saleManVos.add(manVo);
        task.setSaleManVos(saleManVos);
        Collection expenseVoCollection = this.nebulaToolkitService.copyCollectionByBlankList(filterResult, WarehouseProductsExpense.class, VehicleTaskExpenseVo.class, LinkedHashSet.class, ArrayList.class, new String[]{""});
        List<WarehouseExpenseProductVo> warehouseExpenseProductVoList = this.findByExpenseCodeList(expenseVoCollection.stream().map(VehicleTaskExpenseVo::getExpenseCode).collect(Collectors.toList()));
        ArrayList<VehicleDistributionProductVo> vehicleDistributionProducts = new ArrayList<VehicleDistributionProductVo>();
        for (WarehouseExpenseProductVo warehouseExpenseProductVo : warehouseExpenseProductVoList) {
            VehicleDistributionProductVo vehicleDistributionProductVo = this.transExpenseProductVoToDistributionProductVo(warehouseExpenseProductVo, plan);
            vehicleDistributionProducts.add(vehicleDistributionProductVo);
        }
        task.setVehicleDistributionProductVos(vehicleDistributionProducts);
        return task;
    }

    private Set<WarehouseProductsExpense> filterWarehouseProductsExpenses(OutwardPlan plan, List<WarehouseProductsExpense> warehouseProductsExpenses) {
        Date now = new Date();
        OutwardPlanFrequency frequency = plan.getPlanFrequency();
        Validate.notNull((Object)((Object)frequency), (String)"\u4efb\u52a1\u9891\u7387\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer eachNum = frequency.getEachNum();
        Validate.notNull((Object)eachNum, (String)"\u4efb\u52a1\u9891\u7387\u5468\u671f\u7684\u6bcf\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return warehouseProductsExpenses.stream().filter(e -> {
            if (eachNum > 1) {
                Date minDate = DateUtils.addDays((Date)now, (int)(-(eachNum - 1)));
                return DateUtils.truncatedCompareTo((Date)e.getDeliveryTime(), (Date)minDate, (int)5) >= 0 && DateUtils.truncatedCompareTo((Date)now, (Date)e.getDeliveryTime(), (int)5) <= 0;
            }
            return DateUtils.isSameDay((Date)now, (Date)e.getDeliveryTime());
        }).collect(Collectors.toSet());
    }

    private void updateDeliverGoodByVehicleTask(VehicleTask vehicleTask) {
        List<VehicleTaskExpenseMapping> vehicleTaskMapping = this.vehicleTaskExpenseMappingService.findByVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        if (!CollectionUtils.isEmpty(vehicleTaskMapping)) {
            List deliverGoodCodes = vehicleTaskMapping.stream().map(VehicleTaskExpenseMapping::getDeliverGoodCode).collect(Collectors.toList());
            DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
            deliverUpdateVo.setDeliverGoodCodes(deliverGoodCodes);
            deliverUpdateVo.setOldDeliverStatus(DeliverStatus.WAIT_DELIVER.getType());
            deliverUpdateVo.setDeliverStatus(DeliverStatus.ALREADY_DELIVER.getType());
            deliverUpdateVo.setTenantCode(TenantUtils.getTenantCode());
            deliverUpdateVo.setCarNumber(vehicleTask.getCarNumber());
            deliverUpdateVo.setRouteCode(vehicleTask.getRouteCode());
            deliverUpdateVo.setDeliverTime(new Date());
            DistributionRoute distributionRoute = this.distributionRouteService.findByCode(vehicleTask.getRouteCode());
            if (null != distributionRoute) {
                deliverUpdateVo.setRouteName(distributionRoute.getName());
            }
            deliverUpdateVo.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
            VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
            if (null != vehicleSaleMan) {
                deliverUpdateVo.setSaleManAccount(vehicleSaleMan.getUserAccount());
                deliverUpdateVo.setSaleManName(vehicleSaleMan.getUserName());
            }
            deliverUpdateVo.setNoticeVehicleTask(Boolean.valueOf(false));
            this.deliverGoodService.batchUpdateStatusByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
        }
    }

    private VehicleDistributionProduct transDeliverGoodProductVoToDistributionProduct(DeliverProductVo deliverProductVo, VehicleTask vehicleTask) {
        Validate.isTrue((deliverProductVo.getDeliverQuantity().compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0", (Object[])new Object[0]);
        VehicleDistributionProduct vehicleDistributionProduct = (VehicleDistributionProduct)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)deliverProductVo, VehicleDistributionProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        vehicleDistributionProduct.setTenantCode(vehicleTask.getTenantCode());
        vehicleDistributionProduct.setCreateAccount(vehicleTask.getCreateAccount());
        vehicleDistributionProduct.setModifyAccount(vehicleTask.getModifyAccount());
        vehicleDistributionProduct.setFileName(deliverProductVo.getFileName());
        vehicleDistributionProduct.setQuantity(deliverProductVo.getDeliverQuantity());
        vehicleDistributionProduct.setRelativePath(deliverProductVo.getRelativePath());
        vehicleDistributionProduct.setPurchasePrice(deliverProductVo.getUnitPrice());
        vehicleDistributionProduct.setSubtotalAmount(deliverProductVo.getUnitPrice().multiply(deliverProductVo.getDeliverQuantity()).setScale(4, RoundingMode.HALF_UP));
        vehicleDistributionProduct.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        vehicleDistributionProduct.setVehicleCode(vehicleTask.getVehicleCode());
        vehicleDistributionProduct.setRemainingQuantity(deliverProductVo.getDeliverQuantity());
        vehicleDistributionProduct.setId(null);
        vehicleDistributionProduct.setBarCode(deliverProductVo.getBarCode());
        return vehicleDistributionProduct;
    }
}

