/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.internal.vehicle;

import com.bizunited.empower.business.distribution.service.DeliverGoodService;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.distribution.vo.DeliverGoodVo;
import com.bizunited.empower.business.distribution.vo.DeliverProductVo;
import com.bizunited.empower.business.distribution.vo.DeliverUpdateVo;
import com.bizunited.empower.business.sales.dto.VehicleTaskDto;
import com.bizunited.empower.business.sales.entity.outward.DistributionRoute;
import com.bizunited.empower.business.sales.entity.outward.DistributionRouteCustomer;
import com.bizunited.empower.business.sales.entity.outward.OutwardPlan;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleDistributionProduct;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleSaleMan;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleSalesProduct;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTaskExpenseMapping;
import com.bizunited.empower.business.sales.enums.vehicle.DistributionStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskStatusEnum;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskWayEnum;
import com.bizunited.empower.business.sales.repository.vehicle.VehicleTaskRepository;
import com.bizunited.empower.business.sales.repository.vehicle.internal.VehicleTaskRepositoryCustom;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteService;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleDistributionProductService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleSaleManService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleSalesProductService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskExpenseMappingService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskVoService;
import com.bizunited.empower.business.sales.vo.DistributionRouteCustomerVo;
import com.bizunited.empower.business.sales.vo.DistributionRouteDetailVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleDistributionProductVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleSaleManVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleSalesProductVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleTaskDeliverGoodVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleTaskPanelVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleTaskVehicleVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleTaskVo;
import com.bizunited.empower.business.vehicle.dto.VehicleProductStockDto;
import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.empower.business.vehicle.enums.VehicleTransportStatusEnum;
import com.bizunited.empower.business.vehicle.service.VehicleProductStockService;
import com.bizunited.empower.business.vehicle.service.VehicleProductStockVoService;
import com.bizunited.empower.business.vehicle.service.VehicleService;
import com.bizunited.empower.business.vehicle.vo.VehicleProductStockVo;
import com.bizunited.empower.business.vehicle.vo.VehicleTransformProductTypeProductVo;
import com.bizunited.empower.business.vehicle.vo.VehicleTransformProductTypeVo;
import com.bizunited.empower.business.warehouse.service.WarehouseActionService;
import com.bizunited.platform.common.constant.Constants;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.user2.enums.OrganizationTypeEnum;
import com.bizunited.platform.user2.sdk.service.organization.OrganizationVoService;
import com.bizunited.platform.user2.sdk.service.position.PositionVoService;
import com.bizunited.platform.user2.sdk.service.user.UserVoService;
import com.bizunited.platform.user2.sdk.vo.OrganizationVo;
import com.bizunited.platform.user2.sdk.vo.PositionVo;
import com.bizunited.platform.user2.sdk.vo.UserVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="VehicleTaskVoServiceImpl")
public class VehicleTaskVoServiceImpl
implements VehicleTaskVoService {
    @Autowired
    private VehicleTaskService vehicleTaskService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private VehicleTaskExpenseMappingService vehicleTaskExpenseMappingService;
    @Autowired
    private VehicleDistributionProductService vehicleDistributionProductService;
    @Autowired
    private VehicleSalesProductService vehicleSalesProductService;
    @Autowired
    @Qualifier(value="_VehicleTaskRepositoryImpl")
    private VehicleTaskRepositoryCustom vehicleTaskRepositoryCustom;
    @Autowired
    private UserVoService userVoService;
    @Autowired
    private PositionVoService positionVoService;
    @Autowired
    private OrganizationVoService organizationVoService;
    @Autowired
    private DistributionRouteService distributionRouteService;
    @Autowired
    private VehicleSaleManService vehicleSaleManService;
    @Autowired
    private VehicleService vehicleService;
    @Autowired
    private WarehouseActionService warehouseActionService;
    @Autowired
    private VehicleProductStockVoService vehicleProductStockVoService;
    @Autowired
    private OutwardPlanService outwardPlanService;
    @Autowired
    private DeliverGoodService deliverGoodService;
    @Autowired
    private DeliverGoodVoService deliverGoodVoService;
    @Autowired
    private VehicleTaskRepository vehicleTaskRepository;
    @Autowired
    private VehicleProductStockService vehicleProductStockService;

    @Override
    @Transactional
    public VehicleTaskVo create(VehicleTaskVo vehicleTaskVo) {
        Validate.notNull((Object)((Object)vehicleTaskVo), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        vehicleTaskVo.setVehicleName(vehicleTaskVo.getCarNumber());
        VehicleTask vehicleTask = (VehicleTask)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleTaskVo, VehicleTask.class, LinkedHashSet.class, ArrayList.class, new String[]{"saleMans"}));
        List<VehicleSaleManVo> saleManVos = vehicleTaskVo.getSaleManVos();
        Validate.notEmpty(saleManVos, (String)"\u51fa\u8f66\u4efb\u52a1\u5173\u8054\u4e1a\u52a1\u5458\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List headList = saleManVos.stream().filter(user -> user.getHead()).collect(Collectors.toList());
        Validate.isTrue((headList.size() == 1 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u5fc5\u987b\u6307\u5b9a \u4e00\u4f4d \u8d1f\u8d23\u4eba", (Object[])new Object[0]);
        vehicleTask = this.vehicleTaskService.create(vehicleTask);
        List<VehicleSaleMan> vehicleSaleManList = this.transformSaleManVoToVehicleUser(vehicleTask, saleManVos);
        vehicleTask.setSaleMans(vehicleSaleManList);
        this.vehicleSaleManService.batchSave(vehicleTask.getId(), vehicleSaleManList);
        List<VehicleTaskDeliverGoodVo> vehicleTaskDeliverGoods = vehicleTaskVo.getVehicleTaskDeliverGoods();
        if (!CollectionUtils.isEmpty(vehicleTaskDeliverGoods)) {
            this.saveVehicleTaskDeliverGood(vehicleTaskDeliverGoods, vehicleTask);
        }
        List<VehicleDistributionProductVo> vehicleDistributionProductVos = vehicleTaskVo.getVehicleDistributionProductVos();
        BigDecimal distributionProductSubtotalAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(vehicleDistributionProductVos)) {
            List<VehicleDistributionProduct> vehicleDistributionProducts = this.saveVehicleDistributionProduct(vehicleDistributionProductVos, vehicleTask.getVehicleTaskCode(), vehicleTask.getVehicleCode(), vehicleTask.getWarehouseCode());
            distributionProductSubtotalAmount = vehicleDistributionProducts.stream().map(VehicleDistributionProduct::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        List<VehicleSalesProductVo> vehicleSalesProductVos = vehicleTaskVo.getVehicleSalesProductVos();
        BigDecimal salesProductSubtotalAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(vehicleSalesProductVos)) {
            List<VehicleSalesProduct> vehicleSalesProducts = this.saveVehicleSalesProduct(vehicleSalesProductVos, vehicleTask.getVehicleTaskCode(), vehicleTask.getVehicleCode(), vehicleTask.getWarehouseCode());
            salesProductSubtotalAmount = vehicleSalesProducts.stream().map(VehicleSalesProduct::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        vehicleTask.setVehicleLoadAmount(salesProductSubtotalAmount.add(distributionProductSubtotalAmount));
        vehicleTaskVo.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        return vehicleTaskVo;
    }

    @Override
    @Transactional
    public VehicleTaskVo update(VehicleTaskVo vehicleTaskVo) {
        Validate.notNull((Object)((Object)vehicleTaskVo), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        vehicleTaskVo.setVehicleName(vehicleTaskVo.getCarNumber());
        VehicleTask vehicleTask = (VehicleTask)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleTaskVo, VehicleTask.class, HashSet.class, ArrayList.class, new String[]{"saleMans"}));
        Validate.isTrue((boolean)VehicleTaskStatusEnum.WAIT_CONFIRM.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u7f16\u8f91\u4efb\u52a1\u65f6,\u51fa\u8f66\u4efb\u52a1\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001", (Object[])new Object[0]);
        List<VehicleSaleManVo> saleManVos = vehicleTaskVo.getSaleManVos();
        Validate.notEmpty(saleManVos, (String)"\u51fa\u8f66\u4efb\u52a1\u5173\u8054\u4e1a\u52a1\u5458\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List headList = saleManVos.stream().filter(user -> user.getHead()).collect(Collectors.toList());
        Validate.isTrue((headList.size() == 1 ? 1 : 0) != 0, (String)"\u51fa\u8f66\u4efb\u52a1\u5fc5\u987b\u6307\u5b9a \u4e00\u4f4d \u8d1f\u8d23\u4eba", (Object[])new Object[0]);
        List<VehicleSaleMan> vehicleSaleManList = this.transformSaleManVoToVehicleUser(vehicleTask, saleManVos);
        vehicleTask.setSaleMans(vehicleSaleManList);
        vehicleTask = this.vehicleTaskService.update(vehicleTask);
        this.vehicleSaleManService.batchSave(vehicleTask.getId(), vehicleSaleManList);
        this.vehicleTaskExpenseMappingService.deleteByVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        List<VehicleTaskDeliverGoodVo> vehicleTaskDeliverGoods = vehicleTaskVo.getVehicleTaskDeliverGoods();
        if (!CollectionUtils.isEmpty(vehicleTaskDeliverGoods)) {
            this.saveVehicleTaskDeliverGood(vehicleTaskDeliverGoods, vehicleTask);
        }
        this.vehicleDistributionProductService.deleteByVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        List<VehicleDistributionProductVo> vehicleDistributionProductVos = vehicleTaskVo.getVehicleDistributionProductVos();
        BigDecimal distributionProductSubtotalAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(vehicleDistributionProductVos)) {
            List<VehicleDistributionProduct> vehicleDistributionProducts = this.saveVehicleDistributionProduct(vehicleDistributionProductVos, vehicleTask.getVehicleTaskCode(), vehicleTask.getVehicleCode(), vehicleTask.getWarehouseCode());
            distributionProductSubtotalAmount = vehicleDistributionProducts.stream().map(VehicleDistributionProduct::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        this.vehicleSalesProductService.deleteByVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        List<VehicleSalesProductVo> vehicleSalesProductVos = vehicleTaskVo.getVehicleSalesProductVos();
        BigDecimal salesProductSubtotalAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(vehicleSalesProductVos)) {
            List<VehicleSalesProduct> vehicleSalesProducts = this.saveVehicleSalesProduct(vehicleSalesProductVos, vehicleTask.getVehicleTaskCode(), vehicleTask.getVehicleCode(), vehicleTask.getWarehouseCode());
            salesProductSubtotalAmount = vehicleSalesProducts.stream().map(VehicleSalesProduct::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        vehicleTask.setVehicleLoadAmount(salesProductSubtotalAmount.add(distributionProductSubtotalAmount));
        return vehicleTaskVo;
    }

    private List<VehicleSalesProduct> saveVehicleSalesProduct(List<VehicleSalesProductVo> vehicleSalesProductVos, String vehicleTaskCode, String vehicleCode, String warehouseCode) {
        ArrayList<VehicleSalesProduct> vehicleSalesProducts = new ArrayList<VehicleSalesProduct>();
        for (VehicleSalesProductVo vehicleSalesProductVo : vehicleSalesProductVos) {
            Validate.isTrue((vehicleSalesProductVo.getQuantity().compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0", (Object[])new Object[0]);
            VehicleSalesProduct vehicleSalesProduct = (VehicleSalesProduct)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleSalesProductVo, VehicleSalesProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            vehicleSalesProduct.setSubtotalAmount(vehicleSalesProduct.getPurchasePrice().multiply(vehicleSalesProduct.getQuantity()).setScale(4, RoundingMode.HALF_UP));
            vehicleSalesProduct.setVehicleCode(vehicleCode);
            vehicleSalesProduct.setVehicleTaskCode(vehicleTaskCode);
            vehicleSalesProduct.setRemainingQuantity(vehicleSalesProduct.getQuantity());
            vehicleSalesProducts.add(vehicleSalesProduct);
            Boolean aBoolean = this.warehouseActionService.validateStock(vehicleSalesProduct.getProductSpecificationCode(), warehouseCode, vehicleSalesProduct.getQuantity(), vehicleSalesProduct.getUnitCode());
            Validate.isTrue((null != aBoolean && aBoolean != false ? 1 : 0) != 0, (String)("\u5546\u54c1\u7f16\u53f7" + vehicleSalesProduct.getProductCode() + "\u5728\u4ed3\u5e93" + warehouseCode + "\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3"), (Object[])new Object[0]);
        }
        this.vehicleSalesProductService.batchSave(vehicleSalesProducts);
        return vehicleSalesProducts;
    }

    private void saveVehicleTaskDeliverGood(List<VehicleTaskDeliverGoodVo> vehicleTaskDeliverGoodVos, VehicleTask vehicleTask) {
        ArrayList<VehicleTaskExpenseMapping> vehicleTaskDeliverGoods = new ArrayList<VehicleTaskExpenseMapping>();
        for (VehicleTaskDeliverGoodVo vehicleTaskDeliverGoodVo : vehicleTaskDeliverGoodVos) {
            VehicleTaskExpenseMapping deliverGoodMapping = new VehicleTaskExpenseMapping();
            deliverGoodMapping.setDeliverGoodCode(vehicleTaskDeliverGoodVo.getDeliverGoodCode());
            deliverGoodMapping.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
            deliverGoodMapping.setExpenseCode(vehicleTaskDeliverGoodVo.getRelevanceCode());
            deliverGoodMapping.setDistributionStatus(DistributionStatusEnum.WAIT_DISTRIBUTION.getType());
            deliverGoodMapping.setId(null);
            deliverGoodMapping.setCustomerCode(vehicleTaskDeliverGoodVo.getCustomerCode());
            deliverGoodMapping.setCustomerName(vehicleTaskDeliverGoodVo.getCustomerName());
            vehicleTaskDeliverGoods.add(deliverGoodMapping);
        }
        this.vehicleTaskExpenseMappingService.batchSave(vehicleTaskDeliverGoods);
        List deliverGoodCodes = vehicleTaskDeliverGoodVos.stream().map(VehicleTaskDeliverGoodVo::getDeliverGoodCode).collect(Collectors.toList());
        DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
        deliverUpdateVo.setDeliverGoodCodes(deliverGoodCodes);
        deliverUpdateVo.setPlan(Boolean.valueOf(true));
        deliverUpdateVo.setTenantCode(TenantUtils.getTenantCode());
        deliverUpdateVo.setCarNumber(vehicleTask.getCarNumber());
        deliverUpdateVo.setRouteCode(vehicleTask.getRouteCode());
        DistributionRoute distributionRoute = this.distributionRouteService.findByCode(vehicleTask.getRouteCode());
        if (null != distributionRoute) {
            deliverUpdateVo.setRouteName(distributionRoute.getName());
        }
        deliverUpdateVo.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
        if (null != vehicleSaleMan) {
            deliverUpdateVo.setSaleManAccount(vehicleSaleMan.getUserAccount());
            deliverUpdateVo.setSaleManName(vehicleSaleMan.getUserName());
        }
        deliverUpdateVo.setNoticeVehicleTask(Boolean.valueOf(false));
        this.deliverGoodService.batchUpdatePlanByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
    }

    private List<VehicleDistributionProduct> saveVehicleDistributionProduct(List<VehicleDistributionProductVo> vehicleDistributionProductVos, String vehicleTaskCode, String vehicleCode, String warehouseCode) {
        ArrayList<VehicleDistributionProduct> vehicleDistributionProducts = new ArrayList<VehicleDistributionProduct>();
        for (VehicleDistributionProductVo vehicleDistributionProductVo : vehicleDistributionProductVos) {
            Validate.isTrue((vehicleDistributionProductVo.getQuantity().compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0", (Object[])new Object[0]);
            VehicleDistributionProduct vehicleDistributionProduct = (VehicleDistributionProduct)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleDistributionProductVo, VehicleDistributionProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            vehicleDistributionProduct.setSubtotalAmount(vehicleDistributionProduct.getPurchasePrice().multiply(vehicleDistributionProduct.getQuantity()).setScale(4, RoundingMode.HALF_UP));
            vehicleDistributionProduct.setVehicleTaskCode(vehicleTaskCode);
            vehicleDistributionProduct.setVehicleCode(vehicleCode);
            vehicleDistributionProduct.setRemainingQuantity(vehicleDistributionProduct.getQuantity());
            vehicleDistributionProducts.add(vehicleDistributionProduct);
        }
        this.vehicleDistributionProductService.batchSave(vehicleDistributionProducts);
        return vehicleDistributionProducts;
    }

    private List<VehicleSaleMan> transformSaleManVoToVehicleUser(VehicleTask vehicleTask, List<VehicleSaleManVo> userList) {
        ArrayList<VehicleSaleMan> vehicleSaleManList = new ArrayList<VehicleSaleMan>();
        for (VehicleSaleManVo vehicleSaleManVo : userList) {
            VehicleSaleMan vehicleSaleMan = new VehicleSaleMan();
            vehicleSaleMan.setTenantCode(vehicleTask.getTenantCode());
            vehicleSaleMan.setUserAccount(vehicleSaleManVo.getUserAccount());
            vehicleSaleMan.setUserName(vehicleSaleManVo.getUserName());
            vehicleSaleMan.setHead(vehicleSaleManVo.getHead());
            vehicleSaleMan.setVehicleTask(vehicleTask);
            vehicleSaleManList.add(vehicleSaleMan);
        }
        return vehicleSaleManList;
    }

    @Override
    public VehicleTaskVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        VehicleTask vehicleTask = this.vehicleTaskService.findDetailsById(id);
        return this.vehicleTaskToVehicleTaskVo(vehicleTask);
    }

    @Override
    public VehicleTaskVo findByVehicleTaskCode(String vehicleTaskCode) {
        if (StringUtils.isBlank((CharSequence)vehicleTaskCode)) {
            return null;
        }
        VehicleTask vehicleTask = this.vehicleTaskService.findByVehicleTaskCode(vehicleTaskCode);
        return this.vehicleTaskToVehicleTaskVo(vehicleTask);
    }

    @Override
    @Transactional
    public void batchSavePlanTask(List<VehicleTaskVo> allVehicleTaskVo) {
        Validate.notEmpty(allVehicleTaskVo, (String)"\u51fa\u8f66\u8ba1\u5212\u5b9a\u65f6\u4fdd\u5b58\u51fa\u8f66\u4efb\u52a1\u65f6,\u4efb\u52a1\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a ", (Object[])new Object[0]);
        ArrayList saveList = Lists.newArrayList();
        List<String> planCodes = allVehicleTaskVo.stream().map(VehicleTaskVo::getOutwardPlanCode).distinct().collect(Collectors.toList());
        List<Date> taskTimes = allVehicleTaskVo.stream().map(VehicleTaskVo::getTaskTime).distinct().collect(Collectors.toList());
        List<VehicleTask> alreadyVehicleTaskList = this.vehicleTaskRepository.findbyOutwardPlanCodeAndTaskTimeAndTenantCode(planCodes, taskTimes);
        if (CollectionUtils.isEmpty(alreadyVehicleTaskList)) {
            saveList.addAll(allVehicleTaskVo);
        } else {
            for (VehicleTaskVo vehicleTaskVo : allVehicleTaskVo) {
                VehicleTask alreadyVehicleTask = alreadyVehicleTaskList.stream().filter(o -> vehicleTaskVo.getOutwardPlanCode().equals(o.getOutwardPlanCode()) && vehicleTaskVo.getTaskTime().compareTo(o.getTaskTime()) == 0).findFirst().orElse(null);
                if (null != alreadyVehicleTask) continue;
                saveList.add(vehicleTaskVo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            for (VehicleTaskVo vehicleTaskVo : saveList) {
                this.create(vehicleTaskVo);
            }
        }
    }

    @Override
    public void addDeliverGoodToVehicleTask() {
        List<VehicleTask> vehicleTaskList = this.vehicleTaskRepository.findbyAutomaticAndCreateTimeBefore(this.getTodayStart(), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(vehicleTaskList)) {
            return;
        }
        for (VehicleTask vehicleTask : vehicleTaskList) {
            this.addDeliverGoodToVehicleTask(vehicleTask);
        }
    }

    @Override
    @Transactional
    public void batachTransforProductType(VehicleTransformProductTypeVo vehicleTransforProductTypeVo) {
        Validate.notNull((Object)vehicleTransforProductTypeVo, (String)"\u8f66\u8f86\u5e93\u5b58\u5546\u54c1\u8f6c\u6362\u5546\u54c1\u7c7b\u578b,\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        VehicleTask vehicleTask = this.vehicleTaskRepository.findByVehicleTaskCode(vehicleTransforProductTypeVo.getVehicleTaskCode(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)vehicleTask), (String)"\u8f66\u8f86\u5e93\u5b58\u5546\u54c1\u8f6c\u6362\u5546\u54c1\u7c7b\u578b,\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1", (Object[])new Object[0]);
        Validate.isTrue((boolean)VehicleTaskStatusEnum.VEHICLE_DRIVING.getType().equals(vehicleTask.getVehicleTaskStatus()), (String)"\u8f66\u8f86\u5e93\u5b58\u5546\u54c1\u8f6c\u6362\u5546\u54c1\u7c7b\u578b\u65f6,\u51fa\u8f66\u4efb\u52a1\u5fc5\u987b\u4e3a\u51fa\u8f66\u4e2d", (Object[])new Object[0]);
        Validate.isTrue((boolean)vehicleTask.getVehicleCode().equals(vehicleTransforProductTypeVo.getVehicleCode()), (String)"\u8f66\u8f86\u5e93\u5b58\u5546\u54c1\u8f6c\u6362\u5546\u54c1\u7c7b\u578b,\u8f66\u8f86\u7f16\u53f7\u4e0e\u51fa\u8f66\u4efb\u52a1\u4e2d\u5173\u8054\u7684\u8f66\u8f86\u7f16\u53f7\u4e0d\u7b26", (Object[])new Object[0]);
        for (VehicleTransformProductTypeProductVo product : vehicleTransforProductTypeVo.getProducts()) {
            this.vehicleProductStockService.transforVehicleProductType(vehicleTransforProductTypeVo.getVehicleCode(), product.getProductSpecificationCode(), product.getQuantity(), product.getVehicleProductType(), vehicleTransforProductTypeVo.getSignType());
        }
    }

    public void addDeliverGoodToVehicleTask(VehicleTask vehicleTask) {
        DistributionRoute distributionRoute = this.distributionRouteService.findByCode(vehicleTask.getRouteCode());
        Validate.notNull((Object)((Object)distributionRoute), (String)"\u51fa\u8f66\u8ba1\u5212\u5b9a\u65f6\u4fdd\u5b58\u51fa\u8f66\u4efb\u52a1\u65f6,\u672a\u67e5\u8be2\u5230\u8def\u7ebf ", (Object[])new Object[0]);
        List customerCodes = distributionRoute.getCustomers().stream().map(DistributionRouteCustomer::getCustomerCode).collect(Collectors.toList());
        List deliverGoodVos = this.deliverGoodVoService.findByCustomerCodesAndDeliverTimeAndTenantCode(customerCodes, vehicleTask.getTaskTime(), vehicleTask.getTenantCode());
        if (!CollectionUtils.isEmpty((Collection)deliverGoodVos)) {
            HashSet deliverProductVoSet = new HashSet();
            for (Object deliverGoodVo : deliverGoodVos) {
                Set products = deliverGoodVo.getProducts();
                deliverProductVoSet.addAll(products);
            }
            ArrayList<VehicleDistributionProduct> vehicleDistributionProducts = new ArrayList<VehicleDistributionProduct>();
            for (Object deliverProductVo : deliverProductVoSet) {
                VehicleDistributionProduct vehicleDistributionProduct = this.transDeliverGoodProductVoToDistributionProduct((DeliverProductVo)deliverProductVo, vehicleTask);
                vehicleDistributionProducts.add(vehicleDistributionProduct);
            }
            List<VehicleDistributionProduct> saveList = this.vehicleDistributionProductService.findByVehicleTaskCode(vehicleTask.getVehicleTaskCode());
            if (CollectionUtils.isEmpty(saveList)) {
                saveList = new ArrayList<VehicleDistributionProduct>();
            }
            for (VehicleDistributionProduct vehicleDistributionProduct : vehicleDistributionProducts) {
                VehicleDistributionProduct oldProduct = saveList.stream().filter(o -> o.getProductSpecificationCode().equals(vehicleDistributionProduct.getProductSpecificationCode()) && o.getUnitCode().equals(vehicleDistributionProduct.getUnitCode())).findFirst().orElse(null);
                if (null != oldProduct) {
                    oldProduct.setQuantity(oldProduct.getQuantity().add(vehicleDistributionProduct.getQuantity()));
                    oldProduct.setRemainingQuantity(oldProduct.getRemainingQuantity().add(vehicleDistributionProduct.getRemainingQuantity()));
                    oldProduct.setSubtotalAmount(oldProduct.getSubtotalAmount().add(vehicleDistributionProduct.getSubtotalAmount()));
                    continue;
                }
                saveList.add(vehicleDistributionProduct);
            }
            this.vehicleDistributionProductService.batchSave(saveList);
            List<VehicleTaskExpenseMapping> vehicleTaskExpenseMappings = this.vehicleTaskExpenseMappingService.findByVehicleTaskCodeAndTenantCode(vehicleTask.getVehicleTaskCode(), vehicleTask.getTenantCode());
            if (CollectionUtils.isEmpty(vehicleTaskExpenseMappings)) {
                vehicleTaskExpenseMappings = new ArrayList<VehicleTaskExpenseMapping>();
            }
            for (DeliverGoodVo deliverGoodVo : deliverGoodVos) {
                VehicleTaskExpenseMapping deliverGoodMapping = new VehicleTaskExpenseMapping();
                deliverGoodMapping.setTenantCode(vehicleTask.getTenantCode());
                deliverGoodMapping.setCreateAccount(vehicleTask.getCreateAccount());
                deliverGoodMapping.setModifyAccount(vehicleTask.getCreateAccount());
                deliverGoodMapping.setDeliverGoodCode(deliverGoodVo.getDeliverGoodCode());
                deliverGoodMapping.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
                deliverGoodMapping.setExpenseCode(deliverGoodVo.getRelevanceCode());
                deliverGoodMapping.setDistributionStatus(DistributionStatusEnum.WAIT_DISTRIBUTION.getType());
                deliverGoodMapping.setId(null);
                deliverGoodMapping.setCustomerCode(deliverGoodVo.getCustomerCode());
                deliverGoodMapping.setCustomerName(deliverGoodVo.getCustomerName());
                vehicleTaskExpenseMappings.add(deliverGoodMapping);
            }
            this.vehicleTaskExpenseMappingService.batchSave(vehicleTaskExpenseMappings);
            DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
            List deliverGoodCodes = deliverGoodVos.stream().map(DeliverGoodVo::getDeliverGoodCode).collect(Collectors.toList());
            deliverUpdateVo.setDeliverGoodCodes(deliverGoodCodes);
            deliverUpdateVo.setPlan(Boolean.valueOf(true));
            deliverUpdateVo.setTenantCode(vehicleTask.getTenantCode());
            deliverUpdateVo.setRouteCode(vehicleTask.getRouteCode());
            if (null != distributionRoute) {
                deliverUpdateVo.setRouteName(distributionRoute.getName());
            }
            deliverUpdateVo.setCarNumber(vehicleTask.getCarNumber());
            deliverUpdateVo.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
            VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(null);
            if (null != vehicleSaleMan) {
                deliverUpdateVo.setSaleManAccount(vehicleSaleMan.getUserAccount());
                deliverUpdateVo.setSaleManName(vehicleSaleMan.getUserName());
            }
            deliverUpdateVo.setNoticeVehicleTask(Boolean.valueOf(false));
            this.deliverGoodService.batchUpdatePlanByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
            BigDecimal distributionProductSubtotalAmount = saveList.stream().map(VehicleDistributionProduct::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            vehicleTask.setVehicleLoadAmount(vehicleTask.getVehicleLoadAmount().add(distributionProductSubtotalAmount));
            this.vehicleTaskRepository.save((Object)vehicleTask);
        }
    }

    private VehicleTaskVo vehicleTaskToVehicleTaskVo(VehicleTask vehicleTask) {
        DistributionRoute distributionRoute;
        List<VehicleSaleMan> saleMans;
        List<VehicleSalesProduct> vehicleSalesProducts;
        List<VehicleDistributionProduct> vehicleDistributionProducts;
        List deliverGoodCodeList;
        List deliverGoodVos;
        VehicleTaskVo vehicleTaskVo = (VehicleTaskVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleTask, VehicleTaskVo.class, HashSet.class, ArrayList.class, new String[]{"saleMans"}));
        List<VehicleTaskExpenseMapping> vehicleTaskExpenseMappings = this.vehicleTaskExpenseMappingService.findByVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        if (!CollectionUtils.isEmpty(vehicleTaskExpenseMappings) && !CollectionUtils.isEmpty((Collection)(deliverGoodVos = this.deliverGoodVoService.findByDeliverGoodCodes(deliverGoodCodeList = vehicleTaskExpenseMappings.stream().map(VehicleTaskExpenseMapping::getDeliverGoodCode).collect(Collectors.toList()))))) {
            Collection vehicleTaskDeliverGoodVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)deliverGoodVos, DeliverGoodVo.class, VehicleTaskDeliverGoodVo.class, HashSet.class, ArrayList.class, new String[0]);
            vehicleTaskVo.setVehicleTaskDeliverGoods(new ArrayList<VehicleTaskDeliverGoodVo>(vehicleTaskDeliverGoodVos));
        }
        if (!CollectionUtils.isEmpty(vehicleDistributionProducts = this.vehicleDistributionProductService.findByVehicleTaskCode(vehicleTask.getVehicleTaskCode()))) {
            ArrayList<VehicleDistributionProductVo> vehicleDistributionProductVos = new ArrayList<VehicleDistributionProductVo>();
            for (VehicleDistributionProduct vehicleDistributionProduct : vehicleDistributionProducts) {
                VehicleDistributionProductVo vehicleDistributionProductVo = (VehicleDistributionProductVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleDistributionProduct, VehicleDistributionProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                vehicleDistributionProductVos.add(vehicleDistributionProductVo);
            }
            vehicleTaskVo.setVehicleDistributionProductVos(vehicleDistributionProductVos);
        }
        if (!CollectionUtils.isEmpty(vehicleSalesProducts = this.vehicleSalesProductService.findByVehicleTaskCode(vehicleTask.getVehicleTaskCode()))) {
            ArrayList<VehicleSalesProductVo> vehicleSalesProductVos = new ArrayList<VehicleSalesProductVo>();
            for (VehicleSalesProduct vehicleSalesProduct : vehicleSalesProducts) {
                VehicleSalesProductVo vehicleSalesProductVo = (VehicleSalesProductVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicleSalesProduct, VehicleSalesProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                vehicleSalesProductVos.add(vehicleSalesProductVo);
            }
            vehicleTaskVo.setVehicleSalesProductVos(vehicleSalesProductVos);
        }
        if (!CollectionUtils.isEmpty(saleMans = vehicleTask.getSaleMans())) {
            ArrayList<VehicleSaleManVo> arrayList = new ArrayList<VehicleSaleManVo>();
            for (VehicleSaleMan saleMan : saleMans) {
                this.userVoTransformVehicleSaleManVo(arrayList, saleMan);
            }
            vehicleTaskVo.setSaleManVos(arrayList);
        }
        if (null != (distributionRoute = this.distributionRouteService.findByCode(vehicleTask.getRouteCode()))) {
            vehicleTaskVo.setRouteName(distributionRoute.getName());
        }
        return vehicleTaskVo;
    }

    private void userVoTransformVehicleSaleManVo(List<VehicleSaleManVo> vehicleSaleManVos, VehicleSaleMan saleMan) {
        String tenantCode = TenantUtils.getTenantCode();
        UserVo userVo = this.userVoService.findByTenantCodeAndAccount(TenantUtils.getTenantCode(), saleMan.getUserAccount());
        if (null != userVo) {
            PositionVo positionVo;
            Set positions;
            Set positionCodes;
            OrganizationVo organizationVo;
            Set orgs;
            VehicleSaleManVo vehicleSaleManVo = new VehicleSaleManVo();
            vehicleSaleManVo.setUserAccount(saleMan.getUserAccount());
            vehicleSaleManVo.setUserName(userVo.getUserName());
            vehicleSaleManVo.setUserHead(userVo.getUserHead());
            vehicleSaleManVo.setUserHeadPath(userVo.getExtend5());
            Set orgCodes = userVo.getOrgCodes();
            if (!CollectionUtils.isEmpty((Collection)orgCodes) && !CollectionUtils.isEmpty((Collection)(orgs = this.organizationVoService.findByTenantCodeAndOrgCodes(tenantCode, orgCodes.toArray(new String[0])))) && null != (organizationVo = (OrganizationVo)orgs.stream().filter(o -> o.getType().equals(OrganizationTypeEnum.DEPT.getType())).findFirst().orElse(null))) {
                vehicleSaleManVo.setDepartmentCode(organizationVo.getCode());
                vehicleSaleManVo.setDepartmentName(organizationVo.getOrgName());
            }
            if (!CollectionUtils.isEmpty((Collection)(positionCodes = userVo.getPositionCodes())) && !CollectionUtils.isEmpty((Collection)(positions = this.positionVoService.findByTenantCodeAndPositionCodes(tenantCode, positionCodes.toArray(new String[0])))) && null != (positionVo = (PositionVo)positions.stream().findFirst().orElse(null))) {
                vehicleSaleManVo.setPositionCode(positionVo.getCode());
                vehicleSaleManVo.setPositionName(positionVo.getName());
            }
            vehicleSaleManVo.setPhone(userVo.getPhone());
            vehicleSaleManVo.setHead(saleMan.getHead());
            vehicleSaleManVos.add(vehicleSaleManVo);
        }
    }

    private VehicleDistributionProduct transDeliverGoodProductVoToDistributionProduct(DeliverProductVo deliverProductVo, VehicleTask vehicleTask) {
        Validate.isTrue((deliverProductVo.getDeliverQuantity().compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0", (Object[])new Object[0]);
        VehicleDistributionProduct vehicleDistributionProduct = (VehicleDistributionProduct)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)deliverProductVo, VehicleDistributionProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        vehicleDistributionProduct.setTenantCode(vehicleTask.getTenantCode());
        vehicleDistributionProduct.setCreateAccount(vehicleTask.getCreateAccount());
        vehicleDistributionProduct.setModifyAccount(vehicleTask.getModifyAccount());
        vehicleDistributionProduct.setFileName(deliverProductVo.getFileName());
        vehicleDistributionProduct.setQuantity(deliverProductVo.getDeliverQuantity());
        vehicleDistributionProduct.setRelativePath(deliverProductVo.getRelativePath());
        vehicleDistributionProduct.setPurchasePrice(deliverProductVo.getUnitPrice());
        vehicleDistributionProduct.setSubtotalAmount(deliverProductVo.getUnitPrice().multiply(deliverProductVo.getDeliverQuantity()).setScale(4, RoundingMode.HALF_UP));
        vehicleDistributionProduct.setVehicleTaskCode(vehicleTask.getVehicleTaskCode());
        vehicleDistributionProduct.setVehicleCode(vehicleTask.getVehicleCode());
        vehicleDistributionProduct.setRemainingQuantity(deliverProductVo.getDeliverQuantity());
        vehicleDistributionProduct.setId(null);
        vehicleDistributionProduct.setBarCode(deliverProductVo.getBarCode());
        return vehicleDistributionProduct;
    }

    @Override
    public Page<VehicleTaskVo> findByConditions(Pageable pageable, VehicleTaskDto dto) {
        PageImpl vehicleTaskVoPage;
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)Constants.DEFAULT_PAGEABLE);
        Page<VehicleTask> byConditions = this.vehicleTaskRepositoryCustom.findByConditions(pageable, dto);
        List content = byConditions.getContent();
        if (!CollectionUtils.isEmpty((Collection)content)) {
            Map<String, List> map = content.stream().collect(Collectors.toMap(VehicleTask::getVehicleTaskCode, VehicleTask::getSaleMans));
            Collection vehicleTaskVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)content, VehicleTask.class, VehicleTaskVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"saleMans"});
            for (VehicleTaskVo vehicleTaskVo : vehicleTaskVos) {
                List vehicleSaleManList;
                DistributionRoute byCode = this.distributionRouteService.findByCode(vehicleTaskVo.getRouteCode());
                if (null != byCode) {
                    vehicleTaskVo.setRouteName(byCode.getName());
                }
                if (VehicleTaskWayEnum.AUTO.equals(vehicleTaskVo.getVehicleTaskWay())) {
                    OutwardPlan plan = this.outwardPlanService.findByCode(vehicleTaskVo.getOutwardPlanCode());
                    vehicleTaskVo.setOutwardPlanName(plan.getName());
                }
                if (!map.containsKey(vehicleTaskVo.getVehicleTaskCode()) || CollectionUtils.isEmpty((Collection)(vehicleSaleManList = map.get(vehicleTaskVo.getVehicleTaskCode())))) continue;
                ArrayList<VehicleSaleManVo> vehicleSaleManVos = new ArrayList<VehicleSaleManVo>();
                for (VehicleSaleMan saleMan : vehicleSaleManList) {
                    this.userVoTransformVehicleSaleManVo(vehicleSaleManVos, saleMan);
                }
                vehicleTaskVo.setSaleManVos(vehicleSaleManVos);
                VehicleSaleMan vehicleSaleMan = vehicleSaleManList.stream().filter(VehicleSaleMan::getHead).findFirst().orElse(new VehicleSaleMan());
                vehicleTaskVo.setUserName(vehicleSaleMan.getUserName());
                UserVo userVo = this.userVoService.findByTenantCodeAndAccount(TenantUtils.getTenantCode(), vehicleSaleMan.getUserAccount());
                if (null == userVo) continue;
                vehicleTaskVo.setPhone(userVo.getPhone());
            }
            vehicleTaskVoPage = new PageImpl(new ArrayList(vehicleTaskVos), pageable, byConditions.getTotalElements());
        } else {
            vehicleTaskVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return vehicleTaskVoPage;
    }

    @Override
    public List<VehicleTaskVehicleVo> findVehicleStatus() {
        List allVehicle = this.vehicleService.findAll();
        ArrayList<VehicleTaskVehicleVo> list = new ArrayList<VehicleTaskVehicleVo>();
        if (!CollectionUtils.isEmpty((Collection)allVehicle)) {
            List<Object> occupyList = new ArrayList();
            List<Object> vacantList = new ArrayList();
            for (Vehicle vehicle : allVehicle) {
                VehicleTaskVehicleVo vehicleVo = (VehicleTaskVehicleVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)vehicle, VehicleTaskVehicleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                if (vehicle.getVehicleTransportStatus().equals(VehicleTransportStatusEnum.OCCUPY.getType())) {
                    vehicleVo.setStatus("\u51fa\u8f66\u4e2d");
                    VehicleTask vehicleTask = this.vehicleTaskService.findVehicleTaskByDriving(vehicle.getVehicleCode());
                    if (null != vehicleTask) {
                        VehicleSaleMan vehicleSaleMan = vehicleTask.getSaleMans().stream().filter(VehicleSaleMan::getHead).findFirst().orElse(new VehicleSaleMan());
                        vehicleVo.setUserName(vehicleSaleMan.getUserName());
                        DistributionRoute byCode = this.distributionRouteService.findByCode(vehicleTask.getRouteCode());
                        if (null != byCode) {
                            vehicleVo.setRouteName(byCode.getName());
                        }
                    }
                    occupyList.add((Object)vehicleVo);
                    continue;
                }
                if (!vehicle.getVehicleTransportStatus().equals(VehicleTransportStatusEnum.VACANT.getType())) continue;
                vehicleVo.setStatus("\u5df2\u6536\u8f66");
                vacantList.add((Object)vehicleVo);
            }
            occupyList = occupyList.stream().sorted(Comparator.comparing(VehicleTaskVehicleVo::getCarNumber)).collect(Collectors.toList());
            list.addAll(occupyList);
            vacantList = vacantList.stream().sorted(Comparator.comparing(VehicleTaskVehicleVo::getCarNumber)).collect(Collectors.toList());
            list.addAll(vacantList);
        }
        return list;
    }

    @Override
    public List<DistributionRouteCustomerVo> findCustomersByVehicleCode(String vehicleCode) {
        if (StringUtils.isEmpty((CharSequence)vehicleCode)) {
            return Lists.newArrayList();
        }
        ArrayList<DistributionRouteCustomerVo> customerVos = new ArrayList<DistributionRouteCustomerVo>();
        VehicleTask vehicleTask = this.vehicleTaskService.findVehicleTaskByDriving(vehicleCode);
        if (null == vehicleTask) {
            return customerVos;
        }
        DistributionRouteDetailVo detailsByCode = this.distributionRouteService.findDetailsByCode(vehicleTask.getRouteCode());
        return detailsByCode.getCustomers();
    }

    @Override
    public Page<VehicleTaskVo> findVehicleTaskByDeliver(Pageable pageable, String warehouseCode, String customerCode) {
        if (StringUtils.isEmpty((CharSequence)warehouseCode) || StringUtils.isEmpty((CharSequence)customerCode)) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        List<String> routeCodes = this.distributionRouteService.findRouteByCustomerCode(customerCode);
        if (CollectionUtils.isEmpty(routeCodes)) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        VehicleTaskDto dto = new VehicleTaskDto();
        dto.setRouteCodes(routeCodes);
        dto.setWarehouseCode(warehouseCode);
        dto.setVehicleTaskStatus(VehicleTaskStatusEnum.WAIT_CONFIRM.getType());
        Page<VehicleTaskVo> page = this.findByConditions(pageable, dto);
        return page;
    }

    @Override
    public Page<VehicleProductStockVo> findVehicleProductStock(Pageable pageable, String vehicleCode, String vehicleTaskCode) {
        if (StringUtils.isEmpty((CharSequence)vehicleTaskCode) || StringUtils.isEmpty((CharSequence)vehicleCode)) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        VehicleTask vehicleTask = this.vehicleTaskService.findByVehicleTaskCode(vehicleTaskCode);
        if (VehicleTaskStatusEnum.VEHICLE_DRIVING.getType().equals(vehicleTask.getVehicleTaskStatus())) {
            VehicleProductStockDto vehicleProductStockDto = new VehicleProductStockDto();
            vehicleProductStockDto.setVehicleCode(vehicleCode);
            vehicleProductStockDto.setVehicleTaskCode(vehicleTaskCode);
            Page byConditions = this.vehicleProductStockVoService.findByConditions(pageable, vehicleProductStockDto);
            return byConditions;
        }
        return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
    }

    @Override
    public List<VehicleTaskPanelVo> findByPanel(Pageable pageable, VehicleTaskDto dto) {
        ArrayList<VehicleTaskPanelVo> list = new ArrayList<VehicleTaskPanelVo>();
        if (null == dto) {
            return list;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        for (VehicleTaskStatusEnum vehicleTaskStatus : VehicleTaskStatusEnum.values()) {
            VehicleTaskPanelVo vehicleTaskPanelVo = new VehicleTaskPanelVo();
            dto.setVehicleTaskStatus(vehicleTaskStatus.getType());
            Page<VehicleTaskVo> page = this.findByConditions(pageable, dto);
            vehicleTaskPanelVo.setVehicleTaskStatus(vehicleTaskStatus.getType());
            vehicleTaskPanelVo.setVisitTaskVoPage(page);
            list.add(vehicleTaskPanelVo);
        }
        return list;
    }

    private Date getTodayStart() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }
}

