/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.notifier;

import com.bizunited.empower.business.customer.entity.CustomerDeliveryInfo;
import com.bizunited.empower.business.customer.service.CustomerDeliveryInfoService;
import com.bizunited.empower.business.customer.service.notifier.CustomerEventListener;
import com.bizunited.empower.business.customer.vo.CustomerCategoryVo;
import com.bizunited.empower.business.customer.vo.CustomerLevelVo;
import com.bizunited.empower.business.customer.vo.CustomerVo;
import com.bizunited.empower.business.customer.vo.SalesAreaVo;
import com.bizunited.empower.business.sales.entity.outward.DistributionRoute;
import com.bizunited.empower.business.sales.entity.outward.DistributionRouteCustomer;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteCustomerService;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteService;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerEventForDistributionRoteListenerImpl
implements CustomerEventListener {
    @Autowired
    private DistributionRouteCustomerService distributionRouteCustomerService;
    @Autowired
    private DistributionRouteService distributionRouteService;
    @Autowired
    private CustomerDeliveryInfoService customerDeliveryInfoService;

    @Transactional
    public void onCreated(CustomerVo customer) {
        if (StringUtils.isBlank((CharSequence)customer.getDeliveryRoutes())) {
            return;
        }
        String customerCode = customer.getCustomerCode();
        String newDeliveryRoutesCode = customer.getDeliveryRoutes();
        DistributionRoute newDeliveryRoutes = this.distributionRouteService.findByCode(newDeliveryRoutesCode);
        Validate.notNull((Object)((Object)newDeliveryRoutes), (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u914d\u9001\u8def\u7ebf", (Object[])new Object[0]);
        DistributionRouteCustomer distributionRouteCustomer = new DistributionRouteCustomer();
        distributionRouteCustomer.setRoute(newDeliveryRoutes);
        distributionRouteCustomer.setCustomerCode(customerCode);
        CustomerDeliveryInfo customerDeliveryInfo = this.customerDeliveryInfoService.findDefaultByCustomerCode(customerCode);
        distributionRouteCustomer.setProvinceName(customerDeliveryInfo.getProvinceName());
        distributionRouteCustomer.setCityName(customerDeliveryInfo.getCityName());
        distributionRouteCustomer.setDistrictName(customerDeliveryInfo.getDistrictName());
        distributionRouteCustomer.setReceiverAddress(customerDeliveryInfo.getAddress());
        distributionRouteCustomer.setReceiverPhone(customerDeliveryInfo.getPhone());
        distributionRouteCustomer.setReceiver(customerDeliveryInfo.getReceiver());
        distributionRouteCustomer.setId(null);
        this.distributionRouteCustomerService.create(distributionRouteCustomer);
    }

    @Transactional
    public void onUpdated(CustomerVo customer) {
        DistributionRouteCustomer oldDistributionRouteCustomer;
        String customerCode = customer.getCustomerCode();
        DistributionRoute oldDistributionRoute = this.distributionRouteService.findByCustomerCode(customerCode);
        if (StringUtils.isBlank((CharSequence)customer.getDeliveryRoutes())) {
            if (oldDistributionRoute != null) {
                this.customerDeliveryInfoService.deleteById(oldDistributionRoute.getId());
            }
            return;
        }
        String newDeliveryRoutesCode = customer.getDeliveryRoutes();
        if (oldDistributionRoute != null && (oldDistributionRouteCustomer = this.distributionRouteCustomerService.findByCustomerCode(customerCode)) != null) {
            this.distributionRouteCustomerService.deleteById(oldDistributionRouteCustomer.getId());
        }
        DistributionRoute newDeliveryRoutes = this.distributionRouteService.findByCode(newDeliveryRoutesCode);
        Validate.notNull((Object)((Object)newDeliveryRoutes), (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u914d\u9001\u8def\u7ebf", (Object[])new Object[0]);
        DistributionRouteCustomer distributionRouteCustomer = new DistributionRouteCustomer();
        distributionRouteCustomer.setRoute(newDeliveryRoutes);
        distributionRouteCustomer.setCustomerCode(customerCode);
        CustomerDeliveryInfo customerDeliveryInfo = this.customerDeliveryInfoService.findDefaultByCustomerCode(customerCode);
        distributionRouteCustomer.setProvinceName(customerDeliveryInfo.getProvinceName());
        distributionRouteCustomer.setCityName(customerDeliveryInfo.getCityName());
        distributionRouteCustomer.setDistrictName(customerDeliveryInfo.getDistrictName());
        distributionRouteCustomer.setReceiverAddress(customerDeliveryInfo.getAddress());
        distributionRouteCustomer.setReceiverPhone(customerDeliveryInfo.getPhone());
        distributionRouteCustomer.setReceiver(customerDeliveryInfo.getReceiver());
        distributionRouteCustomer.setId(null);
        this.distributionRouteCustomerService.create(distributionRouteCustomer);
    }

    public void onDisabled(CustomerVo customer) {
    }

    public void onEnabled(CustomerVo customer) {
    }

    public void onLevelChanged(CustomerVo customer, CustomerLevelVo before, CustomerLevelVo after) {
    }

    public void onCategoryChanged(CustomerVo customer, CustomerCategoryVo before, CustomerCategoryVo after) {
    }

    public void onSalesAreaChanged(CustomerVo customer, SalesAreaVo before, SalesAreaVo after) {
    }
}

