/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.notifier;

import com.bizunited.empower.business.distribution.entity.DeliverGood;
import com.bizunited.empower.business.distribution.enums.DeliverWay;
import com.bizunited.empower.business.distribution.service.listener.DeliverGoodListener;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTaskExpenseMapping;
import com.bizunited.empower.business.sales.enums.vehicle.DistributionStatusEnum;
import com.bizunited.empower.business.sales.repository.vehicle.VehicleTaskExpenseMappingRepository;
import com.bizunited.empower.business.sales.repository.vehicle.VehicleTaskRepository;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteService;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DeliverGoodEventForVehicleTaskListenerImpl
implements DeliverGoodListener {
    @Autowired
    private VehicleTaskService vehicleTaskService;
    @Autowired
    private VehicleTaskRepository vehicleTaskRepository;
    @Autowired
    private VehicleTaskExpenseMappingRepository vehicleTaskExpenseMappingRepository;
    @Autowired
    private DistributionRouteService distributionRouteService;

    public void onCreate(DeliverGood deliverGood) {
        List<String> routeCodes = this.distributionRouteService.findRouteByCustomerCode(deliverGood.getCustomerCode());
        if (CollectionUtils.isEmpty(routeCodes)) {
            return;
        }
        List<VehicleTask> vehicleTaskList = this.vehicleTaskRepository.findbyTaskTimeBeforeAndTenantCode(deliverGood.getPlanDeliverTime(), routeCodes.get(0), deliverGood.getTenantCode());
        if (CollectionUtils.isEmpty(vehicleTaskList)) {
            return;
        }
        VehicleTask vehicleTask = vehicleTaskList.get(0);
        this.vehicleTaskService.addDeliverToVehicleTask(deliverGood.getDeliverGoodCode(), vehicleTask.getVehicleTaskCode());
    }

    public void onReceiving(DeliverGood deliverGood) {
        if (DeliverWay.DISTRIBUTION.getType().equals(deliverGood.getDeliverWay()) && deliverGood.getNoticeVehicleTask().booleanValue()) {
            VehicleTask vehicleTask = this.vehicleTaskRepository.findByVehicleTaskCode(deliverGood.getVehicleTaskCode(), deliverGood.getTenantCode());
            Validate.notNull((Object)((Object)vehicleTask), (String)"\u53d1\u8d27\u5355\u6536\u8d27\u65f6,\u672a\u67e5\u8be2\u5230\u76f8\u5173\u51fa\u8f66\u4efb\u52a1", (Object[])new Object[0]);
            VehicleTaskExpenseMapping vehicleTaskExpenseMapping = this.vehicleTaskExpenseMappingRepository.findByVehicleTaskCodeAndDeliverGoodCodeAndTenantCode(vehicleTask.getVehicleTaskCode(), deliverGood.getDeliverGoodCode(), vehicleTask.getTenantCode());
            Validate.notNull((Object)((Object)vehicleTaskExpenseMapping), (String)"\u53d1\u8d27\u5355\u6536\u8d27\u65f6,\u672a\u67e5\u8be2\u5230\u51fa\u8f66\u4efb\u52a1\u4e2d\u7684\u76f8\u5173\u53d1\u8d27\u5355", (Object[])new Object[0]);
            Validate.isTrue((boolean)DistributionStatusEnum.ALREADY_DISTRIBUTION.getType().equals(vehicleTaskExpenseMapping.getDistributionStatus()), (String)"\u8be5\u53d1\u8d27\u5355\u672a\u4ea4\u8d27,\u4e0d\u53ef\u6536\u8d27", (Object[])new Object[0]);
        }
    }

    public void deliverGood(DeliverGood deliverGood) {
    }

    public void onRevoke(DeliverGood deliverGood) {
        if (DeliverWay.DISTRIBUTION.getType().equals(deliverGood.getDeliverWay()) && deliverGood.getPlan().booleanValue() && deliverGood.getNoticeVehicleTask().booleanValue()) {
            this.vehicleTaskService.removeDeliverToVehicleTask(deliverGood);
        }
    }

    public void onCancel(DeliverGood deliverGood) {
        if (DeliverWay.DISTRIBUTION.getType().equals(deliverGood.getDeliverWay()) && deliverGood.getPlan().booleanValue() && deliverGood.getNoticeVehicleTask().booleanValue()) {
            this.vehicleTaskService.removeDeliverToVehicleTask(deliverGood);
        }
    }
}

