/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.service.notifier;

import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.enums.vehicle.VehicleTaskStatusEnum;
import com.bizunited.empower.business.sales.repository.vehicle.VehicleTaskRepository;
import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.empower.business.vehicle.service.notify.VehicleListener;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class VehicleEventForVehicleTaskListenerImpl
implements VehicleListener {
    @Autowired
    private VehicleTaskRepository vehicleTaskRepository;

    public void onDelete(Vehicle vehicle) {
        Validate.notNull((Object)vehicle, (String)"\u9519\u8bef\u7684\u8f66\u8f86\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List<VehicleTask> vehicleTaskList = this.vehicleTaskRepository.findByVehicleCodeAndTenantCode(vehicle.getVehicleCode(), TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(vehicleTaskList), (String)"\u8be5\u8f66\u8f86\u6709\u5173\u8054\u7684\u51fa\u8f66\u4efb\u52a1,\u4e0d\u53ef\u5220\u9664", (Object[])new Object[0]);
    }

    public void onDisable(Vehicle vehicle) {
        Validate.notNull((Object)vehicle, (String)"\u9519\u8bef\u7684\u8f66\u8f86\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List<VehicleTask> vehicleTaskList = this.vehicleTaskRepository.findByVehicleCodeAndDriving(vehicle.getVehicleCode(), VehicleTaskStatusEnum.VEHICLE_RETURN.getType(), VehicleTaskStatusEnum.CANCEL.getType(), TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(vehicleTaskList), (String)"\u8be5\u8f66\u8f86\u6709\u6b63\u5728\u8fdb\u884c\u7684\u51fa\u8f66\u4efb\u52a1,\u4e0d\u53ef\u7981\u7528", (Object[])new Object[0]);
    }
}

