package com.bizunited.empower.business.tenant.common.constant;

/**
 * 租户模块常量
 *
 * @author Keller
 */
public class Constants {

  private Constants() {
    throw new IllegalStateException("静态变量类不能进行实例化");
  }

  /**
   * 租户编码前缀
   */
  public final static String TENANT_CODE_PREFIX = "TA";

  /**
   * 默认管理员角色名称
   */
  public final static String TENANT_ADMINROLE_NAME = "管理员";

  /**
   * 默认管理员角色编码
   */
  public final static String TENANT_ADMINROLE_CODE = "ADMIN";

  /**
   * 默认基础角色名称
   */
  public final static String TENANT_BASEROLE_NAME = "基础角色";

  /**
   * 默认基础角色编码
   */
  public final static String TENANT_BASEROLE_CODE = "BASEROLE";

  /**
   * 默认短信验证码长度
   */
  public static final int DEFAULT_SMS_CODE_LENGTH = 6;

  /**
   * 默认短信过期时间,毫秒单位
   */
  public static final int DEFAULT_SMS_EXPIRE_TIME = 120000;
}
