package com.bizunited.empower.business.tenant.common.enums;

import java.util.Objects;

/**
 * 开放商城设置的游客，未经过审核的客户浏览商品的规则枚举
 */
public enum BrowseProductRuleEnum {
  BAN_BROWSE_PRODUCT(0, "不允许查看商品"),
  PRODUCT_PRICE_SHOW_ZERO(1, "商品金额展示为0"),
  PRODUCT_PRICE_SHOW_EMPTY(2, "商品金额展示为空"),
  PRODUCT_PRICE_SHOW_ORIGINAL_PRICE(3, "商品金额展示为原始价格");

  /**
   * 规则code码
   */
  private Integer ruleCode;
  /**
   * 规则描述
   */
  private String ruleDesc;

  BrowseProductRuleEnum(Integer ruleCode, String ruleDesc) {
    this.ruleCode = ruleCode;
    this.ruleDesc = ruleDesc;
  }

  public static BrowseProductRuleEnum findEnumByRuleCode(Integer ruleCode) {
    for (BrowseProductRuleEnum browseProductRuleEnum : BrowseProductRuleEnum.values()) {
      if (Objects.equals(ruleCode, browseProductRuleEnum.getRuleCode())) {
        return browseProductRuleEnum;
      }
    }
    return null;
  }

  public Integer getRuleCode() {
    return ruleCode;
  }

  public void setRuleCode(Integer ruleCode) {
    this.ruleCode = ruleCode;
  }

  public String getRuleDesc() {
    return ruleDesc;
  }

  public void setRuleDesc(String ruleDesc) {
    this.ruleDesc = ruleDesc;
  }
}
