package com.bizunited.empower.business.tenant.common.enums;

/**
 * ProcessingFlowNodeNumber 处理流程节点编号枚举
 *
 * @Author: hefan
 * @Date: 2021/6/22 15:44
 */
public enum ProcessingFlowNodeNumber {

  //-----------订货处理流程节点枚举------------------
  /**
   * 财务审核
   */
  FINANCE(ProcessingFlowType.ORDER_GOODS,1,"财务审核"),
  /**
   * 出库审核
   */
  EXPENSE(ProcessingFlowType.ORDER_GOODS,2,"出库审核"),
  /**
   * 发货确认
   */
  SEND_OUT(ProcessingFlowType.ORDER_GOODS,3,"发货确认"),
  /**
   * 【客户】收货确认
   */
  ORDER_GOODS_RECEIPT(ProcessingFlowType.ORDER_GOODS,4,"【客户】收货确认"),

  //-----------退货处理流程节点枚举------------------
  /**
   * 【客户】收货确认
   */
  RETURN_GOODS_RECEIPT(ProcessingFlowType.RETURN_GOODS,1,"收货确认"),
  /**
   * 退款确认
   */
  RETURN_GOODS_REFUND(ProcessingFlowType.RETURN_GOODS,1,"退款确认"),
  /**
   * 【客户】收款确认
   */
  RETURN_GOODS_RECEIVE(ProcessingFlowType.RETURN_GOODS,1,"【客户】收款确认"),

  ;

  /**
   * 租户处理流程类型
   */
  private ProcessingFlowType processingFlowType;

  /**
   * 编号
   */
  private Integer number;

  /**
   * 说明
   */
  private String desc;

  ProcessingFlowNodeNumber(ProcessingFlowType processingFlowType, Integer number, String desc) {
    this.processingFlowType = processingFlowType;
    this.number = number;
    this.desc = desc;
  }

  public ProcessingFlowType getProcessingFlowType() {
    return processingFlowType;
  }

  public Integer getNumber() {
    return number;
  }

  public String getDesc() {
    return desc;
  }
}
