package com.bizunited.empower.business.tenant.common.enums;

import java.util.Objects;

/**
 * 租户全局配置枚举类（该类描述的是二进制数据每位对应的设置及其默认值）
 */
public enum TenantSettingSwitchEnum {
  BAN_CUSTOMER_PLACE_ORDER(0L, 0, "是否禁止客户下单（0：不禁止（默认），1：禁止）"),
  ALLOW_CUSTOMER_SELF_REGISTRATION(1L, 0, "允许客户自主注册账号（0：不允许（默认），1：允许）"),
  BAN_ALL_CUSTOMER_VIEW_PRODUCT(2L, 0, "禁止所有客户查看商品（0：不禁止（默认），1：禁止）");
  /**
   * 配置项所对应的二进制bit位置（例：ALLOW_CUSTOMER_SELF_REGISTRATION配置为开启时二进制数为 10）
   */
  private Long binaryBit;
  /**
   * 配置项的默认值
   */
  private Integer defaultValue;
  /**
   * 配置项的描述
   */
  private String desc;

  TenantSettingSwitchEnum(Long binaryBit, Integer defaultValue, String desc) {
    this.binaryBit = binaryBit;
    this.defaultValue = defaultValue;
    this.desc = desc;
  }

  public static TenantSettingSwitchEnum findTenantSettingSwitchEnumByBinaryBit(Long binaryBit) {
    for (TenantSettingSwitchEnum tenantSettingSwitchEnum : TenantSettingSwitchEnum.values()) {
      if (Objects.equals(binaryBit, tenantSettingSwitchEnum.getBinaryBit())) {
        return tenantSettingSwitchEnum;
      }
    }
    return null;
  }

  public Long getBinaryBit() {
    return binaryBit;
  }

  public void setBinaryBit(Long binaryBit) {
    this.binaryBit = binaryBit;
  }

  public Integer getDefaultValue() {
    return defaultValue;
  }

  public void setDefaultValue(Integer defaultValue) {
    this.defaultValue = defaultValue;
  }

  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }
}
