package com.bizunited.empower.business.tenant.controller;

import com.bizunited.empower.business.tenant.entity.TenantSetting;
import com.bizunited.empower.business.tenant.service.TenantSettingService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * TenantSetting业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/tenantSetting")
public class TenantSettingController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(TenantSettingController.class);
  
  @Autowired
  private TenantSettingService tenantSettingService;

  /**
   * 保存业务设置实体
   * */
  @ApiOperation(value = "保存业务设置实体")
  @PostMapping(value="")
  public ResponseModel save(@RequestBody @ApiParam(name="tenantSetting" , value="保存业务设置实体") TenantSetting tenantSetting) {
    try {
      TenantSetting current = this.tenantSettingService.save(tenantSetting);
      return this.buildHttpResultW(current);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

}
