package com.bizunited.empower.business.tenant.controller;

import com.bizunited.empower.business.tenant.common.enums.TenantSettingSwitchEnum;
import com.bizunited.empower.business.tenant.entity.TenantSetting;
import com.bizunited.empower.business.tenant.service.TenantSettingVoService;
import com.bizunited.empower.business.tenant.vo.TenantSettingVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * TenantSettingVo业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/tenantSetting")
public class TenantSettingVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(TenantSettingVoController.class);

  @Autowired
  private TenantSettingVoService tenantSettingVoService;

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value="/{id}")
  public ResponseModel findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){
    try {
      TenantSettingVo current = this.tenantSettingVoService.findById(id);
      return this.buildHttpResultW(current);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 获取经销商设置的默认图片（目前仅有商品默认图）
   */
  @GetMapping("findSettingImgByCode")
  @ApiOperation("获取经销商logo（系统首页位置）")
  public ResponseModel findSettingImgByTenantCode() {
    try {
      TenantSettingVo tenantSetting = this.tenantSettingVoService.findSettingImgByTenantCode();
      return this.buildHttpResultW(tenantSetting);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照TenantSettingVo实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id 主键
   */
  @ApiOperation(value = "按照TenantSettingVo实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value = "/findDetailsById", method = {RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      TenantSettingVo result = this.tenantSettingVoService.findDetailsVoById(id);
      return this.buildHttpResultW(result);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据登录用户信息的TenantCode进行明细查询，查询的明细包括当前业务表单所有的关联属性。
   */
  @ApiOperation(value = "按照TenantSettingVo实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value = "/findByTenantCode", method = {RequestMethod.GET})
  public ResponseModel findByTenantCode() {
    try {
      TenantSettingVo result = this.tenantSettingVoService.findByTenantCode();
      return this.buildHttpResultW(result);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据登录用户信息的TenantCode，以及指定的设置枚举查询该枚举是否开启
   *
   * @param tenantSettingSwitchEnum 指定的设置枚举
   */
  @ApiOperation(value = "根据登录用户信息的TenantCode，以及指定的设置枚举查询该枚举是否开启")
  @RequestMapping(value = "/findTenantSettingSwitchByEnum", method = {RequestMethod.GET})
  public ResponseModel findTenantSettingSwitchByEnum(@RequestParam("tenantSettingSwitchEnum") @ApiParam("租户指定设置枚举")
                                                             TenantSettingSwitchEnum tenantSettingSwitchEnum) {
    try {
      TenantSettingVo result = this.tenantSettingVoService.findTenantSettingSwitchByEnum(tenantSettingSwitchEnum);
      return this.buildHttpResultW(result);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
} 
