package com.bizunited.empower.business.tenant.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 租户时间同步使用，获取租户资源桶当前时间
 * 1、需要资源桶服务器配置NTP时间同步功能
 * 2、各业务端时间均需要使用系统服务器时间
 *
 * @author Keller
 */
@RestController
@RequestMapping("/v1/tenantTimeController")
public class TenantTimeController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(TenantTimeController.class);

  /**
   * 查询获取当前系统时间（注意返回的是unix时间戳 单位:毫秒）
   * */
  @ApiOperation(value = "查询获取当前系统时间（注意返回的是unix时间戳 单位:毫秒）")
  @PostMapping(value="")
  public ResponseModel getSystemTime() {
    try {
      long currentTime = System.currentTimeMillis();
      return this.buildHttpResult(currentTime);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
}
