package com.bizunited.empower.business.tenant.dto;

import com.bizunited.empower.business.tenant.entity.TenantInfo;
import com.bizunited.platform.user2.sdk.vo.UserVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author Keller
 */
@ApiModel(value = "TenantDto", description = "用户租户初始化页面创建参数传递")
public class TenantInfoDto implements Serializable {
  private static final long serialVersionUID = 7209002051682162180L;

  /** 租户信息 */
  @ApiModelProperty("租户信息")
  private TenantInfo tenantInfo;

  /** 初始化用户 */
  @ApiModelProperty("租户初始化默认管理员信息")
  private UserVo userVo;

  public TenantInfo getTenantInfo() {
    return tenantInfo;
  }

  public void setTenantInfo(TenantInfo tenantInfo) {
    this.tenantInfo = tenantInfo;
  }

  public UserVo getUserVo() {
    return userVo;
  }

  public void setUserVo(UserVo userVo) {
    this.userVo = userVo;
  }
}
