package com.bizunited.empower.business.tenant.entity;

import com.bizunited.empower.business.tenant.common.enums.TenantSettingSwitchEnum;
import com.bizunited.platform.common.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

/**
 * 租户配置信息
 *
 * @author Keller
 */
@ApiModel(value = "TenantSetting", description = "租户配置信息")
@Entity
@Table(name = "`tenant_setting`", indexes = {@Index(columnList = "tenant_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "`tenant_setting`", comment = "租户配置信息")
public class TenantSetting extends UuidOpEntity {

  /**
   *
   */
  private static final long serialVersionUID = -2860649153884961191L;

  /**
   * 仓库状态
   */
  @Column(name = "warehouse_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 仓库状态 '")
  @SaturnColumn(description = "仓库状态")
  @ApiModelProperty("仓库状态")
  private Boolean warehouseStatus;

  // ---支付设置------------------------------------------------------------------------------------------------------------

  /**
   * 现金支付状态
   */
  @Column(name = "cash_pay_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 现金支付状态 '")
  @SaturnColumn(description = "现金支付状态")
  @ApiModelProperty("现金支付状态")
  private Boolean cashPayStatus;

  /**
   * 订单部分付款状态
   */
  @Column(name = "order_partial_pay_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 订单部分付款状态 '")
  @SaturnColumn(description = "订单部分付款状态")
  @ApiModelProperty("订单部分付款状态")
  private Boolean orderPartialPayStatus;

  /**
   * 先货后款开启状态
   */
  @Column(name = "goods_before_pay_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 先货后款开启状态 '")
  @SaturnColumn(description = "先货后款开启状态")
  @ApiModelProperty("先货后款开启状态")
  private Boolean goodsBeforePayStatus;

  /**
   * 账期类型状态
   */
  @Column(name = "account_period_type_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 账期类型状态 '")
  @SaturnColumn(description = "账期类型状态")
  @ApiModelProperty("账期类型状态")
  private Boolean accountPeriodTypeStatus;

  /**
   * 信用支付状态
   */
  @Column(name = "credit_bill_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 信用支付状态 '")
  @SaturnColumn(description = "信用支付状态")
  @ApiModelProperty("信用支付状态")
  private Boolean creditBillStatus;

  // ---订单设置------------------------------------------------------------------------------------------------------------
  /**
   * 订单审核节点信息配置：目前包含节点名、节点上角色编码配置组合、节点所处顺序
   * 该值是一个JSONArray结构
   * 例如：[
   *        {"node":"name1","roleCodes":["YEWUYUAN1","CAIWU1"],"sorts":1},
   *        {"node":"name3","roleCodes":["YEWUYUAN3","CAIWU3"],"sorts":3},
   *        {"node":"name2","roleCodes":["YEWUYUAN2","CAIWU2"],"sorts":2}
   *      ]
   * */
  @Column(name = "audit_node_settings", nullable = true,length = 1024,columnDefinition = "VARCHAR(1024) COMMENT ' 订单审核节点信息配置 '")
  @SaturnColumn(description = "订单审核节点信息配置")
  @ApiModelProperty("订单审核节点信息配置")
  private String auditNodeSettings;

  /**
   * 退货单审核节点信息配置：目前包含节点名、节点上角色编码配置组合、节点所处顺序
   * 该值是一个JSONArray结构：注意目前退货单只有一个审核节点
   * 例如：[
   *        {"node":"name1","roleCodes":["YEWUYUAN1","CAIWU1"],"sorts":1},
   *        {"node":"name3","roleCodes":["YEWUYUAN3","CAIWU3"],"sorts":3},
   *        {"node":"name2","roleCodes":["YEWUYUAN2","CAIWU2"],"sorts":2}
   *      ]
   * */
  @Column(name = "return_audit_node_settings", nullable = true,length = 512,columnDefinition = "VARCHAR(1024) COMMENT ' 退货单审核节点信息配置 '")
  @SaturnColumn(description = "退货单审核节点信息配置")
  @ApiModelProperty("退货单审核节点信息配置")
  private String returnAuditNodeSettings;

  /**
   * 订单必填收货地址状态
   */
  @Column(name = "order_required_receipt_address_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 订单必填收货地址状态 '")
  @SaturnColumn(description = "订单必填收货地址状态")
  @ApiModelProperty("订单必填收货地址状态")
  private Boolean orderRequiredReceiptAddressStatus;

  /**
   *  订单必填收货地址的业务类型由位运算‘|’求得的值，业务类型二进制值编号参考枚举：OrderBusinessNumber
   */
  @ApiModelProperty("订单必填收货地址的业务类型由位运算‘|’求得的值，业务类型二进制值编号参考枚举：OrderBusinessNumber")
  @SaturnColumn(description = "订单必填收货地址的业务类型由位运算‘|’求得的值，业务类型二进制值编号参考枚举：OrderBusinessNumber")
  @Column(name = "order_required_receipt_address_value", nullable = false, columnDefinition = "INT(11) COMMENT '订单必填收货地址的业务类型由位运算‘|’求得的值，业务类型二进制值编号参考枚举：OrderBusinessNumber'")
  private Integer orderRequiredReceiptAddressValue;

  /**
   * 订单必填交货日期状态
   */
  @Column(name = "order_required_delivery_date_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 订单必填交货日期状态 '")
  @SaturnColumn(description = "订单必填交货日期状态")
  @ApiModelProperty("订单必填交货日期状态")
  private Boolean orderRequiredDeliveryDateStatus;

  /**
   *  订单必填交货日期的业务类型由位运算‘|’求得的值，业务类型二进制值编号参考枚举：OrderBusinessNumber
   */
  @ApiModelProperty("订单必填交货日期的业务类型由位运算‘|’求得的值，业务类型二进制值编号参考枚举：OrderBusinessNumber")
  @SaturnColumn(description = "订单必填交货日期的业务类型由位运算‘|’求得的值，业务类型二进制值编号参考枚举：OrderBusinessNumber")
  @Column(name = "order_required_delivery_date_value", nullable = false, columnDefinition = "INT(11) COMMENT '订单必填交货日期的业务类型由位运算‘|’求得的值，业务类型二进制值编号参考枚举：OrderBusinessNumber'")
  private Integer orderRequiredDeliveryDateValue;

  /**
   * 客户取消订单
   */
  @ApiModelProperty("客户取消订单")
  @SaturnColumn(description = "客户取消订单")
  @Column(name = "customer_cancel_order_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 客户取消订单 '")
  private Boolean customerCancelOrderStatus;

  /**
   * 最低下单金额状态
   */
  @ApiModelProperty("最低下单金额状态")
  @SaturnColumn(description = "最低下单金额状态")
  @Column(name = "minimum_order_amount_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 最低下单金额状态 '")
  private Boolean minimumOrderAmountStatus;

  /**
   * 最低下单金额
   */
  @ApiModelProperty("最低下单金额")
  @SaturnColumn(description = "最低下单金额")
  @Column(name = "minimum_order_amount", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT ' 最低下单金额 '")
  private BigDecimal minimumOrderAmount;

  /**
   * 下单时间状态
   */
  @ApiModelProperty("下单时间状态")
  @SaturnColumn(description = "下单时间状态")
  @Column(name = "order_time_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 下单时间状态 '")
  private Boolean orderTimeStatus;

  /**
   * 下单时间
   */
  @ApiModelProperty("下单时间")
  @SaturnColumn(description = "下单时间")
  @Column(name = "order_time", nullable = true, columnDefinition = "datetime COMMENT '下单时间'")
  private Date orderTime;

  /**
   * 客户超时未收货，系统自动收货 状态
   */
  @ApiModelProperty("客户超时未收货，系统自动收货 状态")
  @SaturnColumn(description = "客户超时未收货，系统自动收货 状态")
  @Column(name = "automatic_receipt_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 客户超时未收货，系统自动收货 状态 '")
  private Boolean automaticReceiptStatus;

  /**
   *  客户超时未收货，系统自动收货值, 单位天
   */
  @ApiModelProperty("客户超时未收货，系统自动收货 值")
  @SaturnColumn(description = "客户超时未收货，系统自动收货 值")
  @Column(name = "automatic_receipt_value", nullable = false, columnDefinition = "INT(11) COMMENT '客户超时未收货，系统自动收货 值'")
  private Integer automaticReceiptValue;

  /**
   * 自动取消订单 状态
   */
  @ApiModelProperty("自动取消订单 状态")
  @SaturnColumn(description = "自动取消订单 状态")
  @Column(name = "automatic_cancel_order_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 自动取消订单 状态 '")
  private Boolean automaticCancelOrderStatus;

  /**
   *  自动取消订单 值, 单位 小时
   */
  @ApiModelProperty("自动取消订单 值, 单位 小时")
  @SaturnColumn(description = "自动取消订单 值, 单位 小时")
  @Column(name = "automatic_cancel_order_value", nullable = false, columnDefinition = "INT(11) COMMENT '自动取消订单 值, 单位 小时'")
  private Integer automaticCancelOrderValue;

  /**
   * 禁止客户修改收货地址 状态
   */
  @ApiModelProperty("禁止客户修改收货地址 状态")
  @SaturnColumn(description = "禁止客户修改收货地址 状态")
  @Column(name = "ban_modify_receipt_address_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 禁止客户修改收货地址 状态 '")
  private Boolean banModifyReceiptAddressStatus;

  /**
   * 退货限制 状态
   */
  @ApiModelProperty("退货限制 状态")
  @SaturnColumn(description = "退货限制 状态")
  @Column(name = "return_limit_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 退货限制 状态 '")
  private Boolean returnLimitStatus;

  /**
   *  退货限制值,单位天
   */
  @ApiModelProperty("退货限制值,单位天")
  @SaturnColumn(description = "退货限制值,单位天")
  @Column(name = "return_limit_value", nullable = false, columnDefinition = "INT(11) COMMENT '退货限制值,单位天'")
  private Integer returnLimitValue;

  // ---库存设置------------------------------------------------------------------------------------------------------------
  /**
   * 商品库存占用 状态
   */
  @ApiModelProperty("商品库存占用 状态")
  @SaturnColumn(description = "商品库存占用 状态")
  @Column(name = "warehouse_occupy_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 商品库存占用 状态 '")
  private Boolean warehouseOccupyStatus;

  /**
   * 是否多仓库
   */
  @ApiModelProperty("是否多仓库")
  @SaturnColumn(description = "是否多仓库")
  @Column(name = "multiple_warehouses", nullable = true, columnDefinition = "tinyint(1) COMMENT ' 是否多仓库 '")
  private Boolean multipleWarehouses;

  /**
   * 负库存订货 状态
   */
  @ApiModelProperty("负库存订货 状态")
  @SaturnColumn(description = "负库存订货 状态")
  @Column(name = "negative_warehouse_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 负库存订货 状态 '")
  private Boolean negativeWarehouseStatus;

  /**
   * 客户订货端的库存显示 ——【大于】——选项
   */
  @ApiModelProperty("客户订货端的库存显示 ——【大于】——选项")
  @SaturnColumn(description = "客户订货端的库存显示 ——【大于】——选项")
  @Column(name = "warehouse_gt_display_option", nullable = true, columnDefinition = "INT(11) COMMENT ' 客户订货端的库存显示 ——【大于】——选项 '")
  private Integer warehouseGtDisplayOption;

  /**
   * 客户订货端的库存显示 ——【大于】——自定义文本
   */
  @ApiModelProperty("客户订货端的库存显示 ——【大于】——自定义文本")
  @SaturnColumn(description = "客户订货端的库存显示 ——【大于】——自定义文本")
  @Column(name = "warehouse_gt_display_text", nullable = true, columnDefinition = "VARCHAR(12) COMMENT ' 客户订货端的库存显示 ——【大于】——自定义文本 '")
  private String warehouseGtDisplayText;

  /**
   *  客户订货端的库存显示 ——【大于】——阈值
   */
  @ApiModelProperty("客户订货端的库存显示 ——【大于】——阈值")
  @SaturnColumn(description = "客户订货端的库存显示 ——【大于】——阈值")
  @Column(name = "warehouse_gt_display_threshold", nullable = true, columnDefinition = "INT(11) COMMENT '客户订货端的库存显示 ——【大于】——阈值'")
  private Integer warehouseGtDisplayThreshold;

  /**
   * 客户订货端的库存显示 ——【小于等于】——选项
   */
  @ApiModelProperty("客户订货端的库存显示 ——【小于等于】——选项")
  @SaturnColumn(description = "客户订货端的库存显示 ——【小于等于】——选项")
  @Column(name = "warehouse_le_display_option", nullable = true, columnDefinition = "INT(11) COMMENT ' 客户订货端的库存显示 ——【小于等于】——选项 '")
  private Integer warehouseLeDisplayOption;

  /**
   * 客户订货端的库存显示 ——【小于等于】——自定义文本
   */
  @ApiModelProperty("客户订货端的库存显示 ——【小于等于】——自定义文本")
  @SaturnColumn(description = "客户订货端的库存显示 ——【小于等于】——自定义文本")
  @Column(name = "warehouse_le_display_text", nullable = true, columnDefinition = "VARCHAR(12) COMMENT ' 客户订货端的库存显示 ——【小于等于】——自定义文本 '")
  private String warehouseLeDisplayText;

  /**
   *  客户订货端的库存显示 ——【小于等于】——阈值
   */
  @ApiModelProperty("客户订货端的库存显示 ——【小于等于】——阈值")
  @SaturnColumn(description = "客户订货端的库存显示 ——【小于等于】——阈值")
  @Column(name = "warehouse_le_display_threshold", nullable = true, columnDefinition = "INT(11) COMMENT '客户订货端的库存显示 ——【小于等于】——阈值'")
  private Integer warehouseLeDisplayThreshold;

  /**
   * 超库存出库 状态 (是否强库存管控,强库存管控情况下不允许实际库存为负)
   */
  @ApiModelProperty("超库存出库 状态 ")
  @SaturnColumn(description = "超库存出库 状态")
  @Column(name = "overflow_warehouse_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 超库存出库 状态 '")
  private Boolean overflowWarehouseStatus;

  // ---客户拜访设置------------------------------------------------------------------------------------------------------------
  /**
   * 签到、离店距离 状态
   */
  @ApiModelProperty("签到、离店距离 状态")
  @SaturnColumn(description = "签到、离店距离 状态")
  @Column(name = "distance_status", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 签到、离店距离 状态 '")
  private Boolean distanceStatus;

  /**
   *  签到、离店距离——阈值，单位米
   */
  @ApiModelProperty("签到、离店距离——阈值，单位米")
  @SaturnColumn(description = "签到、离店距离——阈值，单位米")
  @Column(name = "distance_threshold", nullable = true, columnDefinition = "INT(11) COMMENT '签到、离店距离——阈值，单位米'")
  private Integer distanceThreshold;

  /**
   * 租户信息
   */
  @Column(name = "tenant_code", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 租户编号 '")
  @SaturnColumn(description = "租户信息")
  @ApiModelProperty("租户信息")
  private String tenantCode;

  // 展示相关设置---------------------------------------------------------------------------------------------------------------
  /** 商品图片失效时展示的默认图片相对路径 */
  @Column(name = "product_img_relative_path", nullable = true,  length=255 , columnDefinition = "VARCHAR(255) COMMENT ' 商品图片失效时展示的默认图片相对路径 '")
  @SaturnColumn(description = "商品图片失效时展示的默认图片相对路径")
  @ApiModelProperty("商品图片失效时展示的默认图片相对路径")
  private String productImgRelativePath;

  /** 商品图片失效时展示的默认图片文件名 */
  @Column(name = "product_img_file_name", nullable = true,  length=255 , columnDefinition = "VARCHAR(255) COMMENT ' 商品图片失效时展示的默认图片文件名 '")
  @SaturnColumn(description = "商品图片失效时展示的默认图片文件名")
  @ApiModelProperty("商品图片失效时展示的默认图片文件名")
  private String productImgFileName;

  // 开放商城设置--开放性功能设置
  /** 租户功能设置开关的全局聚合（此方式是将数据转换为二进制格式并对其对应位赋值（0：关闭，1：开启）以表示对应配置是否开启，包含的设置信息详情见：TenantConfigSwitchEnum）  */
  @ApiModelProperty("租户功能设置开关的全局聚合")
  @SaturnColumn(description = "租户功能设置开关的全局聚合")
  @Column(name = "base_setting_switch", nullable = false, length = 16, columnDefinition = "INT(16) NOT NULL DEFAULT 0 COMMENT ' 租户功能设置开关的全局聚合（包含所有的配置信息详情见：包含的设置信息详情见：TenantConfigSwitchEnum） '")
  private Long baseSettingSwitch;

  /**
   *  客户注册订货平台以后-未通过审核前浏览商品的规则（0：不允许浏览，1：商品金额展示未0，2：商品金额展示为空，3：商品金额展示原始订货价）
   */
  @ApiModelProperty("客户注册订货平台以后-未通过审核前浏览商品的规则（0：不允许浏览，1：商品金额展示未0，2：商品金额展示为空，3：商品金额展示原始订货价）")
  @SaturnColumn(description = "客户注册订货平台以后-未通过审核前浏览商品的规则（详情见：BrowseProductRuleEnum）")
  @Column(name = "unreviewed_customer_browse_product", nullable = true, columnDefinition = "INT(4) COMMENT '客户注册订货平台以后-未通过审核前浏览商品的规则（详情见：BrowseProductRuleEnum）'")
  private Integer unreviewedCustomerBrowseProduct;

  /**
   *  游客（客户未登录前）访问订货平台浏览商品的规则（0：不允许浏览，1：商品金额展示未0，2：商品金额展示为空，3：商品金额展示原始订货价）
   */
  @ApiModelProperty("游客（客户未登录前）访问订货平台浏览商品的规则（0：不允许浏览，1：商品金额展示未0，2：商品金额展示为空，3：商品金额展示原始订货价）")
  @SaturnColumn(description = "游客（客户未登录前）访问订货平台浏览商品的规则（详情见：BrowseProductRuleEnum）")
  @Column(name = "tourist_browse_product", nullable = true, columnDefinition = "INT(4) COMMENT '游客（客户未登录前）访问订货平台浏览商品的规则（详情见：BrowseProductRuleEnum）'")
  private Integer touristBrowseProduct;


  @ApiModelProperty("租户功能设置开关枚举列表")
  @Transient
  private Map<TenantSettingSwitchEnum, Integer> baseSettingSwitchMap;

  public Boolean getWarehouseStatus() {
    return warehouseStatus;
  }

  public void setWarehouseStatus(Boolean warehouseStatus) {
    this.warehouseStatus = warehouseStatus;
  }

  public Boolean getCashPayStatus() {
    return cashPayStatus;
  }

  public void setCashPayStatus(Boolean cashPayStatus) {
    this.cashPayStatus = cashPayStatus;
  }

  public Boolean getOrderPartialPayStatus() {
    return orderPartialPayStatus;
  }

  public void setOrderPartialPayStatus(Boolean orderPartialPayStatus) {
    this.orderPartialPayStatus = orderPartialPayStatus;
  }

  public Boolean getGoodsBeforePayStatus() {
    return goodsBeforePayStatus;
  }

  public void setGoodsBeforePayStatus(Boolean goodsBeforePayStatus) {
    this.goodsBeforePayStatus = goodsBeforePayStatus;
  }

  public Boolean getCreditBillStatus() {
    return creditBillStatus;
  }

  public void setCreditBillStatus(Boolean creditBillStatus) {
    this.creditBillStatus = creditBillStatus;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public Boolean getAccountPeriodTypeStatus() {
    return accountPeriodTypeStatus;
  }

  public void setAccountPeriodTypeStatus(Boolean accountPeriodTypeStatus) {
    this.accountPeriodTypeStatus = accountPeriodTypeStatus;
  }

  public Boolean getOrderRequiredReceiptAddressStatus() {
    return orderRequiredReceiptAddressStatus;
  }

  public void setOrderRequiredReceiptAddressStatus(Boolean orderRequiredReceiptAddressStatus) {
    this.orderRequiredReceiptAddressStatus = orderRequiredReceiptAddressStatus;
  }

  public Integer getOrderRequiredReceiptAddressValue() {
    return orderRequiredReceiptAddressValue;
  }

  public void setOrderRequiredReceiptAddressValue(Integer orderRequiredReceiptAddressValue) {
    this.orderRequiredReceiptAddressValue = orderRequiredReceiptAddressValue;
  }

  public Boolean getOrderRequiredDeliveryDateStatus() {
    return orderRequiredDeliveryDateStatus;
  }

  public void setOrderRequiredDeliveryDateStatus(Boolean orderRequiredDeliveryDateStatus) {
    this.orderRequiredDeliveryDateStatus = orderRequiredDeliveryDateStatus;
  }

  public Integer getOrderRequiredDeliveryDateValue() {
    return orderRequiredDeliveryDateValue;
  }

  public void setOrderRequiredDeliveryDateValue(Integer orderRequiredDeliveryDateValue) {
    this.orderRequiredDeliveryDateValue = orderRequiredDeliveryDateValue;
  }

  public Boolean getCustomerCancelOrderStatus() {
    return customerCancelOrderStatus;
  }

  public void setCustomerCancelOrderStatus(Boolean customerCancelOrderStatus) {
    this.customerCancelOrderStatus = customerCancelOrderStatus;
  }

  public Boolean getMinimumOrderAmountStatus() {
    return minimumOrderAmountStatus;
  }

  public void setMinimumOrderAmountStatus(Boolean minimumOrderAmountStatus) {
    this.minimumOrderAmountStatus = minimumOrderAmountStatus;
  }

  public BigDecimal getMinimumOrderAmount() {
    return minimumOrderAmount;
  }

  public void setMinimumOrderAmount(BigDecimal minimumOrderAmount) {
    this.minimumOrderAmount = minimumOrderAmount;
  }

  public Boolean getOrderTimeStatus() {
    return orderTimeStatus;
  }

  public void setOrderTimeStatus(Boolean orderTimeStatus) {
    this.orderTimeStatus = orderTimeStatus;
  }

  public Date getOrderTime() {
    return orderTime;
  }

  public void setOrderTime(Date orderTime) {
    this.orderTime = orderTime;
  }

  public Boolean getAutomaticReceiptStatus() {
    return automaticReceiptStatus;
  }

  public void setAutomaticReceiptStatus(Boolean automaticReceiptStatus) {
    this.automaticReceiptStatus = automaticReceiptStatus;
  }

  public Integer getAutomaticReceiptValue() {
    return automaticReceiptValue;
  }

  public void setAutomaticReceiptValue(Integer automaticReceiptValue) {
    this.automaticReceiptValue = automaticReceiptValue;
  }

  public Boolean getAutomaticCancelOrderStatus() {
    return automaticCancelOrderStatus;
  }

  public void setAutomaticCancelOrderStatus(Boolean automaticCancelOrderStatus) {
    this.automaticCancelOrderStatus = automaticCancelOrderStatus;
  }

  public Integer getAutomaticCancelOrderValue() {
    return automaticCancelOrderValue;
  }

  public void setAutomaticCancelOrderValue(Integer automaticCancelOrderValue) {
    this.automaticCancelOrderValue = automaticCancelOrderValue;
  }

  public Boolean getBanModifyReceiptAddressStatus() {
    return banModifyReceiptAddressStatus;
  }

  public void setBanModifyReceiptAddressStatus(Boolean banModifyReceiptAddressStatus) {
    this.banModifyReceiptAddressStatus = banModifyReceiptAddressStatus;
  }

  public Boolean getReturnLimitStatus() {
    return returnLimitStatus;
  }

  public void setReturnLimitStatus(Boolean returnLimitStatus) {
    this.returnLimitStatus = returnLimitStatus;
  }

  public Integer getReturnLimitValue() {
    return returnLimitValue;
  }

  public void setReturnLimitValue(Integer returnLimitValue) {
    this.returnLimitValue = returnLimitValue;
  }

  public Boolean getWarehouseOccupyStatus() {
    return warehouseOccupyStatus;
  }

  public void setWarehouseOccupyStatus(Boolean warehouseOccupyStatus) {
    this.warehouseOccupyStatus = warehouseOccupyStatus;
  }

  public Boolean getNegativeWarehouseStatus() {
    return negativeWarehouseStatus;
  }

  public void setNegativeWarehouseStatus(Boolean negativeWarehouseStatus) {
    this.negativeWarehouseStatus = negativeWarehouseStatus;
  }

  public Integer getWarehouseGtDisplayOption() {
    return warehouseGtDisplayOption;
  }

  public void setWarehouseGtDisplayOption(Integer warehouseGtDisplayOption) {
    this.warehouseGtDisplayOption = warehouseGtDisplayOption;
  }

  public String getWarehouseGtDisplayText() {
    return warehouseGtDisplayText;
  }

  public void setWarehouseGtDisplayText(String warehouseGtDisplayText) {
    this.warehouseGtDisplayText = warehouseGtDisplayText;
  }

  public Integer getWarehouseGtDisplayThreshold() {
    return warehouseGtDisplayThreshold;
  }

  public void setWarehouseGtDisplayThreshold(Integer warehouseGtDisplayThreshold) {
    this.warehouseGtDisplayThreshold = warehouseGtDisplayThreshold;
  }

  public Integer getWarehouseLeDisplayOption() {
    return warehouseLeDisplayOption;
  }

  public void setWarehouseLeDisplayOption(Integer warehouseLeDisplayOption) {
    this.warehouseLeDisplayOption = warehouseLeDisplayOption;
  }

  public String getWarehouseLeDisplayText() {
    return warehouseLeDisplayText;
  }

  public void setWarehouseLeDisplayText(String warehouseLeDisplayText) {
    this.warehouseLeDisplayText = warehouseLeDisplayText;
  }

  public Integer getWarehouseLeDisplayThreshold() {
    return warehouseLeDisplayThreshold;
  }

  public void setWarehouseLeDisplayThreshold(Integer warehouseLeDisplayThreshold) {
    this.warehouseLeDisplayThreshold = warehouseLeDisplayThreshold;
  }

  public Boolean getOverflowWarehouseStatus() {
    return overflowWarehouseStatus;
  }

  public void setOverflowWarehouseStatus(Boolean overflowWarehouseStatus) {
    this.overflowWarehouseStatus = overflowWarehouseStatus;
  }

  public Boolean getDistanceStatus() {
    return distanceStatus;
  }

  public void setDistanceStatus(Boolean distanceStatus) {
    this.distanceStatus = distanceStatus;
  }

  public Integer getDistanceThreshold() {
    return distanceThreshold;
  }

  public void setDistanceThreshold(Integer distanceThreshold) {
    this.distanceThreshold = distanceThreshold;
  }

  public String getAuditNodeSettings() {
    return auditNodeSettings;
  }

  public void setAuditNodeSettings(String auditNodeSettings) {
    this.auditNodeSettings = auditNodeSettings;
  }

  public String getProductImgRelativePath() {
    return productImgRelativePath;
  }

  public void setProductImgRelativePath(String productImgRelativePath) {
    this.productImgRelativePath = productImgRelativePath;
  }

  public String getProductImgFileName() {
    return productImgFileName;
  }

  public void setProductImgFileName(String productImgFileName) {
    this.productImgFileName = productImgFileName;
  }

  public Long getBaseSettingSwitch() {
    return baseSettingSwitch;
  }

  public void setBaseSettingSwitch(Long baseSettingSwitch) {
    this.baseSettingSwitch = baseSettingSwitch;
  }

  public Integer getUnreviewedCustomerBrowseProduct() {
    return unreviewedCustomerBrowseProduct;
  }

  public void setUnreviewedCustomerBrowseProduct(Integer unreviewedCustomerBrowseProduct) {
    this.unreviewedCustomerBrowseProduct = unreviewedCustomerBrowseProduct;
  }

  public Integer getTouristBrowseProduct() {
    return touristBrowseProduct;
  }

  public void setTouristBrowseProduct(Integer touristBrowseProduct) {
    this.touristBrowseProduct = touristBrowseProduct;
  }

  public Map<TenantSettingSwitchEnum, Integer> getBaseSettingSwitchMap() {
    return baseSettingSwitchMap;
  }

  public void setBaseSettingSwitchMap(Map<TenantSettingSwitchEnum, Integer> baseSettingSwitchMap) {
    this.baseSettingSwitchMap = baseSettingSwitchMap;
  }

  public String getReturnAuditNodeSettings() {
    return returnAuditNodeSettings;
  }

  public void setReturnAuditNodeSettings(String returnAuditNodeSettings) {
    this.returnAuditNodeSettings = returnAuditNodeSettings;
  }

  public Boolean getMultipleWarehouses() {
    return multipleWarehouses;
  }

  public void setMultipleWarehouses(Boolean multipleWarehouses) {
    this.multipleWarehouses = multipleWarehouses;
  }
}
