package com.bizunited.empower.business.tenant.entity;

import com.bizunited.platform.common.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Table;

/**
 * 租户终端配置信息
 *
 * @author Keller
 */
@ApiModel(value = "TenantTerminalSetting", description = "租户终端配置信息")
@Entity
@Table(name = "`tenant_terminal_setting`")
@org.hibernate.annotations.Table(appliesTo = "`tenant_terminal_setting`", comment = "租户终端配置信息")
public class TenantTerminalSetting extends UuidOpEntity {

  /**
   *
   */
  private static final long serialVersionUID = -4083358125822277840L;

  /**
   * 小程序名称
   */
  @Column(name = "mini_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 小程序名称 '")
  @SaturnColumn(description = "小程序名称")
  @ApiModelProperty("小程序名称")
  private String miniName;

  /**
   * 小程序id
   */
  @Column(name = "mini_app_id", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 小程序id '")
  @SaturnColumn(description = "小程序id")
  @ApiModelProperty("小程序id")
  private String miniAppID;


  /**
   * 小程序secret
   */
  @Column(name = "mini_app_secret", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 小程序secret '")
  @SaturnColumn(description = "小程序secret")
  @ApiModelProperty("小程序secret")
  private String miniAppSecret;

  /**
   * 是否交由微信开放平台维护（0:不交由小程序维护（默认），1：交由小程序维护）
   */
  @Column(name = "open_platform_management", nullable = false, columnDefinition = "tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否交由微信开放平台维护（0:不交由小程序维护（默认），1：交由小程序维护）'")
  @SaturnColumn(description = "是否交由微信开放平台维护（0:不交由小程序维护（默认），1：交由小程序维护）")
  @ApiModelProperty("是否交由微信开放平台维护（0:不交由小程序维护（默认），1：交由小程序维护）")
  private Integer openPlatformManagement;

  /**
   * 应用类型
   */
  @Column(name = "app_type", nullable = false, columnDefinition = "VARCHAR(16) COMMENT ' 应用类型 '")
  @SaturnColumn(description = "应用类型")
  @ApiModelProperty("应用类型")
  private Integer appType;

  /**
   * 品牌商信息
   */
  @JoinColumn(name = "app_code", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 品牌商信息 '")
  @SaturnColumn(description = "品牌商信息")
  @ApiModelProperty("品牌商信息")
  private String appCode;


  public Integer getAppType() {
    return appType;
  }

  public void setAppType(Integer appType) {
    this.appType = appType;
  }

  public String getMiniName() {
    return miniName;
  }

  public void setMiniName(String miniName) {
    this.miniName = miniName;
  }

  public String getMiniAppID() {
    return miniAppID;
  }

  public void setMiniAppID(String miniAppID) {
    this.miniAppID = miniAppID;
  }

  public String getMiniAppSecret() {
    return miniAppSecret;
  }

  public void setMiniAppSecret(String miniAppSecret) {
    this.miniAppSecret = miniAppSecret;
  }

  public Integer getOpenPlatformManagement() {
    return openPlatformManagement;
  }

  public void setOpenPlatformManagement(Integer openPlatformManagement) {
    this.openPlatformManagement = openPlatformManagement;
  }

  public String getAppCode() {
    return appCode;
  }

  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }
}
