package com.bizunited.empower.business.tenant.repository;

import com.bizunited.empower.business.tenant.entity.TenantProcessingFlowSetting;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * TenantSetting业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_TenantProcessingFlowSettingRepository")
public interface TenantProcessingFlowSettingRepository extends
    JpaRepository<TenantProcessingFlowSetting, String>
    , JpaSpecificationExecutor<TenantProcessingFlowSetting> {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct tenantProcessingFlowSetting from TenantProcessingFlowSetting tenantProcessingFlowSetting "
      + " where tenantProcessingFlowSetting.id=:id ")
  TenantProcessingFlowSetting findDetailsById(@Param("id") String id);

  /**
   * 按照租户编码查询配置信息
   * @param tenantCode
   * @return
   */
  @Query("select distinct tenantProcessingFlowSetting from TenantProcessingFlowSetting tenantProcessingFlowSetting "
      + " where tenantProcessingFlowSetting.tenantCode=:tenantCode ")
  List<TenantProcessingFlowSetting> findByTenantCode(@Param("tenantCode") String tenantCode);

  /**
   * 根据 租户code，节点编号，流程类型，统计
   * @param tenantCode
   * @param nodeNumber
   * @param processingFlowType
   * @return
   */
  long countByTenantCodeAndNodeNumberAndProcessingFlowType(String tenantCode, Integer nodeNumber, Integer processingFlowType);

  /**
   * 根据 租户code，节点编号，流程类型，查询
   * @param tenantCode
   * @param nodeNumber
   * @param processingFlowType
   * @return
   */
  List<TenantProcessingFlowSetting> findByTenantCodeAndNodeNumberAndProcessingFlowType(String tenantCode, Integer nodeNumber, Integer processingFlowType);
}
