package com.bizunited.empower.business.tenant.repository.internal;
import com.bizunited.empower.business.tenant.entity.TenantInfo;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.script.context.InvokeParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;
/**
 * TenantInfo模型的数据层自定义接口实现，可以由程序员根据实际情况完善
 * @author saturn
 */
public class TenantInfoRepositoryImpl implements TenantInfoRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  @Override
  public Page<TenantInfo> queryPage(Pageable pageable, InvokeParams conditions) {
  StringBuilder hql = new StringBuilder("from TenantInfo t where 1=1");
  StringBuilder countHql = new StringBuilder("select count(*) FROM TenantInfo t where 1=1");
  StringBuilder condition = new StringBuilder();
  Map<String, Object> parameters = new HashMap<>();
  if (conditions != null) {
    String keyword = (String) conditions.getInvokeParam("keyword");
    if(StringUtils.isNotBlank(keyword)){
      condition.append(" and (t.tenantName like concat(:keyword,'%') or t.tenantCode like concat(:keyword,'%')) ");
      parameters.put("keyword", keyword);
    }
  }
  hql.append(condition).append(" order by t.createTime desc");
  countHql.append(condition);
  return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }
}
