package com.bizunited.empower.business.tenant.service;

import com.bizunited.empower.business.tenant.entity.TenantSetting;

/**
 * TenantSetting业务模型的服务层接口定义
 *
 * @author saturn
 */
public interface TenantSettingService {
  /**
   * 保存业务设置实体
   */
  TenantSetting save(TenantSetting tenantSetting);

  /**
   * 按照TenantSetting的主键编号，查询指定的数据信息（不包括任何关联信息）
   *
   * @param id 主键
   */
  TenantSetting findById(String id);

  /**
   * 按照主键进行信息的真删除
   *
   * @param id 主键
   */
  void deleteById(String id);

  /**
   * 按照租户编码查找信息
   *
   * @param tenantCode
   * @return
   */
  TenantSetting findByTenantCode(String tenantCode);

  /**
   * 按照租户编码更新仓库状态
   * @param tenantCode
   * @param status
   * @return
   */
  TenantSetting updateWarehouseStatus(String tenantCode, Boolean status);

  /**
   * 获取经销商设置的默认图片（目前仅有商品默认图）
   * @return TenantInfoVo 获取经销商logo地址及名称
   */
  TenantSetting findSettingImgByTenantCode();
}