package com.bizunited.empower.business.tenant.service;

import com.bizunited.empower.business.tenant.common.enums.TenantSmsBusinessType;

/**
 * 经销商短信服务
 * @Author: Paul Chan
 * @Date: 2021/4/17 上午10:31
 */
public interface TenantSmsService {

  /**
   * 发送验证码，使用默认的验证码生成方式，6位数字验证码，1分钟过期时间
   * @param tenantCode
   * @param mobile
   * @param businessType
   */
  void sendValidCode(String tenantCode, String mobile, TenantSmsBusinessType businessType);

  /**
   * 发送验证码，使用默认的验证码生成方式
   * @param tenantCode
   * @param mobile
   * @param businessType
   * @param codeLength 验证码长度
   * @param expireTime 过期时间，毫秒单位
   */
  void sendValidCode(String tenantCode, String mobile, TenantSmsBusinessType businessType, int codeLength, long expireTime);

  /**
   * 发送验证码，传入验证码方式
   * @param tenantCode
   * @param mobile
   * @param businessType
   * @param validCode
   * @param expireTime 过期时间，毫秒单位
   */
  void sendValidCode(String tenantCode, String mobile, TenantSmsBusinessType businessType, String validCode, long expireTime);

  /**
   * 校验验证码，验证不对则返回false
   * @param tenantCode
   * @param businessType
   * @param validCode
   * @return
   */
  void verifyValidCode(String tenantCode, TenantSmsBusinessType businessType, String validCode);

  /**
   * 校验验证码，验证码或手机号码未匹配则返回false
   * @param tenantCode
   * @param mobile
   * @param businessType
   * @param validCode
   * @return
   */
  void verifyValidCode(String tenantCode, String mobile, TenantSmsBusinessType businessType, String validCode);
}
