package com.bizunited.empower.business.tenant.service.listener;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.empower.business.tenant.entity.TenantSetting;
import com.bizunited.empower.business.tenant.service.TenantSettingService;
import com.bizunited.empower.business.tenant.vo.DealerTenantInfo;
import com.bizunited.platform.common.util.tenant.TenantContextHolder;
import com.bizunited.platform.common.vo.AbstractTenantInfo;

import com.bizunited.platform.security.local.notifier.TenantRequestEventListenerForSecurity;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 该事件监听工作于经销商应用程序，是platform.security模块TenantRequestEventListenerForSecurity监听器实现的替换者</br>
 * 当TenantFilter过滤器工作时，该监听器根据自身业务特性的情况，构建租户信息tenantInfo，并保存在TenantContextHolder中
 * @author yinwenjie
 */
@Component
public class TenantRequestEventListenerForFilter extends TenantRequestEventListenerForSecurity {
  @Autowired
  private TenantSettingService tenantSettingService;
  
  @Override
  public AbstractTenantInfo onBuildTenantInfo(HttpServletRequest request,  HttpServletResponse response) {
    super.onBuildTenantInfo(request, response);
    /*
     * 经销商系统所关注的租户信息，除了tenantCode等基础属性外，还包括了诸如仓库如何进行管理，支付如何进行管理这样的配置信息。
     * 所以还要根据父级类的buildTenantInfo中已经获取到的租户信息，继续构建DealerTenantInfo对象
     * */
    String tenantCode = TenantContextHolder.getTenant();
    if(StringUtils.isBlank(tenantCode)) {
      return null;
    }
    TenantSetting tenantSetting = tenantSettingService.findByTenantCode(tenantCode);
    Validate.notNull(tenantSetting, "租户配置信息异常，请检查!");
    DealerTenantInfo dealerTenantInfo = new DealerTenantInfo();
    
    dealerTenantInfo.setCashPayStatus(tenantSetting.getCashPayStatus());
    dealerTenantInfo.setCreditBillStatus(tenantSetting.getCreditBillStatus());
    dealerTenantInfo.setGoodsBeforePayStatus(tenantSetting.getGoodsBeforePayStatus());
    dealerTenantInfo.setOrderPartialPayStatus(tenantSetting.getOrderPartialPayStatus());
    dealerTenantInfo.setOverflowWarehouseStatus(tenantSetting.getOverflowWarehouseStatus());
    dealerTenantInfo.setMultipleWarehouses(tenantSetting.getMultipleWarehouses() == null ? false : tenantSetting.getMultipleWarehouses());
    String orderAuditSetting = tenantSetting.getAuditNodeSettings();
    dealerTenantInfo.setAuditNodeSettings(StringUtils.isBlank(orderAuditSetting) ? null : JSONArray.parseArray(orderAuditSetting));
    String returnAuditNodeSetting = tenantSetting.getReturnAuditNodeSettings();
    dealerTenantInfo.setReturnAuditNodeSettings(StringUtils.isBlank(returnAuditNodeSetting) ? null : JSONArray.parseArray(returnAuditNodeSetting));
    return dealerTenantInfo;
  }
}