package com.bizunited.empower.business.tenant.service.notifier;

import com.bizunited.empower.business.tenant.vo.TenantSettingVo;

/**
 * 租户业务设置事件监听器
 *
 * @author Keller
 */
public interface TenantSettingEventListener {

  /**
   * 租户业务设置变动
   *
   * 注意:*如果是新建的业务设置信息 oldTenantSetting为null
   *
   * @param oldTenantSetting
   * @param newTenantSetting
   */
  void onChange(TenantSettingVo oldTenantSetting, TenantSettingVo newTenantSetting);
}
