package com.bizunited.empower.business.tenant.utils;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.empower.business.tenant.vo.DealerTenantInfo;
import com.bizunited.platform.common.util.tenant.TenantContextHolder;
import com.bizunited.platform.common.util.tenant.TenantUtils;

/**
 * 适用于经销商系统的租户信息工具，请参见TenantUtils父类红的详细说明
 * @author yinwenjie
 */
public final class DealerTenantUtils extends TenantUtils {
  private DealerTenantUtils() {
    super();
  }
  
  private static DealerTenantInfo getDealerTenantInfo() {
    return (DealerTenantInfo)TenantContextHolder.get("_tenantInfo");
  }
  /**
   * 获取当前经销商现金支付状态
   */
  public static Boolean getCashPayStatus() {
    DealerTenantInfo dealerTenantInfo = getDealerTenantInfo();
    if(dealerTenantInfo == null) {
      return false;
    }
    return dealerTenantInfo.getCashPayStatus();
  }
  /**
   * 获取当前经销商先货后款状态：先付1，后付2
   */
  public static Boolean getGoodsBeforePayStatus() {
    DealerTenantInfo dealerTenantInfo = getDealerTenantInfo();
    if(dealerTenantInfo == null) {
      return false;
    }
    return dealerTenantInfo.getGoodsBeforePayStatus();
  }
  /**
   * 获取当前经销商信用支付状态
   */
  public static Boolean getCreditBillStatus() {
    DealerTenantInfo dealerTenantInfo = getDealerTenantInfo();
    if(dealerTenantInfo == null) {
      return false;
    }
    return dealerTenantInfo.getCreditBillStatus();
  }
  /**
   * 获取当前经销商订单审核节点配置信息
   */
  public static JSONArray getAuditNodeSettings() {
    DealerTenantInfo dealerTenantInfo = getDealerTenantInfo();
    if(dealerTenantInfo == null) {
      return new JSONArray();
    }
    return dealerTenantInfo.getAuditNodeSettings();
  }
  /**
   * 获取当前经销商退货单审核节点配置信息
   */
  public static JSONArray getReturnAuditNodeSettings() {
    DealerTenantInfo dealerTenantInfo = getDealerTenantInfo();
    if(dealerTenantInfo == null) {
      return new JSONArray();
    }
    return dealerTenantInfo.getReturnAuditNodeSettings();
  }
  /**
   * 是否允许超库存出库 (是否强库存管控,强库存管控情况下不允许实际库存为负)
   * true为强库存校验
   */
  public static Boolean getOverflowWarehouseStatus() {
    DealerTenantInfo dealerTenantInfo = getDealerTenantInfo();
    if(dealerTenantInfo == null) {
      return false;
    }
    return dealerTenantInfo.getOverflowWarehouseStatus();
  }
  /**
   * 是否多仓库
   * true多仓，false单仓
   * 默认单仓
   */
  public static Boolean getMultipleWarehouses() {
    DealerTenantInfo dealerTenantInfo = getDealerTenantInfo();
    if(dealerTenantInfo == null) {
      return false;
    }
    return dealerTenantInfo.getMultipleWarehouses();
  }
}
