package com.bizunited.empower.business.tenant.common.constant;

/**
 * redisKey 常量
 *
 * @author Keller
 */
public class RedisKeys {

  private RedisKeys() {
    throw new IllegalStateException("静态变量类不能进行实例化");
  }

  /**
   * 租户编码key
   */
  public final static String TENANT_CODE_REDIS_KEY = "tenant:code:index";

  /**
   * 客户短信验证码前缀
   * 第一个参数：经销商编码
   * 第二个参数：业务类型
   */
  public static final String TENANT_SMS_CODE_PREFIX = "tenant:sms:code:%s:%d";

  /**
   * 客户redis中存储验证码map中的key值
   */
  public static final String TENANT_SMS_CODE_MAP_KEY = "code";

  /**
   * 客户redis中存储手机号map中的key值
   */
  public static final String TENANT_SMS_MOBILE_MAP_KEY = "mobile";

  /**
   * 经销商事件通知，创建、修改、删除等
   */
  public static final String TOPIC_TENANT_EVENT = "topic:tenant:event";

  /**
   * 经销商创建初始化通知键值（saas平台创建经销商基础信息->哨兵通知->经销商pc端创建经销商的数据->再次通知进行经销商的其他数据init）
   */
  public static final String DEALER_CREATE_INIT_TOPIC = "topic:dealer:create:init";


  /**
   * 客户短信验证码前缀
   * appCode编码
   */
  public static final String APP_CODE_LOGO_LOGIN_CACHE_PREFIX = "app:code:logo:login:%s";
}
